/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.statistics;

import JSci.maths.statistics.OutOfRangeException;
import JSci.maths.statistics.ProbabilityDistribution;

public final class ExponentialDistribution
extends ProbabilityDistribution {
    private double lambda;

    public ExponentialDistribution() {
        this(1.0);
    }

    public ExponentialDistribution(double d) {
        if (d < 0.0) {
            throw new OutOfRangeException("The scale parameter should be positive.");
        }
        this.lambda = d;
    }

    public ExponentialDistribution(double[] dArray) {
        double d = dArray[0];
        int n = 1;
        while (n < dArray.length) {
            d += dArray[n];
            ++n;
        }
        this.lambda = d / (double)dArray.length;
    }

    public double getScaleParameter() {
        return this.lambda;
    }

    public double getMean() {
        return this.lambda;
    }

    public double getVariance() {
        return this.lambda * this.lambda;
    }

    public double probability(double d) {
        this.checkRange(d, 0.0, Double.MAX_VALUE);
        return this.lambda * Math.exp(-this.lambda * d);
    }

    public double cumulative(double d) {
        this.checkRange(d, 0.0, Double.MAX_VALUE);
        return 1.0 - Math.exp(-this.lambda * d);
    }

    public double inverse(double d) {
        this.checkRange(d);
        return -Math.log(1.0 - d) / this.lambda;
    }
}

