/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.statistics;

import JSci.maths.SpecialMath;
import JSci.maths.statistics.GammaDistribution;
import JSci.maths.statistics.OutOfRangeException;
import JSci.maths.statistics.ProbabilityDistribution;

public final class ChiSqrDistribution
extends ProbabilityDistribution {
    private double r;
    private GammaDistribution gamma;

    public ChiSqrDistribution(double d) {
        if (d <= 0.0) {
            throw new OutOfRangeException("The degrees of freedom must be greater than zero.");
        }
        this.r = d;
        this.gamma = new GammaDistribution(0.5 * this.r);
    }

    public double getDegreesOfFreedom() {
        return this.r;
    }

    public double probability(double d) {
        return 0.5 * this.gamma.probability(0.5 * d);
    }

    public double cumulative(double d) {
        this.checkRange(d, 0.0, Double.MAX_VALUE);
        return SpecialMath.incompleteGamma(0.5 * this.r, 0.5 * d);
    }

    public double inverse(double d) {
        if (d == 1.0) {
            return Double.MAX_VALUE;
        }
        return 2.0 * this.gamma.inverse(d);
    }
}

