/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.chaos;

import JSci.maths.MappingND;

public final class StandardMap
implements MappingND {
    private final double k;

    public StandardMap(double d) {
        this.k = d;
    }

    public double[] map(double[] dArray) {
        double[] dArray2 = new double[2];
        dArray2[1] = (dArray[1] + this.k * Math.sin(dArray[0])) % (Math.PI * 2);
        dArray2[0] = (dArray[0] + dArray2[1]) % (Math.PI * 2);
        return dArray2;
    }

    public double[] iterate(int n, double[] dArray) {
        double[] dArray2 = this.map(dArray);
        int n2 = 1;
        while (n2 < n) {
            dArray2 = this.map(dArray2);
            ++n2;
        }
        return dArray2;
    }
}

