/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.categories;

import JSci.maths.Complex;
import JSci.maths.ComplexDiagonalMatrix;
import JSci.maths.ComplexMatrix;
import JSci.maths.ComplexVector;
import JSci.maths.MathInteger;
import JSci.maths.algebras.BanachSpaceMember;
import JSci.maths.algebras.HilbertSpace;
import JSci.maths.algebras.ModuleMember;
import JSci.maths.algebras.VectorSpaceMember;
import JSci.maths.categories.Category;
import JSci.maths.categories.Homset;
import JSci.maths.categories.Morphism;
import JSci.maths.categories.UndefinedCompositionException;
import JSci.maths.fields.FieldMember;
import JSci.maths.fields.RingMember;
import JSci.maths.groups.AbelianGroupMember;

public class Hilb
implements Category {
    public Morphism identity(Object object) {
        return new LinearMap(ComplexDiagonalMatrix.identity(((HilbertSpace)object).dimension()));
    }

    public Object cardinality(Object object) {
        return new MathInteger(((HilbertSpace)object).dimension());
    }

    public Homset homset(Object object, Object object2) {
        return new OperatorSpace((HilbertSpace)object, (HilbertSpace)object2);
    }

    public class LinearMap
    implements BanachSpaceMember,
    Morphism {
        private ComplexMatrix matrix;

        public LinearMap(Complex[][] complexArray) {
            this.matrix = new ComplexMatrix(complexArray);
        }

        public LinearMap(ComplexMatrix complexMatrix) {
            this.matrix = complexMatrix;
        }

        public Object domain() {
            return new HilbertSpace(this.matrix.columns());
        }

        public Object codomain() {
            return new HilbertSpace(this.matrix.rows());
        }

        public Object map(Object object) {
            return this.matrix.multiply((ComplexVector)object);
        }

        public Morphism compose(Morphism morphism) {
            if (morphism instanceof LinearMap) {
                LinearMap linearMap = (LinearMap)morphism;
                if (this.matrix.columns() == linearMap.matrix.rows()) {
                    return new LinearMap(linearMap.matrix.multiply(this.matrix));
                }
                throw new UndefinedCompositionException();
            }
            throw new IllegalArgumentException("Morphism is not a LinearMap.");
        }

        public double norm() {
            return this.matrix.frobeniusNorm();
        }

        public int dimension() {
            return this.matrix.rows() * this.matrix.columns();
        }

        public AbelianGroupMember add(AbelianGroupMember abelianGroupMember) {
            if (abelianGroupMember instanceof LinearMap) {
                return new LinearMap(this.matrix.add(((LinearMap)abelianGroupMember).matrix));
            }
            throw new IllegalArgumentException("Member class not recognised by this method.");
        }

        public AbelianGroupMember negate() {
            return new LinearMap((ComplexMatrix)this.matrix.negate());
        }

        public AbelianGroupMember subtract(AbelianGroupMember abelianGroupMember) {
            if (abelianGroupMember instanceof LinearMap) {
                return new LinearMap(this.matrix.subtract(((LinearMap)abelianGroupMember).matrix));
            }
            throw new IllegalArgumentException("Member class not recognised by this method.");
        }

        public ModuleMember scalarMultiply(RingMember ringMember) {
            if (ringMember instanceof Complex) {
                return new LinearMap(this.matrix.scalarMultiply((Complex)ringMember));
            }
            throw new IllegalArgumentException("Member class not recognised by this method.");
        }

        public VectorSpaceMember scalarDivide(FieldMember fieldMember) {
            if (fieldMember instanceof Complex) {
                return new LinearMap(this.matrix.scalarMultiply((Complex)fieldMember));
            }
            throw new IllegalArgumentException("Member class not recognised by this method.");
        }
    }

    public class OperatorSpace
    extends HilbertSpace
    implements Homset {
        private final int rows;
        private final int cols;

        public OperatorSpace(HilbertSpace hilbertSpace, HilbertSpace hilbertSpace2) {
            super(hilbertSpace.dimension() * hilbertSpace2.dimension());
            this.rows = hilbertSpace2.dimension();
            this.cols = hilbertSpace.dimension();
        }

        public VectorSpaceMember getVector(Complex[][] complexArray) {
            return new LinearMap(complexArray);
        }
    }
}

