/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.fields.IntegerRing;
import JSci.maths.fields.RingMember;
import JSci.maths.groups.AbelianGroupMember;

public final class MathInteger
implements Comparable,
RingMember {
    private static final long serialVersionUID = 6893485894391864141L;
    private int x;

    public MathInteger(int n) {
        this.x = n;
    }

    public MathInteger(String string) throws NumberFormatException {
        this.x = Integer.parseInt(string);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof MathInteger) {
            return this.x == ((MathInteger)object).value();
        }
        return false;
    }

    public int compareTo(Object object) throws IllegalArgumentException {
        if (object != null && object instanceof MathInteger) {
            if (this.x == ((MathInteger)object).value()) {
                return 0;
            }
            return this.x - ((MathInteger)object).value();
        }
        throw new IllegalArgumentException("Invalid object.");
    }

    public String toString() {
        return Integer.toString(this.x);
    }

    public int value() {
        return this.x;
    }

    public boolean isEven() {
        return (this.x & 1) == 0;
    }

    public boolean isOdd() {
        return (this.x & 1) == 1;
    }

    public AbelianGroupMember negate() {
        return new MathInteger(-this.x);
    }

    public AbelianGroupMember add(AbelianGroupMember abelianGroupMember) {
        if (abelianGroupMember instanceof MathInteger) {
            return this.add((MathInteger)abelianGroupMember);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public MathInteger add(MathInteger mathInteger) {
        return new MathInteger(this.x + mathInteger.x);
    }

    public AbelianGroupMember subtract(AbelianGroupMember abelianGroupMember) {
        if (abelianGroupMember instanceof MathInteger) {
            return this.subtract((MathInteger)abelianGroupMember);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public MathInteger subtract(MathInteger mathInteger) {
        return new MathInteger(this.x - mathInteger.x);
    }

    public RingMember multiply(RingMember ringMember) {
        if (ringMember instanceof MathInteger) {
            return this.multiply((MathInteger)ringMember);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public MathInteger multiply(MathInteger mathInteger) {
        return new MathInteger(this.x * mathInteger.x);
    }

    public MathInteger pow(MathInteger mathInteger) {
        if (mathInteger.x == 0) {
            return IntegerRing.ONE;
        }
        int n = this.x;
        int n2 = 1;
        while (n2 < mathInteger.x) {
            n *= this.x;
            ++n2;
        }
        return new MathInteger(n);
    }
}

