/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.ComplexDiagonalMatrix;
import JSci.maths.ComplexMatrix;
import JSci.maths.DimensionException;
import JSci.maths.DoubleDiagonalMatrix;
import JSci.maths.DoubleMatrix;
import JSci.maths.DoubleSquareMatrix;
import JSci.maths.IntegerMatrix;
import JSci.maths.IntegerSquareMatrix;
import JSci.maths.IntegerTridiagonalMatrix;
import JSci.maths.IntegerVector;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;

public final class IntegerDiagonalMatrix
extends IntegerTridiagonalMatrix {
    protected static final int DIAGONAL = 4;

    protected IntegerDiagonalMatrix() {
    }

    public IntegerDiagonalMatrix(int n) {
        this();
        this.storageFormat = 4;
        this.matrix = new int[1][n];
    }

    public IntegerDiagonalMatrix(int[][] nArray) {
        this(nArray.length);
        if (nArray.length == nArray[0].length) {
            int n = 0;
            while (n < this.matrix[0].length) {
                this.matrix[0][n] = nArray[n][n];
                ++n;
            }
        } else {
            this.matrix = null;
            throw new MatrixDimensionException("Array must be square.");
        }
    }

    public IntegerDiagonalMatrix(int[] nArray) {
        this();
        this.storageFormat = 4;
        this.matrix = new int[1][];
        this.matrix[0] = nArray;
    }

    public static IntegerDiagonalMatrix identity(int n) {
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = 1;
            ++n2;
        }
        return new IntegerDiagonalMatrix(nArray);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof IntegerDiagonalMatrix && this.matrix[0].length == ((IntegerDiagonalMatrix)object).rows()) {
            IntegerDiagonalMatrix integerDiagonalMatrix = (IntegerDiagonalMatrix)object;
            int n = 0;
            while (n < this.matrix[0].length) {
                if (this.matrix[0][n] != integerDiagonalMatrix.getElement(n, n)) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public DoubleMatrix toDoubleMatrix() {
        double[] dArray = new double[this.matrix[0].length];
        int n = 0;
        while (n < this.matrix[0].length) {
            dArray[n] = this.matrix[0][n];
            ++n;
        }
        return new DoubleDiagonalMatrix(dArray);
    }

    public ComplexMatrix toComplexMatrix() {
        double[] dArray = new double[this.matrix[0].length];
        double[] dArray2 = new double[this.matrix[0].length];
        int n = 0;
        while (n < this.matrix[0].length) {
            dArray[n] = this.matrix[0][n];
            ++n;
        }
        return new ComplexDiagonalMatrix(dArray, dArray2);
    }

    public int getElement(int n, int n2) {
        if (n >= 0 && n < this.matrix[0].length && n2 >= 0 && n2 < this.matrix[0].length) {
            if (n == n2) {
                return this.matrix[0][n];
            }
            return 0;
        }
        throw new MatrixDimensionException("Invalid element.");
    }

    public void setElement(int n, int n2, int n3) {
        if (n < 0 || n >= this.matrix[0].length || n2 < 0 || n2 >= this.matrix[0].length || n != n2) {
            throw new MatrixDimensionException("Invalid element.");
        }
        this.matrix[0][n] = n3;
    }

    public boolean isSymmetric() {
        return true;
    }

    public boolean isUnitary() {
        return this.multiply(this).equals(IntegerDiagonalMatrix.identity(this.matrix[0].length));
    }

    public int det() {
        int n = this.matrix[0][0];
        int n2 = 1;
        while (n2 < this.matrix[0].length) {
            n *= this.matrix[0][n2];
            ++n2;
        }
        return n;
    }

    public int trace() {
        int n = this.matrix[0][0];
        int n2 = 1;
        while (n2 < this.matrix[0].length) {
            n += this.matrix[0][n2];
            ++n2;
        }
        return n;
    }

    public int infNorm() {
        int n = Math.abs(this.matrix[0][0]);
        int n2 = 1;
        while (n2 < this.matrix[0].length) {
            int n3 = Math.abs(this.matrix[0][n2]);
            if (n3 > n) {
                n = n3;
            }
            ++n2;
        }
        return n;
    }

    public double frobeniusNorm() {
        int n = this.matrix[0][0] * this.matrix[0][0];
        int n2 = 1;
        while (n2 < this.matrix[0].length) {
            n += this.matrix[0][n2] * this.matrix[0][n2];
            ++n2;
        }
        return Math.sqrt(n);
    }

    public int rows() {
        return this.matrix[0].length;
    }

    public int columns() {
        return this.matrix[0].length;
    }

    public IntegerMatrix add(IntegerMatrix integerMatrix) {
        switch (integerMatrix.storageFormat) {
            case 1: {
                return this.rawAdd(integerMatrix);
            }
            case 3: {
                return this.rawAddTridiagonal(integerMatrix);
            }
            case 4: {
                return this.rawAddDiagonal(integerMatrix);
            }
        }
        if (this.matrix[0].length == integerMatrix.rows() && this.matrix[0].length == integerMatrix.columns()) {
            int[][] nArray = new int[this.matrix[0].length][this.matrix[0].length];
            int n = 0;
            while (n < nArray.length) {
                nArray[n][0] = integerMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < nArray.length) {
                    nArray[n][n2] = integerMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < nArray.length) {
                int[] nArray2 = nArray[n3];
                int n4 = n3;
                nArray2[n4] = nArray2[n4] + this.matrix[0][n3];
                ++n3;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerSquareMatrix rawAdd(IntegerMatrix integerMatrix) {
        if (this.matrix[0].length == integerMatrix.matrix.length && this.matrix[0].length == integerMatrix.matrix[0].length) {
            int[][] nArray = new int[this.matrix[0].length][this.matrix[0].length];
            int n = 0;
            while (n < nArray.length) {
                System.arraycopy(integerMatrix.matrix[n], 0, nArray[n], 0, nArray.length);
                ++n;
            }
            int n2 = 0;
            while (n2 < nArray.length) {
                int[] nArray2 = nArray[n2];
                int n3 = n2;
                nArray2[n3] = nArray2[n3] + this.matrix[0][n2];
                ++n2;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerSquareMatrix add(IntegerSquareMatrix integerSquareMatrix) {
        switch (integerSquareMatrix.storageFormat) {
            case 1: {
                return this.rawAdd(integerSquareMatrix);
            }
            case 3: {
                return this.rawAddTridiagonal(integerSquareMatrix);
            }
            case 4: {
                return this.rawAddDiagonal(integerSquareMatrix);
            }
        }
        if (this.matrix[0].length == integerSquareMatrix.rows()) {
            int[][] nArray = new int[this.matrix[0].length][this.matrix[0].length];
            int n = 0;
            while (n < nArray.length) {
                nArray[n][0] = integerSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < nArray.length) {
                    nArray[n][n2] = integerSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < nArray.length) {
                int[] nArray2 = nArray[n3];
                int n4 = n3;
                nArray2[n4] = nArray2[n4] + this.matrix[0][n3];
                ++n3;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerTridiagonalMatrix add(IntegerTridiagonalMatrix integerTridiagonalMatrix) {
        switch (integerTridiagonalMatrix.storageFormat) {
            case 3: {
                return this.rawAddTridiagonal(integerTridiagonalMatrix);
            }
            case 4: {
                return this.rawAddDiagonal(integerTridiagonalMatrix);
            }
        }
        int n = this.matrix[0].length;
        if (n == integerTridiagonalMatrix.rows()) {
            IntegerTridiagonalMatrix integerTridiagonalMatrix2 = new IntegerTridiagonalMatrix(n);
            integerTridiagonalMatrix2.matrix[1][0] = this.matrix[0][0] + integerTridiagonalMatrix.getElement(0, 0);
            integerTridiagonalMatrix2.matrix[2][0] = integerTridiagonalMatrix.getElement(0, 1);
            --n;
            int n2 = 1;
            while (n2 < n) {
                integerTridiagonalMatrix2.matrix[0][n2] = integerTridiagonalMatrix.getElement(n2, n2 - 1);
                integerTridiagonalMatrix2.matrix[1][n2] = this.matrix[0][n2] + integerTridiagonalMatrix.getElement(n2, n2);
                integerTridiagonalMatrix2.matrix[2][n2] = integerTridiagonalMatrix.getElement(n2, n2 + 1);
                ++n2;
            }
            integerTridiagonalMatrix2.matrix[0][n] = integerTridiagonalMatrix.getElement(n, n - 1);
            integerTridiagonalMatrix2.matrix[1][n] = this.matrix[0][n] + integerTridiagonalMatrix.getElement(n, n);
            return integerTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerTridiagonalMatrix rawAddTridiagonal(IntegerMatrix integerMatrix) {
        if (this.matrix[0].length == integerMatrix.matrix[1].length) {
            IntegerTridiagonalMatrix integerTridiagonalMatrix = new IntegerTridiagonalMatrix(this.matrix[0].length);
            System.arraycopy(integerMatrix.matrix[0], 0, integerTridiagonalMatrix.matrix[0], 0, this.matrix[0].length);
            System.arraycopy(integerMatrix.matrix[2], 0, integerTridiagonalMatrix.matrix[2], 0, this.matrix[2].length);
            integerTridiagonalMatrix.matrix[1][0] = this.matrix[0][0] + integerMatrix.matrix[1][0];
            int n = 1;
            while (n < this.matrix[0].length) {
                integerTridiagonalMatrix.matrix[1][n] = this.matrix[0][n] + integerMatrix.matrix[1][n];
                ++n;
            }
            return integerTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerDiagonalMatrix add(IntegerDiagonalMatrix integerDiagonalMatrix) {
        return this.rawAddDiagonal(integerDiagonalMatrix);
    }

    private IntegerDiagonalMatrix rawAddDiagonal(IntegerMatrix integerMatrix) {
        if (this.matrix[0].length == integerMatrix.matrix[0].length) {
            int[] nArray = new int[this.matrix[0].length];
            nArray[0] = this.matrix[0][0] + integerMatrix.matrix[0][0];
            int n = 1;
            while (n < nArray.length) {
                nArray[n] = this.matrix[0][n] + integerMatrix.matrix[0][n];
                ++n;
            }
            return new IntegerDiagonalMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerMatrix subtract(IntegerMatrix integerMatrix) {
        switch (integerMatrix.storageFormat) {
            case 1: {
                return this.rawSubtract(integerMatrix);
            }
            case 3: {
                return this.rawSubtractTridiagonal(integerMatrix);
            }
            case 4: {
                return this.rawSubtractDiagonal(integerMatrix);
            }
        }
        if (this.matrix[0].length == integerMatrix.rows() && this.matrix[0].length == integerMatrix.columns()) {
            int[][] nArray = new int[this.matrix[0].length][this.matrix[0].length];
            int n = 0;
            while (n < nArray.length) {
                nArray[n][0] = -integerMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < nArray.length) {
                    nArray[n][n2] = -integerMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < nArray.length) {
                int[] nArray2 = nArray[n3];
                int n4 = n3;
                nArray2[n4] = nArray2[n4] + this.matrix[0][n3];
                ++n3;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerSquareMatrix rawSubtract(IntegerMatrix integerMatrix) {
        if (this.matrix[0].length == integerMatrix.matrix.length && this.matrix[0].length == integerMatrix.matrix[0].length) {
            int[][] nArray = new int[this.matrix[0].length][this.matrix[0].length];
            int n = 0;
            while (n < nArray.length) {
                nArray[n][0] = -integerMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < nArray.length) {
                    nArray[n][n2] = -integerMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < nArray.length) {
                int[] nArray2 = nArray[n3];
                int n4 = n3;
                nArray2[n4] = nArray2[n4] + this.matrix[0][n3];
                ++n3;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerSquareMatrix subtract(IntegerSquareMatrix integerSquareMatrix) {
        switch (integerSquareMatrix.storageFormat) {
            case 1: {
                return this.rawSubtract(integerSquareMatrix);
            }
            case 3: {
                return this.rawSubtractTridiagonal(integerSquareMatrix);
            }
            case 4: {
                return this.rawSubtractDiagonal(integerSquareMatrix);
            }
        }
        if (this.matrix[0].length == integerSquareMatrix.rows()) {
            int[][] nArray = new int[this.matrix[0].length][this.matrix[0].length];
            int n = 0;
            while (n < nArray.length) {
                nArray[n][0] = -integerSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < nArray.length) {
                    nArray[n][n2] = -integerSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < nArray.length) {
                int[] nArray2 = nArray[n3];
                int n4 = n3;
                nArray2[n4] = nArray2[n4] + this.matrix[0][n3];
                ++n3;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerTridiagonalMatrix subtract(IntegerTridiagonalMatrix integerTridiagonalMatrix) {
        switch (integerTridiagonalMatrix.storageFormat) {
            case 3: {
                return this.rawSubtractTridiagonal(integerTridiagonalMatrix);
            }
            case 4: {
                return this.rawSubtractDiagonal(integerTridiagonalMatrix);
            }
        }
        int n = this.matrix[0].length;
        if (n == integerTridiagonalMatrix.rows()) {
            IntegerTridiagonalMatrix integerTridiagonalMatrix2 = new IntegerTridiagonalMatrix(n);
            integerTridiagonalMatrix2.matrix[1][0] = this.matrix[0][0] - integerTridiagonalMatrix.getElement(0, 0);
            integerTridiagonalMatrix2.matrix[2][0] = -integerTridiagonalMatrix.getElement(0, 1);
            --n;
            int n2 = 1;
            while (n2 < n) {
                integerTridiagonalMatrix2.matrix[0][n2] = -integerTridiagonalMatrix.getElement(n2, n2 - 1);
                integerTridiagonalMatrix2.matrix[1][n2] = this.matrix[0][n2] - integerTridiagonalMatrix.getElement(n2, n2);
                integerTridiagonalMatrix2.matrix[2][n2] = -integerTridiagonalMatrix.getElement(n2, n2 + 1);
                ++n2;
            }
            integerTridiagonalMatrix2.matrix[0][n] = -integerTridiagonalMatrix.getElement(n, n - 1);
            integerTridiagonalMatrix2.matrix[1][n] = this.matrix[0][n] - integerTridiagonalMatrix.getElement(n, n);
            return integerTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerTridiagonalMatrix rawSubtractTridiagonal(IntegerMatrix integerMatrix) {
        int n = this.matrix[0].length;
        if (n == integerMatrix.matrix[1].length) {
            IntegerTridiagonalMatrix integerTridiagonalMatrix = new IntegerTridiagonalMatrix(n);
            integerTridiagonalMatrix.matrix[1][0] = this.matrix[0][0] - integerMatrix.matrix[1][0];
            integerTridiagonalMatrix.matrix[2][0] = -integerMatrix.matrix[2][0];
            --n;
            int n2 = 1;
            while (n2 < n) {
                integerTridiagonalMatrix.matrix[0][n2] = -integerMatrix.matrix[0][n2];
                integerTridiagonalMatrix.matrix[1][n2] = this.matrix[0][n2] - integerMatrix.matrix[1][n2];
                integerTridiagonalMatrix.matrix[2][n2] = -integerMatrix.matrix[2][n2];
                ++n2;
            }
            integerTridiagonalMatrix.matrix[0][n] = -integerMatrix.matrix[0][n];
            integerTridiagonalMatrix.matrix[1][n] = this.matrix[0][n] - integerMatrix.matrix[1][n];
            return integerTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerDiagonalMatrix subtract(IntegerDiagonalMatrix integerDiagonalMatrix) {
        return this.rawSubtractDiagonal(integerDiagonalMatrix);
    }

    private IntegerDiagonalMatrix rawSubtractDiagonal(IntegerMatrix integerMatrix) {
        if (this.matrix[0].length == integerMatrix.matrix[0].length) {
            int[] nArray = new int[this.matrix[0].length];
            nArray[0] = this.matrix[0][0] - integerMatrix.matrix[0][0];
            int n = 1;
            while (n < nArray.length) {
                nArray[n] = this.matrix[0][n] - integerMatrix.matrix[0][n];
                ++n;
            }
            return new IntegerDiagonalMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerMatrix scalarMultiply(int n) {
        int[] nArray = new int[this.matrix[0].length];
        nArray[0] = n * this.matrix[0][0];
        int n2 = 1;
        while (n2 < nArray.length) {
            nArray[n2] = n * this.matrix[0][n2];
            ++n2;
        }
        return new IntegerDiagonalMatrix(nArray);
    }

    public IntegerVector multiply(IntegerVector integerVector) {
        if (this.matrix[0].length == integerVector.dimension()) {
            int[] nArray = new int[this.matrix[0].length];
            nArray[0] = this.matrix[0][0] * integerVector.getComponent(0);
            int n = 1;
            while (n < nArray.length) {
                nArray[n] = this.matrix[0][n] * integerVector.getComponent(n);
                ++n;
            }
            return new IntegerVector(nArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public IntegerMatrix multiply(IntegerMatrix integerMatrix) {
        switch (integerMatrix.storageFormat) {
            case 1: {
                return this.rawMultiply(integerMatrix);
            }
            case 3: {
                return this.rawMultiplyTridiagonal(integerMatrix);
            }
            case 4: {
                return this.rawMultiplyDiagonal(integerMatrix);
            }
        }
        if (this.matrix[0].length == integerMatrix.rows()) {
            int[][] nArray = new int[this.matrix[0].length][integerMatrix.columns()];
            int n = 0;
            while (n < nArray.length) {
                nArray[n][0] = this.matrix[0][n] * integerMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < nArray[0].length) {
                    nArray[n][n2] = this.matrix[0][n] * integerMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new IntegerMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerMatrix rawMultiply(IntegerMatrix integerMatrix) {
        if (this.matrix[0].length == integerMatrix.matrix.length) {
            int[][] nArray = new int[this.matrix[0].length][integerMatrix.matrix[0].length];
            int n = 0;
            while (n < nArray.length) {
                nArray[n][0] = this.matrix[0][n] * integerMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < nArray[0].length) {
                    nArray[n][n2] = this.matrix[0][n] * integerMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new IntegerMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerSquareMatrix multiply(IntegerSquareMatrix integerSquareMatrix) {
        switch (integerSquareMatrix.storageFormat) {
            case 1: {
                return this.rawMultiply(integerSquareMatrix);
            }
            case 3: {
                return this.rawMultiplyTridiagonal(integerSquareMatrix);
            }
            case 4: {
                return this.rawMultiplyDiagonal(integerSquareMatrix);
            }
        }
        if (this.matrix[0].length == integerSquareMatrix.rows()) {
            int[][] nArray = new int[this.matrix[0].length][this.matrix[0].length];
            int n = 0;
            while (n < nArray.length) {
                nArray[n][0] = this.matrix[0][n] * integerSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < nArray.length) {
                    nArray[n][n2] = this.matrix[0][n] * integerSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerSquareMatrix rawMultiply(IntegerSquareMatrix integerSquareMatrix) {
        if (this.matrix[0].length == integerSquareMatrix.matrix.length) {
            int[][] nArray = new int[this.matrix[0].length][this.matrix[0].length];
            int n = 0;
            while (n < nArray.length) {
                nArray[n][0] = this.matrix[0][n] * integerSquareMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < nArray.length) {
                    nArray[n][n2] = this.matrix[0][n] * integerSquareMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerSquareMatrix multiply(IntegerTridiagonalMatrix integerTridiagonalMatrix) {
        switch (integerTridiagonalMatrix.storageFormat) {
            case 3: {
                return this.rawMultiplyTridiagonal(integerTridiagonalMatrix);
            }
            case 4: {
                return this.rawMultiplyDiagonal(integerTridiagonalMatrix);
            }
        }
        int n = this.matrix[0].length;
        if (n == integerTridiagonalMatrix.rows()) {
            IntegerTridiagonalMatrix integerTridiagonalMatrix2 = new IntegerTridiagonalMatrix(n);
            integerTridiagonalMatrix2.matrix[1][0] = this.matrix[0][0] * integerTridiagonalMatrix.getElement(0, 0);
            integerTridiagonalMatrix2.matrix[2][0] = this.matrix[0][0] * integerTridiagonalMatrix.getElement(0, 1);
            --n;
            int n2 = 1;
            while (n2 < n) {
                integerTridiagonalMatrix2.matrix[0][n2] = this.matrix[0][n2] * integerTridiagonalMatrix.getElement(n2, n2 - 1);
                integerTridiagonalMatrix2.matrix[1][n2] = this.matrix[0][n2] * integerTridiagonalMatrix.getElement(n2, n2);
                integerTridiagonalMatrix2.matrix[2][n2] = this.matrix[0][n2] * integerTridiagonalMatrix.getElement(n2, n2 + 1);
                ++n2;
            }
            integerTridiagonalMatrix2.matrix[0][n] = this.matrix[0][n] * integerTridiagonalMatrix.getElement(n, n - 1);
            integerTridiagonalMatrix2.matrix[1][n] = this.matrix[0][n] * integerTridiagonalMatrix.getElement(n, n);
            return integerTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerSquareMatrix rawMultiplyTridiagonal(IntegerMatrix integerMatrix) {
        int n = this.matrix[0].length;
        if (n == integerMatrix.matrix[1].length) {
            IntegerTridiagonalMatrix integerTridiagonalMatrix = new IntegerTridiagonalMatrix(n);
            integerTridiagonalMatrix.matrix[1][0] = this.matrix[0][0] * integerMatrix.matrix[1][0];
            integerTridiagonalMatrix.matrix[2][0] = this.matrix[0][0] * integerMatrix.matrix[2][0];
            --n;
            int n2 = 1;
            while (n2 < n) {
                integerTridiagonalMatrix.matrix[0][n2] = this.matrix[0][n2] * integerMatrix.matrix[0][n2];
                integerTridiagonalMatrix.matrix[1][n2] = this.matrix[0][n2] * integerMatrix.matrix[1][n2];
                integerTridiagonalMatrix.matrix[2][n2] = this.matrix[0][n2] * integerMatrix.matrix[2][n2];
                ++n2;
            }
            integerTridiagonalMatrix.matrix[0][n] = this.matrix[0][n] * integerMatrix.matrix[0][n];
            integerTridiagonalMatrix.matrix[1][n] = this.matrix[0][n] * integerMatrix.matrix[1][n];
            return integerTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerDiagonalMatrix multiply(IntegerDiagonalMatrix integerDiagonalMatrix) {
        return this.rawMultiplyDiagonal(integerDiagonalMatrix);
    }

    private IntegerDiagonalMatrix rawMultiplyDiagonal(IntegerMatrix integerMatrix) {
        if (this.matrix[0].length == integerMatrix.matrix[0].length) {
            int[] nArray = new int[this.matrix[0].length];
            nArray[0] = this.matrix[0][0] * integerMatrix.matrix[0][0];
            int n = 1;
            while (n < nArray.length) {
                nArray[n] = this.matrix[0][n] * integerMatrix.matrix[0][n];
                ++n;
            }
            return new IntegerDiagonalMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public Matrix transpose() {
        return this;
    }

    public DoubleSquareMatrix[] luDecompose(int[] nArray) {
        if (this.LU != null) {
            if (nArray != null) {
                System.arraycopy(this.LUpivot, 0, nArray, 0, nArray.length);
            }
            return this.LU;
        }
        if (nArray == null) {
            nArray = new int[this.matrix[0].length + 1];
        }
        int n = 0;
        while (n < this.matrix[0].length) {
            nArray[n] = n;
            ++n;
        }
        nArray[this.matrix[0].length] = 1;
        this.LU = new DoubleDiagonalMatrix[2];
        this.LU[0] = DoubleDiagonalMatrix.identity(this.matrix[0].length);
        this.LU[1] = (DoubleDiagonalMatrix)this.toDoubleMatrix();
        this.LUpivot = new int[nArray.length];
        System.arraycopy(nArray, 0, this.LUpivot, 0, nArray.length);
        return this.LU;
    }

    public DoubleSquareMatrix[] choleskyDecompose() {
        DoubleSquareMatrix[] doubleSquareMatrixArray = new DoubleDiagonalMatrix[2];
        double[] dArray = new double[this.matrix[0].length];
        dArray[0] = Math.sqrt(this.matrix[0][0]);
        int n = 1;
        while (n < dArray.length) {
            dArray[n] = Math.sqrt(this.matrix[0][n]);
            ++n;
        }
        doubleSquareMatrixArray[0] = new DoubleDiagonalMatrix(dArray);
        doubleSquareMatrixArray[1] = doubleSquareMatrixArray[0];
        return doubleSquareMatrixArray;
    }
}

