/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.GlobalSettings;
import JSci.maths.ComplexVector;
import JSci.maths.IntegerVector;
import JSci.maths.Mapping;
import JSci.maths.MathDouble;
import JSci.maths.MathInteger;
import JSci.maths.MathVector;
import JSci.maths.VectorDimensionException;
import JSci.maths.algebras.BanachSpaceMember;
import JSci.maths.algebras.ModuleMember;
import JSci.maths.algebras.VectorSpaceMember;
import JSci.maths.fields.FieldMember;
import JSci.maths.fields.RingMember;
import JSci.maths.groups.AbelianGroupMember;

public class DoubleVector
extends MathVector
implements BanachSpaceMember {
    protected static final int ARRAY_1D = 1;
    protected double[] vector;

    protected DoubleVector(int n, int n2) {
        super(n);
        this.storageFormat = n2;
    }

    public DoubleVector(int n) {
        this(n, 1);
        this.vector = new double[n];
    }

    public DoubleVector(double[] dArray) {
        this(dArray.length, 1);
        this.vector = dArray;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof DoubleVector && this.N == ((DoubleVector)object).N) {
            DoubleVector doubleVector = (DoubleVector)object;
            int n = 0;
            while (n < this.N) {
                if (Math.abs(this.vector[n] - doubleVector.getComponent(n)) > GlobalSettings.ZERO_TOL) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.N);
        int n = 0;
        while (n < this.N - 1) {
            stringBuffer.append(this.vector[n]);
            stringBuffer.append(',');
            ++n;
        }
        stringBuffer.append(this.vector[n]);
        return stringBuffer.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.norm());
    }

    public IntegerVector toIntegerVector() {
        int[] nArray = new int[this.N];
        int n = 0;
        while (n < this.N) {
            nArray[n] = Math.round((float)this.vector[n]);
            ++n;
        }
        return new IntegerVector(nArray);
    }

    public ComplexVector toComplexVector() {
        return new ComplexVector(this.vector, new double[this.N]);
    }

    public double getComponent(int n) {
        if (n >= 0 && n < this.N) {
            return this.vector[n];
        }
        throw new VectorDimensionException("Invalid component.");
    }

    public void setComponent(int n, double d) {
        if (n < 0 || n >= this.N) {
            throw new VectorDimensionException("Invalid component.");
        }
        this.vector[n] = d;
    }

    public double norm(int n) {
        double d = Math.pow(this.vector[0], n);
        int n2 = 1;
        while (n2 < this.N) {
            d += Math.pow(this.vector[n2], n);
            ++n2;
        }
        return Math.pow(d, 1.0 / (double)n);
    }

    public double norm() {
        double d = this.vector[0] * this.vector[0];
        int n = 1;
        while (n < this.N) {
            d += this.vector[n] * this.vector[n];
            ++n;
        }
        return Math.sqrt(d);
    }

    public double infNorm() {
        double d = this.vector[0];
        int n = 1;
        while (n < this.N) {
            if (this.vector[n] > d) {
                d = this.vector[n];
            }
            ++n;
        }
        return d;
    }

    public AbelianGroupMember negate() {
        double[] dArray = new double[this.N];
        dArray[0] = -this.vector[0];
        int n = 1;
        while (n < this.N) {
            dArray[n] = -this.vector[n];
            ++n;
        }
        return new DoubleVector(dArray);
    }

    public AbelianGroupMember add(AbelianGroupMember abelianGroupMember) {
        if (abelianGroupMember instanceof DoubleVector) {
            return this.add((DoubleVector)abelianGroupMember);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public DoubleVector add(DoubleVector doubleVector) {
        switch (doubleVector.storageFormat) {
            case 1: {
                return this.rawAdd(doubleVector);
            }
        }
        if (this.N == doubleVector.N) {
            double[] dArray = new double[this.N];
            dArray[0] = this.vector[0] + doubleVector.getComponent(0);
            int n = 1;
            while (n < this.N) {
                dArray[n] = this.vector[n] + doubleVector.getComponent(n);
                ++n;
            }
            return new DoubleVector(dArray);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    private DoubleVector rawAdd(DoubleVector doubleVector) {
        if (this.N == doubleVector.N) {
            double[] dArray = new double[this.N];
            dArray[0] = this.vector[0] + doubleVector.vector[0];
            int n = 1;
            while (n < this.N) {
                dArray[n] = this.vector[n] + doubleVector.vector[n];
                ++n;
            }
            return new DoubleVector(dArray);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbelianGroupMember subtract(AbelianGroupMember abelianGroupMember) {
        if (abelianGroupMember instanceof DoubleVector) {
            return this.subtract((DoubleVector)abelianGroupMember);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public DoubleVector subtract(DoubleVector doubleVector) {
        switch (doubleVector.storageFormat) {
            case 1: {
                return this.rawSubtract(doubleVector);
            }
        }
        if (this.N == doubleVector.N) {
            double[] dArray = new double[this.N];
            dArray[0] = this.vector[0] - doubleVector.getComponent(0);
            int n = 1;
            while (n < this.N) {
                dArray[n] = this.vector[n] - doubleVector.getComponent(n);
                ++n;
            }
            return new DoubleVector(dArray);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    private DoubleVector rawSubtract(DoubleVector doubleVector) {
        if (this.N == doubleVector.N) {
            double[] dArray = new double[this.N];
            dArray[0] = this.vector[0] - doubleVector.vector[0];
            int n = 1;
            while (n < this.N) {
                dArray[n] = this.vector[n] - doubleVector.vector[n];
                ++n;
            }
            return new DoubleVector(dArray);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public ModuleMember scalarMultiply(RingMember ringMember) {
        if (ringMember instanceof MathDouble) {
            return this.scalarMultiply(((MathDouble)ringMember).value());
        }
        if (ringMember instanceof MathInteger) {
            return this.scalarMultiply(((MathInteger)ringMember).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public DoubleVector scalarMultiply(double d) {
        double[] dArray = new double[this.N];
        dArray[0] = d * this.vector[0];
        int n = 1;
        while (n < this.N) {
            dArray[n] = d * this.vector[n];
            ++n;
        }
        return new DoubleVector(dArray);
    }

    public VectorSpaceMember scalarDivide(FieldMember fieldMember) {
        if (fieldMember instanceof MathDouble) {
            return this.scalarDivide(((MathDouble)fieldMember).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public DoubleVector scalarDivide(double d) {
        double[] dArray = new double[this.N];
        dArray[0] = this.vector[0] / d;
        int n = 1;
        while (n < this.N) {
            dArray[n] = this.vector[n] / d;
            ++n;
        }
        return new DoubleVector(dArray);
    }

    public double scalarProduct(DoubleVector doubleVector) {
        switch (doubleVector.storageFormat) {
            case 1: {
                return this.rawScalarProduct(doubleVector);
            }
        }
        if (this.N == doubleVector.N) {
            double d = this.vector[0] * doubleVector.getComponent(0);
            int n = 1;
            while (n < this.N) {
                d += this.vector[n] * doubleVector.getComponent(n);
                ++n;
            }
            return d;
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    private double rawScalarProduct(DoubleVector doubleVector) {
        if (this.N == doubleVector.N) {
            double d = this.vector[0] * doubleVector.vector[0];
            int n = 1;
            while (n < this.N) {
                d += this.vector[n] * doubleVector.vector[n];
                ++n;
            }
            return d;
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public DoubleVector mapComponents(Mapping mapping) {
        double[] dArray = new double[this.N];
        dArray[0] = mapping.map(this.vector[0]);
        int n = 1;
        while (n < this.N) {
            dArray[n] = mapping.map(this.vector[n]);
            ++n;
        }
        return new DoubleVector(dArray);
    }
}

