/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.GlobalSettings;
import JSci.maths.ComplexDiagonalMatrix;
import JSci.maths.ComplexMatrix;
import JSci.maths.DimensionException;
import JSci.maths.DoubleMatrix;
import JSci.maths.DoubleSquareMatrix;
import JSci.maths.DoubleTridiagonalMatrix;
import JSci.maths.DoubleVector;
import JSci.maths.IntegerDiagonalMatrix;
import JSci.maths.IntegerMatrix;
import JSci.maths.Mapping;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;

public final class DoubleDiagonalMatrix
extends DoubleTridiagonalMatrix {
    protected static final int DIAGONAL = 4;

    protected DoubleDiagonalMatrix() {
    }

    public DoubleDiagonalMatrix(int n) {
        this();
        this.storageFormat = 4;
        this.matrix = new double[1][n];
    }

    public DoubleDiagonalMatrix(double[][] dArray) {
        this(dArray.length);
        if (dArray.length == dArray[0].length) {
            int n = 0;
            while (n < this.matrix[0].length) {
                this.matrix[0][n] = dArray[n][n];
                ++n;
            }
        } else {
            this.matrix = null;
            throw new MatrixDimensionException("Array must be square.");
        }
    }

    public DoubleDiagonalMatrix(double[] dArray) {
        this();
        this.storageFormat = 4;
        this.matrix = new double[1][];
        this.matrix[0] = dArray;
    }

    public static DoubleDiagonalMatrix identity(int n) {
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = 1.0;
            ++n2;
        }
        return new DoubleDiagonalMatrix(dArray);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof DoubleDiagonalMatrix && this.matrix[0].length == ((DoubleDiagonalMatrix)object).rows()) {
            DoubleDiagonalMatrix doubleDiagonalMatrix = (DoubleDiagonalMatrix)object;
            int n = 0;
            while (n < this.matrix[0].length) {
                if (Math.abs(this.matrix[0][n] - doubleDiagonalMatrix.getElement(n, n)) > GlobalSettings.ZERO_TOL) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public IntegerMatrix toIntegerMatrix() {
        int[] nArray = new int[this.matrix[0].length];
        int n = 0;
        while (n < this.matrix[0].length) {
            nArray[n] = Math.round((float)this.matrix[0][n]);
            ++n;
        }
        return new IntegerDiagonalMatrix(nArray);
    }

    public ComplexMatrix toComplexMatrix() {
        return new ComplexDiagonalMatrix(this.matrix[0], new double[this.matrix[0].length]);
    }

    public double getElement(int n, int n2) {
        if (n >= 0 && n < this.matrix[0].length && n2 >= 0 && n2 < this.matrix[0].length) {
            if (n == n2) {
                return this.matrix[0][n];
            }
            return 0.0;
        }
        throw new MatrixDimensionException("Invalid element.");
    }

    public void setElement(int n, int n2, double d) {
        if (n < 0 || n >= this.matrix[0].length || n2 < 0 || n2 >= this.matrix[0].length || n != n2) {
            throw new MatrixDimensionException("Invalid element.");
        }
        this.matrix[0][n] = d;
    }

    public boolean isSymmetric() {
        return true;
    }

    public boolean isUnitary() {
        return this.multiply(this).equals(DoubleDiagonalMatrix.identity(this.matrix[0].length));
    }

    public double det() {
        double d = this.matrix[0][0];
        int n = 1;
        while (n < this.matrix[0].length) {
            d *= this.matrix[0][n];
            ++n;
        }
        return d;
    }

    public double trace() {
        double d = this.matrix[0][0];
        int n = 1;
        while (n < this.matrix[0].length) {
            d += this.matrix[0][n];
            ++n;
        }
        return d;
    }

    public double infNorm() {
        double d = Math.abs(this.matrix[0][0]);
        int n = 1;
        while (n < this.matrix[0].length) {
            double d2 = Math.abs(this.matrix[0][n]);
            if (d2 > d) {
                d = d2;
            }
            ++n;
        }
        return d;
    }

    public double frobeniusNorm() {
        double d = this.matrix[0][0] * this.matrix[0][0];
        int n = 1;
        while (n < this.matrix[0].length) {
            d += this.matrix[0][n] * this.matrix[0][n];
            ++n;
        }
        return Math.sqrt(d);
    }

    public double operatorNorm() {
        return this.infNorm();
    }

    public int rows() {
        return this.matrix[0].length;
    }

    public int columns() {
        return this.matrix[0].length;
    }

    public DoubleMatrix add(DoubleMatrix doubleMatrix) {
        switch (doubleMatrix.storageFormat) {
            case 1: {
                return this.rawAdd(doubleMatrix);
            }
            case 3: {
                return this.rawAddTridiagonal(doubleMatrix);
            }
            case 4: {
                return this.rawAddDiagonal(doubleMatrix);
            }
        }
        if (this.matrix[0].length == doubleMatrix.rows() && this.matrix[0].length == doubleMatrix.columns()) {
            double[][] dArray = new double[this.matrix[0].length][this.matrix[0].length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = doubleMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < dArray.length) {
                    dArray[n][n2] = doubleMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < dArray.length) {
                double[] dArray2 = dArray[n3];
                int n4 = n3;
                dArray2[n4] = dArray2[n4] + this.matrix[0][n3];
                ++n3;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleSquareMatrix rawAdd(DoubleMatrix doubleMatrix) {
        if (this.matrix[0].length == doubleMatrix.matrix.length && this.matrix[0].length == doubleMatrix.matrix[0].length) {
            double[][] dArray = new double[this.matrix[0].length][this.matrix[0].length];
            int n = 0;
            while (n < dArray.length) {
                System.arraycopy(doubleMatrix.matrix[n], 0, dArray[n], 0, dArray.length);
                ++n;
            }
            int n2 = 0;
            while (n2 < dArray.length) {
                double[] dArray2 = dArray[n2];
                int n3 = n2;
                dArray2[n3] = dArray2[n3] + this.matrix[0][n2];
                ++n2;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix add(DoubleSquareMatrix doubleSquareMatrix) {
        switch (doubleSquareMatrix.storageFormat) {
            case 1: {
                return this.rawAdd(doubleSquareMatrix);
            }
            case 3: {
                return this.rawAddTridiagonal(doubleSquareMatrix);
            }
            case 4: {
                return this.rawAddDiagonal(doubleSquareMatrix);
            }
        }
        if (this.matrix[0].length == doubleSquareMatrix.rows()) {
            double[][] dArray = new double[this.matrix[0].length][this.matrix[0].length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = doubleSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < dArray.length) {
                    dArray[n][n2] = doubleSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < dArray.length) {
                double[] dArray2 = dArray[n3];
                int n4 = n3;
                dArray2[n4] = dArray2[n4] + this.matrix[0][n3];
                ++n3;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleTridiagonalMatrix add(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        switch (doubleTridiagonalMatrix.storageFormat) {
            case 3: {
                return this.rawAddTridiagonal(doubleTridiagonalMatrix);
            }
            case 4: {
                return this.rawAddDiagonal(doubleTridiagonalMatrix);
            }
        }
        int n = this.matrix[0].length;
        if (n == doubleTridiagonalMatrix.rows()) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix2 = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix2.matrix[1][0] = this.matrix[0][0] + doubleTridiagonalMatrix.getElement(0, 0);
            doubleTridiagonalMatrix2.matrix[2][0] = doubleTridiagonalMatrix.getElement(0, 1);
            --n;
            int n2 = 1;
            while (n2 < n) {
                doubleTridiagonalMatrix2.matrix[0][n2] = doubleTridiagonalMatrix.getElement(n2, n2 - 1);
                doubleTridiagonalMatrix2.matrix[1][n2] = this.matrix[0][n2] + doubleTridiagonalMatrix.getElement(n2, n2);
                doubleTridiagonalMatrix2.matrix[2][n2] = doubleTridiagonalMatrix.getElement(n2, n2 + 1);
                ++n2;
            }
            doubleTridiagonalMatrix2.matrix[0][n] = doubleTridiagonalMatrix.getElement(n, n - 1);
            doubleTridiagonalMatrix2.matrix[1][n] = this.matrix[0][n] + doubleTridiagonalMatrix.getElement(n, n);
            return doubleTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleTridiagonalMatrix rawAddTridiagonal(DoubleMatrix doubleMatrix) {
        if (this.matrix[0].length == doubleMatrix.matrix[1].length) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(this.matrix[0].length);
            System.arraycopy(doubleMatrix.matrix[0], 0, doubleTridiagonalMatrix.matrix[0], 0, this.matrix[0].length);
            System.arraycopy(doubleMatrix.matrix[2], 0, doubleTridiagonalMatrix.matrix[2], 0, this.matrix[2].length);
            doubleTridiagonalMatrix.matrix[1][0] = this.matrix[0][0] + doubleMatrix.matrix[1][0];
            int n = 1;
            while (n < this.matrix[0].length) {
                doubleTridiagonalMatrix.matrix[1][n] = this.matrix[0][n] + doubleMatrix.matrix[1][n];
                ++n;
            }
            return doubleTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleDiagonalMatrix add(DoubleDiagonalMatrix doubleDiagonalMatrix) {
        return this.rawAddDiagonal(doubleDiagonalMatrix);
    }

    private DoubleDiagonalMatrix rawAddDiagonal(DoubleMatrix doubleMatrix) {
        if (this.matrix[0].length == doubleMatrix.matrix[0].length) {
            double[] dArray = new double[this.matrix[0].length];
            dArray[0] = this.matrix[0][0] + doubleMatrix.matrix[0][0];
            int n = 1;
            while (n < dArray.length) {
                dArray[n] = this.matrix[0][n] + doubleMatrix.matrix[0][n];
                ++n;
            }
            return new DoubleDiagonalMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleMatrix subtract(DoubleMatrix doubleMatrix) {
        switch (doubleMatrix.storageFormat) {
            case 1: {
                return this.rawSubtract(doubleMatrix);
            }
            case 3: {
                return this.rawSubtractTridiagonal(doubleMatrix);
            }
            case 4: {
                return this.rawSubtractDiagonal(doubleMatrix);
            }
        }
        if (this.matrix[0].length == doubleMatrix.rows() && this.matrix[0].length == doubleMatrix.columns()) {
            double[][] dArray = new double[this.matrix[0].length][this.matrix[0].length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = -doubleMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < dArray.length) {
                    dArray[n][n2] = -doubleMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < dArray.length) {
                double[] dArray2 = dArray[n3];
                int n4 = n3;
                dArray2[n4] = dArray2[n4] + this.matrix[0][n3];
                ++n3;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleSquareMatrix rawSubtract(DoubleMatrix doubleMatrix) {
        if (this.matrix[0].length == doubleMatrix.matrix.length && this.matrix[0].length == doubleMatrix.matrix[0].length) {
            double[][] dArray = new double[this.matrix[0].length][this.matrix[0].length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = -doubleMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < dArray.length) {
                    dArray[n][n2] = -doubleMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < dArray.length) {
                double[] dArray2 = dArray[n3];
                int n4 = n3;
                dArray2[n4] = dArray2[n4] + this.matrix[0][n3];
                ++n3;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix subtract(DoubleSquareMatrix doubleSquareMatrix) {
        switch (doubleSquareMatrix.storageFormat) {
            case 1: {
                return this.rawSubtract(doubleSquareMatrix);
            }
            case 3: {
                return this.rawSubtractTridiagonal(doubleSquareMatrix);
            }
            case 4: {
                return this.rawSubtractDiagonal(doubleSquareMatrix);
            }
        }
        if (this.matrix[0].length == doubleSquareMatrix.rows()) {
            double[][] dArray = new double[this.matrix[0].length][this.matrix[0].length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = -doubleSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < dArray.length) {
                    dArray[n][n2] = -doubleSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < dArray.length) {
                double[] dArray2 = dArray[n3];
                int n4 = n3;
                dArray2[n4] = dArray2[n4] + this.matrix[0][n3];
                ++n3;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleTridiagonalMatrix subtract(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        switch (doubleTridiagonalMatrix.storageFormat) {
            case 3: {
                return this.rawSubtractTridiagonal(doubleTridiagonalMatrix);
            }
            case 4: {
                return this.rawSubtractDiagonal(doubleTridiagonalMatrix);
            }
        }
        int n = this.matrix[0].length;
        if (n == doubleTridiagonalMatrix.rows()) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix2 = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix2.matrix[1][0] = this.matrix[0][0] - doubleTridiagonalMatrix.getElement(0, 0);
            doubleTridiagonalMatrix2.matrix[2][0] = -doubleTridiagonalMatrix.getElement(0, 1);
            --n;
            int n2 = 1;
            while (n2 < n) {
                doubleTridiagonalMatrix2.matrix[0][n2] = -doubleTridiagonalMatrix.getElement(n2, n2 - 1);
                doubleTridiagonalMatrix2.matrix[1][n2] = this.matrix[0][n2] - doubleTridiagonalMatrix.getElement(n2, n2);
                doubleTridiagonalMatrix2.matrix[2][n2] = -doubleTridiagonalMatrix.getElement(n2, n2 + 1);
                ++n2;
            }
            doubleTridiagonalMatrix2.matrix[0][n] = -doubleTridiagonalMatrix.getElement(n, n - 1);
            doubleTridiagonalMatrix2.matrix[1][n] = this.matrix[0][n] - doubleTridiagonalMatrix.getElement(n, n);
            return doubleTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleTridiagonalMatrix rawSubtractTridiagonal(DoubleMatrix doubleMatrix) {
        int n = this.matrix[0].length;
        if (n == doubleMatrix.matrix[1].length) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix.matrix[1][0] = this.matrix[0][0] - doubleMatrix.matrix[1][0];
            doubleTridiagonalMatrix.matrix[2][0] = -doubleMatrix.matrix[2][0];
            --n;
            int n2 = 1;
            while (n2 < n) {
                doubleTridiagonalMatrix.matrix[0][n2] = -doubleMatrix.matrix[0][n2];
                doubleTridiagonalMatrix.matrix[1][n2] = this.matrix[0][n2] - doubleMatrix.matrix[1][n2];
                doubleTridiagonalMatrix.matrix[2][n2] = -doubleMatrix.matrix[2][n2];
                ++n2;
            }
            doubleTridiagonalMatrix.matrix[0][n] = -doubleMatrix.matrix[0][n];
            doubleTridiagonalMatrix.matrix[1][n] = this.matrix[0][n] - doubleMatrix.matrix[1][n];
            return doubleTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleDiagonalMatrix subtract(DoubleDiagonalMatrix doubleDiagonalMatrix) {
        return this.rawSubtractDiagonal(doubleDiagonalMatrix);
    }

    private DoubleDiagonalMatrix rawSubtractDiagonal(DoubleMatrix doubleMatrix) {
        if (this.matrix[0].length == doubleMatrix.matrix[0].length) {
            double[] dArray = new double[this.matrix[0].length];
            dArray[0] = this.matrix[0][0] - doubleMatrix.matrix[0][0];
            int n = 1;
            while (n < dArray.length) {
                dArray[n] = this.matrix[0][n] - doubleMatrix.matrix[0][n];
                ++n;
            }
            return new DoubleDiagonalMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleMatrix scalarMultiply(double d) {
        double[] dArray = new double[this.matrix[0].length];
        dArray[0] = d * this.matrix[0][0];
        int n = 1;
        while (n < dArray.length) {
            dArray[n] = d * this.matrix[0][n];
            ++n;
        }
        return new DoubleDiagonalMatrix(dArray);
    }

    public double scalarProduct(DoubleMatrix doubleMatrix) {
        switch (doubleMatrix.storageFormat) {
            case 1: {
                return this.rawScalarProduct(doubleMatrix);
            }
            case 3: {
                return this.rawScalarProductTridiagonal(doubleMatrix);
            }
            case 4: {
                return this.rawScalarProductDiagonal(doubleMatrix);
            }
        }
        if (this.matrix[0].length == doubleMatrix.rows() && this.matrix[0].length == doubleMatrix.columns()) {
            double d = this.matrix[0][0] * doubleMatrix.getElement(0, 0);
            int n = 1;
            while (n < this.matrix[0].length) {
                d += this.matrix[0][n] * doubleMatrix.getElement(n, n);
                ++n;
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private double rawScalarProduct(DoubleMatrix doubleMatrix) {
        if (this.matrix[0].length == doubleMatrix.matrix.length && this.matrix[0].length == doubleMatrix.matrix[0].length) {
            double d = this.matrix[0][0] * doubleMatrix.matrix[0][0];
            int n = 1;
            while (n < this.matrix[0].length) {
                d += this.matrix[0][n] * doubleMatrix.matrix[n][n];
                ++n;
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public double scalarProduct(DoubleSquareMatrix doubleSquareMatrix) {
        switch (doubleSquareMatrix.storageFormat) {
            case 1: {
                return this.rawScalarProduct(doubleSquareMatrix);
            }
            case 3: {
                return this.rawScalarProductTridiagonal(doubleSquareMatrix);
            }
            case 4: {
                return this.rawScalarProductDiagonal(doubleSquareMatrix);
            }
        }
        if (this.matrix[0].length == doubleSquareMatrix.rows()) {
            double d = this.matrix[0][0] * doubleSquareMatrix.getElement(0, 0);
            int n = 1;
            while (n < this.matrix[0].length) {
                d += this.matrix[0][n] * doubleSquareMatrix.getElement(n, n);
                ++n;
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public double scalarProduct(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        switch (doubleTridiagonalMatrix.storageFormat) {
            case 3: {
                return this.rawScalarProductTridiagonal(doubleTridiagonalMatrix);
            }
            case 4: {
                return this.rawScalarProductDiagonal(doubleTridiagonalMatrix);
            }
        }
        if (this.matrix[0].length == doubleTridiagonalMatrix.rows()) {
            double d = this.matrix[0][0] * doubleTridiagonalMatrix.getElement(0, 0);
            int n = 1;
            while (n < this.matrix[0].length) {
                d += this.matrix[0][n] * doubleTridiagonalMatrix.getElement(n, n);
                ++n;
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private double rawScalarProductTridiagonal(DoubleMatrix doubleMatrix) {
        if (this.matrix[0].length == doubleMatrix.matrix[1].length) {
            double d = this.matrix[0][0] * doubleMatrix.matrix[1][0];
            int n = 1;
            while (n < this.matrix[0].length) {
                d += this.matrix[0][n] * doubleMatrix.matrix[1][n];
                ++n;
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public double scalarProduct(DoubleDiagonalMatrix doubleDiagonalMatrix) {
        return this.rawScalarProductDiagonal(doubleDiagonalMatrix);
    }

    private double rawScalarProductDiagonal(DoubleMatrix doubleMatrix) {
        if (this.matrix[0].length == doubleMatrix.matrix[0].length) {
            double d = this.matrix[0][0] * doubleMatrix.matrix[0][0];
            int n = 1;
            while (n < this.matrix[0].length) {
                d += this.matrix[0][n] * doubleMatrix.matrix[0][n];
                ++n;
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleVector multiply(DoubleVector doubleVector) {
        if (this.matrix[0].length == doubleVector.dimension()) {
            double[] dArray = new double[this.matrix[0].length];
            dArray[0] = this.matrix[0][0] * doubleVector.getComponent(0);
            int n = 1;
            while (n < dArray.length) {
                dArray[n] = this.matrix[0][n] * doubleVector.getComponent(n);
                ++n;
            }
            return new DoubleVector(dArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public DoubleMatrix multiply(DoubleMatrix doubleMatrix) {
        switch (doubleMatrix.storageFormat) {
            case 1: {
                return this.rawMultiply(doubleMatrix);
            }
            case 3: {
                return this.rawMultiplyTridiagonal(doubleMatrix);
            }
            case 4: {
                return this.rawMultiplyDiagonal(doubleMatrix);
            }
        }
        if (this.matrix[0].length == doubleMatrix.rows()) {
            double[][] dArray = new double[this.matrix[0].length][doubleMatrix.columns()];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = this.matrix[0][n] * doubleMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < dArray[0].length) {
                    dArray[n][n2] = this.matrix[0][n] * doubleMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleMatrix rawMultiply(DoubleMatrix doubleMatrix) {
        if (this.matrix[0].length == doubleMatrix.matrix.length) {
            double[][] dArray = new double[this.matrix[0].length][doubleMatrix.matrix[0].length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = this.matrix[0][n] * doubleMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < dArray[0].length) {
                    dArray[n][n2] = this.matrix[0][n] * doubleMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix multiply(DoubleSquareMatrix doubleSquareMatrix) {
        switch (doubleSquareMatrix.storageFormat) {
            case 1: {
                return this.rawMultiply(doubleSquareMatrix);
            }
            case 3: {
                return this.rawMultiplyTridiagonal(doubleSquareMatrix);
            }
            case 4: {
                return this.rawMultiplyDiagonal(doubleSquareMatrix);
            }
        }
        if (this.matrix[0].length == doubleSquareMatrix.rows()) {
            double[][] dArray = new double[this.matrix[0].length][this.matrix[0].length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = this.matrix[0][n] * doubleSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < dArray.length) {
                    dArray[n][n2] = this.matrix[0][n] * doubleSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleSquareMatrix rawMultiply(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.matrix[0].length == doubleSquareMatrix.matrix.length) {
            double[][] dArray = new double[this.matrix[0].length][this.matrix[0].length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = this.matrix[0][n] * doubleSquareMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < dArray.length) {
                    dArray[n][n2] = this.matrix[0][n] * doubleSquareMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix multiply(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        switch (doubleTridiagonalMatrix.storageFormat) {
            case 3: {
                return this.rawMultiplyTridiagonal(doubleTridiagonalMatrix);
            }
            case 4: {
                return this.rawMultiplyDiagonal(doubleTridiagonalMatrix);
            }
        }
        int n = this.matrix[0].length;
        if (n == doubleTridiagonalMatrix.rows()) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix2 = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix2.matrix[1][0] = this.matrix[0][0] * doubleTridiagonalMatrix.getElement(0, 0);
            doubleTridiagonalMatrix2.matrix[2][0] = this.matrix[0][0] * doubleTridiagonalMatrix.getElement(0, 1);
            --n;
            int n2 = 1;
            while (n2 < n) {
                doubleTridiagonalMatrix2.matrix[0][n2] = this.matrix[0][n2] * doubleTridiagonalMatrix.getElement(n2, n2 - 1);
                doubleTridiagonalMatrix2.matrix[1][n2] = this.matrix[0][n2] * doubleTridiagonalMatrix.getElement(n2, n2);
                doubleTridiagonalMatrix2.matrix[2][n2] = this.matrix[0][n2] * doubleTridiagonalMatrix.getElement(n2, n2 + 1);
                ++n2;
            }
            doubleTridiagonalMatrix2.matrix[0][n] = this.matrix[0][n] * doubleTridiagonalMatrix.getElement(n, n - 1);
            doubleTridiagonalMatrix2.matrix[1][n] = this.matrix[0][n] * doubleTridiagonalMatrix.getElement(n, n);
            return doubleTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleSquareMatrix rawMultiplyTridiagonal(DoubleMatrix doubleMatrix) {
        int n = this.matrix[0].length;
        if (n == doubleMatrix.matrix[1].length) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix.matrix[1][0] = this.matrix[0][0] * doubleMatrix.matrix[1][0];
            doubleTridiagonalMatrix.matrix[2][0] = this.matrix[0][0] * doubleMatrix.matrix[2][0];
            --n;
            int n2 = 1;
            while (n2 < n) {
                doubleTridiagonalMatrix.matrix[0][n2] = this.matrix[0][n2] * doubleMatrix.matrix[0][n2];
                doubleTridiagonalMatrix.matrix[1][n2] = this.matrix[0][n2] * doubleMatrix.matrix[1][n2];
                doubleTridiagonalMatrix.matrix[2][n2] = this.matrix[0][n2] * doubleMatrix.matrix[2][n2];
                ++n2;
            }
            doubleTridiagonalMatrix.matrix[0][n] = this.matrix[0][n] * doubleMatrix.matrix[0][n];
            doubleTridiagonalMatrix.matrix[1][n] = this.matrix[0][n] * doubleMatrix.matrix[1][n];
            return doubleTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleDiagonalMatrix multiply(DoubleDiagonalMatrix doubleDiagonalMatrix) {
        return this.rawMultiplyDiagonal(doubleDiagonalMatrix);
    }

    private DoubleDiagonalMatrix rawMultiplyDiagonal(DoubleMatrix doubleMatrix) {
        if (this.matrix[0].length == doubleMatrix.matrix[0].length) {
            double[] dArray = new double[this.matrix[0].length];
            dArray[0] = this.matrix[0][0] * doubleMatrix.matrix[0][0];
            int n = 1;
            while (n < dArray.length) {
                dArray[n] = this.matrix[0][n] * doubleMatrix.matrix[0][n];
                ++n;
            }
            return new DoubleDiagonalMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix inverse() {
        double[] dArray = new double[this.matrix[0].length];
        dArray[0] = 1.0 / this.matrix[0][0];
        int n = 1;
        while (n < dArray.length) {
            dArray[n] = 1.0 / this.matrix[0][n];
            ++n;
        }
        return new DoubleDiagonalMatrix(dArray);
    }

    public Matrix transpose() {
        return this;
    }

    public DoubleSquareMatrix[] luDecompose(int[] nArray) {
        if (this.LU != null) {
            if (nArray != null) {
                System.arraycopy(this.LUpivot, 0, nArray, 0, nArray.length);
            }
            return this.LU;
        }
        if (nArray == null) {
            nArray = new int[this.matrix[0].length + 1];
        }
        int n = 0;
        while (n < this.matrix[0].length) {
            nArray[n] = n;
            ++n;
        }
        nArray[this.matrix[0].length] = 1;
        this.LU = new DoubleDiagonalMatrix[2];
        this.LU[0] = DoubleDiagonalMatrix.identity(this.matrix[0].length);
        this.LU[1] = this;
        this.LUpivot = new int[nArray.length];
        System.arraycopy(nArray, 0, this.LUpivot, 0, nArray.length);
        return this.LU;
    }

    public DoubleSquareMatrix[] choleskyDecompose() {
        DoubleSquareMatrix[] doubleSquareMatrixArray = new DoubleDiagonalMatrix[2];
        double[] dArray = new double[this.matrix[0].length];
        dArray[0] = Math.sqrt(this.matrix[0][0]);
        int n = 1;
        while (n < dArray.length) {
            dArray[n] = Math.sqrt(this.matrix[0][n]);
            ++n;
        }
        doubleSquareMatrixArray[0] = new DoubleDiagonalMatrix(dArray);
        doubleSquareMatrixArray[1] = doubleSquareMatrixArray[0];
        return doubleSquareMatrixArray;
    }

    public DoubleMatrix mapElements(Mapping mapping) {
        double[] dArray = new double[this.matrix[0].length];
        dArray[0] = mapping.map(this.matrix[0][0]);
        int n = 1;
        while (n < dArray.length) {
            dArray[n] = mapping.map(this.matrix[0][n]);
            ++n;
        }
        return new DoubleDiagonalMatrix(dArray);
    }
}

