/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.MathSet;

public class DiscreteSet
implements MathSet {
    public static final DiscreteSet EMPTY = new DiscreteSet("Empty Set", new Object[0]);
    private String label;
    protected Object[] elements;

    protected DiscreteSet(String string) {
        this.label = string;
    }

    public DiscreteSet(String string, Object[] objectArray) {
        this(string);
        this.elements = new Object[objectArray.length];
        System.arraycopy(objectArray, 0, this.elements, 0, objectArray.length);
    }

    public boolean equals(Object object) {
        return object != null && object instanceof DiscreteSet && this.label.equals(object.toString());
    }

    public final String toString() {
        return this.label;
    }

    public final int cardinality() {
        return this.elements.length;
    }

    public final Object getElement(int n) {
        return this.elements[n];
    }

    public MathSet union(MathSet mathSet) {
        int n;
        int n2;
        if (!(mathSet instanceof DiscreteSet)) {
            throw new IllegalArgumentException("Must be a discrete set.");
        }
        DiscreteSet discreteSet = (DiscreteSet)mathSet;
        Object[] objectArray = new Object[this.elements.length + discreteSet.cardinality()];
        if (this.elements.length > discreteSet.cardinality()) {
            n2 = 0;
            while (n2 < discreteSet.cardinality()) {
                objectArray[n2] = discreteSet.getElement(n2);
                ++n2;
            }
            n = 0;
            while (n < this.elements.length) {
                boolean bl = true;
                int n3 = 0;
                while (n3 < discreteSet.cardinality()) {
                    if (this.elements[n].equals(objectArray[n3])) {
                        bl = false;
                    }
                    ++n3;
                }
                if (bl) {
                    objectArray[n2++] = this.elements[n];
                }
                ++n;
            }
        } else {
            n2 = 0;
            while (n2 < this.elements.length) {
                objectArray[n2] = this.elements[n2];
                ++n2;
            }
            n = 0;
            while (n < discreteSet.cardinality()) {
                boolean bl = true;
                int n4 = 0;
                while (n4 < this.elements.length) {
                    if (discreteSet.getElement(n).equals(objectArray[n4])) {
                        bl = false;
                    }
                    ++n4;
                }
                if (bl) {
                    objectArray[n2++] = discreteSet.getElement(n);
                }
                ++n;
            }
        }
        Object[] objectArray2 = new Object[n2];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray2.length);
        return new DiscreteSet("(" + this.toString() + ") U (" + discreteSet.toString() + ")", objectArray2);
    }

    public MathSet intersect(MathSet mathSet) {
        int n;
        Object[] objectArray;
        if (!(mathSet instanceof DiscreteSet)) {
            throw new IllegalArgumentException("Must be a discrete set.");
        }
        DiscreteSet discreteSet = (DiscreteSet)mathSet;
        int n2 = 0;
        if (this.elements.length > discreteSet.cardinality()) {
            objectArray = new Object[this.elements.length];
            n = 0;
            while (n < this.elements.length) {
                boolean bl = true;
                int n3 = 0;
                while (n3 < discreteSet.cardinality() && bl) {
                    if (this.elements[n].equals(discreteSet.getElement(n3))) {
                        objectArray[n2++] = this.elements[n];
                        bl = false;
                    }
                    ++n3;
                }
                ++n;
            }
        } else {
            objectArray = new Object[discreteSet.cardinality()];
            n = 0;
            while (n < discreteSet.cardinality()) {
                boolean bl = true;
                int n4 = 0;
                while (n4 < this.elements.length && bl) {
                    if (discreteSet.getElement(n).equals(this.elements[n4])) {
                        objectArray[n2++] = this.elements[n4];
                        bl = false;
                    }
                    ++n4;
                }
                ++n;
            }
        }
        Object[] objectArray2 = new Object[n2];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray2.length);
        return new DiscreteSet("(" + this.toString() + ") I (" + discreteSet.toString() + ")", objectArray2);
    }
}

