/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.ArrayMath;
import JSci.maths.Complex;
import JSci.maths.ComplexMapping;
import JSci.maths.ComplexMatrix;
import JSci.maths.ComplexSquareMatrix;
import JSci.maths.ComplexVector;
import JSci.maths.DimensionException;
import JSci.maths.DoubleMatrix;
import JSci.maths.DoubleTridiagonalMatrix;
import JSci.maths.LinearMath;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;
import JSci.maths.MaximumIterationsExceededException;

public class ComplexTridiagonalMatrix
extends ComplexSquareMatrix {
    protected static final int TRIDIAGONAL = 3;

    protected ComplexTridiagonalMatrix() {
    }

    public ComplexTridiagonalMatrix(int n) {
        this();
        this.storageFormat = 3;
        this.matrixRe = new double[3][n];
        this.matrixIm = new double[3][n];
    }

    public ComplexTridiagonalMatrix(Complex[][] complexArray) {
        this(complexArray.length);
        int n;
        if (complexArray.length == complexArray[0].length) {
            this.matrixRe[1][0] = complexArray[0][0].real();
            this.matrixIm[1][0] = complexArray[0][0].imag();
            this.matrixRe[2][0] = complexArray[0][1].real();
            this.matrixIm[2][0] = complexArray[0][1].imag();
            n = 1;
            while (n < complexArray.length - 1) {
                this.matrixRe[0][n] = complexArray[n][n - 1].real();
                this.matrixIm[0][n] = complexArray[n][n - 1].imag();
                this.matrixRe[1][n] = complexArray[n][n].real();
                this.matrixIm[1][n] = complexArray[n][n].imag();
                this.matrixRe[2][n] = complexArray[n][n + 1].real();
                this.matrixIm[2][n] = complexArray[n][n + 1].imag();
                ++n;
            }
        } else {
            this.matrixRe = null;
            this.matrixIm = null;
            throw new MatrixDimensionException("The array is not square.");
        }
        this.matrixRe[0][n] = complexArray[n][n - 1].real();
        this.matrixIm[0][n] = complexArray[n][n - 1].imag();
        this.matrixRe[1][n] = complexArray[n][n].real();
        this.matrixIm[1][n] = complexArray[n][n].imag();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof ComplexTridiagonalMatrix && this.matrixRe[1].length == ((ComplexTridiagonalMatrix)object).rows()) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix = (ComplexTridiagonalMatrix)object;
            if (!complexTridiagonalMatrix.getElement(0, 0).equals(this.matrixRe[1][0], this.matrixIm[1][0])) {
                return false;
            }
            if (!complexTridiagonalMatrix.getElement(0, 1).equals(this.matrixRe[2][0], this.matrixIm[2][0])) {
                return false;
            }
            int n = 1;
            while (n < this.matrixRe[1].length - 1) {
                if (!complexTridiagonalMatrix.getElement(n, n - 1).equals(this.matrixRe[0][n], this.matrixIm[0][n])) {
                    return false;
                }
                if (!complexTridiagonalMatrix.getElement(n, n).equals(this.matrixRe[1][n], this.matrixIm[1][n])) {
                    return false;
                }
                if (!complexTridiagonalMatrix.getElement(n, n + 1).equals(this.matrixRe[2][n], this.matrixIm[2][n])) {
                    return false;
                }
                ++n;
            }
            if (!complexTridiagonalMatrix.getElement(n, n - 1).equals(this.matrixRe[0][n], this.matrixIm[0][n])) {
                return false;
            }
            return complexTridiagonalMatrix.getElement(n, n).equals(this.matrixRe[1][n], this.matrixIm[1][n]);
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(5 * this.rows() * this.columns());
        int n = 0;
        while (n < this.rows()) {
            int n2 = 0;
            while (n2 < this.columns()) {
                stringBuffer.append(this.getElement(n, n2).toString());
                stringBuffer.append(' ');
                ++n2;
            }
            stringBuffer.append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    public DoubleMatrix real() {
        DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(this.matrixRe[1].length);
        doubleTridiagonalMatrix.matrix[1][0] = this.matrixRe[1][0];
        doubleTridiagonalMatrix.matrix[2][0] = this.matrixRe[2][0];
        int n = 1;
        while (n < this.matrixRe[1].length - 1) {
            doubleTridiagonalMatrix.matrix[0][n] = this.matrixRe[0][n];
            doubleTridiagonalMatrix.matrix[1][n] = this.matrixRe[1][n];
            doubleTridiagonalMatrix.matrix[2][n] = this.matrixRe[2][n];
            ++n;
        }
        doubleTridiagonalMatrix.matrix[0][n] = this.matrixRe[0][n];
        doubleTridiagonalMatrix.matrix[1][n] = this.matrixRe[1][n];
        return doubleTridiagonalMatrix;
    }

    public DoubleMatrix imag() {
        DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(this.matrixIm[1].length);
        doubleTridiagonalMatrix.matrix[1][0] = this.matrixIm[1][0];
        doubleTridiagonalMatrix.matrix[2][0] = this.matrixIm[2][0];
        int n = 1;
        while (n < this.matrixIm[1].length - 1) {
            doubleTridiagonalMatrix.matrix[0][n] = this.matrixIm[0][n];
            doubleTridiagonalMatrix.matrix[1][n] = this.matrixIm[1][n];
            doubleTridiagonalMatrix.matrix[2][n] = this.matrixIm[2][n];
            ++n;
        }
        doubleTridiagonalMatrix.matrix[0][n] = this.matrixIm[0][n];
        doubleTridiagonalMatrix.matrix[1][n] = this.matrixIm[1][n];
        return doubleTridiagonalMatrix;
    }

    public Complex getElement(int n, int n2) {
        if (n >= 0 && n < this.matrixRe[1].length && n2 >= 0 && n2 < this.matrixRe[1].length) {
            if (n2 >= n - 1 && n2 <= n + 1) {
                return new Complex(this.matrixRe[n2 - n + 1][n], this.matrixIm[n2 - n + 1][n]);
            }
            return Complex.ZERO;
        }
        throw new MatrixDimensionException("Invalid element.");
    }

    public void setElement(int n, int n2, Complex complex) {
        if (n >= 0 && n < this.matrixRe[1].length && n2 >= 0 && n2 < this.matrixRe[1].length) {
            if (n2 < n - 1 || n2 > n + 1) {
                throw new MatrixDimensionException("Invalid element.");
            }
        } else {
            throw new MatrixDimensionException("Invalid element.");
        }
        this.matrixRe[n2 - n + 1][n] = complex.real();
        this.matrixIm[n2 - n + 1][n] = complex.imag();
    }

    public Complex trace() {
        double d = this.matrixRe[1][0];
        double d2 = this.matrixIm[1][0];
        int n = 1;
        while (n < this.matrixRe[1].length) {
            d += this.matrixRe[1][n];
            d2 += this.matrixIm[1][n];
            ++n;
        }
        return new Complex(d, d2);
    }

    public double infNorm() {
        double d;
        double d2 = Math.sqrt(this.matrixRe[1][0] * this.matrixRe[1][0] + this.matrixIm[1][0] * this.matrixIm[1][0]) + Math.sqrt(this.matrixRe[2][0] * this.matrixRe[2][0] + this.matrixIm[2][0] * this.matrixIm[2][0]);
        int n = 1;
        while (n < this.matrixRe[1].length - 1) {
            d = Math.sqrt(this.matrixRe[0][n] * this.matrixRe[0][n] + this.matrixIm[0][n] * this.matrixIm[0][n]) + Math.sqrt(this.matrixRe[1][n] * this.matrixRe[1][n] + this.matrixIm[1][n] * this.matrixIm[1][n]) + Math.sqrt(this.matrixRe[2][n] * this.matrixRe[2][n] + this.matrixIm[2][n] * this.matrixIm[2][n]);
            if (d > d2) {
                d2 = d;
            }
            ++n;
        }
        d = Math.sqrt(this.matrixRe[0][n] * this.matrixRe[0][n] + this.matrixIm[0][n] * this.matrixIm[0][n]) + Math.sqrt(this.matrixRe[1][n] * this.matrixRe[1][n] + this.matrixIm[1][n] * this.matrixIm[1][n]);
        if (d > d2) {
            d2 = d;
        }
        return d2;
    }

    public double frobeniusNorm() {
        double d = this.matrixRe[1][0] * this.matrixRe[1][0] + this.matrixIm[1][0] * this.matrixIm[1][0] + this.matrixRe[2][0] * this.matrixRe[2][0] + this.matrixIm[2][0] * this.matrixIm[2][0];
        int n = 1;
        while (n < this.matrixRe[1].length - 1) {
            d += this.matrixRe[0][n] * this.matrixRe[0][n] + this.matrixIm[0][n] * this.matrixIm[0][n] + this.matrixRe[1][n] * this.matrixRe[1][n] + this.matrixIm[1][n] * this.matrixIm[1][n] + this.matrixRe[2][n] * this.matrixRe[2][n] + this.matrixIm[2][n] * this.matrixIm[2][n];
            ++n;
        }
        return Math.sqrt(d += this.matrixRe[0][n] * this.matrixRe[0][n] + this.matrixIm[0][n] * this.matrixIm[0][n] + this.matrixRe[1][n] * this.matrixRe[1][n] + this.matrixIm[1][n] * this.matrixIm[1][n]);
    }

    public double operatorNorm() throws MaximumIterationsExceededException {
        return Math.sqrt(ArrayMath.max(LinearMath.eigenvalueSolveHermitian((ComplexTridiagonalMatrix)this.hermitianAdjoint().multiply(this))));
    }

    public int rows() {
        return this.matrixRe[1].length;
    }

    public int columns() {
        return this.matrixRe[1].length;
    }

    public ComplexMatrix add(ComplexMatrix complexMatrix) {
        switch (complexMatrix.storageFormat) {
            case 1: {
                return this.rawAdd(complexMatrix);
            }
            case 3: {
                return this.rawAddTridiagonal(complexMatrix);
            }
        }
        if (this.matrixRe[1].length == complexMatrix.rows() && this.matrixRe[1].length == complexMatrix.columns()) {
            double[][] dArray = new double[this.matrixRe[1].length][this.matrixRe[1].length];
            double[][] dArray2 = new double[this.matrixIm[1].length][this.matrixIm[1].length];
            int n = 0;
            while (n < dArray.length) {
                Complex complex = this.getElement(n, 0).add(complexMatrix.getElement(n, 0));
                dArray[n][0] = complex.real();
                dArray2[n][0] = complex.imag();
                int n2 = 1;
                while (n2 < dArray.length) {
                    complex = this.getElement(n, n2).add(complexMatrix.getElement(n, n2));
                    dArray[n][n2] = complex.real();
                    dArray2[n][n2] = complex.imag();
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexSquareMatrix rawAdd(ComplexMatrix complexMatrix) {
        if (this.matrixRe[1].length == complexMatrix.matrixRe.length && this.matrixRe[1].length == complexMatrix.matrixRe[0].length) {
            double[][] dArray = new double[this.matrixRe[1].length][this.matrixRe[1].length];
            double[][] dArray2 = new double[this.matrixIm[1].length][this.matrixIm[1].length];
            int n = 0;
            while (n < dArray.length) {
                System.arraycopy(complexMatrix.matrixRe[n], 0, dArray[n], 0, dArray.length);
                System.arraycopy(complexMatrix.matrixIm[n], 0, dArray2[n], 0, dArray2.length);
                ++n;
            }
            double[] dArray3 = dArray[0];
            dArray3[0] = dArray3[0] + this.matrixRe[1][0];
            double[] dArray4 = dArray2[0];
            dArray4[0] = dArray4[0] + this.matrixIm[1][0];
            double[] dArray5 = dArray[0];
            dArray5[1] = dArray5[1] + this.matrixRe[2][0];
            double[] dArray6 = dArray2[0];
            dArray6[1] = dArray6[1] + this.matrixIm[2][0];
            int n2 = dArray.length - 1;
            int n3 = 1;
            while (n3 < n2) {
                double[] dArray7 = dArray[n3];
                int n4 = n3 - 1;
                dArray7[n4] = dArray7[n4] + this.matrixRe[0][n3];
                double[] dArray8 = dArray2[n3];
                int n5 = n3 - 1;
                dArray8[n5] = dArray8[n5] + this.matrixIm[0][n3];
                double[] dArray9 = dArray[n3];
                int n6 = n3;
                dArray9[n6] = dArray9[n6] + this.matrixRe[1][n3];
                double[] dArray10 = dArray2[n3];
                int n7 = n3;
                dArray10[n7] = dArray10[n7] + this.matrixIm[1][n3];
                double[] dArray11 = dArray[n3];
                int n8 = n3 + 1;
                dArray11[n8] = dArray11[n8] + this.matrixRe[2][n3];
                double[] dArray12 = dArray2[n3];
                int n9 = n3 + 1;
                dArray12[n9] = dArray12[n9] + this.matrixIm[2][n3];
                ++n3;
            }
            double[] dArray13 = dArray[n2];
            int n10 = n2 - 1;
            dArray13[n10] = dArray13[n10] + this.matrixRe[0][n2];
            double[] dArray14 = dArray2[n2];
            int n11 = n2 - 1;
            dArray14[n11] = dArray14[n11] + this.matrixIm[0][n2];
            double[] dArray15 = dArray[n2];
            int n12 = n2;
            dArray15[n12] = dArray15[n12] + this.matrixRe[1][n2];
            double[] dArray16 = dArray2[n2];
            int n13 = n2;
            dArray16[n13] = dArray16[n13] + this.matrixIm[1][n2];
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix add(ComplexSquareMatrix complexSquareMatrix) {
        switch (complexSquareMatrix.storageFormat) {
            case 1: {
                return this.rawAdd(complexSquareMatrix);
            }
            case 3: {
                return this.rawAddTridiagonal(complexSquareMatrix);
            }
        }
        if (this.matrixRe[1].length == complexSquareMatrix.rows()) {
            double[][] dArray = new double[this.matrixRe[1].length][this.matrixRe[1].length];
            double[][] dArray2 = new double[this.matrixIm[1].length][this.matrixIm[1].length];
            int n = 0;
            while (n < dArray.length) {
                Complex complex = this.getElement(n, 0).add(complexSquareMatrix.getElement(n, 0));
                dArray[n][0] = complex.real();
                dArray2[n][0] = complex.imag();
                int n2 = 1;
                while (n2 < dArray.length) {
                    complex = this.getElement(n, n2).add(complexSquareMatrix.getElement(n, n2));
                    dArray[n][n2] = complex.real();
                    dArray2[n][n2] = complex.imag();
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexTridiagonalMatrix add(ComplexTridiagonalMatrix complexTridiagonalMatrix) {
        switch (complexTridiagonalMatrix.storageFormat) {
            case 3: {
                return this.rawAddTridiagonal(complexTridiagonalMatrix);
            }
        }
        int n = this.matrixRe[1].length;
        if (n == complexTridiagonalMatrix.rows()) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix2 = new ComplexTridiagonalMatrix(n);
            Complex complex = complexTridiagonalMatrix.getElement(0, 0);
            complexTridiagonalMatrix2.matrixRe[1][0] = this.matrixRe[1][0] + complex.real();
            complexTridiagonalMatrix2.matrixIm[1][0] = this.matrixIm[1][0] + complex.imag();
            complex = complexTridiagonalMatrix.getElement(0, 1);
            complexTridiagonalMatrix2.matrixRe[2][0] = this.matrixRe[2][0] + complex.real();
            complexTridiagonalMatrix2.matrixIm[2][0] = this.matrixIm[2][0] + complex.imag();
            --n;
            int n2 = 1;
            while (n2 < n) {
                complex = complexTridiagonalMatrix.getElement(n2, n2 - 1);
                complexTridiagonalMatrix2.matrixRe[0][n2] = this.matrixRe[0][n2] + complex.real();
                complexTridiagonalMatrix2.matrixIm[0][n2] = this.matrixIm[0][n2] + complex.imag();
                complex = complexTridiagonalMatrix.getElement(n2, n2);
                complexTridiagonalMatrix2.matrixRe[1][n2] = this.matrixRe[1][n2] + complex.real();
                complexTridiagonalMatrix2.matrixIm[1][n2] = this.matrixIm[1][n2] + complex.imag();
                complex = complexTridiagonalMatrix.getElement(n2, n2 + 1);
                complexTridiagonalMatrix2.matrixRe[2][n2] = this.matrixRe[2][n2] + complex.real();
                complexTridiagonalMatrix2.matrixIm[2][n2] = this.matrixIm[2][n2] + complex.imag();
                ++n2;
            }
            complex = complexTridiagonalMatrix.getElement(n, n - 1);
            complexTridiagonalMatrix2.matrixRe[0][n] = this.matrixRe[0][n] + complex.real();
            complexTridiagonalMatrix2.matrixIm[0][n] = this.matrixIm[0][n] + complex.imag();
            complex = complexTridiagonalMatrix.getElement(n, n);
            complexTridiagonalMatrix2.matrixRe[1][n] = this.matrixRe[1][n] + complex.real();
            complexTridiagonalMatrix2.matrixIm[1][n] = this.matrixIm[1][n] + complex.imag();
            return complexTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexTridiagonalMatrix rawAddTridiagonal(ComplexMatrix complexMatrix) {
        int n = this.matrixRe[1].length;
        if (n == complexMatrix.matrixRe[1].length) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
            complexTridiagonalMatrix.matrixRe[1][0] = this.matrixRe[1][0] + complexMatrix.matrixRe[1][0];
            complexTridiagonalMatrix.matrixIm[1][0] = this.matrixIm[1][0] + complexMatrix.matrixIm[1][0];
            complexTridiagonalMatrix.matrixRe[2][0] = this.matrixRe[2][0] + complexMatrix.matrixRe[2][0];
            complexTridiagonalMatrix.matrixIm[2][0] = this.matrixIm[2][0] + complexMatrix.matrixIm[2][0];
            --n;
            int n2 = 1;
            while (n2 < n) {
                complexTridiagonalMatrix.matrixRe[0][n2] = this.matrixRe[0][n2] + complexMatrix.matrixRe[0][n2];
                complexTridiagonalMatrix.matrixIm[0][n2] = this.matrixIm[0][n2] + complexMatrix.matrixIm[0][n2];
                complexTridiagonalMatrix.matrixRe[1][n2] = this.matrixRe[1][n2] + complexMatrix.matrixRe[1][n2];
                complexTridiagonalMatrix.matrixIm[1][n2] = this.matrixIm[1][n2] + complexMatrix.matrixIm[1][n2];
                complexTridiagonalMatrix.matrixRe[2][n2] = this.matrixRe[2][n2] + complexMatrix.matrixRe[2][n2];
                complexTridiagonalMatrix.matrixIm[2][n2] = this.matrixIm[2][n2] + complexMatrix.matrixIm[2][n2];
                ++n2;
            }
            complexTridiagonalMatrix.matrixRe[0][n] = this.matrixRe[0][n] + complexMatrix.matrixRe[0][n];
            complexTridiagonalMatrix.matrixIm[0][n] = this.matrixIm[0][n] + complexMatrix.matrixIm[0][n];
            complexTridiagonalMatrix.matrixRe[1][n] = this.matrixRe[1][n] + complexMatrix.matrixRe[1][n];
            complexTridiagonalMatrix.matrixIm[1][n] = this.matrixIm[1][n] + complexMatrix.matrixIm[1][n];
            return complexTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexMatrix subtract(ComplexMatrix complexMatrix) {
        switch (complexMatrix.storageFormat) {
            case 1: {
                return this.rawSubtract(complexMatrix);
            }
            case 3: {
                return this.rawSubtractTridiagonal(complexMatrix);
            }
        }
        if (this.matrixRe[1].length == complexMatrix.rows() && this.matrixRe[1].length == complexMatrix.columns()) {
            double[][] dArray = new double[this.matrixRe[1].length][this.matrixRe[1].length];
            double[][] dArray2 = new double[this.matrixIm[1].length][this.matrixIm[1].length];
            int n = 0;
            while (n < dArray.length) {
                Complex complex = this.getElement(n, 0).subtract(complexMatrix.getElement(n, 0));
                dArray[n][0] = complex.real();
                dArray2[n][0] = complex.imag();
                int n2 = 1;
                while (n2 < dArray.length) {
                    complex = this.getElement(n, n2).subtract(complexMatrix.getElement(n, n2));
                    dArray[n][n2] = complex.real();
                    dArray2[n][n2] = complex.imag();
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexSquareMatrix rawSubtract(ComplexMatrix complexMatrix) {
        if (this.matrixRe[1].length == complexMatrix.matrixRe.length && this.matrixRe[1].length == complexMatrix.matrixRe[0].length) {
            double[][] dArray = new double[this.matrixRe[1].length][this.matrixRe[1].length];
            double[][] dArray2 = new double[this.matrixIm[1].length][this.matrixIm[1].length];
            int n = 0;
            while (n < dArray.length) {
                Complex complex = this.getElement(n, 0);
                dArray[n][0] = complex.real() - complexMatrix.matrixRe[n][0];
                dArray2[n][0] = complex.imag() - complexMatrix.matrixIm[n][0];
                int n2 = 1;
                while (n2 < dArray.length) {
                    complex = this.getElement(n, n2);
                    dArray[n][n2] = complex.real() - complexMatrix.matrixRe[n][n2];
                    dArray2[n][n2] = complex.imag() - complexMatrix.matrixIm[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix subtract(ComplexSquareMatrix complexSquareMatrix) {
        switch (complexSquareMatrix.storageFormat) {
            case 1: {
                return this.rawSubtract(complexSquareMatrix);
            }
            case 3: {
                return this.rawSubtractTridiagonal(complexSquareMatrix);
            }
        }
        if (this.matrixRe[1].length == complexSquareMatrix.rows()) {
            double[][] dArray = new double[this.matrixRe[1].length][this.matrixRe[1].length];
            double[][] dArray2 = new double[this.matrixIm[1].length][this.matrixIm[1].length];
            int n = 0;
            while (n < dArray.length) {
                Complex complex = this.getElement(n, 0).subtract(complexSquareMatrix.getElement(n, 0));
                dArray[n][0] = complex.real();
                dArray2[n][0] = complex.imag();
                int n2 = 1;
                while (n2 < dArray.length) {
                    complex = this.getElement(n, n2).subtract(complexSquareMatrix.getElement(n, n2));
                    dArray[n][n2] = complex.real();
                    dArray2[n][n2] = complex.imag();
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexTridiagonalMatrix subtract(ComplexTridiagonalMatrix complexTridiagonalMatrix) {
        switch (complexTridiagonalMatrix.storageFormat) {
            case 3: {
                return this.rawSubtractTridiagonal(complexTridiagonalMatrix);
            }
        }
        int n = this.matrixRe[1].length;
        if (n == complexTridiagonalMatrix.rows()) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix2 = new ComplexTridiagonalMatrix(n);
            Complex complex = complexTridiagonalMatrix.getElement(0, 0);
            complexTridiagonalMatrix2.matrixRe[1][0] = this.matrixRe[1][0] - complex.real();
            complexTridiagonalMatrix2.matrixIm[1][0] = this.matrixIm[1][0] - complex.imag();
            complex = complexTridiagonalMatrix.getElement(0, 1);
            complexTridiagonalMatrix2.matrixRe[2][0] = this.matrixRe[2][0] - complex.real();
            complexTridiagonalMatrix2.matrixIm[2][0] = this.matrixIm[2][0] - complex.imag();
            --n;
            int n2 = 1;
            while (n2 < n) {
                complex = complexTridiagonalMatrix.getElement(n2, n2 - 1);
                complexTridiagonalMatrix2.matrixRe[0][n2] = this.matrixRe[0][n2] - complex.real();
                complexTridiagonalMatrix2.matrixIm[0][n2] = this.matrixIm[0][n2] - complex.imag();
                complex = complexTridiagonalMatrix.getElement(n2, n2);
                complexTridiagonalMatrix2.matrixRe[1][n2] = this.matrixRe[1][n2] - complex.real();
                complexTridiagonalMatrix2.matrixIm[1][n2] = this.matrixIm[1][n2] - complex.imag();
                complex = complexTridiagonalMatrix.getElement(n2, n2 + 1);
                complexTridiagonalMatrix2.matrixRe[2][n2] = this.matrixRe[2][n2] - complex.real();
                complexTridiagonalMatrix2.matrixIm[2][n2] = this.matrixIm[2][n2] - complex.imag();
                ++n2;
            }
            complex = complexTridiagonalMatrix.getElement(n, n - 1);
            complexTridiagonalMatrix2.matrixRe[0][n] = this.matrixRe[0][n] - complex.real();
            complexTridiagonalMatrix2.matrixIm[0][n] = this.matrixIm[0][n] - complex.imag();
            complex = complexTridiagonalMatrix.getElement(n, n);
            complexTridiagonalMatrix2.matrixRe[1][n] = this.matrixRe[1][n] - complex.real();
            complexTridiagonalMatrix2.matrixIm[1][n] = this.matrixIm[1][n] - complex.imag();
            return complexTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexTridiagonalMatrix rawSubtractTridiagonal(ComplexMatrix complexMatrix) {
        int n = this.matrixRe[1].length;
        if (n == complexMatrix.matrixRe[1].length) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
            complexTridiagonalMatrix.matrixRe[1][0] = this.matrixRe[1][0] - complexMatrix.matrixRe[1][0];
            complexTridiagonalMatrix.matrixIm[1][0] = this.matrixIm[1][0] - complexMatrix.matrixIm[1][0];
            complexTridiagonalMatrix.matrixRe[2][0] = this.matrixRe[2][0] - complexMatrix.matrixRe[2][0];
            complexTridiagonalMatrix.matrixIm[2][0] = this.matrixIm[2][0] - complexMatrix.matrixIm[2][0];
            --n;
            int n2 = 1;
            while (n2 < n) {
                complexTridiagonalMatrix.matrixRe[0][n2] = this.matrixRe[0][n2] - complexMatrix.matrixRe[0][n2];
                complexTridiagonalMatrix.matrixIm[0][n2] = this.matrixIm[0][n2] - complexMatrix.matrixIm[0][n2];
                complexTridiagonalMatrix.matrixRe[1][n2] = this.matrixRe[1][n2] - complexMatrix.matrixRe[1][n2];
                complexTridiagonalMatrix.matrixIm[1][n2] = this.matrixIm[1][n2] - complexMatrix.matrixIm[1][n2];
                complexTridiagonalMatrix.matrixRe[2][n2] = this.matrixRe[2][n2] - complexMatrix.matrixRe[2][n2];
                complexTridiagonalMatrix.matrixIm[2][n2] = this.matrixIm[2][n2] - complexMatrix.matrixIm[2][n2];
                ++n2;
            }
            complexTridiagonalMatrix.matrixRe[0][n] = this.matrixRe[0][n] - complexMatrix.matrixRe[0][n];
            complexTridiagonalMatrix.matrixIm[0][n] = this.matrixIm[0][n] - complexMatrix.matrixIm[0][n];
            complexTridiagonalMatrix.matrixRe[1][n] = this.matrixRe[1][n] - complexMatrix.matrixRe[1][n];
            complexTridiagonalMatrix.matrixIm[1][n] = this.matrixIm[1][n] - complexMatrix.matrixIm[1][n];
            return complexTridiagonalMatrix;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexMatrix scalarMultiply(Complex complex) {
        double d = complex.real();
        double d2 = complex.imag();
        int n = this.matrixRe[1].length;
        ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
        complexTridiagonalMatrix.matrixRe[1][0] = d * this.matrixRe[1][0] - d2 * this.matrixIm[1][0];
        complexTridiagonalMatrix.matrixIm[1][0] = d2 * this.matrixRe[1][0] + d * this.matrixIm[1][0];
        complexTridiagonalMatrix.matrixRe[2][0] = d * this.matrixRe[2][0] - d2 * this.matrixIm[2][0];
        complexTridiagonalMatrix.matrixIm[2][0] = d2 * this.matrixRe[2][0] + d * this.matrixIm[2][0];
        --n;
        int n2 = 1;
        while (n2 < n) {
            complexTridiagonalMatrix.matrixRe[0][n2] = d * this.matrixRe[0][n2] - d2 * this.matrixIm[0][n2];
            complexTridiagonalMatrix.matrixIm[0][n2] = d2 * this.matrixRe[0][n2] + d * this.matrixIm[0][n2];
            complexTridiagonalMatrix.matrixRe[1][n2] = d * this.matrixRe[1][n2] - d2 * this.matrixIm[1][n2];
            complexTridiagonalMatrix.matrixIm[1][n2] = d2 * this.matrixRe[1][n2] + d * this.matrixIm[1][n2];
            complexTridiagonalMatrix.matrixRe[2][n2] = d * this.matrixRe[2][n2] - d2 * this.matrixIm[2][n2];
            complexTridiagonalMatrix.matrixIm[2][n2] = d2 * this.matrixRe[2][n2] + d * this.matrixIm[2][n2];
            ++n2;
        }
        complexTridiagonalMatrix.matrixRe[0][n] = d * this.matrixRe[0][n] - d2 * this.matrixIm[0][n];
        complexTridiagonalMatrix.matrixIm[0][n] = d2 * this.matrixRe[0][n] + d * this.matrixIm[0][n];
        complexTridiagonalMatrix.matrixRe[1][n] = d * this.matrixRe[1][n] - d2 * this.matrixIm[1][n];
        complexTridiagonalMatrix.matrixIm[1][n] = d2 * this.matrixRe[1][n] + d * this.matrixIm[1][n];
        return complexTridiagonalMatrix;
    }

    public ComplexMatrix scalarMultiply(double d) {
        int n = this.matrixRe[1].length;
        ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
        complexTridiagonalMatrix.matrixRe[1][0] = d * this.matrixRe[1][0];
        complexTridiagonalMatrix.matrixIm[1][0] = d * this.matrixIm[1][0];
        complexTridiagonalMatrix.matrixRe[2][0] = d * this.matrixRe[2][0];
        complexTridiagonalMatrix.matrixIm[2][0] = d * this.matrixIm[2][0];
        --n;
        int n2 = 1;
        while (n2 < n) {
            complexTridiagonalMatrix.matrixRe[0][n2] = d * this.matrixRe[0][n2];
            complexTridiagonalMatrix.matrixIm[0][n2] = d * this.matrixIm[0][n2];
            complexTridiagonalMatrix.matrixRe[1][n2] = d * this.matrixRe[1][n2];
            complexTridiagonalMatrix.matrixIm[1][n2] = d * this.matrixIm[1][n2];
            complexTridiagonalMatrix.matrixRe[2][n2] = d * this.matrixRe[2][n2];
            complexTridiagonalMatrix.matrixIm[2][n2] = d * this.matrixIm[2][n2];
            ++n2;
        }
        complexTridiagonalMatrix.matrixRe[0][n] = d * this.matrixRe[0][n];
        complexTridiagonalMatrix.matrixIm[0][n] = d * this.matrixIm[0][n];
        complexTridiagonalMatrix.matrixRe[1][n] = d * this.matrixRe[1][n];
        complexTridiagonalMatrix.matrixIm[1][n] = d * this.matrixIm[1][n];
        return complexTridiagonalMatrix;
    }

    public ComplexVector multiply(ComplexVector complexVector) {
        int n = this.matrixRe[1].length;
        if (n == complexVector.dimension()) {
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            Complex complex = complexVector.getComponent(0);
            dArray[0] = this.matrixRe[1][0] * complex.real() - this.matrixIm[1][0] * complex.imag();
            dArray2[0] = this.matrixIm[1][0] * complex.real() + this.matrixRe[1][0] * complex.imag();
            complex = complexVector.getComponent(1);
            dArray[0] = dArray[0] + (this.matrixRe[2][0] * complex.real() - this.matrixIm[2][0] * complex.imag());
            dArray2[0] = dArray2[0] + (this.matrixIm[2][0] * complex.real() + this.matrixRe[2][0] * complex.imag());
            --n;
            int n2 = 1;
            while (n2 < n) {
                complex = complexVector.getComponent(n2 - 1);
                dArray[n2] = this.matrixRe[0][n2] * complex.real() - this.matrixIm[0][n2] * complex.imag();
                dArray2[n2] = this.matrixIm[0][n2] * complex.real() + this.matrixRe[0][n2] * complex.imag();
                complex = complexVector.getComponent(n2);
                int n3 = n2;
                dArray[n3] = dArray[n3] + (this.matrixRe[1][n2] * complex.real() - this.matrixIm[1][n2] * complex.imag());
                int n4 = n2;
                dArray2[n4] = dArray2[n4] + (this.matrixIm[1][n2] * complex.real() + this.matrixRe[1][n2] * complex.imag());
                complex = complexVector.getComponent(n2 + 1);
                int n5 = n2;
                dArray[n5] = dArray[n5] + (this.matrixRe[2][n2] * complex.real() - this.matrixIm[2][n2] * complex.imag());
                int n6 = n2;
                dArray2[n6] = dArray2[n6] + (this.matrixIm[2][n2] * complex.real() + this.matrixRe[2][n2] * complex.imag());
                ++n2;
            }
            complex = complexVector.getComponent(n - 1);
            dArray[n] = this.matrixRe[0][n] * complex.real() - this.matrixIm[0][n] * complex.imag();
            dArray2[n] = this.matrixIm[0][n] * complex.real() + this.matrixRe[0][n] * complex.imag();
            complex = complexVector.getComponent(n);
            int n7 = n;
            dArray[n7] = dArray[n7] + (this.matrixRe[1][n] * complex.real() - this.matrixIm[1][n] * complex.imag());
            int n8 = n;
            dArray2[n8] = dArray2[n8] + (this.matrixIm[1][n] * complex.real() + this.matrixRe[1][n] * complex.imag());
            return new ComplexVector(dArray, dArray2);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public ComplexMatrix multiply(ComplexMatrix complexMatrix) {
        switch (complexMatrix.storageFormat) {
            case 1: {
                return this.rawMultiply(complexMatrix);
            }
            case 3: {
                return this.rawMultiplyTridiagonal(complexMatrix);
            }
        }
        if (this.matrixRe[1].length == complexMatrix.rows()) {
            double[][] dArray = new double[this.matrixRe[1].length][complexMatrix.columns()];
            double[][] dArray2 = new double[this.matrixIm[1].length][complexMatrix.columns()];
            int n = 0;
            while (n < dArray.length) {
                int n2 = 0;
                while (n2 < dArray[0].length) {
                    Complex complex = this.getElement(n, 0).multiply(complexMatrix.getElement(0, n2));
                    dArray[n][n2] = complex.real();
                    dArray2[n][n2] = complex.imag();
                    int n3 = 1;
                    while (n3 < this.matrixRe[1].length) {
                        complex = this.getElement(n, n3).multiply(complexMatrix.getElement(n3, n2));
                        double[] dArray3 = dArray[n];
                        int n4 = n2;
                        dArray3[n4] = dArray3[n4] + complex.real();
                        double[] dArray4 = dArray2[n];
                        int n5 = n2;
                        dArray4[n5] = dArray4[n5] + complex.imag();
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new ComplexMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private ComplexMatrix rawMultiply(ComplexMatrix complexMatrix) {
        if (this.matrixRe[1].length == complexMatrix.matrixRe.length) {
            double[][] dArray = new double[this.matrixRe[1].length][complexMatrix.matrixRe[0].length];
            double[][] dArray2 = new double[this.matrixIm[1].length][complexMatrix.matrixIm[0].length];
            int n = 0;
            while (n < dArray.length) {
                int n2 = 0;
                while (n2 < dArray[0].length) {
                    Complex complex = this.getElement(n, 0);
                    double d = complex.real() * complexMatrix.matrixRe[0][n2] - complex.imag() * complexMatrix.matrixIm[0][n2];
                    double d2 = complex.imag() * complexMatrix.matrixRe[0][n2] + complex.real() * complexMatrix.matrixIm[0][n2];
                    int n3 = 1;
                    while (n3 < this.matrixRe[1].length) {
                        complex = this.getElement(n, n3);
                        d += complex.real() * complexMatrix.matrixRe[n3][n2] - complex.imag() * complexMatrix.matrixIm[n3][n2];
                        d2 += complex.imag() * complexMatrix.matrixRe[n3][n2] + complex.real() * complexMatrix.matrixIm[n3][n2];
                        ++n3;
                    }
                    dArray[n][n2] = d;
                    dArray2[n][n2] = d2;
                    ++n2;
                }
                ++n;
            }
            return new ComplexMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public ComplexSquareMatrix multiply(ComplexSquareMatrix complexSquareMatrix) {
        switch (complexSquareMatrix.storageFormat) {
            case 1: {
                return this.rawMultiply(complexSquareMatrix);
            }
            case 3: {
                return this.rawMultiplyTridiagonal(complexSquareMatrix);
            }
        }
        if (this.matrixRe[1].length == complexSquareMatrix.rows()) {
            double[][] dArray = new double[this.matrixRe[1].length][this.matrixRe[1].length];
            double[][] dArray2 = new double[this.matrixIm[1].length][this.matrixIm[1].length];
            int n = 0;
            while (n < dArray.length) {
                int n2 = 0;
                while (n2 < dArray.length) {
                    Complex complex = this.getElement(n, 0).multiply(complexSquareMatrix.getElement(0, n2));
                    dArray[n][n2] = complex.real();
                    dArray2[n][n2] = complex.imag();
                    int n3 = 1;
                    while (n3 < dArray.length) {
                        complex = this.getElement(n, n3).multiply(complexSquareMatrix.getElement(n3, n2));
                        double[] dArray3 = dArray[n];
                        int n4 = n2;
                        dArray3[n4] = dArray3[n4] + complex.real();
                        double[] dArray4 = dArray2[n];
                        int n5 = n2;
                        dArray4[n5] = dArray4[n5] + complex.imag();
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private ComplexSquareMatrix rawMultiply(ComplexSquareMatrix complexSquareMatrix) {
        if (this.matrixRe[1].length == complexSquareMatrix.matrixRe.length) {
            double[][] dArray = new double[this.matrixRe[1].length][this.matrixRe[1].length];
            double[][] dArray2 = new double[this.matrixIm[1].length][this.matrixIm[1].length];
            int n = 0;
            while (n < dArray.length) {
                int n2 = 0;
                while (n2 < dArray.length) {
                    Complex complex = this.getElement(n, 0);
                    double d = complex.real() * complexSquareMatrix.matrixRe[0][n2] - complex.imag() * complexSquareMatrix.matrixIm[0][n2];
                    double d2 = complex.imag() * complexSquareMatrix.matrixRe[0][n2] + complex.real() * complexSquareMatrix.matrixIm[0][n2];
                    int n3 = 1;
                    while (n3 < dArray.length) {
                        complex = this.getElement(n, n3);
                        d += complex.real() * complexSquareMatrix.matrixRe[n3][n2] - complex.imag() * complexSquareMatrix.matrixIm[n3][n2];
                        d2 += complex.imag() * complexSquareMatrix.matrixRe[n3][n2] + complex.real() * complexSquareMatrix.matrixIm[n3][n2];
                        ++n3;
                    }
                    dArray[n][n2] = d;
                    dArray2[n][n2] = d2;
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public ComplexSquareMatrix multiply(ComplexTridiagonalMatrix complexTridiagonalMatrix) {
        switch (complexTridiagonalMatrix.storageFormat) {
            case 3: {
                return this.rawMultiplyTridiagonal(complexTridiagonalMatrix);
            }
        }
        int n = this.matrixRe[1].length;
        if (n == complexTridiagonalMatrix.rows()) {
            Complex complex;
            double[][] dArray = new double[n][n];
            double[][] dArray2 = new double[n][n];
            Complex complex2 = complexTridiagonalMatrix.getElement(0, 0);
            Complex complex3 = complexTridiagonalMatrix.getElement(1, 0);
            dArray[0][0] = this.matrixRe[1][0] * complex2.real() - this.matrixIm[1][0] * complex2.imag() + (this.matrixRe[2][0] * complex3.real() - this.matrixIm[2][0] * complex3.imag());
            dArray2[0][0] = this.matrixIm[1][0] * complex2.real() + this.matrixRe[1][0] * complex2.imag() + (this.matrixIm[2][0] * complex3.real() + this.matrixRe[2][0] * complex3.imag());
            complex2 = complexTridiagonalMatrix.getElement(0, 1);
            complex3 = complexTridiagonalMatrix.getElement(1, 1);
            dArray[0][1] = this.matrixRe[1][0] * complex2.real() - this.matrixIm[1][0] * complex2.imag() + (this.matrixRe[2][0] * complex3.real() - this.matrixIm[2][0] * complex3.imag());
            dArray2[0][1] = this.matrixIm[1][0] * complex2.real() + this.matrixRe[1][0] * complex2.imag() + (this.matrixIm[2][0] * complex3.real() + this.matrixRe[2][0] * complex3.imag());
            complex2 = complexTridiagonalMatrix.getElement(1, 2);
            dArray[0][2] = this.matrixRe[2][0] * complex2.real() - this.matrixIm[2][0] * complex2.imag();
            dArray2[0][2] = this.matrixIm[2][0] * complex2.real() + this.matrixRe[2][0] * complex2.imag();
            if (n > 3) {
                complex2 = complexTridiagonalMatrix.getElement(0, 0);
                complex3 = complexTridiagonalMatrix.getElement(1, 0);
                dArray[1][0] = this.matrixRe[0][1] * complex2.real() - this.matrixIm[0][1] * complex2.imag() + (this.matrixRe[1][1] * complex3.real() - this.matrixIm[1][1] * complex3.imag());
                dArray2[1][0] = this.matrixIm[0][1] * complex2.real() + this.matrixRe[0][1] * complex2.imag() + (this.matrixIm[1][1] * complex3.real() + this.matrixRe[1][1] * complex3.imag());
                complex2 = complexTridiagonalMatrix.getElement(0, 1);
                complex3 = complexTridiagonalMatrix.getElement(1, 1);
                complex = complexTridiagonalMatrix.getElement(2, 1);
                dArray[1][1] = this.matrixRe[0][1] * complex2.real() - this.matrixIm[0][1] * complex2.imag() + (this.matrixRe[1][1] * complex3.real() - this.matrixIm[1][1] * complex3.imag()) + (this.matrixRe[2][1] * complex.real() - this.matrixIm[2][1] * complex.imag());
                dArray2[1][1] = this.matrixIm[0][1] * complex2.real() + this.matrixRe[0][1] * complex2.imag() + (this.matrixIm[1][1] * complex3.real() + this.matrixRe[1][1] * complex3.imag()) + (this.matrixIm[2][1] * complex.real() + this.matrixRe[2][1] * complex.imag());
                complex2 = complexTridiagonalMatrix.getElement(1, 2);
                complex3 = complexTridiagonalMatrix.getElement(2, 2);
                dArray[1][2] = this.matrixRe[1][1] * complex2.real() - this.matrixIm[1][1] * complex2.imag() + (this.matrixRe[2][1] * complex3.real() - this.matrixIm[2][1] * complex3.imag());
                dArray2[1][2] = this.matrixIm[1][1] * complex2.real() + this.matrixRe[1][1] * complex2.imag() + (this.matrixIm[2][1] * complex3.real() + this.matrixRe[2][1] * complex3.imag());
                complex2 = complexTridiagonalMatrix.getElement(2, 3);
                dArray[1][3] = this.matrixRe[2][1] * complex2.real() - this.matrixIm[2][1] * complex2.imag();
                dArray2[1][3] = this.matrixIm[2][1] * complex2.real() + this.matrixRe[2][1] * complex2.imag();
            }
            if (n == 3) {
                complex2 = complexTridiagonalMatrix.getElement(0, 0);
                complex3 = complexTridiagonalMatrix.getElement(1, 0);
                dArray[1][0] = this.matrixRe[0][1] * complex2.real() - this.matrixIm[0][1] * complex2.imag() + (this.matrixRe[1][1] * complex3.real() - this.matrixIm[1][1] * complex3.imag());
                dArray2[1][0] = this.matrixIm[0][1] * complex2.real() + this.matrixRe[0][1] * complex2.imag() + (this.matrixIm[1][1] * complex3.real() + this.matrixRe[1][1] * complex3.imag());
                complex2 = complexTridiagonalMatrix.getElement(0, 1);
                complex3 = complexTridiagonalMatrix.getElement(1, 1);
                complex = complexTridiagonalMatrix.getElement(2, 1);
                dArray[1][1] = this.matrixRe[0][1] * complex2.real() - this.matrixIm[0][1] * complex2.imag() + (this.matrixRe[1][1] * complex3.real() - this.matrixIm[1][1] * complex3.imag()) + (this.matrixRe[2][1] * complex.real() - this.matrixIm[2][1] * complex.imag());
                dArray2[1][1] = this.matrixIm[0][1] * complex2.real() + this.matrixRe[0][1] * complex2.imag() + (this.matrixIm[1][1] * complex3.real() + this.matrixRe[1][1] * complex3.imag()) + (this.matrixIm[2][1] * complex.real() + this.matrixRe[2][1] * complex.imag());
                complex2 = complexTridiagonalMatrix.getElement(1, 2);
                complex3 = complexTridiagonalMatrix.getElement(2, 2);
                dArray[1][2] = this.matrixRe[1][1] * complex2.real() - this.matrixIm[1][1] * complex2.imag() + (this.matrixRe[2][1] * complex3.real() - this.matrixIm[2][1] * complex3.imag());
                dArray2[1][2] = this.matrixIm[1][1] * complex2.real() + this.matrixRe[1][1] * complex2.imag() + (this.matrixIm[2][1] * complex3.real() + this.matrixRe[2][1] * complex3.imag());
            } else if (n > 4) {
                int n2 = 2;
                while (n2 < n - 2) {
                    complex2 = complexTridiagonalMatrix.getElement(n2 - 1, n2 - 2);
                    dArray[n2][n2 - 2] = this.matrixRe[0][n2] * complex2.real() - this.matrixIm[0][n2] * complex2.imag();
                    dArray2[n2][n2 - 2] = this.matrixIm[0][n2] * complex2.real() + this.matrixRe[0][n2] * complex2.imag();
                    complex2 = complexTridiagonalMatrix.getElement(n2 - 1, n2 - 1);
                    complex3 = complexTridiagonalMatrix.getElement(n2, n2 - 1);
                    dArray[n2][n2 - 1] = this.matrixRe[0][n2] * complex2.real() - this.matrixIm[0][n2] * complex2.imag() + (this.matrixRe[1][n2] * complex3.real() - this.matrixIm[1][n2] * complex3.imag());
                    dArray2[n2][n2 - 1] = this.matrixIm[0][n2] * complex2.real() + this.matrixRe[0][n2] * complex2.imag() + (this.matrixIm[1][n2] * complex3.real() + this.matrixRe[1][n2] * complex3.imag());
                    complex2 = complexTridiagonalMatrix.getElement(n2 - 1, n2);
                    complex3 = complexTridiagonalMatrix.getElement(n2, n2);
                    complex = complexTridiagonalMatrix.getElement(n2 + 1, n2);
                    dArray[n2][n2] = this.matrixRe[0][n2] * complex2.real() - this.matrixIm[0][n2] * complex2.imag() + (this.matrixRe[1][n2] * complex3.real() - this.matrixIm[1][n2] * complex3.imag()) + (this.matrixRe[2][n2] * complex.real() - this.matrixIm[2][n2] * complex.imag());
                    dArray2[n2][n2] = this.matrixIm[0][n2] * complex2.real() + this.matrixRe[0][n2] * complex2.imag() + (this.matrixIm[1][n2] * complex3.real() + this.matrixRe[1][n2] * complex3.imag()) + (this.matrixIm[2][n2] * complex.real() + this.matrixRe[2][n2] * complex.imag());
                    complex2 = complexTridiagonalMatrix.getElement(n2, n2 + 1);
                    complex3 = complexTridiagonalMatrix.getElement(n2 + 1, n2 + 1);
                    dArray[n2][n2 + 1] = this.matrixRe[1][n2] * complex2.real() - this.matrixIm[1][n2] * complex2.imag() + (this.matrixRe[2][n2] * complex3.real() - this.matrixIm[2][n2] * complex3.imag());
                    dArray2[n2][n2 + 1] = this.matrixIm[1][n2] * complex2.real() + this.matrixRe[1][n2] * complex2.imag() + (this.matrixIm[2][n2] * complex3.real() + this.matrixRe[2][n2] * complex3.imag());
                    complex2 = complexTridiagonalMatrix.getElement(n2 + 1, n2 + 2);
                    dArray[n2][n2 + 2] = this.matrixRe[2][n2] * complex2.real() - this.matrixIm[2][n2] * complex2.imag();
                    dArray2[n2][n2 + 2] = this.matrixIm[2][n2] * complex2.real() + this.matrixRe[2][n2] * complex2.imag();
                    ++n2;
                }
            }
            if (n > 3) {
                complex2 = complexTridiagonalMatrix.getElement(n - 3, n - 4);
                dArray[n - 2][n - 4] = this.matrixRe[0][n - 2] * complex2.real() - this.matrixIm[0][n - 2] * complex2.imag();
                dArray2[n - 2][n - 4] = this.matrixIm[0][n - 2] * complex2.real() + this.matrixRe[0][n - 2] * complex2.imag();
                complex2 = complexTridiagonalMatrix.getElement(n - 3, n - 3);
                complex3 = complexTridiagonalMatrix.getElement(n - 2, n - 3);
                dArray[n - 2][n - 3] = this.matrixRe[0][n - 2] * complex2.real() - this.matrixIm[0][n - 2] * complex2.imag() + (this.matrixRe[1][n - 2] * complex3.real() - this.matrixIm[1][n - 2] * complex3.imag());
                dArray2[n - 2][n - 3] = this.matrixIm[0][n - 2] * complex2.real() + this.matrixRe[0][n - 2] * complex2.imag() + (this.matrixIm[1][n - 2] * complex3.real() + this.matrixRe[1][n - 2] * complex3.imag());
                complex2 = complexTridiagonalMatrix.getElement(n - 3, n - 2);
                complex3 = complexTridiagonalMatrix.getElement(n - 2, n - 2);
                complex = complexTridiagonalMatrix.getElement(n - 1, n - 2);
                dArray[n - 2][n - 2] = this.matrixRe[0][n - 2] * complex2.real() - this.matrixIm[0][n - 2] * complex2.imag() + (this.matrixRe[1][n - 2] * complex3.real() - this.matrixIm[1][n - 2] * complex3.imag()) + (this.matrixRe[2][n - 2] * complex.real() - this.matrixIm[2][n - 2] * complex.imag());
                dArray2[n - 2][n - 2] = this.matrixIm[0][n - 2] * complex2.real() + this.matrixRe[0][n - 2] * complex2.imag() + (this.matrixIm[1][n - 2] * complex3.real() + this.matrixRe[1][n - 2] * complex3.imag()) + (this.matrixIm[2][n - 2] * complex.real() + this.matrixRe[2][n - 2] * complex.imag());
                complex2 = complexTridiagonalMatrix.getElement(n - 2, n - 1);
                complex3 = complexTridiagonalMatrix.getElement(n - 1, n - 1);
                dArray[n - 2][n - 1] = this.matrixRe[1][n - 2] * complex2.real() - this.matrixIm[1][n - 2] * complex2.imag() + (this.matrixRe[2][n - 2] * complex3.real() - this.matrixIm[2][n - 2] * complex3.imag());
                dArray2[n - 2][n - 1] = this.matrixIm[1][n - 2] * complex2.real() + this.matrixRe[1][n - 2] * complex2.imag() + (this.matrixIm[2][n - 2] * complex3.real() + this.matrixRe[2][n - 2] * complex3.imag());
            }
            complex2 = complexTridiagonalMatrix.getElement(--n - 1, n - 2);
            dArray[n][n - 2] = this.matrixRe[0][n] * complex2.real() - this.matrixIm[0][n] * complex2.imag();
            dArray2[n][n - 2] = this.matrixIm[0][n] * complex2.real() + this.matrixRe[0][n] * complex2.imag();
            complex2 = complexTridiagonalMatrix.getElement(n - 1, n - 1);
            complex3 = complexTridiagonalMatrix.getElement(n, n - 1);
            dArray[n][n - 1] = this.matrixRe[0][n] * complex2.real() - this.matrixIm[0][n] * complex2.imag() + (this.matrixRe[1][n] * complex3.real() - this.matrixIm[1][n] * complex3.imag());
            dArray2[n][n - 1] = this.matrixIm[0][n] * complex2.real() + this.matrixRe[0][n] * complex2.imag() + (this.matrixIm[1][n] * complex3.real() + this.matrixRe[1][n] * complex3.imag());
            complex2 = complexTridiagonalMatrix.getElement(n - 1, n);
            complex3 = complexTridiagonalMatrix.getElement(n, n);
            dArray[n][n] = this.matrixRe[0][n] * complex2.real() - this.matrixIm[0][n] * complex2.imag() + (this.matrixRe[1][n] * complex3.real() - this.matrixIm[1][n] * complex3.imag());
            dArray2[n][n] = this.matrixIm[0][n] * complex2.real() + this.matrixRe[0][n] * complex2.imag() + (this.matrixIm[1][n] * complex3.real() + this.matrixRe[1][n] * complex3.imag());
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private ComplexSquareMatrix rawMultiplyTridiagonal(ComplexMatrix complexMatrix) {
        int n = this.matrixRe[1].length;
        if (n == complexMatrix.matrixRe[1].length) {
            double[][] dArray = new double[n][n];
            double[][] dArray2 = new double[n][n];
            dArray[0][0] = this.matrixRe[1][0] * complexMatrix.matrixRe[1][0] - this.matrixIm[1][0] * complexMatrix.matrixIm[1][0] + (this.matrixRe[2][0] * complexMatrix.matrixRe[0][1] - this.matrixIm[2][0] * complexMatrix.matrixIm[0][1]);
            dArray2[0][0] = this.matrixIm[1][0] * complexMatrix.matrixRe[1][0] + this.matrixRe[1][0] * complexMatrix.matrixIm[1][0] + (this.matrixIm[2][0] * complexMatrix.matrixRe[0][1] + this.matrixRe[2][0] * complexMatrix.matrixIm[0][1]);
            dArray[0][1] = this.matrixRe[1][0] * complexMatrix.matrixRe[2][0] - this.matrixIm[1][0] * complexMatrix.matrixIm[2][0] + (this.matrixRe[2][0] * complexMatrix.matrixRe[1][1] - this.matrixIm[2][0] * complexMatrix.matrixIm[1][1]);
            dArray2[0][1] = this.matrixIm[1][0] * complexMatrix.matrixRe[2][0] + this.matrixRe[1][0] * complexMatrix.matrixIm[2][0] + (this.matrixIm[2][0] * complexMatrix.matrixRe[1][1] + this.matrixRe[2][0] * complexMatrix.matrixIm[1][1]);
            dArray[0][2] = this.matrixRe[2][0] * complexMatrix.matrixRe[2][1] - this.matrixIm[2][0] * complexMatrix.matrixIm[2][1];
            dArray2[0][2] = this.matrixIm[2][0] * complexMatrix.matrixRe[2][1] + this.matrixRe[2][0] * complexMatrix.matrixIm[2][1];
            if (n > 3) {
                dArray[1][0] = this.matrixRe[0][1] * complexMatrix.matrixRe[1][0] - this.matrixIm[0][1] * complexMatrix.matrixIm[1][0] + (this.matrixRe[1][1] * complexMatrix.matrixRe[0][1] - this.matrixIm[1][1] * complexMatrix.matrixIm[0][1]);
                dArray2[1][0] = this.matrixIm[0][1] * complexMatrix.matrixRe[1][0] + this.matrixRe[0][1] * complexMatrix.matrixIm[1][0] + (this.matrixIm[1][1] * complexMatrix.matrixRe[0][1] + this.matrixRe[1][1] * complexMatrix.matrixIm[0][1]);
                dArray[1][1] = this.matrixRe[0][1] * complexMatrix.matrixRe[2][0] - this.matrixIm[0][1] * complexMatrix.matrixIm[2][0] + (this.matrixRe[1][1] * complexMatrix.matrixRe[1][1] - this.matrixIm[1][1] * complexMatrix.matrixIm[1][1]) + (this.matrixRe[2][1] * complexMatrix.matrixRe[0][2] - this.matrixIm[2][1] * complexMatrix.matrixIm[0][2]);
                dArray2[1][1] = this.matrixIm[0][1] * complexMatrix.matrixRe[2][0] + this.matrixRe[0][1] * complexMatrix.matrixIm[2][0] + (this.matrixIm[1][1] * complexMatrix.matrixRe[1][1] + this.matrixRe[1][1] * complexMatrix.matrixIm[1][1]) + (this.matrixIm[2][1] * complexMatrix.matrixRe[0][2] + this.matrixRe[2][1] * complexMatrix.matrixIm[0][2]);
                dArray[1][2] = this.matrixRe[1][1] * complexMatrix.matrixRe[2][1] - this.matrixIm[1][1] * complexMatrix.matrixIm[2][1] + (this.matrixRe[2][1] * complexMatrix.matrixRe[1][2] - this.matrixIm[2][1] * complexMatrix.matrixIm[1][2]);
                dArray2[1][2] = this.matrixIm[1][1] * complexMatrix.matrixRe[2][1] + this.matrixRe[1][1] * complexMatrix.matrixIm[2][1] + (this.matrixIm[2][1] * complexMatrix.matrixRe[1][2] + this.matrixRe[2][1] * complexMatrix.matrixIm[1][2]);
                dArray[1][3] = this.matrixRe[2][1] * complexMatrix.matrixRe[2][2] - this.matrixIm[2][1] * complexMatrix.matrixIm[2][2];
                dArray2[1][3] = this.matrixIm[2][1] * complexMatrix.matrixRe[2][2] + this.matrixRe[2][1] * complexMatrix.matrixIm[2][2];
            }
            if (n == 3) {
                dArray[1][0] = this.matrixRe[0][1] * complexMatrix.matrixRe[1][0] - this.matrixIm[0][1] * complexMatrix.matrixIm[1][0] + (this.matrixRe[1][1] * complexMatrix.matrixRe[0][1] - this.matrixIm[1][1] * complexMatrix.matrixIm[0][1]);
                dArray2[1][0] = this.matrixIm[0][1] * complexMatrix.matrixRe[1][0] + this.matrixRe[0][1] * complexMatrix.matrixIm[1][0] + (this.matrixIm[1][1] * complexMatrix.matrixRe[0][1] + this.matrixRe[1][1] * complexMatrix.matrixIm[0][1]);
                dArray[1][1] = this.matrixRe[0][1] * complexMatrix.matrixRe[2][0] - this.matrixIm[0][1] * complexMatrix.matrixIm[2][0] + (this.matrixRe[1][1] * complexMatrix.matrixRe[1][1] - this.matrixIm[1][1] * complexMatrix.matrixIm[1][1]) + (this.matrixRe[2][1] * complexMatrix.matrixRe[0][2] - this.matrixIm[2][1] * complexMatrix.matrixIm[0][2]);
                dArray2[1][1] = this.matrixIm[0][1] * complexMatrix.matrixRe[2][0] + this.matrixRe[0][1] * complexMatrix.matrixIm[2][0] + (this.matrixIm[1][1] * complexMatrix.matrixRe[1][1] + this.matrixRe[1][1] * complexMatrix.matrixIm[1][1]) + (this.matrixIm[2][1] * complexMatrix.matrixRe[0][2] + this.matrixRe[2][1] * complexMatrix.matrixIm[0][2]);
                dArray[1][2] = this.matrixRe[1][1] * complexMatrix.matrixRe[2][1] - this.matrixIm[1][1] * complexMatrix.matrixIm[2][1] + (this.matrixRe[2][1] * complexMatrix.matrixRe[1][2] - this.matrixIm[2][1] * complexMatrix.matrixIm[1][2]);
                dArray2[1][2] = this.matrixIm[1][1] * complexMatrix.matrixRe[2][1] + this.matrixRe[1][1] * complexMatrix.matrixIm[2][1] + (this.matrixIm[2][1] * complexMatrix.matrixRe[1][2] + this.matrixRe[2][1] * complexMatrix.matrixIm[1][2]);
            } else if (n > 4) {
                int n2 = 2;
                while (n2 < n - 2) {
                    dArray[n2][n2 - 2] = this.matrixRe[0][n2] * complexMatrix.matrixRe[0][n2 - 1] - this.matrixIm[0][n2] * complexMatrix.matrixIm[0][n2 - 1];
                    dArray2[n2][n2 - 2] = this.matrixIm[0][n2] * complexMatrix.matrixRe[0][n2 - 1] + this.matrixRe[0][n2] * complexMatrix.matrixIm[0][n2 - 1];
                    dArray[n2][n2 - 1] = this.matrixRe[0][n2] * complexMatrix.matrixRe[1][n2 - 1] - this.matrixIm[0][n2] * complexMatrix.matrixIm[1][n2 - 1] + (this.matrixRe[1][n2] * complexMatrix.matrixRe[0][n2] - this.matrixIm[1][n2] * complexMatrix.matrixIm[0][n2]);
                    dArray2[n2][n2 - 1] = this.matrixIm[0][n2] * complexMatrix.matrixRe[1][n2 - 1] + this.matrixRe[0][n2] * complexMatrix.matrixIm[1][n2 - 1] + (this.matrixIm[1][n2] * complexMatrix.matrixRe[0][n2] + this.matrixRe[1][n2] * complexMatrix.matrixIm[0][n2]);
                    dArray[n2][n2] = this.matrixRe[0][n2] * complexMatrix.matrixRe[2][n2 - 1] - this.matrixIm[0][n2] * complexMatrix.matrixIm[2][n2 - 1] + (this.matrixRe[1][n2] * complexMatrix.matrixRe[1][n2] - this.matrixIm[1][n2] * complexMatrix.matrixIm[1][n2]) + (this.matrixRe[2][n2] * complexMatrix.matrixRe[0][n2 + 1] - this.matrixIm[2][n2] * complexMatrix.matrixIm[0][n2 + 1]);
                    dArray2[n2][n2] = this.matrixIm[0][n2] * complexMatrix.matrixRe[2][n2 - 1] + this.matrixRe[0][n2] * complexMatrix.matrixIm[2][n2 - 1] + (this.matrixIm[1][n2] * complexMatrix.matrixRe[1][n2] + this.matrixRe[1][n2] * complexMatrix.matrixIm[1][n2]) + (this.matrixIm[2][n2] * complexMatrix.matrixRe[0][n2 + 1] + this.matrixRe[2][n2] * complexMatrix.matrixIm[0][n2 + 1]);
                    dArray[n2][n2 + 1] = this.matrixRe[1][n2] * complexMatrix.matrixRe[2][n2] - this.matrixIm[1][n2] * complexMatrix.matrixIm[2][n2] + (this.matrixRe[2][n2] * complexMatrix.matrixRe[1][n2 + 1] - this.matrixIm[2][n2] * complexMatrix.matrixIm[1][n2 + 1]);
                    dArray2[n2][n2 + 1] = this.matrixIm[1][n2] * complexMatrix.matrixRe[2][n2] + this.matrixRe[1][n2] * complexMatrix.matrixIm[2][n2] + (this.matrixIm[2][n2] * complexMatrix.matrixRe[1][n2 + 1] + this.matrixRe[2][n2] * complexMatrix.matrixIm[1][n2 + 1]);
                    dArray[n2][n2 + 2] = this.matrixRe[2][n2] * complexMatrix.matrixRe[2][n2 + 1] - this.matrixIm[2][n2] * complexMatrix.matrixIm[2][n2 + 1];
                    dArray2[n2][n2 + 2] = this.matrixIm[2][n2] * complexMatrix.matrixRe[2][n2 + 1] + this.matrixRe[2][n2] * complexMatrix.matrixIm[2][n2 + 1];
                    ++n2;
                }
            }
            if (n > 3) {
                dArray[n - 2][n - 4] = this.matrixRe[0][n - 2] * complexMatrix.matrixRe[0][n - 3] - this.matrixIm[0][n - 2] * complexMatrix.matrixIm[0][n - 3];
                dArray2[n - 2][n - 4] = this.matrixIm[0][n - 2] * complexMatrix.matrixRe[0][n - 3] + this.matrixRe[0][n - 2] * complexMatrix.matrixIm[0][n - 3];
                dArray[n - 2][n - 3] = this.matrixRe[0][n - 2] * complexMatrix.matrixRe[1][n - 3] - this.matrixIm[0][n - 2] * complexMatrix.matrixIm[1][n - 3] + (this.matrixRe[1][n - 2] * complexMatrix.matrixRe[0][n - 2] - this.matrixIm[1][n - 2] * complexMatrix.matrixIm[0][n - 2]);
                dArray2[n - 2][n - 3] = this.matrixIm[0][n - 2] * complexMatrix.matrixRe[1][n - 3] + this.matrixRe[0][n - 2] * complexMatrix.matrixIm[1][n - 3] + (this.matrixIm[1][n - 2] * complexMatrix.matrixRe[0][n - 2] + this.matrixRe[1][n - 2] * complexMatrix.matrixIm[0][n - 2]);
                dArray[n - 2][n - 2] = this.matrixRe[0][n - 2] * complexMatrix.matrixRe[2][n - 3] - this.matrixIm[0][n - 2] * complexMatrix.matrixIm[2][n - 3] + (this.matrixRe[1][n - 2] * complexMatrix.matrixRe[1][n - 2] - this.matrixIm[1][n - 2] * complexMatrix.matrixIm[1][n - 2]) + (this.matrixRe[2][n - 2] * complexMatrix.matrixRe[0][n - 1] - this.matrixIm[2][n - 2] * complexMatrix.matrixIm[0][n - 1]);
                dArray2[n - 2][n - 2] = this.matrixIm[0][n - 2] * complexMatrix.matrixRe[2][n - 3] + this.matrixRe[0][n - 2] * complexMatrix.matrixIm[2][n - 3] + (this.matrixIm[1][n - 2] * complexMatrix.matrixRe[1][n - 2] + this.matrixRe[1][n - 2] * complexMatrix.matrixIm[1][n - 2]) + (this.matrixIm[2][n - 2] * complexMatrix.matrixRe[0][n - 1] + this.matrixRe[2][n - 2] * complexMatrix.matrixIm[0][n - 1]);
                dArray[n - 2][n - 1] = this.matrixRe[1][n - 2] * complexMatrix.matrixRe[2][n - 2] - this.matrixIm[1][n - 2] * complexMatrix.matrixIm[2][n - 2] + (this.matrixRe[2][n - 2] * complexMatrix.matrixRe[1][n - 1] - this.matrixIm[2][n - 2] * complexMatrix.matrixIm[1][n - 1]);
                dArray2[n - 2][n - 1] = this.matrixIm[1][n - 2] * complexMatrix.matrixRe[2][n - 2] + this.matrixRe[1][n - 2] * complexMatrix.matrixIm[2][n - 2] + (this.matrixIm[2][n - 2] * complexMatrix.matrixRe[1][n - 1] + this.matrixRe[2][n - 2] * complexMatrix.matrixIm[1][n - 1]);
            }
            dArray[n][--n - 2] = this.matrixRe[0][n] * complexMatrix.matrixRe[0][n - 1] - this.matrixIm[0][n] * complexMatrix.matrixIm[0][n - 1];
            dArray2[n][n - 2] = this.matrixIm[0][n] * complexMatrix.matrixRe[0][n - 1] + this.matrixRe[0][n] * complexMatrix.matrixIm[0][n - 1];
            dArray[n][n - 1] = this.matrixRe[0][n] * complexMatrix.matrixRe[1][n - 1] - this.matrixIm[0][n] * complexMatrix.matrixIm[1][n - 1] + (this.matrixRe[1][n] * complexMatrix.matrixRe[0][n] - this.matrixIm[1][n] * complexMatrix.matrixIm[0][n]);
            dArray2[n][n - 1] = this.matrixIm[0][n] * complexMatrix.matrixRe[1][n - 1] + this.matrixRe[0][n] * complexMatrix.matrixIm[1][n - 1] + (this.matrixIm[1][n] * complexMatrix.matrixRe[0][n] + this.matrixRe[1][n] * complexMatrix.matrixIm[0][n]);
            dArray[n][n] = this.matrixRe[0][n] * complexMatrix.matrixRe[2][n - 1] - this.matrixIm[0][n] * complexMatrix.matrixIm[2][n - 1] + (this.matrixRe[1][n] * complexMatrix.matrixRe[1][n] - this.matrixIm[1][n] * complexMatrix.matrixIm[1][n]);
            dArray2[n][n] = this.matrixIm[0][n] * complexMatrix.matrixRe[2][n - 1] + this.matrixRe[0][n] * complexMatrix.matrixIm[2][n - 1] + (this.matrixIm[1][n] * complexMatrix.matrixRe[1][n] + this.matrixRe[1][n] * complexMatrix.matrixIm[1][n]);
            return new ComplexSquareMatrix(dArray, dArray2);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public ComplexMatrix hermitianAdjoint() {
        int n = this.matrixRe[1].length;
        ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
        System.arraycopy(this.matrixRe[0], 1, complexTridiagonalMatrix.matrixRe[2], 0, this.matrixRe[0].length - 1);
        System.arraycopy(this.matrixRe[1], 0, complexTridiagonalMatrix.matrixRe[1], 0, this.matrixRe[1].length);
        System.arraycopy(this.matrixRe[2], 0, complexTridiagonalMatrix.matrixRe[0], 1, this.matrixRe[2].length - 1);
        complexTridiagonalMatrix.matrixIm[1][0] = -this.matrixIm[1][0];
        complexTridiagonalMatrix.matrixIm[0][1] = -this.matrixIm[2][0];
        --n;
        int n2 = 1;
        while (n2 < n) {
            complexTridiagonalMatrix.matrixIm[2][n2 - 1] = -this.matrixIm[0][n2];
            complexTridiagonalMatrix.matrixIm[1][n2] = -this.matrixIm[1][n2];
            complexTridiagonalMatrix.matrixIm[0][n2 + 1] = -this.matrixIm[2][n2];
            ++n2;
        }
        complexTridiagonalMatrix.matrixIm[2][n - 1] = -this.matrixIm[0][n];
        complexTridiagonalMatrix.matrixIm[1][n] = -this.matrixIm[1][n];
        return complexTridiagonalMatrix;
    }

    public ComplexMatrix conjugate() {
        int n = this.matrixRe[1].length;
        ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
        System.arraycopy(this.matrixRe[0], 1, complexTridiagonalMatrix.matrixRe[0], 0, this.matrixRe[0].length - 1);
        System.arraycopy(this.matrixRe[1], 0, complexTridiagonalMatrix.matrixRe[1], 0, this.matrixRe[1].length);
        System.arraycopy(this.matrixRe[2], 0, complexTridiagonalMatrix.matrixRe[2], 1, this.matrixRe[2].length - 1);
        complexTridiagonalMatrix.matrixIm[1][0] = -this.matrixIm[1][0];
        complexTridiagonalMatrix.matrixIm[2][0] = -this.matrixIm[2][0];
        --n;
        int n2 = 1;
        while (n2 < n) {
            complexTridiagonalMatrix.matrixIm[0][n2] = -this.matrixIm[0][n2];
            complexTridiagonalMatrix.matrixIm[1][n2] = -this.matrixIm[1][n2];
            complexTridiagonalMatrix.matrixIm[2][n2] = -this.matrixIm[2][n2];
            ++n2;
        }
        complexTridiagonalMatrix.matrixIm[0][n] = -this.matrixIm[0][n];
        complexTridiagonalMatrix.matrixIm[1][n] = -this.matrixIm[1][n];
        return complexTridiagonalMatrix;
    }

    public Matrix transpose() {
        ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(this.matrixRe[1].length);
        System.arraycopy(this.matrixRe[0], 1, complexTridiagonalMatrix.matrixRe[2], 0, this.matrixRe[0].length - 1);
        System.arraycopy(this.matrixIm[0], 1, complexTridiagonalMatrix.matrixIm[2], 0, this.matrixIm[0].length - 1);
        System.arraycopy(this.matrixRe[1], 0, complexTridiagonalMatrix.matrixRe[1], 0, this.matrixRe[1].length);
        System.arraycopy(this.matrixIm[1], 0, complexTridiagonalMatrix.matrixIm[1], 0, this.matrixIm[1].length);
        System.arraycopy(this.matrixRe[2], 0, complexTridiagonalMatrix.matrixRe[0], 1, this.matrixRe[2].length - 1);
        System.arraycopy(this.matrixIm[2], 0, complexTridiagonalMatrix.matrixIm[0], 1, this.matrixIm[2].length - 1);
        return complexTridiagonalMatrix;
    }

    public ComplexSquareMatrix[] luDecompose(int[] nArray) {
        if (this.LU != null) {
            if (nArray != null) {
                System.arraycopy(this.LUpivot, 0, nArray, 0, nArray.length);
            }
            return this.LU;
        }
        double[][] dArray = new double[this.matrixRe.length][this.matrixRe.length];
        double[][] dArray2 = new double[this.matrixIm.length][this.matrixIm.length];
        double[][] dArray3 = new double[this.matrixRe.length][this.matrixRe.length];
        double[][] dArray4 = new double[this.matrixIm.length][this.matrixIm.length];
        double[] dArray5 = new double[this.matrixRe.length];
        if (nArray == null) {
            nArray = new int[this.matrixRe.length + 1];
        }
        int n = 0;
        while (n < this.matrixRe.length) {
            nArray[n] = n;
            ++n;
        }
        nArray[this.matrixRe.length] = 1;
        int n2 = 0;
        while (n2 < this.matrixRe.length) {
            double d;
            double d2;
            int n3;
            double d3;
            double d4;
            Complex complex;
            n = 0;
            while (n < n2) {
                complex = this.getElement(nArray[n], n2);
                d4 = complex.real();
                d3 = complex.imag();
                n3 = 0;
                while (n3 < n) {
                    d4 -= dArray3[n][n3] * dArray3[n3][n2] - dArray4[n][n3] * dArray4[n3][n2];
                    d3 -= dArray4[n][n3] * dArray3[n3][n2] + dArray3[n][n3] * dArray4[n3][n2];
                    ++n3;
                }
                dArray3[n][n2] = d4;
                dArray4[n][n2] = d3;
                ++n;
            }
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            int n4 = n2;
            n = n2;
            while (n < this.matrixRe.length) {
                complex = this.getElement(nArray[n], n2);
                d4 = complex.real();
                d3 = complex.imag();
                n3 = 0;
                while (n3 < n2) {
                    d4 -= dArray3[n][n3] * dArray3[n3][n2] - dArray4[n][n3] * dArray4[n3][n2];
                    d3 -= dArray4[n][n3] * dArray3[n3][n2] + dArray3[n][n3] * dArray4[n3][n2];
                    ++n3;
                }
                dArray3[n][n2] = d4;
                dArray4[n][n2] = d3;
                double d8 = d4 * d4 + d3 * d3;
                if (d8 > d5) {
                    d5 = d8;
                    d6 = d4;
                    d7 = d3;
                    n4 = n;
                }
                ++n;
            }
            if (n4 != n2) {
                System.arraycopy(dArray3[n2], 0, dArray5, 0, n2 + 1);
                System.arraycopy(dArray3[n4], 0, dArray3[n2], 0, n2 + 1);
                System.arraycopy(dArray5, 0, dArray3[n4], 0, n2 + 1);
                System.arraycopy(dArray4[n2], 0, dArray5, 0, n2 + 1);
                System.arraycopy(dArray4[n4], 0, dArray4[n2], 0, n2 + 1);
                System.arraycopy(dArray5, 0, dArray4[n4], 0, n2 + 1);
                n3 = nArray[n2];
                nArray[n2] = nArray[n4];
                nArray[n4] = n3;
                nArray[this.matrixRe.length] = -nArray[this.matrixRe.length];
            }
            if (Math.abs(d6) < Math.abs(d7)) {
                d2 = d6 / d7;
                d = d6 * d2 + d7;
                n = n2 + 1;
                while (n < this.matrixRe.length) {
                    d4 = (dArray3[n][n2] * d2 + dArray4[n][n2]) / d;
                    dArray4[n][n2] = (dArray4[n][n2] * d2 - dArray3[n][n2]) / d;
                    dArray3[n][n2] = d4;
                    ++n;
                }
            } else {
                d2 = d7 / d6;
                d = d6 + d7 * d2;
                n = n2 + 1;
                while (n < this.matrixRe.length) {
                    d4 = (dArray3[n][n2] + dArray4[n][n2] * d2) / d;
                    dArray4[n][n2] = (dArray4[n][n2] - dArray3[n][n2] * d2) / d;
                    dArray3[n][n2] = d4;
                    ++n;
                }
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.matrixRe.length) {
            dArray[n2][n2] = 1.0;
            n = n2 + 1;
            while (n < this.matrixRe.length) {
                dArray[n][n2] = dArray3[n][n2];
                dArray2[n][n2] = dArray4[n][n2];
                dArray3[n][n2] = 0.0;
                dArray4[n][n2] = 0.0;
                ++n;
            }
            ++n2;
        }
        this.LU = new ComplexSquareMatrix[2];
        this.LU[0] = new ComplexSquareMatrix(dArray, dArray2);
        this.LU[1] = new ComplexSquareMatrix(dArray3, dArray4);
        this.LUpivot = new int[nArray.length];
        System.arraycopy(nArray, 0, this.LUpivot, 0, nArray.length);
        return this.LU;
    }

    public ComplexMatrix mapElements(ComplexMapping complexMapping) {
        int n = this.matrixRe[1].length;
        ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
        complexTridiagonalMatrix.setElement(0, 0, complexMapping.map(this.matrixRe[1][0], this.matrixIm[1][0]));
        complexTridiagonalMatrix.setElement(0, 1, complexMapping.map(this.matrixRe[2][0], this.matrixIm[2][0]));
        --n;
        int n2 = 1;
        while (n2 < n) {
            complexTridiagonalMatrix.setElement(n2, n2 - 1, complexMapping.map(this.matrixRe[0][n2], this.matrixIm[0][n2]));
            complexTridiagonalMatrix.setElement(n2, n2, complexMapping.map(this.matrixRe[1][n2], this.matrixIm[1][n2]));
            complexTridiagonalMatrix.setElement(n2, n2 + 1, complexMapping.map(this.matrixRe[2][n2], this.matrixIm[2][n2]));
            ++n2;
        }
        complexTridiagonalMatrix.setElement(n, n - 1, complexMapping.map(this.matrixRe[0][n], this.matrixIm[0][n]));
        complexTridiagonalMatrix.setElement(n, n, complexMapping.map(this.matrixRe[1][n], this.matrixIm[1][n]));
        return complexTridiagonalMatrix;
    }
}

