/*
 * Decompiled with CFR 0.152.
 */
package ftp;

import java.util.StringTokenizer;

public class FtpListResult {
    public static final int DIRECTORY = 1;
    public static final int FILE = 2;
    public static final int LINK = 3;
    public static final int BLK_DEV = 4;
    public static final int CHAR_DEV = 5;
    public static final int OTHERS = 6;
    private int[] type;
    private long[] size;
    private String[] permission;
    private String[] owner;
    private String[] group;
    private String[] name;
    private String[] date;
    private int index = -1;
    private final boolean DEBUG = false;

    public int getFtBlkDev() {
        return 4;
    }

    public int getFtCharDev() {
        return 5;
    }

    public int getFtFile() {
        return 2;
    }

    public int getFtDir() {
        return 1;
    }

    public int getFtLink() {
        return 3;
    }

    public String getDate() {
        return this.date[this.index];
    }

    public String getGroup() {
        return this.group[this.index];
    }

    public String getName() {
        return this.name[this.index];
    }

    public String getOwner() {
        return this.owner[this.index];
    }

    public String getPermission() {
        return this.permission[this.index];
    }

    public long getSize() {
        return this.size[this.index];
    }

    public int getType() {
        return this.type[this.index];
    }

    public boolean ownerReadable() {
        return this.isOwnerReadable();
    }

    public boolean isOwnerReadable() {
        if (this.permission[this.index].equals("")) {
            return true;
        }
        return this.permission[this.index].charAt(0) != '-';
    }

    public boolean ownerWritable() {
        return this.isOwnerWritable();
    }

    public boolean isOwnerWritable() {
        if (this.permission[this.index].equals("")) {
            return true;
        }
        return this.permission[this.index].charAt(1) != '-';
    }

    public boolean ownerExecutable() {
        return this.isOwnerExecutable();
    }

    public boolean isOwnerExecutable() {
        if (this.permission[this.index].equals("")) {
            return true;
        }
        return this.permission[this.index].charAt(2) != '-';
    }

    public boolean groupReadable() {
        return this.isGroupReadable();
    }

    public boolean isGroupReadable() {
        if (this.permission[this.index].equals("")) {
            return true;
        }
        return this.permission[this.index].charAt(3) != '-';
    }

    public boolean groupWritable() {
        return this.isGroupWritable();
    }

    public boolean isGroupWritable() {
        if (this.permission[this.index].equals("")) {
            return true;
        }
        return this.permission[this.index].charAt(4) != '-';
    }

    public boolean groupExecutable() {
        return this.isGroupExecutable();
    }

    public boolean isGroupExecutable() {
        if (this.permission[this.index].equals("")) {
            return true;
        }
        return this.permission[this.index].charAt(5) != '-';
    }

    public boolean globalReadable() {
        return this.isGlobalReadable();
    }

    public boolean isGlobalReadable() {
        if (this.permission[this.index].equals("")) {
            return true;
        }
        return this.permission[this.index].charAt(6) != '-';
    }

    public boolean globalWritable() {
        return this.isGlobalWritable();
    }

    public boolean isGlobalWritable() {
        if (this.permission[this.index].equals("")) {
            return true;
        }
        return this.permission[this.index].charAt(7) != '-';
    }

    public boolean globalExecutable() {
        return this.isGlobalExecutable();
    }

    public boolean isGlobalExecutable() {
        if (this.permission[this.index].equals("")) {
            return true;
        }
        return this.permission[this.index].charAt(8) != '-';
    }

    public boolean next() {
        if (this.name == null || this.index >= this.name.length - 1) {
            return false;
        }
        ++this.index;
        return true;
    }

    protected void parseList(String string, String string2) {
        if (string.length() <= 0) {
            return;
        }
        if (string2.toLowerCase().indexOf("windows") == -1) {
            char c = string.charAt(0);
            if (c != 'd' && c != '-' && c != 'l' && c != 'b' && c != 'c') {
                this.parseUnixList(string, 1);
            } else {
                this.parseUnixList(string, 0);
            }
        } else {
            char c = string.charAt(0);
            if (c != 'd' && c != '-' && c != 'l' && c != 'b' && c != 'c') {
                this.parseDosList(string);
            } else {
                this.parseUnixList(string, 0);
            }
        }
    }

    private void parseUnixList(String string, int n) {
        int n2 = this.countLine(string) - n;
        this.type = new int[n2];
        this.permission = new String[n2];
        this.owner = new String[n2];
        this.group = new String[n2];
        this.size = new long[n2];
        this.name = new String[n2];
        this.date = new String[n2];
        int n3 = 0;
        int n4 = 0;
        if (n == 1) {
            n3 = string.indexOf(10) + 1;
        }
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            int n5;
            n4 = string.substring(n3).indexOf(10);
            String string2 = string.substring(n3, n3 + n4);
            n3 += n4 + 1;
            int n6 = 3;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
            String string3 = stringTokenizer.nextToken();
            this.type[i] = this.parseType(string3);
            this.permission[i] = this.parsePermission(string3);
            stringTokenizer.nextToken();
            this.owner[i] = stringTokenizer.nextToken();
            this.group[i] = stringTokenizer.nextToken();
            String string4 = "";
            if (this.type[i] == 4 || this.type[i] == 5) {
                string4 = stringTokenizer.nextToken();
            }
            this.date[i] = "";
            try {
                string3 = stringTokenizer.nextToken();
                this.size[i] = Long.parseLong(string3);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    this.size[i] = Long.parseLong(this.group[i]);
                }
                catch (NumberFormatException numberFormatException2) {
                    this.size[i] = Long.parseLong(string4);
                }
                this.date[i] = string3.concat(" ");
                this.group[i] = "";
                n6 = 2;
            }
            for (n5 = 0; n5 < n6; ++n5) {
                if (n5 > 0) {
                    this.date[i] = this.date[i].concat(" ");
                }
                this.date[i] = this.date[i].concat(stringTokenizer.nextToken());
            }
            this.name[i] = stringTokenizer.nextToken("\n").trim();
            if (this.type[i] != 3 || (n5 = this.name[i].lastIndexOf("->")) <= -1) continue;
            this.name[i] = this.name[i].substring(0, n5).trim();
        }
    }

    private void parseDosList(String string) {
        int n = this.countLine(string);
        this.type = new int[n];
        this.permission = new String[n];
        this.owner = new String[n];
        this.group = new String[n];
        this.size = new long[n];
        this.name = new String[n];
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            n3 = string.substring(n2).indexOf(10);
            String string2 = string.substring(n2, n2 + n3);
            n2 += n3 + 1;
            this.permission[i] = "";
            this.owner[i] = "";
            this.group[i] = "";
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
            for (int j = 0; j < 2; ++j) {
                stringTokenizer.nextToken();
            }
            String string3 = stringTokenizer.nextToken();
            if (string3.equals("<DIR>")) {
                this.type[i] = 1;
                this.size[i] = 0L;
            } else {
                this.type[i] = 2;
                this.size[i] = Long.parseLong(string3);
            }
            this.name[i] = stringTokenizer.nextToken("\n").trim();
        }
    }

    private int parseType(String string) {
        char c = string.charAt(0);
        int n = 0;
        n = c == 'd' ? 1 : (c == '-' ? 2 : (c == 'l' ? 3 : (c == 'b' ? 4 : (c == 'c' ? 5 : 6))));
        return n;
    }

    private String parsePermission(String string) {
        return string.substring(1, string.length());
    }

    private int countLine(String string) {
        int n;
        int n2 = 0;
        int n3 = 0;
        while ((n = string.substring(n2).indexOf("\n")) != -1) {
            ++n3;
            n2 += n + 1;
        }
        if (string.substring(n2).length() > 0) {
            ++n3;
        }
        return n3;
    }
}

