/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.gaggle.util;

import cytoscape.data.servers.BioDataServer;
import java.util.ArrayList;

public class NameHelper {
    private String species = null;
    private String defaultCategory = null;
    private ArrayList categoryList;
    private BioDataServer bioDataServer = null;

    public NameHelper(String species, BioDataServer bioDataServer) {
        this.species = species;
        this.bioDataServer = bioDataServer;
        this.categoryList = new ArrayList();
        this.categoryList.add("Canonical");
        this.categoryList.add("Common");
        this.defaultCategory = (String)this.categoryList.get(0);
    }

    public NameHelper(String species) {
        this.species = species;
    }

    public NameHelper() {
    }

    public String getName(String category, String name) {
        String canonicalName;
        String[] commonNames;
        if (null == this.species) {
            return name;
        }
        if (null == this.bioDataServer) {
            return name;
        }
        if (null == this.defaultCategory) {
            return name;
        }
        if (null == this.categoryList) {
            return name;
        }
        if (this.categoryList.size() < 2) {
            return name;
        }
        if (category.equalsIgnoreCase("common") && (commonNames = this.bioDataServer.getAllCommonNames(this.species, name)) != null & commonNames.length > 0) {
            return commonNames[0];
        }
        if (category.equalsIgnoreCase("canonical") && (canonicalName = this.bioDataServer.getCanonicalName(this.species, name)) != null) {
            return canonicalName;
        }
        return name;
    }

    public String getDefaultCategory() {
        return this.defaultCategory;
    }

    public String[] getCategoryList() {
        if (null == this.categoryList) {
            return null;
        }
        String[] result = new String[this.categoryList.size()];
        this.categoryList.toArray(result);
        return result;
    }
}

