/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.gaggle.geese.common;

import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.systemsbiology.gaggle.core.Boss;
import org.systemsbiology.gaggle.core.Goose;
import org.systemsbiology.gaggle.geese.common.GaggleConnectionListener;

public class RmiGaggleConnector {
    private Goose goose;
    private Boss boss;
    String serviceName = "gaggle";
    String hostname = "localhost";
    String uri = "rmi://" + this.hostname + "/" + this.serviceName;
    private Set<GaggleConnectionListener> listeners = new HashSet<GaggleConnectionListener>();
    private boolean exported = false;
    private boolean autoStartBoss = true;
    private long timerTimeElapsed = 0L;
    private long timerInterval = 100L;
    private long timerTimeout = 15000L;

    public RmiGaggleConnector(Goose goose) {
        if (goose == null) {
            throw new NullPointerException("RmiGaggleConnector requires a non-null goose.");
        }
        this.goose = goose;
        if (goose instanceof GaggleConnectionListener) {
            this.addListener((GaggleConnectionListener)((Object)goose));
        }
    }

    private synchronized void exportObject(Goose goose) throws Exception {
        try {
            UnicastRemoteObject.exportObject((Remote)goose, 0);
            this.exported = true;
        }
        catch (Exception e) {
            System.err.println("RmiGaggleConnector failed to export remote object: " + e.getMessage());
            throw e;
        }
    }

    public synchronized void connectToGaggle() throws Exception {
        try {
            if (!this.exported) {
                this.exportObject(this.goose);
            }
            if (this.autoStartBoss) {
                try {
                    this.boss = (Boss)Naming.lookup(this.uri);
                }
                catch (Exception ex) {
                    if (ex.getMessage().startsWith("Connection refused to host:")) {
                        System.out.println("Couldn't find a boss, trying to start one....");
                        this.tryToStartBoss();
                    }
                }
            } else {
                this.boss = (Boss)Naming.lookup(this.uri);
            }
            String gooseName = this.boss.register(this.goose);
            this.goose.setName(gooseName);
            this.fireConnectionEvent(true);
        }
        catch (NullPointerException npe) {
            System.out.println("Boss isn't quite ready yet, trying again...");
        }
        catch (Exception e) {
            if (!this.autoStartBoss) {
                System.err.println("failed to connect to gaggle at " + this.uri + ": " + e.getMessage());
                e.printStackTrace();
            }
            this.boss = null;
            this.fireConnectionEvent(false);
            throw e;
        }
    }

    private void tryToStartBoss() {
        String command = System.getProperty("java.home");
        command = command + File.separator + "bin" + File.separator + "javaws " + "http://gaggle.systemsbiology.net/2007-04/minimizedBoss.jnlp";
        try {
            Runtime.getRuntime().exec(command);
            Timer timer = new Timer();
            timer.schedule((TimerTask)new WaitForBossStart(), 0L, 100L);
        }
        catch (IOException e) {
            System.out.println("Failed to start boss process!");
            e.printStackTrace();
        }
    }

    public synchronized void disconnectFromGaggle(boolean printStackTrace) {
        if (this.boss != null) {
            try {
                System.out.println("received disconnect request from " + this.goose.getName());
                this.boss.unregister(this.goose.getName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.boss = null;
        }
        if (this.exported) {
            block6: {
                try {
                    System.out.println("received disconnect request from " + this.goose.getName());
                    UnicastRemoteObject.unexportObject(this.goose, true);
                }
                catch (Exception e) {
                    if (!printStackTrace) break block6;
                    e.printStackTrace();
                }
            }
            this.exported = false;
        }
        this.fireConnectionEvent(false);
    }

    public synchronized void addListener(GaggleConnectionListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeListener(GaggleConnectionListener listener) {
        this.listeners.remove(listener);
    }

    private synchronized void fireConnectionEvent(boolean connected) {
        for (GaggleConnectionListener listener : this.listeners) {
            try {
                listener.setConnected(connected, this.boss);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized boolean isConnected() {
        return this.boss != null;
    }

    public void setAutoStartBoss(boolean autoStartBoss) {
        this.autoStartBoss = autoStartBoss;
    }

    public boolean getAutoStartBoss() {
        return this.autoStartBoss;
    }

    public synchronized Boss getBoss() {
        return this.boss;
    }

    class WaitForBossStart
    extends TimerTask {
        WaitForBossStart() {
        }

        public void run() {
            RmiGaggleConnector.this.timerTimeElapsed += RmiGaggleConnector.this.timerInterval;
            if (RmiGaggleConnector.this.timerTimeElapsed > RmiGaggleConnector.this.timerTimeout) {
                System.out.println("Didn't hear from the boss for 15 seconds, timing out.");
                this.cancel();
            }
            try {
                Naming.lookup(RmiGaggleConnector.this.uri);
                RmiGaggleConnector.this.connectToGaggle();
                this.cancel();
            }
            catch (ConnectException ce) {
            }
            catch (ClassNotFoundException cnfe) {
                try {
                    RmiGaggleConnector.this.connectToGaggle();
                    this.cancel();
                }
                catch (Exception ex) {
                    System.out.println("exception trying to connect using boss autostart: " + ex.getMessage());
                    ex.printStackTrace();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

