/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.gaggle.core.datatypes;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.systemsbiology.gaggle.core.datatypes.GaggleData;
import org.systemsbiology.gaggle.core.datatypes.Tuple;

public class DataMatrix
implements GaggleData {
    protected String name;
    protected Tuple metadata;
    protected String rowTitlesTitle;
    protected String[] columnTitles = new String[0];
    protected String[] rowTitles = new String[0];
    protected double[][] data = null;
    protected String uri = "";
    protected String fullName = "";
    protected String shortName = "";
    protected String fileExtension;
    protected String dataTypeBriefName;
    protected String species = "unknown";

    public DataMatrix() {
        this("");
    }

    public DataMatrix(String uri) {
        this.uri = uri.trim();
        this.fullName = uri;
        this.shortName = this.calculateShortName();
        this.dataTypeBriefName = this.fileExtension = this.calculateFileExtension();
    }

    public void setShortName(String newValue) {
        this.shortName = newValue;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setSpecies(String newValue) {
        this.species = newValue;
    }

    public String getSpecies() {
        return this.species;
    }

    protected String calculateShortName() {
        String[] tokens = this.fullName.split("/");
        int lastToken = tokens.length - 1;
        if (lastToken < 0) {
            return this.fullName;
        }
        return tokens[lastToken];
    }

    protected String calculateFileExtension() {
        String shortName = this.getShortName();
        int lastDot = shortName.lastIndexOf(".");
        if (lastDot < 0) {
            return "";
        }
        return shortName.substring(lastDot + 1);
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public String getDataTypeBriefName() {
        return this.dataTypeBriefName;
    }

    public void setDataTypeBriefName(String newValue) {
        this.dataTypeBriefName = newValue;
    }

    public void setFullName(String newValue) {
        this.fullName = newValue;
        this.shortName = this.calculateShortName();
        this.fileExtension = this.calculateFileExtension();
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setSize(int rows, int columns) {
        this.data = new double[rows][columns];
    }

    public void setDefault(double value) {
        if (this.data == null) {
            return;
        }
        for (int r = 0; r < this.data.length; ++r) {
            for (int c = 0; c < this.data[0].length; ++c) {
                this.data[r][c] = value;
            }
        }
    }

    public void set(int row, int column, double value) {
        this.data[row][column] = value;
    }

    public void set(int row, double[] values) {
        this.data[row] = values;
    }

    public void addRow(String rowName, double[] values) throws IllegalArgumentException {
        if (values.length != this.getColumnCount()) {
            throw new IllegalArgumentException("new row must have only " + this.getColumnCount() + " values; you supplied " + values.length);
        }
        int newCount = this.getRowCount() + 1;
        double[][] newData = new double[newCount][this.getColumnCount()];
        System.arraycopy(this.data, 0, newData, 0, this.getRowCount());
        newData[newCount - 1] = values;
        this.data = newData;
        ArrayList<String> tmp = new ArrayList<String>(Arrays.asList(this.rowTitles));
        tmp.add(rowName);
        this.rowTitles = tmp.toArray(new String[0]);
    }

    public void setColumnTitles(String[] newValues) {
        this.columnTitles = newValues;
    }

    public void setRowTitles(String[] newValues) {
        this.rowTitles = newValues;
    }

    public void setRowTitlesTitle(String newValue) {
        this.rowTitlesTitle = newValue;
    }

    public int getRowCount() {
        if (this.data != null) {
            return this.data.length;
        }
        return 0;
    }

    public int getColumnCount() {
        if (this.columnTitles != null) {
            return this.columnTitles.length;
        }
        return 0;
    }

    public double get(int row, int column) {
        return this.data[row][column];
    }

    public double[] get(int row) {
        if (this.data != null) {
            return this.data[row];
        }
        return new double[0];
    }

    public double[] get(String rowName) {
        for (int i = 0; i < this.rowTitles.length; ++i) {
            if (!this.rowTitles[i].equals(rowName)) continue;
            return this.data[i];
        }
        throw new IllegalArgumentException("no data for '" + rowName + "'");
    }

    public String[] getRowTitles() {
        return this.rowTitles;
    }

    public void set(double[][] d) {
        this.data = d;
    }

    public double[][] get() {
        return this.data;
    }

    public int getColumnNumber(String columnName) {
        for (int c = 0; c < this.getColumnCount(); ++c) {
            if (!this.columnTitles[c].equals(columnName)) continue;
            return c;
        }
        throw new IllegalArgumentException("no column named " + columnName);
    }

    public int getRowNumber(String rowName) {
        for (int r = 0; r < this.getRowCount(); ++r) {
            if (!this.rowTitles[r].equals(rowName)) continue;
            return r;
        }
        throw new IllegalArgumentException("no row named " + rowName);
    }

    public double[] getColumn(String columnName) {
        int columnNumber = this.getColumnNumber(columnName);
        double[] result = new double[this.getRowCount()];
        for (int r = 0; r < this.getRowCount(); ++r) {
            result[r] = this.data[r][columnNumber];
        }
        return result;
    }

    public double[] getColumn(int columnNumber) {
        double[] result = new double[this.getRowCount()];
        for (int r = 0; r < this.getRowCount(); ++r) {
            result[r] = this.data[r][columnNumber];
        }
        return result;
    }

    public String getRowTitlesTitle() {
        return this.rowTitlesTitle;
    }

    public String[] getColumnTitles() {
        return this.columnTitles;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int colMax = this.columnTitles.length;
        String[] columnTitles = this.getColumnTitles();
        sb.append(this.rowTitlesTitle);
        for (int c = 0; c < colMax; ++c) {
            sb.append("\t");
            sb.append(columnTitles[c]);
        }
        sb.append("\n");
        int rowMax = this.rowTitles.length;
        for (int r = 0; r < rowMax; ++r) {
            double[] adjustedRow = this.get(r);
            sb.append(this.rowTitles[r]);
            for (int c = 0; c < colMax; ++c) {
                sb.append("\t");
                sb.append(adjustedRow[c]);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public void sortByRowName() {
        int i;
        double[][] sortedData = new double[this.getRowCount()][this.getColumnCount()];
        HashMap<String, Integer> oldMap = new HashMap<String, Integer>();
        HashMap<String, Integer> newMap = new HashMap<String, Integer>();
        HashMap indexMap = new HashMap();
        for (i = 0; i < this.rowTitles.length; ++i) {
            oldMap.put(this.rowTitles[i], i);
        }
        Arrays.sort(this.rowTitles);
        for (i = 0; i < this.rowTitles.length; ++i) {
            newMap.put(this.rowTitles[i], i);
        }
        for (String rowName : this.rowTitles) {
            indexMap.put(oldMap.get(rowName), newMap.get(rowName));
        }
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            sortedData[((Integer)indexMap.get((Object)Integer.valueOf((int)i2))).intValue()] = this.data[i2];
        }
        this.data = sortedData;
    }

    public boolean equals(DataMatrix other) {
        return this.toString().equals(other.toString());
    }

    public void writeObject(String uri) throws IOException {
        FileOutputStream fstream = new FileOutputStream(uri);
        ObjectOutputStream ostream = new ObjectOutputStream(fstream);
        ostream.writeObject(this);
        ostream.close();
    }

    public static DataMatrix readObject(String uri) throws IOException, ClassNotFoundException {
        FileInputStream fstream = new FileInputStream(uri);
        ObjectInputStream ostream = new ObjectInputStream(fstream);
        return (DataMatrix)ostream.readObject();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Tuple getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Tuple metadata) {
        this.metadata = metadata;
    }
}

