/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.gaggle.boss;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.systemsbiology.gaggle.boss.BossConfig;
import org.systemsbiology.gaggle.boss.GaggleBossTableModel;
import org.systemsbiology.gaggle.boss.GuiBoss;
import org.systemsbiology.gaggle.boss.NameUniquifier;
import org.systemsbiology.gaggle.boss.plugins.GaggleBossPlugin;
import org.systemsbiology.gaggle.core.Boss;
import org.systemsbiology.gaggle.core.Goose;
import org.systemsbiology.gaggle.core.datatypes.Cluster;
import org.systemsbiology.gaggle.core.datatypes.DataMatrix;
import org.systemsbiology.gaggle.core.datatypes.GaggleTuple;
import org.systemsbiology.gaggle.core.datatypes.Namelist;
import org.systemsbiology.gaggle.core.datatypes.Network;
import org.systemsbiology.gaggle.geese.DeafGoose;
import org.systemsbiology.gaggle.util.MiscUtil;
import org.systemsbiology.gaggle.util.NewNameHelper;

public final class GuiBoss
extends UnicastRemoteObject
implements Boss,
WindowStateListener,
Serializable {
    protected JFrame frame;
    protected JTable gooseTable;
    protected JScrollPane scrollPane;
    protected JTextField searchBox;
    protected GaggleBossTableModel gooseTableModel;
    protected String serviceName = "gaggle";
    protected NewNameHelper nameHelper;
    protected HashMap<String, Goose> gooseMap;
    protected HashMap gooseListeningMap;
    transient NameUniquifier nameUniquifier;
    ArrayList deafGeese = new ArrayList();
    ArrayList plugins = new ArrayList();
    JPanel outerPanel;
    JTabbedPane tabbedPanel;
    JButton frameSizeToggleButton;
    boolean bodyVisible = true;
    BossConfig config;

    public GuiBoss() throws RemoteException {
        this(new String[0]);
    }

    public GuiBoss(String[] args) throws RemoteException {
        this.config = new BossConfig(args);
        String nameHelperUri = this.config.getNameHelperUri();
        if (nameHelperUri != null && nameHelperUri.length() > 0) {
            try {
                this.nameHelper = new NewNameHelper(nameHelperUri);
            }
            catch (Exception ex0) {
                String msg = "Error reading name helper file from " + nameHelperUri + "\n" + ex0.getMessage();
                JOptionPane.showMessageDialog(this.frame, msg);
            }
        }
        System.out.println("start invisibly? " + this.config.startInvisibly());
        System.out.println("start minimized? " + this.config.startMinimized());
        this.gooseMap = new HashMap();
        this.gooseListeningMap = new HashMap();
        this.nameUniquifier = new NameUniquifier();
        this.frame = new JFrame(this.createFrameTitle());
        this.frame.addWindowStateListener(this);
        try {
            LocateRegistry.createRegistry(1099);
            Naming.rebind(this.serviceName, this);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.frame, "Gaggle Port already in use.  Exiting....");
            System.exit(0);
        }
        this.frame.setDefaultCloseOperation(3);
        this.frame.addWindowStateListener(this);
        this.frame.getContentPane().add(this.createGui());
        this.frame.pack();
        if (!this.config.startInvisibly()) {
            this.frame.setVisible(true);
            this.frame.toFront();
        }
        if (this.config.startMinimized()) {
            this.frame.setVisible(true);
            this.frame.setState(1);
        }
    }

    public BossConfig getConfig() {
        return this.config;
    }

    public NewNameHelper getNameHelper() {
        return this.nameHelper;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void windowStateChanged(WindowEvent e) {
    }

    public String renameGoose(String oldName, String proposedName) {
        String uniqueName = this.nameUniquifier.makeUnique(proposedName);
        if (this.gooseMap.containsKey(oldName)) {
            Goose goose = this.gooseMap.get(oldName);
            this.gooseMap.remove(oldName);
            this.gooseMap.put(uniqueName, goose);
            try {
                goose.setName(uniqueName);
                this.unregisterIdleGeeseAndUpdate();
                return uniqueName;
            }
            catch (RemoteException rex0) {
                String msg = "Failed to contact goose to rename: " + oldName + " -> " + uniqueName;
                JOptionPane.showMessageDialog(this.frame, msg);
            }
        }
        return null;
    }

    protected void unregisterIdleGeeseAndUpdate() {
        ArrayList<String> idleGeeseNames = new ArrayList<String>();
        for (String gooseName : this.gooseMap.keySet()) {
            try {
                this.gooseMap.get(gooseName).getName();
            }
            catch (RemoteException e) {
                System.out.println("Removing idle goose '" + gooseName + "'");
                idleGeeseNames.add(gooseName);
            }
        }
        for (String idleGooseName : idleGeeseNames) {
            this.unregister(idleGooseName, false);
        }
        this.updateGeese();
    }

    protected String createFrameTitle() {
        String id = "$Revision: 2421 $";
        String signature = "Revision: ";
        int start = id.indexOf(signature);
        int end = id.indexOf(" $", start += signature.length());
        String versionNumber = id.substring(start, end);
        return "Gaggle Boss v." + versionNumber;
    }

    public String register(Goose goose) throws RemoteException {
        String uniqueName = this.nameUniquifier.makeUnique(goose.getName());
        goose.setName(uniqueName);
        this.addNewGoose(uniqueName, goose);
        this.refresh();
        this.unregisterIdleGeeseAndUpdate();
        return uniqueName;
    }

    private void updateGeese() {
        Object[] keys = this.gooseMap.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        for (Object gooseName : keys) {
            Goose goose = this.gooseMap.get(gooseName);
            try {
                goose.update((String[])keys);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public String register(DeafGoose deafGoose) throws RemoteException {
        this.deafGeese.add(deafGoose);
        return "";
    }

    public void unregister(String gooseName) {
        this.unregister(gooseName, true);
    }

    public void unregister(String gooseName, boolean doUpdate) {
        System.out.println("boss: received unregister request for " + gooseName);
        try {
            if (this.gooseMap.containsKey(gooseName)) {
                this.gooseMap.remove(gooseName);
            }
            if (this.gooseListeningMap.containsKey(gooseName)) {
                this.gooseListeningMap.remove(gooseName);
            }
            this.gooseTableModel.removeGoose(gooseName);
            this.setTableColumnWidths();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (doUpdate) {
            this.unregisterIdleGeeseAndUpdate();
        }
    }

    public Goose[] getGeese() {
        return this.gooseMap.values().toArray(new Goose[0]);
    }

    private String[] getSelectedGooseNames() {
        ArrayList<String> list = new ArrayList<String>();
        int[] selectedRows = this.gooseTable.getSelectedRows();
        String[] gooseNamesInTable = this.gooseTableModel.getAppNames();
        for (int i = 0; i < selectedRows.length; ++i) {
            list.add(gooseNamesInTable[selectedRows[i]]);
        }
        return list.toArray(new String[0]);
    }

    private String[] getUnselectedGooseNames() {
        ArrayList<Object> list = new ArrayList<Object>();
        int[] selectedRows = this.gooseTable.getSelectedRows();
        Object[] selectedGooseNames = this.getSelectedGooseNames();
        Object[] allNames = this.getGooseNames();
        Arrays.sort(selectedGooseNames);
        Arrays.sort(allNames);
        for (int i = 0; i < allNames.length; ++i) {
            if (Arrays.binarySearch(selectedGooseNames, allNames[i]) >= 0) continue;
            list.add(allNames[i]);
        }
        return list.toArray(new String[0]);
    }

    public Goose getGoose(String name) {
        return this.gooseMap.get(name);
    }

    public String[] getGooseNames() {
        return this.gooseMap.keySet().toArray(new String[0]);
    }

    public HashMap getGooseMap() {
        return this.gooseMap;
    }

    protected void broadcastToPlugins(String[] names) {
        for (int i = 0; i < this.plugins.size(); ++i) {
            GaggleBossPlugin plugin = (GaggleBossPlugin)this.plugins.get(i);
            plugin.select(names);
        }
    }

    public void broadcastNamelist(String sourceGoose, String targetGoose, Namelist nameList) throws RemoteException {
        long startTime = System.currentTimeMillis();
        this.broadcastToPlugins(nameList.getNames());
        String[] gooseNames = targetGoose == null || targetGoose.equalsIgnoreCase("boss") || targetGoose.equalsIgnoreCase("all") ? this.getListeningGeese() : new String[]{targetGoose};
        for (int i = 0; i < gooseNames.length; ++i) {
            Goose goose;
            String gooseName = gooseNames[i];
            if (gooseName.equals(sourceGoose) || (goose = this.getGoose(gooseName)) == null) continue;
            try {
                goose.handleNameList(sourceGoose, nameList);
                continue;
            }
            catch (Exception ex0) {
                System.err.println("error in select request to " + goose.getName() + ": " + ex0.getMessage());
                ex0.printStackTrace();
            }
        }
        this.refresh(true);
        long duration = System.currentTimeMillis() - startTime;
    }

    public void broadcastMatrix(String sourceGoose, String targetGoose, DataMatrix matrix) throws RemoteException {
        long startTime = System.currentTimeMillis();
        this.broadcastToPlugins(matrix.getRowTitles());
        String[] gooseNames = targetGoose == null || targetGoose.equalsIgnoreCase("boss") || targetGoose.equalsIgnoreCase("all") ? this.getListeningGeese() : new String[]{targetGoose};
        for (int i = 0; i < gooseNames.length; ++i) {
            Goose goose;
            String gooseName = gooseNames[i];
            if (gooseName.equals(sourceGoose) || (goose = this.getGoose(gooseName)) == null) continue;
            try {
                goose.handleMatrix(sourceGoose, matrix);
                continue;
            }
            catch (Exception ex0) {
                System.err.println("error in handleMatrix request to " + gooseName + ": " + ex0.getMessage());
                ex0.printStackTrace();
            }
        }
        this.refresh(true);
        long duration = System.currentTimeMillis() - startTime;
    }

    public void broadcastTuple(String sourceGoose, String targetGoose, GaggleTuple gaggleTuple) {
        long startTime = System.currentTimeMillis();
        this.refresh();
        String[] gooseNames = targetGoose == null || targetGoose.equalsIgnoreCase("boss") || targetGoose.equalsIgnoreCase("all") ? this.getListeningGeese() : new String[]{targetGoose};
        for (int i = 0; i < gooseNames.length; ++i) {
            Goose goose;
            String gooseName = gooseNames[i];
            if (gooseName.equals(sourceGoose) || (goose = this.getGoose(gooseName)) == null) continue;
            try {
                System.out.println("broadcastTuple to " + gooseName);
                goose.handleTuple(sourceGoose, gaggleTuple);
                continue;
            }
            catch (Exception ex0) {
                System.err.println("error in broadcastTuple to " + gooseName + ": " + ex0.getMessage());
                ex0.printStackTrace();
            }
        }
    }

    public void broadcastCluster(String sourceGoose, String targetGoose, Cluster cluster) {
        long startTime = System.currentTimeMillis();
        this.broadcastToPlugins(cluster.getRowNames());
        String[] gooseNames = targetGoose == null || targetGoose.equalsIgnoreCase("boss") || targetGoose.equalsIgnoreCase("all") ? this.getListeningGeese() : new String[]{targetGoose};
        for (int i = 0; i < gooseNames.length; ++i) {
            Goose goose;
            String gooseName = gooseNames[i];
            if (gooseName.equals(sourceGoose) || !this.isListening(gooseName) || (goose = this.getGoose(gooseName)) == null) continue;
            try {
                goose.handleCluster(sourceGoose, cluster);
                continue;
            }
            catch (Exception ex0) {
                System.err.println("error in broadcastCluster () to " + gooseName + ": " + ex0.getMessage());
                ex0.printStackTrace();
            }
        }
        long duration = System.currentTimeMillis() - startTime;
        this.refresh();
        System.out.println("GuiBoss.broadcastCluster  " + cluster.getName() + ", " + "rows: " + cluster.getRowNames().length + "columns: " + cluster.getColumnNames().length + ": " + duration + " msecs");
    }

    public void broadcastNetwork(String sourceGoose, String targetGoose, Network network) {
        String[] gooseNames = targetGoose == null || targetGoose.equalsIgnoreCase("boss") || targetGoose.equalsIgnoreCase("all") ? this.getListeningGeese() : new String[]{targetGoose};
        for (int i = 0; i < gooseNames.length; ++i) {
            Goose goose;
            String gooseName = gooseNames[i];
            if (gooseName.equals(sourceGoose) || (goose = this.getGoose(gooseName)) == null) continue;
            try {
                goose.handleNetwork(sourceGoose, network);
                continue;
            }
            catch (Exception ex0) {
                System.err.println("error in broadcastNetwork () to " + gooseName + ": " + ex0.getMessage());
                ex0.printStackTrace();
            }
        }
        this.refresh();
    }

    public void cleanUpOnExit(String appName) throws RemoteException {
    }

    public void hide(String targetGoose) throws RemoteException {
        String[] gooseNames;
        if (targetGoose == null) {
            gooseNames = this.getListeningGeese();
        } else {
            if (targetGoose.equalsIgnoreCase("boss")) {
                this.frame.setVisible(false);
                return;
            }
            gooseNames = new String[]{targetGoose};
        }
        for (int i = 0; i < gooseNames.length; ++i) {
            Goose goose = this.getGoose(gooseNames[i]);
            if (goose == null) continue;
            try {
                goose.doHide();
                continue;
            }
            catch (Exception ex0) {
                System.err.println("error in hide request to " + targetGoose + ": " + ex0.getMessage());
                ex0.printStackTrace();
            }
        }
    }

    public void show(String gooseName) throws RemoteException {
        if (gooseName.equalsIgnoreCase("boss")) {
            if (this.getFrame().getExtendedState() != 0) {
                this.getFrame().setExtendedState(0);
            }
            this.getFrame().setAlwaysOnTop(true);
            MiscUtil.setJFrameAlwaysOnTop(this.getFrame(), true);
            this.getFrame().setVisible(true);
            this.getFrame().setAlwaysOnTop(false);
            MiscUtil.setJFrameAlwaysOnTop(this.getFrame(), false);
            return;
        }
        Goose goose = this.getGoose(gooseName);
        if (goose == null) {
            return;
        }
        try {
            goose.doShow();
        }
        catch (Exception ex0) {
            System.err.println("error in show request to " + gooseName + ": " + ex0.getMessage());
            ex0.printStackTrace();
        }
    }

    public void askForShow(String gooseName) throws RemoteException {
        this.getFrame().toBack();
        this.getFrame().toFront();
        this.getFrame().setVisible(true);
    }

    public void terminate(String gooseName) throws RemoteException {
        Goose goose = this.getGoose(gooseName);
        if (goose == null) {
            return;
        }
        try {
            goose.doExit();
        }
        catch (UnmarshalException ignore0) {
        }
        catch (Exception ex1) {
            System.err.println("error in terminate request to " + gooseName + ": " + ex1.getMessage());
        }
    }

    public void toggleVisibility() {
        this.bodyVisible = !this.bodyVisible;
        String label = "Shrink";
        if (!this.bodyVisible) {
            label = "Boss";
        }
        this.frameSizeToggleButton.setText(label);
        this.tabbedPanel.setVisible(this.bodyVisible);
        this.frame.pack();
    }

    protected JPanel createGui() {
        this.outerPanel = new JPanel();
        this.outerPanel.setLayout(new BorderLayout());
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        this.frameSizeToggleButton = new JButton("Shrink");
        this.frameSizeToggleButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        toolbar.add(this.frameSizeToggleButton);
        this.outerPanel.add((Component)toolbar, "North");
        JButton aboutButton = new JButton("About");
        aboutButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        toolbar.add(aboutButton);
        this.outerPanel.add((Component)toolbar, "North");
        this.tabbedPanel = new JTabbedPane();
        this.outerPanel.add((Component)this.tabbedPanel, "Center");
        this.tabbedPanel.add((Component)this.createGaggleControlPanel(), "Gaggle");
        String[] pluginClassNames = this.config.getPluginNames();
        for (int i = 0; i < pluginClassNames.length; ++i) {
            System.out.println("about to load boss plugin: " + pluginClassNames[i]);
            GaggleBossPlugin plugin = this.loadPlugin(pluginClassNames[i], this);
            if (plugin == null) {
                String msg = "Could not locate plugin '" + pluginClassNames[i] + "'";
                JOptionPane.showMessageDialog(this.frame, msg);
                continue;
            }
            this.plugins.add(plugin);
            this.tabbedPanel.add((Component)plugin, plugin.getName());
        }
        return this.outerPanel;
    }

    protected JPanel createGaggleControlPanel() {
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BorderLayout());
        int topBorder = 20;
        int bottomBorder = 10;
        int sideBorder = 20;
        tablePanel.setBorder(BorderFactory.createEmptyBorder(topBorder, sideBorder, bottomBorder, sideBorder));
        JPanel tableOuterPanel = new JPanel();
        tableOuterPanel.setLayout(new BorderLayout());
        tableOuterPanel.add((Component)tablePanel, "Center");
        JPanel controlsPanel = new JPanel();
        controlsPanel.setLayout(new BorderLayout());
        controlsPanel.add((Component)this.createButtonsInPanel(), "Center");
        tableOuterPanel.add((Component)controlsPanel, "South");
        this.gooseTableModel = new GaggleBossTableModel((Boss)this);
        this.gooseTable = new JTable((TableModel)this.gooseTableModel);
        this.gooseTable.setSelectionMode(2);
        this.gooseTable.setShowGrid(true);
        this.gooseTable.setGridColor(Color.gray);
        this.gooseTable.setDefaultRenderer(JButton.class, (TableCellRenderer)new ButtonCellRenderer(this, this.gooseTable.getDefaultRenderer(JButton.class)));
        this.setTableColumnWidths();
        this.gooseTable.setPreferredScrollableViewportSize(new Dimension(400, 200));
        this.gooseTable.addMouseListener((MouseListener)new GaggleMouseListener(this, this.gooseTable));
        this.scrollPane = new JScrollPane(this.gooseTable);
        tablePanel.add((Component)this.scrollPane, "Center");
        return tableOuterPanel;
    }

    protected JPanel createButtonsInPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BorderLayout());
        JPanel actionButtonPanel = new JPanel();
        JPanel upperActionButtonPanel = new JPanel();
        JPanel lowerActionButtonPanel = new JPanel();
        JPanel quitButtonPanel = new JPanel();
        actionButtonPanel.setLayout(new GridLayout(2, 1));
        actionButtonPanel.add(upperActionButtonPanel);
        actionButtonPanel.add(lowerActionButtonPanel);
        JButton showButton = new JButton("Show");
        JButton showOthersButton = new JButton("Show Others");
        JButton hideButton = new JButton("Hide");
        JButton hideOthersButton = new JButton("Hide Others");
        JButton selectAllButton = new JButton("Select All");
        JButton refreshButton = new JButton("Refresh");
        JButton listenAllButton = new JButton("Listen All");
        JButton listenNoneButton = new JButton("Listen None");
        JButton terminateButton = new JButton("Terminate");
        JButton quitButton = new JButton("Quit");
        showButton.addActionListener((ActionListener)new ShowAction(this));
        showOthersButton.addActionListener((ActionListener)new ShowOthersAction(this));
        hideButton.addActionListener((ActionListener)new HideAction(this));
        hideOthersButton.addActionListener((ActionListener)new HideOthersAction(this));
        selectAllButton.addActionListener((ActionListener)new SelectAllAction(this));
        refreshButton.addActionListener((ActionListener)new RefreshAction(this));
        listenAllButton.addActionListener((ActionListener)new ListenAllAction(this));
        listenNoneButton.addActionListener((ActionListener)new ListenNoneAction(this));
        terminateButton.addActionListener((ActionListener)new TerminateAction(this));
        quitButton.addActionListener((ActionListener)new QuitAction(this));
        upperActionButtonPanel.add(showButton);
        upperActionButtonPanel.add(showOthersButton);
        upperActionButtonPanel.add(hideButton);
        upperActionButtonPanel.add(hideOthersButton);
        lowerActionButtonPanel.add(selectAllButton);
        lowerActionButtonPanel.add(refreshButton);
        lowerActionButtonPanel.add(listenAllButton);
        lowerActionButtonPanel.add(listenNoneButton);
        lowerActionButtonPanel.add(terminateButton);
        quitButtonPanel.add(quitButton);
        buttonPanel.add((Component)actionButtonPanel, "Center");
        buttonPanel.add((Component)quitButtonPanel, "South");
        return buttonPanel;
    }

    protected void setTableColumnWidths() {
    }

    protected String[] getListeningGeese() {
        String[] allGeese = this.getGooseNames();
        ArrayList<String> tmp = new ArrayList<String>();
        for (int i = 0; i < allGeese.length; ++i) {
            if (!this.listening(allGeese[i])) continue;
            tmp.add(allGeese[i]);
        }
        return tmp.toArray(new String[0]);
    }

    protected boolean listening(String gooseName) {
        return this.gooseTableModel.isListening(gooseName);
    }

    protected void setSelectionCount(String gooseName, int count) {
        this.gooseTableModel.setSelectionCount(gooseName, count);
    }

    public void refresh() {
        this.refresh(false);
    }

    public void refresh(boolean resetTableColumnWidths) {
        if (resetTableColumnWidths) {
            this.setTableColumnWidths();
        }
    }

    public void windowClosed(WindowEvent event) {
    }

    public void windowClosing(WindowEvent event) {
    }

    public void windowOpened(WindowEvent event) {
    }

    public void windowIconified(WindowEvent event) {
    }

    public void windowDeiconified(WindowEvent event) {
    }

    public void windowActivated(WindowEvent event) {
    }

    public void windowDeactivated(WindowEvent event) {
    }

    public void windowGainedFocus(WindowEvent event) {
    }

    public void windowLostFocus(WindowEvent event) {
    }

    private void placeInCenter() {
        GraphicsConfiguration gc = this.frame.getGraphicsConfiguration();
        int screenHeight = (int)gc.getBounds().getHeight();
        int screenWidth = (int)gc.getBounds().getWidth();
        int windowWidth = this.frame.getWidth();
        int windowHeight = this.frame.getHeight();
        this.frame.setLocation((screenWidth - windowWidth) / 2, (screenHeight - windowHeight) / 2);
    }

    public void addNewGoose(String name, Goose goose) {
        this.gooseMap.put(name, goose);
        this.gooseTableModel.addClient(name);
        this.setTableColumnWidths();
    }

    public boolean isListening(String gooseName) {
        return this.gooseTableModel.isListening(gooseName);
    }

    public GaggleBossPlugin loadPlugin(String className, GuiBoss gaggleBoss) {
        try {
            Class<?> pluginClass = Class.forName(className);
            Class[] argClasses = new Class[]{gaggleBoss.getClass()};
            Object[] args = new Object[]{gaggleBoss};
            Constructor<?>[] ctors = pluginClass.getConstructors();
            Constructor<?> ctor = pluginClass.getConstructor(argClasses);
            Object plugin = ctor.newInstance(args);
            return (GaggleBossPlugin)plugin;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        GuiBoss app = new GuiBoss(args);
    }

    static /* synthetic */ String[] access$000(GuiBoss x0) {
        return x0.getSelectedGooseNames();
    }

    static /* synthetic */ String[] access$100(GuiBoss x0) {
        return x0.getUnselectedGooseNames();
    }
}

