/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.sqlserver.tds;

import com.microsoft.jdbc.base.BaseExceptions;
import com.microsoft.jdbc.sqlserver.SQLServerDepacketizingDataProvider;
import com.microsoft.jdbc.sqlserver.SQLServerPacketizingDataConsumer;
import com.microsoft.util.UtilBufferedDataConsumer;
import com.microsoft.util.UtilBufferedDataProvider;
import com.microsoft.util.UtilDebug;
import com.microsoft.util.UtilException;
import com.microsoft.util.UtilSocketDataConsumer;
import com.microsoft.util.UtilSocketDataProvider;
import com.microsoft.util.UtilTransliterator;
import com.microsoft.util.UtilTransliteratorForUCS2;
import java.io.IOException;
import java.net.Socket;
import java.sql.SQLException;
import java.util.Vector;

public class TDSConnection {
    private static String footprint = "$Revision:   1.21  $";
    private Socket socket;
    private UtilSocketDataConsumer socketConsumer;
    private UtilBufferedDataConsumer bufferedConsumer;
    private SQLServerPacketizingDataConsumer packetizer;
    public UtilSocketDataProvider socketProvider;
    private UtilBufferedDataProvider bufferedProvider;
    private SQLServerDepacketizingDataProvider depacketizer;
    BaseExceptions exceptions;
    byte[] sqlCollation;
    int tdsVersion;
    public UtilTransliteratorForUCS2 unicodeTransliterator = null;
    public UtilTransliterator nonUnicodeTransliterator = null;
    Vector transliterators = null;
    public int numOutstandingCancelRequests;
    private String catalog;
    public static final int TDS_UNDEFINED = 0;
    public static final int TDS_07000000 = 1;
    public static final int TDS_07010000 = 2;

    public TDSConnection(String string, String string2, BaseExceptions baseExceptions) throws SQLException {
        this.exceptions = baseExceptions;
        try {
            this.socket = new Socket(string, Integer.parseInt(string2));
        }
        catch (Exception exception) {
            SQLException sQLException = this.exceptions.getException(exception);
            throw this.exceptions.getException(sQLException, 11002, "08001");
        }
        try {
            this.unicodeTransliterator = (UtilTransliteratorForUCS2)this.getTransliteratorForCodePage("UCS2");
            this.unicodeTransliterator.setToLittleEndian();
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException(utilException);
        }
        this.socketConsumer = new UtilSocketDataConsumer(this.socket);
        this.bufferedConsumer = new UtilBufferedDataConsumer(this.socketConsumer);
        this.packetizer = new SQLServerPacketizingDataConsumer(this.bufferedConsumer);
        this.socketProvider = new UtilSocketDataProvider(this.socket);
        this.bufferedProvider = new UtilBufferedDataProvider(this.socketProvider);
        this.depacketizer = new SQLServerDepacketizingDataProvider(this.bufferedProvider);
        this.tdsVersion = 0;
        this.numOutstandingCancelRequests = 0;
        this.catalog = null;
    }

    public void close() {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {}
    }

    public String getCatalog() {
        return this.catalog;
    }

    public SQLServerDepacketizingDataProvider getDepacketizer() {
        return this.depacketizer;
    }

    public String getLocalHostname() {
        if (this.socket != null) {
            return this.socket.getLocalAddress().getHostName();
        }
        return "";
    }

    public SQLServerPacketizingDataConsumer getPacketizer() {
        return this.packetizer;
    }

    public byte[] getSQLCollation() {
        return this.sqlCollation;
    }

    public String getServerHostname() {
        String string = "";
        if (this.socket != null && (string = this.socket.getInetAddress().getHostName()).equals("127.0.0.1")) {
            string = "localhost";
        }
        return string;
    }

    public int getTDSVersion() {
        return this.tdsVersion;
    }

    public UtilTransliterator getTransliteratorForCodePage(String string) throws UtilException {
        Object object;
        if (this.transliterators == null) {
            this.transliterators = new Vector(10);
        }
        int n = 0;
        while (n < this.transliterators.size()) {
            object = (TransliteratorForLCID)this.transliterators.elementAt(n);
            if (string.compareTo(((TransliteratorForLCID)object).codePage) == 0) {
                return ((TransliteratorForLCID)object).transliterator;
            }
            ++n;
        }
        object = UtilTransliterator.GetNewTransliterator(string);
        if (object != null) {
            TransliteratorForLCID transliteratorForLCID = new TransliteratorForLCID();
            transliteratorForLCID.codePage = string;
            transliteratorForLCID.transliterator = object;
            this.transliterators.addElement(transliteratorForLCID);
        }
        return object;
    }

    String mapCollationToCodePage(byte[] byArray) throws SQLException {
        int n = (byArray[2] & 0xF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
        String string = null;
        switch (n) {
            case 1054: {
                string = "874";
                break;
            }
            case 1041: 
            case 66577: {
                string = "932";
                break;
            }
            case 2052: 
            case 4100: 
            case 133124: {
                string = "936";
                break;
            }
            case 1042: 
            case 66578: {
                string = "949";
                break;
            }
            case 1028: 
            case 197636: {
                string = "950";
                break;
            }
            case 1029: 
            case 1038: 
            case 1045: 
            case 1048: 
            case 1050: 
            case 1051: 
            case 1052: 
            case 1060: 
            case 66574: {
                string = "1250";
                break;
            }
            case 1026: 
            case 1049: 
            case 1058: 
            case 1059: 
            case 1071: 
            case 2074: 
            case 3098: {
                string = "1251";
                break;
            }
            case 1027: 
            case 1030: 
            case 1031: 
            case 1033: 
            case 1034: 
            case 1035: 
            case 1036: 
            case 1039: 
            case 1040: 
            case 1043: 
            case 1044: 
            case 1046: 
            case 1053: 
            case 1057: 
            case 1069: 
            case 1080: 
            case 2055: 
            case 2057: 
            case 2058: 
            case 2060: 
            case 2064: 
            case 2067: 
            case 2068: 
            case 2070: 
            case 3079: 
            case 3081: 
            case 3082: 
            case 3084: 
            case 4103: 
            case 4105: 
            case 4106: 
            case 4108: 
            case 5127: 
            case 5129: 
            case 5130: 
            case 5132: 
            case 6153: 
            case 6154: 
            case 7178: 
            case 7717: 
            case 8201: 
            case 8202: 
            case 9225: 
            case 9226: 
            case 10250: 
            case 11274: 
            case 12298: 
            case 13322: 
            case 14346: 
            case 15370: 
            case 16394: 
            case 66567: 
            case 66615: {
                string = "1252";
                break;
            }
            case 1032: {
                string = "1253";
                break;
            }
            case 1055: {
                string = "1254";
                break;
            }
            case 1037: {
                string = "1255";
                break;
            }
            case 1025: 
            case 1056: 
            case 1065: 
            case 2049: 
            case 3073: 
            case 4097: 
            case 5121: 
            case 6145: 
            case 7169: 
            case 8193: 
            case 9217: 
            case 10241: 
            case 11265: 
            case 12289: 
            case 13313: 
            case 14337: 
            case 15361: 
            case 16385: {
                string = "1256";
                break;
            }
            case 1061: 
            case 1062: 
            case 1063: 
            case 2087: {
                string = "1257";
                break;
            }
            case 1066: {
                string = "1258";
                break;
            }
            default: {
                String[] stringArray = new String[]{String.valueOf(n)};
                throw this.exceptions.getException(11012, stringArray);
            }
        }
        return string;
    }

    public void setCatalog(String string) {
        this.catalog = string;
    }

    public void setMessageType(int n) {
        this.packetizer.setMessageType(n);
    }

    public void setNonUnicodeTransliterator(String string) throws SQLException {
        try {
            this.nonUnicodeTransliterator = this.getTransliteratorForCodePage(string);
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException(utilException);
        }
    }

    public void setPacketSize(int n) {
        this.packetizer.setMessageType(n);
    }

    public void setSQLCollation(byte[] byArray) throws SQLException {
        this.sqlCollation = byArray;
        this.setNonUnicodeTransliterator(this.mapCollationToCodePage(byArray));
    }

    public void setTDSVersion(int n) {
        if (n == 0x7000000) {
            this.tdsVersion = 1;
        } else if (n == 0x7010000) {
            this.tdsVersion = 2;
        } else {
            UtilDebug.assert("The server is using an unknown TDS version.", false);
        }
    }

    private class TransliteratorForLCID {
        String codePage;
        UtilTransliterator transliterator;

        TransliteratorForLCID() {
        }
    }
}

