/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.sqlserver;

import com.microsoft.jdbc.base.BaseImplConnection;
import com.microsoft.jdbc.base.BaseImplStatement;
import com.microsoft.jdbc.sqlserver.SQLServerConnection;
import com.microsoft.jdbc.sqlserver.SQLServerImplStatement;
import com.microsoft.jdbc.sqlserver.tds.TDSConnection;
import com.microsoft.jdbc.sqlserver.tds.TDSExecuteRequest;
import com.microsoft.jdbc.sqlserver.tds.TDSLoginRequest;
import com.microsoft.util.UtilByteArrayDataProvider;
import com.microsoft.util.UtilByteOrderedDataReader;
import com.microsoft.util.UtilByteOrderedDataWriter;
import java.sql.SQLException;

public class SQLServerImplConnection
extends BaseImplConnection {
    private static String footprint = "$Revision:   1.49  $";
    SQLServerConnection connection;
    TDSConnection conn;
    boolean useServerSideCursor;
    int maxRows;
    public static int defaultMaxRows = 0;
    int maxFieldSize;
    public static int defaultMaxFieldSize = Integer.MAX_VALUE;
    public UtilByteOrderedDataWriter writer;
    public UtilByteOrderedDataReader reader;

    public SQLServerImplConnection(SQLServerConnection sQLServerConnection) {
        this.connection = sQLServerConnection;
        this.quotingChar = (char)39;
        this.maxFieldSize = defaultMaxFieldSize;
        this.maxRows = defaultMaxRows;
    }

    public void close() throws SQLException {
        try {
            this.conn.close();
        }
        catch (Exception exception) {
            throw this.exceptions.getException(11003);
        }
    }

    protected void commitTransaction() throws SQLException {
        TDSExecuteRequest tDSExecuteRequest = new TDSExecuteRequest(this.conn, this.reader, this.writer, "IF @@TRANCOUNT > 0 COMMIT TRAN", false);
        tDSExecuteRequest.submitRequest();
        tDSExecuteRequest.processReply(this.warnings);
    }

    protected BaseImplStatement createImplStatement(int n, int n2) throws SQLException {
        SQLServerImplStatement sQLServerImplStatement = new SQLServerImplStatement(this.conn, n, n2, this.exceptions);
        UtilByteOrderedDataReader utilByteOrderedDataReader = null;
        if (this.useServerSideCursor) {
            utilByteOrderedDataReader = new UtilByteOrderedDataReader(new UtilByteArrayDataProvider(this.conn.getDepacketizer()), this.conn.unicodeTransliterator);
            utilByteOrderedDataReader.setToLittleEndian();
        } else {
            utilByteOrderedDataReader = this.reader;
        }
        sQLServerImplStatement.setReader(utilByteOrderedDataReader);
        sQLServerImplStatement.setWriter(this.writer);
        return sQLServerImplStatement;
    }

    public boolean enableCancelBasedQueryTimeout() {
        return true;
    }

    protected String getCatalog() throws SQLException {
        return this.conn.getCatalog();
    }

    public int getEmptyRowInsertSyntax() {
        return 1;
    }

    protected int getTransactionIsolation() throws SQLException {
        return 2;
    }

    public static String mapNativeErrorToSQLState(int n) {
        switch (n) {
            case 919: 
            case 926: 
            case 3606: 
            case 3607: 
            case 3622: 
            case 5701: 
            case 5703: {
                return "01000";
            }
            case 16934: 
            case 16947: {
                return "01001";
            }
            case 8153: {
                return "01003";
            }
            case 120: 
            case 121: {
                return "07008";
            }
            case 911: 
            case 916: 
            case 2740: 
            case 4017: 
            case 4019: 
            case 17809: 
            case 18450: 
            case 18458: {
                return "08004";
            }
            case 512: {
                return "21000";
            }
            case 109: 
            case 110: 
            case 213: {
                return "21S01";
            }
            case 4409: 
            case 4501: 
            case 4502: {
                return "21S02";
            }
            case 8115: 
            case 8152: {
                return "22001";
            }
            case 168: 
            case 220: 
            case 232: 
            case 236: 
            case 237: 
            case 238: 
            case 240: 
            case 244: 
            case 246: 
            case 248: 
            case 535: 
            case 1007: {
                return "22003";
            }
            case 210: 
            case 211: 
            case 241: 
            case 242: 
            case 295: 
            case 296: 
            case 517: {
                return "22007";
            }
            case 8134: {
                return "22012";
            }
            case 206: 
            case 235: 
            case 245: 
            case 247: 
            case 249: 
            case 256: 
            case 305: 
            case 409: 
            case 518: 
            case 529: {
                return "22018";
            }
            case 1010: {
                return "22019";
            }
            case 310: {
                return "22025";
            }
            case 221: 
            case 233: 
            case 234: 
            case 272: 
            case 273: 
            case 544: 
            case 547: 
            case 1505: 
            case 1508: 
            case 2601: 
            case 2615: 
            case 2627: 
            case 3604: 
            case 3605: 
            case 8101: {
                return "23000";
            }
            case 16930: 
            case 16931: {
                return "24000";
            }
            case 266: 
            case 628: 
            case 3902: 
            case 3903: 
            case 3906: 
            case 3908: 
            case 6401: {
                return "25000";
            }
            case 4002: 
            case 18456: 
            case 18459: {
                return "28000";
            }
            case 16916: {
                return "34000";
            }
            case 1205: 
            case 1211: 
            case 7112: {
                return "40001";
            }
            case 229: 
            case 230: {
                return "42000";
            }
            case 2714: {
                return "42S01";
            }
            case 208: 
            case 239: 
            case 267: 
            case 1906: 
            case 2501: 
            case 2706: 
            case 3701: 
            case 4401: 
            case 4701: 
            case 4902: 
            case 4924: {
                return "42S02";
            }
            case 1913: {
                return "42S11";
            }
            case 3718: {
                return "42S12";
            }
            case 2705: 
            case 2727: 
            case 4506: {
                return "42S21";
            }
            case 207: {
                return "42S22";
            }
            case 550: {
                return "44000";
            }
            case 16902: {
                return "HY109";
            }
        }
        return "HY000";
    }

    public void open() throws SQLException {
        String string = this.connectProps.get("serverName");
        String string2 = this.connectProps.get("portNumber");
        String string3 = this.connectProps.get("selectMethod");
        this.useServerSideCursor = string3.equalsIgnoreCase("cursor");
        this.conn = new TDSConnection(string, string2, this.exceptions);
        this.writer = new UtilByteOrderedDataWriter(this.conn.getPacketizer(), this.conn.unicodeTransliterator);
        this.writer.setToLittleEndian();
        this.reader = new UtilByteOrderedDataReader(this.conn.getDepacketizer(), this.conn.unicodeTransliterator);
        this.reader.setToLittleEndian();
        TDSLoginRequest tDSLoginRequest = new TDSLoginRequest(this.conn, this.reader, this.writer, this.connectProps.get("user"), this.connectProps.get("password"), this.connectProps.get("databaseName"), this.connectProps.get("programName"), this.connectProps.get("hostProcess"), this.connectProps.get("netAddress"));
        tDSLoginRequest.submitRequest();
        tDSLoginRequest.processReply(this.warnings);
        String string4 = "com.microsoft";
        if (this.conn.getTDSVersion() < 2 && string4.endsWith("microsoft")) {
            this.close();
            throw this.exceptions.getException(11013);
        }
    }

    protected void rollbackTransaction() throws SQLException {
        TDSExecuteRequest tDSExecuteRequest = new TDSExecuteRequest(this.conn, this.reader, this.writer, "IF @@TRANCOUNT > 0 ROLLBACK TRAN", false);
        tDSExecuteRequest.submitRequest();
        tDSExecuteRequest.processReply(this.warnings);
    }

    protected void setCatalog(String string) throws SQLException {
        TDSExecuteRequest tDSExecuteRequest = new TDSExecuteRequest(this.conn, this.reader, this.writer, "USE " + string, false);
        tDSExecuteRequest.submitRequest();
        tDSExecuteRequest.processReply(this.warnings);
        tDSExecuteRequest.discardReplyBytes();
    }

    protected void setTransactionIsolation(int n) throws SQLException {
        String string = new String("SET TRANSACTION ISOLATION LEVEL ");
        switch (n) {
            case 2: {
                string = String.valueOf(string) + "READ COMMITTED";
                break;
            }
            case 1: {
                string = String.valueOf(string) + "READ UNCOMMITTED";
                break;
            }
            case 4: {
                string = String.valueOf(string) + "REPEATABLE READ";
                break;
            }
            case 8: {
                string = String.valueOf(string) + "SERIALIZABLE";
                break;
            }
        }
        TDSExecuteRequest tDSExecuteRequest = new TDSExecuteRequest(this.conn, this.reader, this.writer, string, false);
        tDSExecuteRequest.submitRequest();
        tDSExecuteRequest.processReply(this.warnings);
        tDSExecuteRequest.discardReplyBytes();
    }

    protected void startManualTransactionMode() throws SQLException {
        TDSExecuteRequest tDSExecuteRequest = new TDSExecuteRequest(this.conn, this.reader, this.writer, "SET IMPLICIT_TRANSACTIONS ON", false);
        tDSExecuteRequest.submitRequest();
        tDSExecuteRequest.processReply(this.warnings);
    }

    protected void stopManualTransactionMode() throws SQLException {
        TDSExecuteRequest tDSExecuteRequest = new TDSExecuteRequest(this.conn, this.reader, this.writer, "SET IMPLICIT_TRANSACTIONS OFF", false);
        tDSExecuteRequest.submitRequest();
        tDSExecuteRequest.processReply(this.warnings);
    }
}

