/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseParameter;
import com.microsoft.util.UtilDebug;

public class BaseParameters {
    private static String footprint = "$Revision:   1.7  $";
    private BaseParameter[] parametersIn;
    private BaseParameter[] parametersOut;

    public BaseParameters(int n) {
        this.parametersIn = new BaseParameter[n];
        this.parametersOut = new BaseParameter[n];
    }

    public BaseParameters(BaseParameters baseParameters) {
        this.parametersIn = new BaseParameter[baseParameters.parametersIn.length];
        this.parametersOut = new BaseParameter[baseParameters.parametersOut.length];
        int n = 0;
        while (n < this.parametersIn.length) {
            if (baseParameters.parametersIn[n] != null) {
                this.parametersIn[n] = new BaseParameter(baseParameters.parametersIn[n]);
            }
            if (baseParameters.parametersOut[n] != null) {
                this.parametersOut[n] = new BaseParameter(baseParameters.parametersOut[n]);
            }
            ++n;
        }
    }

    public void clearInput() {
        int n = 0;
        while (n < this.count()) {
            this.parametersIn[n] = null;
            ++n;
        }
    }

    public int count() {
        return this.parametersIn.length;
    }

    public boolean directionSet(int n) {
        boolean bl = false;
        return bl;
    }

    public BaseParameter get(int n, int n2) {
        BaseParameter baseParameter = null;
        if (n2 == 1) {
            baseParameter = this.parametersIn[n - 1];
        } else if (n2 == 2) {
            baseParameter = this.parametersOut[n - 1];
        } else {
            UtilDebug.assert("IN / OUT parameters are maintained as separate instances", false);
        }
        return baseParameter;
    }

    protected boolean haveMinimalBindings() {
        boolean bl = true;
        int n = this.count();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            if (this.parametersIn[n4] != null) {
                ++n2;
            } else if (this.parametersOut[n4] != null) {
                ++n3;
            }
            ++n4;
        }
        if (n2 + n3 < n) {
            bl = false;
        }
        return bl;
    }

    boolean isValidOrdinal(int n) {
        return n > 0 && n <= this.count();
    }

    public void set(int n, int n2, BaseParameter baseParameter) {
        if (n2 == 1) {
            this.parametersIn[n - 1] = baseParameter;
        } else if (n2 == 2) {
            this.parametersOut[n - 1] = baseParameter;
        } else {
            UtilDebug.assert("IN / OUT parameters are maintained as separate instances", false);
        }
    }
}

