/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseColumn;
import com.microsoft.jdbc.base.BaseData;
import com.microsoft.jdbc.base.BaseImplServiceResultSet;
import com.microsoft.jdbc.base.BaseResultSetSortDescriptor;
import com.microsoft.util.UtilTempFile;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.SQLException;

public final class BaseImplSortCursorResultSet
extends BaseImplServiceResultSet {
    private static String footprint = "$Revision:   1.6.1.0  $";
    private File rowPositionFileHandle;
    private RandomAccessFile rowPositionFile;
    boolean haveSortedRows = false;
    BaseResultSetSortDescriptor sortDescriptor;
    private BaseData[] sortedRow;
    private BaseData[] nextRowToBeSorted;
    int maxCursorPosition = 0;

    public void close() throws SQLException {
        super.close();
        try {
            this.rowPositionFile.close();
            this.rowPositionFileHandle.delete();
        }
        catch (IOException iOException) {}
    }

    private boolean compareCurrentRows() throws SQLException {
        int n = 0;
        int n2 = 0;
        while (n < this.sortDescriptor.getSortCount() && n2 == 0) {
            int n3 = this.sortDescriptor.getSortColumnOrdinal(n);
            n2 = BaseData.compare(this.nextRowToBeSorted[n3 - 1], this.sortedRow[n3 - 1], BaseData.mapJDBCTypeToJavaObjectType(this.columns.get((int)n3).type), this.implStatement.implConnection.exceptions);
            ++n;
        }
        return n2 >= 0;
    }

    public void endOfResultSetReached(int n) {
        this.maxCursorPosition = n;
        if (this.notificationSink != null) {
            this.notificationSink.endOfResultSetReached(n);
        }
    }

    private void fetchAndSortRows() throws SQLException {
        boolean bl;
        int n = 1;
        do {
            if (!(bl = this.subImplResultSet.positionCursor(n))) continue;
            this.getCurrentFromSubResultSet(this.nextRowToBeSorted, false);
            this.insertSubResultSetRowIntoSortList(n);
            ++n;
        } while (bl);
        this.haveSortedRows = true;
    }

    public int getColumnAccess() {
        return 2;
    }

    private void getCurrentFromSubResultSet(BaseData[] baseDataArray, boolean bl) throws SQLException {
        if (bl) {
            int n = this.sortDescriptor.getSortCount();
            int n2 = 0;
            while (n2 < n) {
                int n3 = this.sortDescriptor.getSortColumnOrdinal(n2);
                BaseData baseData = this.subImplResultSet.getData(n3, this.columns.get((int)n3).baseDataType);
                baseDataArray[n3 - 1].data = baseData.data;
                baseDataArray[n3 - 1].type = baseData.type;
                ++n2;
            }
        } else {
            int n = this.columns.count(1);
            int n4 = 1;
            while (n4 <= n) {
                BaseData baseData = this.subImplResultSet.getData(n4, this.columns.get((int)n4).baseDataType);
                baseDataArray[n4 - 1].data = baseData.data;
                baseDataArray[n4 - 1].type = baseData.type;
                ++n4;
            }
        }
    }

    public BaseData getData(int n, int n2) throws SQLException {
        return this.sortedRow[n - 1];
    }

    private void getSortedFromSubResultSet(int n, boolean bl) throws SQLException {
        try {
            this.rowPositionFile.seek((n - 1) * 4);
            n = this.rowPositionFile.readInt();
            this.subImplResultSet.positionCursor(n);
            this.getCurrentFromSubResultSet(this.sortedRow, bl);
        }
        catch (IOException iOException) {
            SQLException sQLException = this.implStatement.implConnection.exceptions.getException(iOException);
            throw this.implStatement.implConnection.exceptions.getException(sQLException, 6039);
        }
    }

    private void initializeRows() {
        int n = this.columns.count(1);
        this.sortedRow = new BaseData[n];
        this.nextRowToBeSorted = new BaseData[n];
        int n2 = 0;
        while (n2 < n) {
            BaseColumn baseColumn = this.columns.get(n2 + 1);
            this.sortedRow[n2] = new BaseData();
            this.nextRowToBeSorted[n2] = new BaseData();
            ++n2;
        }
    }

    private void insertSubResultSetRowIntoSortList(int n) throws SQLException {
        try {
            int n2;
            int n3;
            int n4 = 0;
            boolean bl = true;
            if (n != 1) {
                int n5;
                n3 = 1;
                n2 = n;
                int n6 = (n3 + n2) / 2;
                boolean bl2 = false;
                do {
                    n5 = n6;
                    this.getSortedFromSubResultSet(n6, true);
                    bl = this.compareCurrentRows();
                    if (bl) {
                        n3 = n6;
                        bl2 = true;
                        continue;
                    }
                    n2 = n6;
                    bl2 = false;
                } while (n5 != (n6 = (n3 + n2) / 2));
                n4 = n6 - 1 + (bl2 ? 1 : 0);
            }
            n3 = n;
            n2 = 0;
            while (n4 < n) {
                if (n4 != n - 1) {
                    this.rowPositionFile.seek(n4 * 4);
                    n2 = this.rowPositionFile.readInt();
                }
                this.rowPositionFile.seek(n4 * 4);
                this.rowPositionFile.writeInt(n3);
                n3 = n2;
                ++n4;
            }
        }
        catch (IOException iOException) {
            SQLException sQLException = this.implStatement.implConnection.exceptions.getException(iOException);
            throw this.implStatement.implConnection.exceptions.getException(sQLException, 6044);
        }
    }

    public boolean positionCursor(int n) throws SQLException {
        boolean bl;
        if (!this.haveSortedRows) {
            this.initializeRows();
            this.fetchAndSortRows();
        }
        if (n <= this.maxCursorPosition) {
            this.getSortedFromSubResultSet(n, false);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public void postSetupInitialize() throws SQLException {
        this.setupTempFile();
        super.postSetupInitialize();
    }

    public void setFetchSize(int n) {
    }

    public void setSortCriteria(BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        this.sortDescriptor = baseResultSetSortDescriptor;
    }

    private void setupTempFile() throws SQLException {
        try {
            this.rowPositionFileHandle = UtilTempFile.createTempFile("srt_");
            this.rowPositionFile = new RandomAccessFile(this.rowPositionFileHandle, "rw");
        }
        catch (Exception exception) {
            SQLException sQLException = this.implStatement.implConnection.exceptions.getException(exception);
            throw this.implStatement.implConnection.exceptions.getException(sQLException, 6039);
        }
    }
}

