/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseExceptions;
import com.microsoft.jdbc.base.BaseImplBlob;
import com.microsoft.jdbc.base.BaseImplBlobService;
import com.microsoft.util.UtilDebug;
import java.sql.SQLException;

public class BaseImplCachedBlob
extends BaseImplBlobService {
    private static String footprint = "$Revision:   1.3  $";
    private int cacheStartOffset = -1;
    private int cacheEndOffset = -1;
    private byte[] cachedData = null;

    public BaseImplCachedBlob(BaseImplBlob baseImplBlob, BaseExceptions baseExceptions) {
        super(baseImplBlob, baseExceptions);
    }

    private void createCacheBuffer() throws SQLException {
        if (this.cachedData == null) {
            int n;
            try {
                n = new Long(this.subImplBlob.getLength()).intValue();
            }
            catch (Exception exception) {
                throw this.exceptions.getException(6067);
            }
            this.cachedData = new byte[n + 1];
        }
    }

    protected void fetchDataToCache(long l, int n) throws SQLException {
        UtilDebug.assert("blobOffset must be positive", l > 0L);
        UtilDebug.assert("numBytesToRead must be non-negative", n >= 0);
        this.createCacheBuffer();
        if (l + (long)n > Integer.MAX_VALUE) {
            throw this.exceptions.getException(6067);
        }
        int n2 = new Long(l).intValue();
        int n3 = new Long(l + (long)n).intValue();
        if (this.cacheStartOffset == -1 || this.cacheEndOffset == -1) {
            UtilDebug.assert("Invalid Cache State", this.cacheStartOffset == -1 && this.cacheEndOffset == -1);
            int n4 = n3 - n2;
            if (n4 > 0) {
                this.subImplBlob.readData(this.cachedData, n2, n2, n4);
                this.cacheStartOffset = n2;
                this.cacheEndOffset = n3 - 1;
            }
        } else {
            int n5;
            if (n2 < this.cacheStartOffset && (n5 = this.cacheStartOffset - n2) > 0) {
                this.subImplBlob.readData(this.cachedData, n2, n2, n5);
                this.cacheStartOffset = n2;
            }
            if (n3 > this.cacheEndOffset && (n5 = n3 - (n2 = this.cacheEndOffset + 1)) > 0) {
                this.subImplBlob.readData(this.cachedData, n2, n2, n5);
                this.cacheEndOffset = n3 - 1;
            }
        }
    }

    protected byte[] getCachedData() {
        return this.cachedData;
    }

    public int readData(byte[] byArray, int n, long l, int n2) throws SQLException {
        this.fetchDataToCache(l, n2);
        int n3 = new Long(l).intValue();
        System.arraycopy(this.cachedData, n3, byArray, n, n2);
        return n2;
    }
}

