/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseCallEscape;
import com.microsoft.jdbc.base.BaseEscape;
import com.microsoft.jdbc.base.BaseEscapeEscape;
import com.microsoft.jdbc.base.BaseEscapeParsingLex;
import com.microsoft.jdbc.base.BaseEscapeParsingLexTable;
import com.microsoft.jdbc.base.BaseEscapeParsingYacc;
import com.microsoft.jdbc.base.BaseEscapeParsingYaccTable;
import com.microsoft.jdbc.base.BaseExceptions;
import com.microsoft.jdbc.base.BaseFunctionEscape;
import com.microsoft.jdbc.base.BaseImplStatement;
import com.microsoft.jdbc.base.BaseJoinEscape;
import com.microsoft.jdbc.base.BaseTimestampEscape;
import com.microsoft.jdbc.base.BaseWarnings;
import com.microsoft.jdbc.vprt.SSLexStringConsumer;
import com.microsoft.jdbc.vprt.SSLexTable;
import com.microsoft.jdbc.vprt.SSYaccTable;
import com.microsoft.util.UtilDebug;
import java.sql.SQLException;

public class BaseEscapeTranslator {
    private static String footprint = "$Revision:   1.19.1.1  $";
    protected BaseImplStatement implStatement;
    private String translation;
    private String newWhere;
    protected static final int NO_TRANSLATION_NEEDED = 0;
    protected static final int UNADORN_TRANSLATION_NEEDED = 1;
    protected static final int FULL_TRANSLATION_NEEDED = 2;
    protected BaseWarnings warnings;
    private static SSLexTable lexTable = null;
    private static SSYaccTable yaccTable = null;

    public BaseEscapeTranslator() {
        if (lexTable == null) {
            lexTable = new BaseEscapeParsingLexTable();
        }
        if (yaccTable == null) {
            yaccTable = new BaseEscapeParsingYaccTable();
        }
    }

    public final void fullTranslateEscape(BaseEscape baseEscape, String string) {
        switch (baseEscape.getEscapeType()) {
            case 1: 
            case 2: 
            case 3: {
                this.translation = this.translateTimestampEscape((BaseTimestampEscape)baseEscape);
                this.newWhere = null;
                break;
            }
            case 4: {
                this.translation = this.translateFunctionEscape((BaseFunctionEscape)baseEscape);
                this.newWhere = null;
                break;
            }
            case 5: {
                this.translation = this.translateJoinEscapeFromClause((BaseJoinEscape)baseEscape);
                this.newWhere = this.translateJoinEscapeWhereClause((BaseJoinEscape)baseEscape, string);
                break;
            }
            case 6: 
            case 7: {
                this.translation = this.translateCallEscape((BaseCallEscape)baseEscape);
                this.newWhere = null;
                break;
            }
            case 8: {
                this.translation = this.translateEscapeEscape((BaseEscapeEscape)baseEscape);
                this.newWhere = null;
                break;
            }
            default: {
                UtilDebug.assert("Unknown escape type.", false);
            }
        }
    }

    public final String getNewWhere() {
        return this.newWhere;
    }

    public final String getTranslation() {
        return this.translation;
    }

    public int getTranslationNeeded(int n) {
        return 2;
    }

    public void insertOuterJoinOperator(StringBuffer stringBuffer, int n) {
    }

    public final BaseEscape parseEscape(String string, BaseExceptions baseExceptions) throws SQLException {
        SSLexTable sSLexTable = lexTable;
        synchronized (sSLexTable) {
            SSLexStringConsumer sSLexStringConsumer = new SSLexStringConsumer(string);
            BaseEscapeParsingLex baseEscapeParsingLex = new BaseEscapeParsingLex(lexTable, sSLexStringConsumer);
            BaseEscapeParsingYacc baseEscapeParsingYacc = new BaseEscapeParsingYacc(yaccTable, baseEscapeParsingLex);
            if (baseEscapeParsingYacc.parse()) {
                throw baseExceptions.getException(baseEscapeParsingYacc.getErrorReasonKey(), baseEscapeParsingYacc.getErrorReasonArgs(), "42000");
            }
            BaseEscape baseEscape = baseEscapeParsingYacc.getEscape();
            Object var5_8 = null;
            return baseEscape;
        }
    }

    protected void setImplStatement(BaseImplStatement baseImplStatement) {
        this.implStatement = baseImplStatement;
    }

    public void setWarnings(BaseWarnings baseWarnings) {
        this.warnings = baseWarnings;
    }

    public String translateCallEscape(BaseCallEscape baseCallEscape) {
        return null;
    }

    public final int translateEscape(String string, String string2, BaseExceptions baseExceptions) throws SQLException {
        BaseEscape baseEscape = this.parseEscape(string, baseExceptions);
        int n = baseEscape.getEscapeType();
        switch (this.getTranslationNeeded(n)) {
            case 0: {
                this.translation = null;
                this.newWhere = null;
                break;
            }
            case 1: {
                this.translation = this.unadornTranslateEscape(string, baseEscape);
                this.newWhere = null;
                break;
            }
            case 2: {
                this.fullTranslateEscape(baseEscape, string2);
                break;
            }
            default: {
                UtilDebug.assert("Unknown escape type.", false);
            }
        }
        return n;
    }

    public String translateEscapeEscape(BaseEscapeEscape baseEscapeEscape) {
        return null;
    }

    public String translateFunctionEscape(BaseFunctionEscape baseFunctionEscape) {
        return null;
    }

    public String translateJoinEscapeFromClause(BaseJoinEscape baseJoinEscape) {
        boolean bl;
        boolean bl2 = true;
        StringBuffer stringBuffer = new StringBuffer("");
        while (bl = baseJoinEscape.moveToNextTableReference()) {
            String string = baseJoinEscape.getCurrentTableName();
            String string2 = baseJoinEscape.getCurrentCorrelationName();
            if (bl2) {
                bl2 = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string);
            if (string2 == null) continue;
            stringBuffer.append(" ");
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    private final String translateJoinEscapeWhereClause(BaseJoinEscape var1_1, String var2_2) {
        block6: {
            var4_3 = true;
            var5_4 = 0;
            if (var2_2 == null) {
                var7_5 = new StringBuffer("WHERE ");
                var4_3 = true;
            } else {
                var7_5 = new StringBuffer(var2_2);
                var4_3 = false;
            }
            while (var1_1.moveToNextOuterJoin()) {
                var6_7 = new StringBuffer(var1_1.getCurrentSearchCondition());
                var3_6 = var1_1.getCurrentJoinOperator();
                this.insertOuterJoinOperator(var6_7, var3_6);
                if (var4_3) {
                    var4_3 = false;
                } else {
                    var7_5.append(" ) AND ");
                    ++var5_4;
                }
                var7_5.append((Object)var6_7);
            }
            break block6;
lbl23:
            // 1 sources

            while (true) {
                var7_5.insert(6, " (");
                --var5_4;
                break;
            }
        }
        ** while (var5_4 != 0)
lbl29:
        // 1 sources

        return var7_5.toString();
    }

    public String translateTimestampEscape(BaseTimestampEscape baseTimestampEscape) {
        return null;
    }

    public final String unadornTranslateEscape(String string, BaseEscape baseEscape) {
        int n;
        if (baseEscape.getEscapeType() == 6 || baseEscape.getEscapeType() == 7 || baseEscape.getEscapeType() == 8) {
            n = string.indexOf(123) + 1;
        } else {
            n = string.indexOf(baseEscape.getEscapeTypeText());
            n += baseEscape.getEscapeTypeText().length();
        }
        int n2 = string.lastIndexOf(125);
        return string.substring(n, n2);
    }
}

