/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseExceptions;
import com.microsoft.jdbc.base.BaseImplClob;
import com.microsoft.util.UtilDebug;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class BaseClobInputStream
extends InputStream {
    private static String footprint = "$Revision:   1.2  $";
    private long currentPosition;
    private long dataLength;
    private BaseImplClob implClob;
    BaseExceptions exceptions;

    public BaseClobInputStream(BaseImplClob baseImplClob, BaseExceptions baseExceptions) throws SQLException {
        UtilDebug.assert("Must supplay a BaseImplClob derivative", baseImplClob != null);
        UtilDebug.assert("Must supply an exception generator", baseExceptions != null);
        this.currentPosition = 0L;
        this.implClob = baseImplClob;
        this.exceptions = baseExceptions;
        switch (baseImplClob.getCharacterEncoding()) {
            case 1: {
                this.dataLength = baseImplClob.getLength();
                break;
            }
            case 2: {
                this.dataLength = baseImplClob.getLength() * 2L;
                break;
            }
            default: {
                throw baseExceptions.getException(6071);
            }
        }
    }

    public int read() throws IOException {
        byte[] byArray = new byte[2];
        if (this.currentPosition >= this.dataLength) {
            return -1;
        }
        try {
            int n;
            switch (this.implClob.getCharacterEncoding()) {
                case 1: {
                    int n2 = this.implClob.readData(byArray, 0, this.currentPosition + 1L, 1);
                    if (n2 == 0) {
                        n = -1;
                        break;
                    }
                    n = byArray[0] & 0xFF;
                    break;
                }
                case 2: {
                    long l = this.currentPosition / 2L + 1L;
                    int n3 = new Long(this.currentPosition % 2L).intValue();
                    int n4 = this.implClob.readData(byArray, 0, l, 1);
                    if (n4 == 0) {
                        n = -1;
                        break;
                    }
                    n = byArray[n3] & 0xFF;
                    break;
                }
                default: {
                    throw new IOException(this.exceptions.getException(6071).getMessage());
                }
            }
            if (n != -1) {
                ++this.currentPosition;
            }
            return n;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.currentPosition >= this.dataLength) {
            return -1;
        }
        long l = this.dataLength - this.currentPosition;
        if (l < Integer.MAX_VALUE && n2 > (n3 = new Long(l).intValue())) {
            n2 = n3;
        }
        try {
            long l2;
            int n4;
            switch (this.implClob.getCharacterEncoding()) {
                case 1: {
                    n4 = n2;
                    l2 = this.currentPosition + 1L;
                    break;
                }
                case 2: {
                    if (this.currentPosition % 2L != 0L) {
                        throw new IOException(this.exceptions.getException(6072).getMessage());
                    }
                    n4 = n2 / 2;
                    l2 = this.currentPosition / 2L + 1L;
                    break;
                }
                default: {
                    throw new IOException(this.exceptions.getException(6071).getMessage());
                }
            }
            int n5 = this.implClob.readData(byArray, n, l2, n4);
            this.currentPosition += (long)n5;
            return n5;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }
}

