/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource.util;

import com.klg.jclass.datasource.util.ColumnMap;
import com.klg.jclass.datasource.util.SqlStatementColumn;
import com.klg.jclass.datasource.util.SqlStatementTable;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class SqlParser
implements Serializable {
    static final long serialVersionUID = 1389861757357973153L;
    Vector columns = new Vector();
    Vector tables = new Vector();
    Vector joins = new Vector();
    Vector parameterColumns = new Vector();
    String non_join_where = null;
    String[] clauses = new String[]{"", "", "", ""};
    int currentClause = 0;
    int parenCount = 0;
    String[] terminators = new String[]{"from", "where", "group", "having", "union", "intersect", "except", "order"};
    public static final int SELECT = 0;
    public static final int FROM = 1;
    public static final int WHERE = 2;
    public static final int REST = 3;
    private static final boolean TRACE = false;

    public SqlParser(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\t\r )(", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("(")) {
                ++this.parenCount;
            } else if (string2.equals(")")) {
                --this.parenCount;
            } else if (!this.betweenParentheses() && this.isTerminator(string2)) {
                this.nextClause(string2);
            }
            int n = this.currentClause;
            this.clauses[n] = String.valueOf(this.clauses[n]) + string2;
        }
        this.parseSelectClause();
        this.parseFromClause();
        this.parseWhereClause();
    }

    boolean betweenParentheses() {
        return this.parenCount != 0;
    }

    public String getClause(int n) {
        return this.getClause(n, true);
    }

    public String getClause(int n, boolean bl) {
        String string = this.clauses[n].trim();
        if (n != 0 && n != 1 && n != 2 || bl) {
            return string;
        }
        String string2 = new String("");
        if (n == 0) {
            string2 = "select";
        } else if (n == 1) {
            string2 = "from";
        } else if (n == 2) {
            string2 = "where";
        } else {
            System.err.println("assertion failed.");
        }
        String string3 = new String("");
        if (string.toLowerCase().indexOf(string2) > -1) {
            string3 = string.substring(string2.length());
        }
        return string3;
    }

    public Vector getColumns() {
        return this.columns;
    }

    public Vector getColumnsForTable(String string) {
        Vector<SqlStatementColumn> vector = new Vector<SqlStatementColumn>();
        Enumeration enumeration = this.getColumns().elements();
        while (enumeration.hasMoreElements()) {
            SqlStatementColumn sqlStatementColumn = (SqlStatementColumn)enumeration.nextElement();
            if (sqlStatementColumn.getTableName() != null && !sqlStatementColumn.getTableName().equals(string)) continue;
            vector.addElement(sqlStatementColumn);
        }
        return vector;
    }

    public Vector getJoins() {
        return this.joins;
    }

    public String getNonJoinWhereClause() {
        return this.non_join_where;
    }

    public Vector getParameterColumns() {
        return this.parameterColumns;
    }

    public SqlStatementColumn getSqlStatementColumn(String string, String string2) {
        Enumeration enumeration = this.getColumns().elements();
        while (enumeration.hasMoreElements()) {
            SqlStatementColumn sqlStatementColumn = (SqlStatementColumn)enumeration.nextElement();
            SqlStatementTable sqlStatementTable = this.getSqlStatementTable(string);
            if (!sqlStatementColumn.getColumnName().equals(string2) || sqlStatementColumn.getTableName() == null || !sqlStatementColumn.getTableName().equals(string) && !sqlStatementColumn.getTableName().equals(sqlStatementTable.getAlias())) continue;
            return sqlStatementColumn;
        }
        return null;
    }

    public SqlStatementTable getSqlStatementTable(String string) {
        Enumeration enumeration = this.tables.elements();
        while (enumeration.hasMoreElements()) {
            SqlStatementTable sqlStatementTable = (SqlStatementTable)enumeration.nextElement();
            if (!sqlStatementTable.getTableName().equals(string)) continue;
            return sqlStatementTable;
        }
        return null;
    }

    public Vector getTables() {
        return this.tables;
    }

    public static boolean isColumn(String string) {
        boolean bl;
        block3: {
            bl = false;
            try {
                Double d = Double.valueOf(string);
            }
            catch (Exception exception) {
                boolean bl2 = bl = string.indexOf(34) <= -1;
                if (bl) {
                    boolean bl3 = bl = string.indexOf("'") <= -1;
                }
                if (!bl) break block3;
                bl = SqlParser.isParameter(string) ^ true;
            }
        }
        return bl;
    }

    public static boolean isParameter(String string) {
        return string.indexOf("?") > -1;
    }

    boolean isTerminator(String string) {
        string = string.trim().toLowerCase();
        int n = 0;
        while (n < this.terminators.length) {
            if (string.equals(this.terminators[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void nextClause(String string) {
        if (this.currentClause < 3) {
            this.currentClause = !string.trim().toLowerCase().equals("where") && this.currentClause == 1 ? 3 : ++this.currentClause;
        }
    }

    public static SqlStatementColumn parseColumn(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens() && (string5 = stringTokenizer.nextToken()).equalsIgnoreCase("AS")) {
            string5 = null;
            if (stringTokenizer.hasMoreTokens()) {
                string5 = stringTokenizer.nextToken();
                if (string5.startsWith("\"")) {
                    string5 = string5.substring(1);
                }
                if (string5.endsWith("\"")) {
                    string5 = string5.substring(0, string5.length() - 1);
                }
            }
        }
        if (string2.lastIndexOf(".") > -1) {
            string4 = string2.substring(0, string2.lastIndexOf("."));
            string3 = string2.substring(string2.lastIndexOf(".") + 1);
        } else {
            string3 = string2;
        }
        if (!string3.equals("*") && string5 == null) {
            string5 = string3;
        }
        return new SqlStatementColumn(string3, string4, string5);
    }

    void parseFromClause() {
        String string = this.getClause(1, false);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            SqlStatementTable sqlStatementTable = SqlParser.parseTable(stringTokenizer.nextToken());
            if (sqlStatementTable == null) continue;
            this.tables.addElement(sqlStatementTable);
        }
    }

    void parseSelectClause() {
        String string = this.getClause(0, false);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            SqlStatementColumn sqlStatementColumn = SqlParser.parseColumn(stringTokenizer.nextToken());
            if (sqlStatementColumn == null) continue;
            this.columns.addElement(sqlStatementColumn);
        }
    }

    public static SqlStatementTable parseTable(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens() && (string5 = stringTokenizer.nextToken()).equalsIgnoreCase("AS")) {
            string5 = null;
            if (stringTokenizer.hasMoreTokens()) {
                string5 = stringTokenizer.nextToken();
            }
        }
        if (string2.lastIndexOf(".") > -1) {
            string4 = string2.substring(0, string2.lastIndexOf("."));
            string3 = string2.substring(string2.lastIndexOf(".") + 1);
        } else {
            string3 = string2;
        }
        if (string5 == null) {
            string5 = string3;
        }
        return new SqlStatementTable(string3, string4, string5);
    }

    void parseWhereClause() {
        String string = this.getClause(2, false);
        String string2 = new String(string.toUpperCase());
        int n = 0;
        String string3 = new String("");
        String string4 = System.getProperty("line.separator");
        this.non_join_where = new String("");
        while (n < string2.length()) {
            int n2 = string2.indexOf("AND", n);
            if (n2 < 0) {
                string3 = String.valueOf(string3) + string.substring(n);
                n = string2.length();
            } else if (Character.isWhitespace(string2.charAt(n2 - 1)) && (string2.length() == n2 + 3 || Character.isWhitespace(string2.charAt(n2 + 3)))) {
                string3 = string.substring(n, n2);
                n += string3.length() + 3;
            } else {
                string3 = String.valueOf(string3) + string.substring(n, n2 + 3);
                n = n2 + 3;
                continue;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "=");
            if (stringTokenizer.countTokens() == 2) {
                String string5 = stringTokenizer.nextToken().trim();
                String string6 = stringTokenizer.nextToken().trim();
                if (SqlParser.isColumn(string5) && SqlParser.isColumn(string6)) {
                    this.joins.addElement(new ColumnMap(string5, string6));
                } else if (SqlParser.isParameter(string5) || SqlParser.isParameter(string6)) {
                    this.parameterColumns.addElement(SqlParser.isParameter(string5) ? string6 : string5);
                } else {
                    if (this.non_join_where.length() > 0) {
                        this.non_join_where = String.valueOf(this.non_join_where) + string4 + "AND\t";
                    }
                    this.non_join_where = String.valueOf(this.non_join_where) + string3.trim();
                }
                string3 = new String("");
                continue;
            }
            if (this.non_join_where.length() > 0) {
                this.non_join_where = String.valueOf(this.non_join_where) + string4 + "AND\t";
            }
            this.non_join_where = String.valueOf(this.non_join_where) + string3.trim();
        }
    }
}

