/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource.util;

import com.klg.jclass.datasource.BindingModel;
import com.klg.jclass.datasource.DataModel;
import com.klg.jclass.datasource.DataModelEvent;
import com.klg.jclass.datasource.DataModelException;
import com.klg.jclass.datasource.DataModelListener;
import com.klg.jclass.datasource.DataTableModel;
import com.klg.jclass.datasource.MetaDataModel;
import com.klg.jclass.datasource.beans.DataSourceBeanInstance;
import com.klg.jclass.datasource.util.ExceptionManager;
import com.klg.jclass.util.JCEnvironment;
import java.awt.Component;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public abstract class DataBinding
implements DataModelListener,
Serializable {
    protected BindingModel binding;
    protected Component component;
    protected String dataBinding;
    private static int DEBUG = -1;
    private static final boolean TRACE = false;
    private DataTableModel dataTableModel;
    public static final String PATH_DELIMITER = "|";
    public static final String SOURCE_DELIMITER = ":";

    public DataBinding(Component component) {
        this.component = component;
    }

    public DataBinding(Component component, BindingModel bindingModel) {
        this.component = component;
        this.setDataAvailable(bindingModel.isDataAvailable());
        this.setDataBinding(bindingModel);
    }

    public void afterChangeOfRowData(DataModelEvent dataModelEvent) {
        String string = dataModelEvent.getColumn();
        int n = dataModelEvent.getRowIndex();
        if (string == null || string.length() == 0) {
            this.rowDataChanged(n);
        } else {
            this.cellDataChanged(n, string);
        }
    }

    public void afterDeleteRow(DataModelEvent dataModelEvent) {
        this.rowDeleted();
    }

    public void afterInsertRow(DataModelEvent dataModelEvent) {
        this.rowInserted();
    }

    public void afterMoveToCurrentRow(DataModelEvent dataModelEvent) {
        this.checkDataTableChanged(dataModelEvent);
    }

    public void afterRequeryRowAndDetails(DataModelEvent dataModelEvent) {
        this.handleCheckingAfterEvents(dataModelEvent);
    }

    public void afterRequeryTable(DataModelEvent dataModelEvent) {
        this.handleCheckingAfterEvents(dataModelEvent);
    }

    public void afterReset(DataModelEvent dataModelEvent) {
        this.checkDataTableChanged();
    }

    public void beforeCancelAll(DataModelEvent dataModelEvent) {
    }

    public void beforeCancelRowChanges(DataModelEvent dataModelEvent) {
    }

    public void beforeCommitAll(DataModelEvent dataModelEvent) {
        this.handleCancellingBeforeEvents(dataModelEvent);
    }

    public void beforeCommitConditional(DataModelEvent dataModelEvent) {
    }

    public void beforeCommitRow(DataModelEvent dataModelEvent) {
        this.handleCancellingBeforeEvents(dataModelEvent);
    }

    protected abstract boolean beforeCurrentRowChange();

    public void beforeDeleteRow(DataModelEvent dataModelEvent) {
    }

    public void beforeDeleteTable(DataModelEvent dataModelEvent) {
    }

    public void beforeEditCell(DataModelEvent dataModelEvent) {
    }

    public void beforeInsertRow(DataModelEvent dataModelEvent) {
    }

    public void beforeMoveToCurrentRow(DataModelEvent dataModelEvent) {
        this.handleCancellingBeforeEvents(dataModelEvent);
    }

    public void beforeRequery(DataModelEvent dataModelEvent) {
    }

    public void beforeReset(DataModelEvent dataModelEvent) {
    }

    public void beginEvents(DataModelEvent dataModelEvent) {
    }

    protected abstract void cellDataChanged(int var1, String var2);

    protected void checkDataTableChanged() {
        this.checkDataTableChanged(null, -1);
    }

    protected void checkDataTableChanged(DataModelEvent dataModelEvent) {
        this.checkDataTableChanged(dataModelEvent.getTable().getMetaData(), dataModelEvent.getRowIndex());
    }

    private void checkDataTableChanged(MetaDataModel metaDataModel, int n) {
        DataTableModel dataTableModel = null;
        try {
            dataTableModel = this.binding.getCurrentDataTableModel(this);
            if (dataTableModel != this.dataTableModel) {
                this.dataTableModel = dataTableModel;
                this.toggleDataAvailableState();
                this.tableChanged();
            }
            if (this.binding.isDataAvailable()) {
                this.currentRowChanged(this.binding.getCurrentRowIndex());
            }
        }
        catch (DataModelException dataModelException) {
            this.processException(dataModelException);
        }
    }

    protected abstract void currentRowChanged(int var1);

    public void dispose() {
        this.component = null;
        if (this.binding != null) {
            this.binding.removeBindingListener(this);
        }
    }

    public void endEvents(DataModelEvent dataModelEvent) {
        this.handleCheckingAfterEvents(dataModelEvent);
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public BindingModel getBinding() {
        return this.binding;
    }

    public Component getComponent() {
        return this.component;
    }

    public int getCurrentRowIndex() {
        return this.binding == null ? -1 : this.binding.getCurrentRowIndex();
    }

    public String getDataBinding() {
        if (this.binding == null || !this.binding.isDataAvailable()) {
            if (JCEnvironment.isDesignTime()) {
                return this.dataBinding == null ? "" : this.dataBinding;
            }
            return "";
        }
        String string = "";
        MetaDataModel metaDataModel = this.binding.getMetaDataModel();
        while (metaDataModel != null) {
            string = String.valueOf(metaDataModel.getDescription()) + (string.length() == 0 ? "" : PATH_DELIMITER) + string;
            metaDataModel = (MetaDataModel)metaDataModel.getParent();
        }
        string = String.valueOf(this.binding.getDataModel().getModelName()) + SOURCE_DELIMITER + string;
        return string;
    }

    public int getJavaColumnType(String string) {
        return this.binding.getJavaColumnType(string);
    }

    public Object getNativeMetaData() {
        return this.binding.getMetaDataModel().getNativeMetaData();
    }

    public int getNumColumns() {
        return this.binding.getColumnCount();
    }

    public int getNumRows() {
        return this.binding.getRowCount();
    }

    public String getTableColumnLabel(int n) {
        return this.binding.getColumnIdentifier(n);
    }

    protected void handleCancellingBeforeEvents(DataModelEvent dataModelEvent) {
        if (!this.beforeCurrentRowChange() && dataModelEvent.isCancelable()) {
            dataModelEvent.cancelProposedAction();
        }
    }

    protected void handleCheckingAfterEvents(DataModelEvent dataModelEvent) {
        this.checkDataTableChanged();
    }

    public void initialize(DataModelEvent dataModelEvent) {
        this.handleCheckingAfterEvents(dataModelEvent);
    }

    public boolean isColumnEditable(String string) {
        return this.binding.isColumnEditable(string);
    }

    public boolean isDataAvailable() {
        return this.binding == null ? false : this.binding.isDataAvailable();
    }

    protected void moveToBestRowAfterDelete(DataModelEvent dataModelEvent) {
        try {
            this.binding.moveToBestRowAfterDelete(this, dataModelEvent);
        }
        catch (DataModelException dataModelException) {
            this.processException(dataModelException);
        }
    }

    protected boolean moveToRowIndex(int n) {
        try {
            return this.binding.moveToRowIndex(this, n);
        }
        catch (DataModelException dataModelException) {
            return false;
        }
    }

    public void originatorNavigateRow(DataModelEvent dataModelEvent) {
        if (this == dataModelEvent.getOriginator()) {
            this.moveToBestRowAfterDelete(dataModelEvent);
        }
    }

    protected void processException(DataModelException dataModelException) {
        ExceptionManager.getHandler().processException(this.getComponent(), dataModelException);
    }

    protected abstract void rowDataChanged(int var1);

    protected abstract void rowDeleted();

    protected abstract void rowInserted();

    protected abstract void setDataAvailable(boolean var1);

    public void setDataBinding(BindingModel bindingModel) {
        this.setDataBindingInternalBegin(bindingModel);
        this.setDataBindingInternalEnd();
    }

    public void setDataBinding(DataModel dataModel, MetaDataModel metaDataModel) {
        BindingModel bindingModel = null;
        if (dataModel != null) {
            bindingModel = metaDataModel == null ? ((MetaDataModel)dataModel.getMetaDataTree().getRoot()).getBinding() : metaDataModel.getBinding();
        }
        this.setDataBinding(bindingModel);
    }

    public void setDataBinding(DataModel dataModel, String string) {
        if (dataModel == null) {
            return;
        }
        MetaDataModel metaDataModel = (MetaDataModel)dataModel.getMetaDataTree().getRoot();
        StringTokenizer stringTokenizer = new StringTokenizer(string, PATH_DELIMITER);
        if (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            block0: while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                Enumeration<? extends TreeNode> enumeration = metaDataModel.children();
                while (enumeration.hasMoreElements()) {
                    MetaDataModel metaDataModel2 = (MetaDataModel)enumeration.nextElement();
                    if (string2.compareTo(metaDataModel2.getDescription()) != 0) continue;
                    metaDataModel = metaDataModel2;
                    continue block0;
                }
            }
        }
        this.setDataBinding(metaDataModel.getBinding());
    }

    public void setDataBinding(String string) {
        if (JCEnvironment.isDesignTime()) {
            this.dataBinding = string;
        }
        if (string == null || string.length() == 0) {
            return;
        }
        int n = string.indexOf(SOURCE_DELIMITER);
        if (n == -1) {
            System.out.println("Invalid data binding hierarchy: \"" + string + "\"");
            return;
        }
        String string2 = string.substring(0, n);
        DataModel dataModel = null;
        Vector vector = DataSourceBeanInstance.getInstances();
        int n2 = 0;
        while (n2 < vector.size()) {
            dataModel = (DataModel)vector.elementAt(n2);
            if (dataModel != null && dataModel.getModelName() != null && string2.compareTo(dataModel.getModelName()) == 0) break;
            ++n2;
        }
        if (dataModel == null) {
            return;
        }
        this.setDataBinding(dataModel, string.substring(n + 1));
    }

    public void setDataBindingInternalBegin(BindingModel bindingModel) {
        if (this.binding != null) {
            bindingModel.removeBindingListener(this);
        }
        this.binding = bindingModel;
        if (bindingModel == null) {
            return;
        }
        try {
            if (bindingModel.getMetaDataModel().getCommitPolicy() != 1) {
                bindingModel.getMetaDataModel().setShowDeletedRows(false);
            }
        }
        catch (DataModelException dataModelException) {
            this.processException(dataModelException);
        }
    }

    public void setDataBindingInternalEnd() {
        if (this.binding == null) {
            this.toggleDataAvailableState();
            return;
        }
        this.binding.addBindingListener(this);
        this.checkDataTableChanged();
    }

    protected abstract void tableChanged();

    protected void toggleDataAvailableState() {
        this.setDataAvailable(this.binding.isDataAvailable());
    }
}

