/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource.jdbc;

import com.klg.jclass.datasource.DataModelException;
import com.klg.jclass.util.JCDebug;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class DataTableConnection
implements Serializable {
    static final long serialVersionUID = 5569509834849517005L;
    protected transient Connection connection;
    protected boolean autoCommitFlag = true;
    private String url;
    private String login;
    private String password;
    private String driver;
    private Properties properties;

    public DataTableConnection() {
    }

    public DataTableConnection(String string, String string2, String string3, String string4, String string5) throws DataModelException {
        this.loadDriver(string);
        this.connect(string2, string3, string4, string5);
    }

    public void connect(String string, String string2, String string3) throws DataModelException {
        JCDebug.println("Connecting to URL= " + string + " Login= " + string2 + " Password= " + string3);
        try {
            this.connection = DriverManager.getConnection(string, string2, string3);
            this.url = string;
            this.login = string2;
            this.password = string3;
        }
        catch (Exception exception) {
            throw new DataModelException(107, exception);
        }
    }

    public void connect(String string, String string2, String string3, String string4) throws DataModelException {
        if (string4 != null && !string4.equals("")) {
            string = String.valueOf(string) + "/";
            string = String.valueOf(string) + string4;
        }
        this.connect(string, string2, string3);
    }

    public void connect(String string, Properties properties) throws DataModelException {
        try {
            this.connection = DriverManager.getConnection(string, properties);
            this.url = string;
            this.properties = properties;
        }
        catch (Exception exception) {
            throw new DataModelException(107, exception);
        }
    }

    public void disconnect() {
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    public boolean getAutoCommit() throws SQLException {
        return this.autoCommitFlag;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void loadDriver(String string) throws DataModelException {
        try {
            Class.forName(string).newInstance();
            this.driver = string;
        }
        catch (Exception exception) {
            throw new DataModelException(107, exception);
        }
    }

    public void reconnect() throws DataModelException {
        if (this.properties != null) {
            this.connect(this.url, this.properties);
        } else {
            this.connect(this.url, this.login, this.password);
        }
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (this.autoCommitFlag != bl) {
            this.connection.setAutoCommit(bl);
            this.autoCommitFlag = bl;
        }
    }
}

