/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource.customizer;

import com.klg.jclass.beans.PanelEditor;
import com.klg.jclass.datasource.DataModel;
import com.klg.jclass.datasource.LocaleBundle;
import com.klg.jclass.datasource.MetaDataModel;
import com.klg.jclass.datasource.beans.DataSourceBeanInstance;
import com.klg.jclass.datasource.customizer.EditorTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DataBindingEditor
extends PanelEditor
implements TreeSelectionListener {
    protected JTree outliner = null;
    protected boolean topLevelOnly = false;
    protected boolean allowLeafsOnly = false;
    static Dimension ourSize = new Dimension(300, 300);

    public DataBindingEditor() {
        this(false, false);
    }

    public DataBindingEditor(boolean bl, boolean bl2) {
        this.topLevelOnly = bl;
        this.allowLeafsOnly = bl2;
        this.outliner = new JTree(this.getTree());
        this.outliner.addTreeSelectionListener(this);
        this.outliner.setVisible(true);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.outliner), "Center");
    }

    protected void addChildren(MutableTreeNode mutableTreeNode, MetaDataModel metaDataModel) {
        Enumeration<? extends TreeNode> enumeration = metaDataModel.children();
        while (enumeration.hasMoreElements()) {
            this.addMetaDataLevel(mutableTreeNode, (MetaDataModel)enumeration.nextElement(), null);
        }
    }

    private void addMetaDataLevel(MutableTreeNode mutableTreeNode, MetaDataModel metaDataModel, String string) {
        if (metaDataModel == null) {
            return;
        }
        try {
            String string2 = metaDataModel.getDescription();
            if (string2 == null || string2.length() == 0) {
                string2 = "No Description";
            }
            if (string != null) {
                string2 = String.valueOf(string) + ":" + string2;
            }
            EditorTreeNode editorTreeNode = null;
            editorTreeNode = this.hasChildren(metaDataModel) && !this.topLevelOnly ? new EditorTreeNode(string2) : new EditorTreeNode(string2);
            mutableTreeNode.insert(editorTreeNode, mutableTreeNode.getChildCount());
            if (this.hasChildren(metaDataModel) && !this.topLevelOnly) {
                this.addChildren(editorTreeNode, metaDataModel);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getAsText() {
        String string = this.getDataBindingHierarchy();
        if (string == null || string.equals("")) {
            string = new String(LocaleBundle.string("Select a Data Source..."));
        }
        return string;
    }

    protected String getDataBindingHierarchy() {
        String string = "";
        TreePath treePath = this.outliner.getSelectionPath();
        if (treePath == null) {
            return string;
        }
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        if (treeNode == null) {
            return string;
        }
        if (this.allowLeafsOnly && !treeNode.isLeaf()) {
            return string;
        }
        int n = treePath.getPathCount() - 1;
        while (n > 0) {
            String string2 = this.getNextPart(treePath, n);
            string = string.length() == 0 ? string2 : String.valueOf(string2) + "|" + string;
            --n;
        }
        return string;
    }

    public String getJavaInitializationString() {
        return "\"" + this.getDataBindingHierarchy() + "\"";
    }

    protected String getNextPart(TreePath treePath, int n) {
        return (String)((EditorTreeNode)treePath.getPathComponent(n)).getUserObject();
    }

    public Dimension getPreferredSize() {
        return ourSize;
    }

    private MutableTreeNode getTree() {
        Vector vector = DataSourceBeanInstance.getInstances();
        EditorTreeNode editorTreeNode = new EditorTreeNode(LocaleBundle.string("Available Data Sources"));
        int n = 0;
        while (n < vector.size()) {
            TreeModel treeModel;
            DataModel dataModel = (DataModel)vector.elementAt(n);
            if (dataModel != null && (treeModel = dataModel.getMetaDataTree()) != null) {
                MetaDataModel metaDataModel = (MetaDataModel)treeModel.getRoot();
                this.addMetaDataLevel(editorTreeNode, metaDataModel, dataModel.getModelName());
            }
            ++n;
        }
        return editorTreeNode;
    }

    public Object getValue() {
        return this.getDataBindingHierarchy();
    }

    protected boolean hasChildren(MetaDataModel metaDataModel) {
        return metaDataModel.getChildCount() > 0;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        String string = this.getAsText();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = (rectangle.height - fontMetrics.getAscent()) / 2;
        graphics.drawString(string, rectangle.x, rectangle.y + rectangle.height - n);
    }

    private void refreshTree() {
    }

    protected void setDataBindingHierarchy(String string) {
        TreeModel treeModel = this.outliner.getModel();
        EditorTreeNode editorTreeNode = (EditorTreeNode)treeModel.getRoot();
        TreePath treePath = null;
        if (string != null && string.length() > 0) {
            Object[] objectArray;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            Vector<Object> vector = new Vector<Object>(10);
            vector.addElement(this.outliner.getModel().getRoot());
            block0: while (stringTokenizer.hasMoreTokens()) {
                objectArray = stringTokenizer.nextToken();
                int n = 0;
                while (n < editorTreeNode.getChildCount()) {
                    EditorTreeNode editorTreeNode2 = (EditorTreeNode)editorTreeNode.getChildAt(n);
                    if (objectArray.equals(editorTreeNode2.getUserObject())) {
                        editorTreeNode = editorTreeNode2;
                        vector.addElement(editorTreeNode);
                        continue block0;
                    }
                    ++n;
                }
            }
            objectArray = new Object[vector.size()];
            vector.copyInto(objectArray);
            treePath = new TreePath(objectArray);
            this.outliner.expandPath(treePath);
            this.outliner.setSelectionPath(treePath);
        }
    }

    public void setValue(Object object) {
        this.refreshTree();
        this.setDataBindingHierarchy((String)object);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.support.firePropertyChange("dataBinding", null, this.getValue());
    }
}

