/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource.beans;

import com.klg.jclass.datasource.BaseVirtualColumn;
import com.klg.jclass.datasource.ColumnModel;
import com.klg.jclass.datasource.DataModelException;
import com.klg.jclass.datasource.JCVersion;
import com.klg.jclass.datasource.LocaleBundle;
import com.klg.jclass.datasource.beans.JCDataConverter;
import com.klg.jclass.datasource.beans.SerializedProperties;
import com.klg.jclass.datasource.jdbc.DataTableConnection;
import com.klg.jclass.datasource.jdbc.MetaDataCreator;
import com.klg.jclass.util.JCEnvironment;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class NodeProperties
extends SerializedProperties {
    static final long serialVersionUID = 3857956278383656657L;
    public static final int JBUILDER = 0;
    public static final int JDBC = 1;
    public static final int POWERJ = 2;
    public static final int VCAFE = 3;
    public static final int ARRAY = 4;
    public static final int UNBOUND = 5;
    public static final int UNKNOWN = -999;
    public static final int INSERT_ALLOWED_INDEX = 0;
    public static final int UPDATE_ALLOWED_INDEX = 1;
    public static final int DELETE_ALLOWED_INDEX = 2;
    protected String providerName;
    protected Vector unboundColumns = new Vector();
    private int metaID = -1;
    private String modelName;
    private String dataSourceName;
    private transient Object dataSource;
    private String vcFullName;
    private String vcClassName;
    private String description;
    private int type;
    private int commitPolicy = 1;
    private boolean autoCommit = true;
    private Hashtable tableAccess;
    private Vector virtualColumns;
    private boolean showDeletedRows = true;
    private boolean cacheChildren = false;
    private boolean useParentConnection = false;
    private NodeProperties parentComp;
    private Vector joinColumns;
    private Vector parentJoinColumns;
    private String driver;
    private String url;
    private String user;
    private String password;
    private String database;
    private String sqlStatement;
    private boolean expertMode = false;
    private String driverTable;
    private Vector driverTablePrimaryKeys;
    private boolean promptUserForLogin = false;
    private transient DataTableConnection connection;
    private static transient String serializedVersion = new String("");
    private static final String base = "jcdbcomp";
    private static int counter = 0;
    private static final boolean TRACE = false;

    public NodeProperties() {
        this(1, null);
    }

    public NodeProperties(int n, String string) {
        this(n, string, null, null);
    }

    public NodeProperties(int n, String string, String string2, String string3) {
        this.type = n;
        this.dataSourceName = string;
        this.description = string2;
        this.modelName = string3;
        this.init();
    }

    public NodeProperties(String string, Class clazz) throws DataModelException {
        this(string, clazz, null);
    }

    public NodeProperties(String string, Class clazz, Object object) throws DataModelException {
        try {
            if (string != null) {
                NodeProperties nodeProperties = (NodeProperties)SerializedProperties.fromResource(clazz, string);
                nodeProperties.setDataSource(object);
                this.copyProperties(nodeProperties);
            } else {
                this.init();
            }
        }
        catch (Exception exception) {
            throw new DataModelException(107, exception);
        }
    }

    public NodeProperties(String string, Class clazz, String string2) throws DataModelException {
        this(string, clazz, string2, null);
    }

    public NodeProperties(String string, Class clazz, String string2, Object object) throws DataModelException {
        try {
            if (string != null) {
                NodeProperties nodeProperties = (NodeProperties)SerializedProperties.fromResource(clazz, string);
                nodeProperties.setDataSource(object);
                this.copyProperties(nodeProperties);
            } else {
                this.init();
            }
        }
        catch (Exception exception) {
            throw new DataModelException(107, exception);
        }
    }

    public NodeProperties(String string, ClassLoader classLoader) throws DataModelException {
        this(string, classLoader, null);
    }

    public NodeProperties(String string, ClassLoader classLoader, Object object) throws DataModelException {
        try {
            if (string != null) {
                NodeProperties nodeProperties = (NodeProperties)SerializedProperties.fromResource(classLoader, string);
                nodeProperties.setDataSource(object);
                this.copyProperties(nodeProperties);
            } else {
                this.init();
            }
        }
        catch (Exception exception) {
            throw new DataModelException(107, exception);
        }
    }

    public synchronized void addJoin(String string, String string2) {
        this.parentJoinColumns.addElement(string);
        this.joinColumns.addElement(string2);
        this.setChanged();
    }

    public void addUnboundColumn(ColumnModel columnModel) {
        this.unboundColumns.addElement(columnModel);
    }

    public void addVirtualColumn(BaseVirtualColumn baseVirtualColumn) {
        this.virtualColumns.addElement(baseVirtualColumn);
        this.setChanged();
    }

    private boolean baseVirtualColumnsEqual(Enumeration enumeration, Enumeration enumeration2) {
        boolean bl = true;
        while (enumeration.hasMoreElements() && enumeration2.hasMoreElements()) {
            BaseVirtualColumn baseVirtualColumn;
            BaseVirtualColumn baseVirtualColumn2 = (BaseVirtualColumn)enumeration.nextElement();
            if (this.isSameBaseVirtualColumn(baseVirtualColumn2, baseVirtualColumn = (BaseVirtualColumn)enumeration2.nextElement())) continue;
            bl = false;
            break;
        }
        if (bl) {
            bl = (enumeration.hasMoreElements() || enumeration2.hasMoreElements()) ^ true;
        }
        return bl;
    }

    private void copyProperties(NodeProperties nodeProperties) {
        this.type = nodeProperties.getDataSourceType();
        this.dataSource = nodeProperties.getDataSourceName();
        this.dataSourceName = nodeProperties.getDataSourceName();
        this.vcFullName = nodeProperties.getVCFullName();
        this.vcClassName = nodeProperties.getVCClassName();
        this.description = nodeProperties.getDescription();
        this.modelName = nodeProperties.getModelName();
        this.virtualColumns = nodeProperties.getVirtualColumns();
        this.tableAccess = nodeProperties.getTableAccess();
        if (nodeProperties.getJoins() != null) {
            int n = 0;
            while (n < nodeProperties.getJoins().length) {
                this.addJoin(nodeProperties.getJoins()[n][0], nodeProperties.getJoins()[n][1]);
                ++n;
            }
        }
        this.metaID = nodeProperties.getMetaID();
        this.autoCommit = nodeProperties.getAutoCommit();
        this.showDeletedRows = nodeProperties.getShowDeletedRows();
        this.cacheChildren = nodeProperties.getCacheChildren();
        this.useParentConnection = nodeProperties.getUseParentConnection();
        this.parentComp = nodeProperties.getParentNodeProperties();
        this.driver = nodeProperties.getDriver();
        this.url = nodeProperties.getURL();
        this.user = nodeProperties.getUser();
        this.password = nodeProperties.getPassword();
        this.database = nodeProperties.getDatabase();
        this.sqlStatement = nodeProperties.getStatement();
        this.promptUserForLogin = nodeProperties.getPromptUserForLogin();
        this.driverTable = nodeProperties.getDriverTable();
        this.driverTablePrimaryKeys = nodeProperties.getDriverTablePrimaryKeys();
        this.serializationFile = nodeProperties.getSerializationFile();
        this.resourceName = nodeProperties.getResourceName();
        this.providerName = nodeProperties.getProviderName();
    }

    private boolean elementsEqual(Enumeration enumeration, Enumeration enumeration2) {
        boolean bl = true;
        while (enumeration.hasMoreElements() && enumeration2.hasMoreElements()) {
            if (enumeration.nextElement().equals(enumeration2.nextElement())) continue;
            bl = false;
            break;
        }
        if (bl) {
            bl = (enumeration.hasMoreElements() || enumeration2.hasMoreElements()) ^ true;
        }
        return bl;
    }

    public boolean equals(Object object) {
        if (!(object instanceof NodeProperties)) {
            return false;
        }
        NodeProperties nodeProperties = (NodeProperties)object;
        boolean bl = true;
        if (this.tableAccess != null && nodeProperties.tableAccess != null) {
            bl = this.elementsEqual(this.tableAccess.elements(), nodeProperties.tableAccess.elements());
        } else {
            boolean bl2 = bl = this.tableAccess == null && nodeProperties.tableAccess == null;
        }
        if (!bl) {
            return bl;
        }
        if (this.virtualColumns != null && nodeProperties.virtualColumns != null) {
            bl = this.baseVirtualColumnsEqual(this.virtualColumns.elements(), nodeProperties.virtualColumns.elements());
        } else {
            boolean bl3 = bl = this.virtualColumns == null && nodeProperties.virtualColumns == null;
        }
        if (!bl) {
            return bl;
        }
        if (this.joinColumns != null && nodeProperties.joinColumns != null) {
            bl = this.elementsEqual(this.joinColumns.elements(), nodeProperties.joinColumns.elements());
        } else {
            boolean bl4 = bl = this.joinColumns == null && nodeProperties.joinColumns == null;
        }
        if (!bl) {
            return bl;
        }
        if (this.parentJoinColumns != null && nodeProperties.parentJoinColumns != null) {
            bl = this.elementsEqual(this.parentJoinColumns.elements(), nodeProperties.parentJoinColumns.elements());
        } else {
            boolean bl5 = bl = this.parentJoinColumns == null && nodeProperties.parentJoinColumns == null;
        }
        if (!bl) {
            return bl;
        }
        if (this.driverTablePrimaryKeys != null && nodeProperties.driverTablePrimaryKeys != null) {
            bl = this.elementsEqual(this.driverTablePrimaryKeys.elements(), nodeProperties.driverTablePrimaryKeys.elements());
        } else {
            boolean bl6 = bl = this.driverTablePrimaryKeys == null && nodeProperties.driverTablePrimaryKeys == null;
        }
        if (!bl) {
            return bl;
        }
        return this.isSameString(this.dataSourceName, nodeProperties.dataSourceName) && this.isSameString(this.resourceName, nodeProperties.resourceName) && this.isSameString(this.serializationFile, nodeProperties.serializationFile) && this.isSameString(this.description, nodeProperties.description) && this.isSameString(this.modelName, nodeProperties.modelName) && this.type == nodeProperties.type && this.commitPolicy == nodeProperties.commitPolicy && this.autoCommit == nodeProperties.autoCommit && this.useParentConnection == nodeProperties.useParentConnection && (this.parentComp == null && nodeProperties.parentComp == null || this.parentComp != null && nodeProperties.parentComp != null && this.parentComp.equals(nodeProperties.parentComp)) && this.isSameString(this.driver, nodeProperties.driver) && this.isSameString(this.url, nodeProperties.url) && this.isSameString(this.user, nodeProperties.user) && this.isSameString(this.password, nodeProperties.password) && this.isSameString(this.database, nodeProperties.database) && this.isSameString(this.sqlStatement, nodeProperties.sqlStatement) && this.isSameString(this.driverTable, nodeProperties.driverTable) && this.promptUserForLogin == nodeProperties.promptUserForLogin;
    }

    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    public boolean getCacheChildren() {
        return this.cacheChildren;
    }

    public int getCommitPolicy() {
        return this.commitPolicy;
    }

    public DataTableConnection getConnection() throws DataModelException {
        if (this.connection != null) {
            return this.connection;
        }
        if (this.getUseParentConnection()) {
            this.connection = this.getParentNodeProperties().getConnection();
        } else if (JCEnvironment.isDesignTime()) {
            if (this.getURL() != null && this.getURL().trim().length() != 0) {
                this.connection = MetaDataCreator.getJdbcConnection(null, this);
            }
        } else {
            this.connection = new DataTableConnection();
            if (this.getDriver() != null && this.getDriver().trim().length() != 0) {
                this.connection.loadDriver(this.getDriver().trim());
            }
            this.connection.connect(this.getURL(), this.getUser(), this.getPassword(), this.getDatabase());
        }
        return this.connection;
    }

    public Object getDataSource() {
        return this.dataSource;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public int getDataSourceType() {
        return this.type;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getDriverTable() {
        return this.driverTable;
    }

    public Vector getDriverTablePrimaryKeys() {
        return this.driverTablePrimaryKeys;
    }

    public synchronized String[][] getJoins() {
        if (this.joinColumns != null) {
            String[][] stringArray = new String[this.joinColumns.size()][2];
            int n = 0;
            while (n < this.joinColumns.size()) {
                stringArray[n] = new String[]{(String)this.parentJoinColumns.elementAt(n), (String)this.joinColumns.elementAt(n)};
                ++n;
            }
            return stringArray;
        }
        return null;
    }

    public int getMetaID() {
        return this.metaID;
    }

    public String getModelName() {
        return this.modelName;
    }

    public NodeProperties getParentNodeProperties() {
        return this.parentComp;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean getPromptUserForLogin() {
        return this.promptUserForLogin;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public static synchronized String getSerializedVersion() {
        return serializedVersion;
    }

    public boolean getShowDeletedRows() {
        return this.showDeletedRows;
    }

    public String getStatement() {
        return this.sqlStatement;
    }

    public Hashtable getTableAccess() {
        if (this.tableAccess == null) {
            this.tableAccess = new Hashtable();
        }
        return this.tableAccess;
    }

    public String getURL() {
        return this.url;
    }

    public Vector getUnboundColumns() {
        return this.unboundColumns;
    }

    public boolean getUseParentConnection() {
        return this.useParentConnection;
    }

    public String getUser() {
        return this.user;
    }

    public String getVCClassName() {
        return this.vcClassName;
    }

    public String getVCFullName() {
        return this.vcFullName;
    }

    public static String getVersion() {
        return JCVersion.getVersionNumber();
    }

    public BaseVirtualColumn getVirtualColumn(String string) {
        Enumeration enumeration = this.virtualColumns.elements();
        while (enumeration.hasMoreElements()) {
            BaseVirtualColumn baseVirtualColumn = (BaseVirtualColumn)enumeration.nextElement();
            if (!baseVirtualColumn.getColumnName().equals(string)) continue;
            return baseVirtualColumn;
        }
        return null;
    }

    public Vector getVirtualColumns() {
        return this.virtualColumns;
    }

    private void init() {
        this.virtualColumns = new Vector();
        this.tableAccess = new Hashtable();
        this.joinColumns = new Vector();
        this.parentJoinColumns = new Vector();
        this.driverTablePrimaryKeys = new Vector();
        this.setDefaultSerializationFileBase(base);
        this.serializationFile = SerializedProperties.getDefaultSerializationFile(base, counter);
        try {
            String string = this.serializationFile.substring(this.serializationFile.indexOf(base) + base.length());
            string = string.substring(0, string.indexOf(".ser"));
            counter = Integer.parseInt(string);
        }
        catch (Exception exception) {}
    }

    public boolean isExpertMode() {
        return this.expertMode;
    }

    public static boolean isIDEDataSourceType(int n) {
        return n == 0 || n == 3 || n == 2;
    }

    private boolean isSameBaseVirtualColumn(BaseVirtualColumn baseVirtualColumn, BaseVirtualColumn baseVirtualColumn2) {
        boolean bl = true;
        if (baseVirtualColumn.getColumns() != null && baseVirtualColumn2.getColumns() != null) {
            boolean bl2 = bl = baseVirtualColumn.getColumns().length == baseVirtualColumn2.getColumns().length;
            if (bl) {
                int n = 0;
                while (n < baseVirtualColumn.getColumns().length) {
                    if (!this.isSameString(baseVirtualColumn.getColumns()[n], baseVirtualColumn2.getColumns()[n])) {
                        bl = false;
                        break;
                    }
                    ++n;
                }
            }
        } else {
            boolean bl3 = bl = baseVirtualColumn.getColumns() == null && baseVirtualColumn2.getColumns() == null;
        }
        if (!bl) {
            return bl;
        }
        return baseVirtualColumn.getColumnName().equals(baseVirtualColumn2.getColumnName()) && baseVirtualColumn.getOperation() == baseVirtualColumn2.getOperation() && baseVirtualColumn.getColumnType() == baseVirtualColumn2.getColumnType();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        String string = serializedVersion;
        synchronized (string) {
            try {
                serializedVersion = (String)objectInputStream.readObject();
                objectInputStream.defaultReadObject();
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
        }
    }

    public synchronized void removeAllJoins() {
        this.parentJoinColumns.removeAllElements();
        this.joinColumns.removeAllElements();
        this.setChanged();
    }

    public void removeAllVirtualColumns() {
        this.virtualColumns.removeAllElements();
        this.setChanged();
    }

    public synchronized void removeJoin(String string, String string2) {
        int n = 0;
        while (n < this.joinColumns.size()) {
            String string3 = (String)this.parentJoinColumns.elementAt(n);
            String string4 = (String)this.joinColumns.elementAt(n);
            if (string3.equals(string) && string4.equals(string2)) {
                this.parentJoinColumns.removeElement(string);
                this.joinColumns.removeElement(string2);
                break;
            }
            ++n;
        }
        this.setChanged();
    }

    public void removeTableAccess(String string) {
        if (this.tableAccess == null || !this.tableAccess.containsKey(string)) {
            return;
        }
        this.tableAccess.remove(string);
        this.setChanged();
    }

    public void removeUnboundColumn(ColumnModel columnModel) {
        this.unboundColumns.removeElement(columnModel);
    }

    public void removeVirtualColumn(BaseVirtualColumn baseVirtualColumn) {
        this.virtualColumns.removeElement(baseVirtualColumn);
        this.setChanged();
    }

    public void resetConnection() {
        this.connection = null;
        if (JCEnvironment.isDesignTime() && this.getURL() != null && this.getURL().trim().length() != 0) {
            MetaDataCreator.resetJdbcConnection(this);
        }
    }

    public void setAutoCommit(boolean bl) {
        if (this.autoCommit == bl) {
            return;
        }
        this.autoCommit = bl;
        this.setChanged();
    }

    public void setCacheChildren(boolean bl) {
        if (this.cacheChildren == bl) {
            return;
        }
        this.cacheChildren = bl;
        this.setChanged();
    }

    public void setChanged() {
        super.setChanged();
    }

    public void setCommitPolicy(int n) {
        if (this.commitPolicy == n) {
            return;
        }
        JCDataConverter.checkCommitPolicy(n);
        this.commitPolicy = n;
        this.setChanged();
    }

    public void setDataSource(Object object) {
        this.dataSource = object;
        this.setChanged();
    }

    public void setDataSourceName(String string) {
        if (this.isSameString(this.dataSourceName, string)) {
            return;
        }
        this.dataSourceName = string;
        this.setChanged();
    }

    public void setDataSourceType(int n) {
        if (this.type == n) {
            return;
        }
        this.type = n;
        this.setChanged();
    }

    public void setDatabase(String string) throws Exception {
        this.setJDBCInfo(this.driver, this.url, this.user, this.password, string);
    }

    public void setDescription(String string) {
        if (this.isSameString(this.description, string)) {
            return;
        }
        this.description = string;
        this.setChanged();
    }

    public void setDriver(String string) throws Exception {
        this.setJDBCInfo(string, this.url, this.user, this.password, this.database);
    }

    public void setDriverTable(String string) throws Exception {
        if (this.type != 1) {
            throw new Exception(LocaleBundle.string("Cannot set JDBC connection information for non-JDBC type data source."));
        }
        if (this.isSameString(this.driverTable, string)) {
            return;
        }
        this.driverTable = string;
        this.setChanged();
    }

    public void setDriverTablePrimaryKeys(Vector vector) throws Exception {
        if (this.type != 1) {
            throw new Exception(LocaleBundle.string("Cannot set JDBC connection information for non-JDBC type data source."));
        }
        this.driverTablePrimaryKeys = vector;
        this.setChanged();
    }

    public void setExpertMode(boolean bl) {
        if (this.expertMode == bl) {
            return;
        }
        this.expertMode = bl;
        this.setChanged();
    }

    public void setJDBCInfo(String string, String string2, String string3, String string4, String string5) throws Exception {
        if (this.type != 1) {
            throw new Exception(LocaleBundle.string("Cannot set JDBC connection information for non-JDBC type data source."));
        }
        if (this.isSameString(this.driver, string) && this.isSameString(this.url, string2) && this.isSameString(this.user, string3) && this.isSameString(this.password, string4) && this.isSameString(this.database, string5)) {
            return;
        }
        this.driver = string;
        this.url = string2;
        this.user = string3;
        this.password = string4;
        this.database = string5;
        this.connection = null;
        this.setChanged();
    }

    public void setMetaID(int n) {
        if (this.metaID == n) {
            return;
        }
        this.metaID = n;
        this.setChanged();
    }

    public void setModelName(String string) {
        if (this.isSameString(this.modelName, string)) {
            return;
        }
        this.modelName = string;
        this.setChanged();
    }

    public void setParentNodeProperties(NodeProperties nodeProperties) {
        this.parentComp = nodeProperties;
        this.setChanged();
    }

    public void setPassword(String string) throws Exception {
        this.setJDBCInfo(this.driver, this.url, this.user, string, this.database);
    }

    public void setPromptUserForLogin(boolean bl) {
        if (this.promptUserForLogin == bl) {
            return;
        }
        this.promptUserForLogin = bl;
        this.setChanged();
    }

    public void setProviderName(String string) {
        this.providerName = string;
        this.setChanged();
    }

    public void setShowDeletedRows(boolean bl) {
        if (this.showDeletedRows == bl) {
            return;
        }
        this.showDeletedRows = bl;
        this.setChanged();
    }

    public void setStatement(String string) throws Exception {
        if (this.type != 1) {
            throw new Exception(LocaleBundle.string("Cannot set JDBC connection information for non-JDBC type data source."));
        }
        if (this.isSameString(this.sqlStatement, string = NodeProperties.stripWhitespace(string))) {
            return;
        }
        this.sqlStatement = string;
        this.connection = null;
        this.setChanged();
    }

    public void setTableAccess(String string, Boolean[] booleanArray) {
        if (booleanArray.length != 3) {
            throw new IllegalArgumentException();
        }
        if (this.tableAccess == null) {
            this.tableAccess = new Hashtable();
        }
        boolean bl = false;
        if (this.tableAccess.containsKey(string)) {
            Boolean[] booleanArray2 = (Boolean[])this.tableAccess.get(string);
            if (booleanArray2[0].booleanValue() != booleanArray[0].booleanValue() || booleanArray2[1].booleanValue() != booleanArray[1].booleanValue() || booleanArray2[2].booleanValue() != booleanArray[2].booleanValue()) {
                bl = true;
                this.tableAccess.put(string, booleanArray);
            }
        } else {
            bl = true;
            this.tableAccess.put(string, booleanArray);
        }
        if (bl) {
            this.setChanged();
        }
    }

    public void setURL(String string) throws Exception {
        this.setJDBCInfo(this.driver, string, this.user, this.password, this.database);
    }

    public void setUseParentConnection(boolean bl) {
        if (this.useParentConnection == bl) {
            return;
        }
        this.useParentConnection = bl;
        this.connection = null;
        this.setChanged();
    }

    public void setUser(String string) throws Exception {
        this.setJDBCInfo(this.driver, this.url, string, this.password, this.database);
    }

    public void setVCClassName(String string) {
        if (this.isSameString(this.vcClassName, string)) {
            return;
        }
        this.vcClassName = string;
        this.setChanged();
    }

    public void setVCFullName(String string) {
        if (this.isSameString(this.vcFullName, string)) {
            return;
        }
        this.vcFullName = string;
        this.setChanged();
    }

    static String stripWhitespace(String string) {
        if (string == null) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] < ' ') {
                cArray[n] = 32;
            }
            ++n;
        }
        String string2 = new String(cArray);
        if (string2 != null) {
            string2 = string2.trim();
        }
        return string2;
    }

    public String toString() {
        String string = super.toString();
        return string;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(NodeProperties.getVersion());
        try {
            objectOutputStream.defaultWriteObject();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }
}

