/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource;

import com.klg.jclass.datasource.Binding;
import com.klg.jclass.datasource.BindingModel;
import com.klg.jclass.datasource.ColumnModel;
import com.klg.jclass.datasource.DataModel;
import com.klg.jclass.datasource.DataModelAdapter;
import com.klg.jclass.datasource.DataModelEvent;
import com.klg.jclass.datasource.DataModelException;
import com.klg.jclass.datasource.DataModelListener;
import com.klg.jclass.datasource.DataTableModel;
import com.klg.jclass.datasource.MetaDataModel;
import com.klg.jclass.util.JCListenerList;
import java.io.Serializable;
import javax.swing.tree.TreeNode;

public abstract class ReadOnlyBinding
implements BindingModel,
Serializable {
    static final long serialVersionUID = 8241141894499940558L;
    protected MetaDataModel metaDataModel;
    public DataModel dataModel;
    protected Binding parent;
    protected JCListenerList listeners;
    protected String dataBinding;
    private DataModelListener eventAdapter = new DataModelAdapter();

    public ReadOnlyBinding(Binding binding) {
        this(binding.getDataModel());
    }

    public ReadOnlyBinding(DataModel dataModel) {
        this.dataModel = dataModel;
        this.setMetaDataModel((MetaDataModel)dataModel.getMetaDataTree().getRoot());
    }

    public void addBindingListener(DataModelListener dataModelListener) {
        this.listeners = JCListenerList.add(this.listeners, dataModelListener);
    }

    public abstract void addRow(DataModelListener var1) throws DataModelException;

    public abstract void cancelAll(DataModelListener var1) throws DataModelException;

    public abstract void cancelCurrentRowChanges(DataModelListener var1) throws DataModelException;

    public abstract void cancelRowChanges(DataModelListener var1, int var2) throws DataModelException;

    public abstract void commitAll(DataModelListener var1) throws DataModelException;

    public abstract void commitCurrentRow(DataModelListener var1) throws DataModelException;

    public abstract void commitRow(DataModelListener var1, int var2) throws DataModelException;

    public abstract void deleteCurrentRow(DataModelListener var1) throws DataModelException;

    public abstract void deleteRow(DataModelListener var1, int var2) throws DataModelException;

    public abstract void deleteRows(DataModelListener var1, int var2, int var3) throws DataModelException;

    public Object getCell(DataModelListener dataModelListener, int n, int n2) throws DataModelException {
        DataTableModel dataTableModel = this.getCurrentDataTableModel(dataModelListener);
        return dataTableModel.getResultData(dataTableModel.getRowIdentifier(n), this.metaDataModel.getColumnIdentifier(n2));
    }

    public Object getCell(DataModelListener dataModelListener, int n, String string) throws DataModelException {
        return this.getCell(dataModelListener, n, this.getColumnIndex(string));
    }

    public int getColumnCount() {
        int n = 0;
        try {
            n = this.metaDataModel.getColumnCount();
        }
        catch (DataModelException dataModelException) {}
        return n;
    }

    public String getColumnIdentifier(int n) {
        String string = "";
        try {
            string = this.metaDataModel.getColumnIdentifier(n);
        }
        catch (DataModelException dataModelException) {}
        return string;
    }

    public int getColumnIndex(String string) {
        try {
            return this.metaDataModel.getColumnIndex(string);
        }
        catch (DataModelException dataModelException) {
            return -1;
        }
    }

    public ColumnModel getColumnObject(String string) {
        ColumnModel columnModel = null;
        try {
            columnModel = this.metaDataModel.getColumnObject(string);
        }
        catch (DataModelException dataModelException) {}
        return columnModel;
    }

    public Object getCurrentCell(DataModelListener dataModelListener, String string) throws DataModelException {
        Object object = this.dataModel.getCurrentDataItem(dataModelListener, this.metaDataModel, string);
        return object;
    }

    public DataTableModel getCurrentDataTableModel(DataModelListener dataModelListener) throws DataModelException {
        return this.dataModel.getCurrentDataTable(dataModelListener, this.metaDataModel);
    }

    public int getCurrentRowIndex() {
        int n = -1;
        long l = this.metaDataModel.getCurrentBookmark();
        try {
            DataTableModel dataTableModel = this.getCurrentDataTableModel(new DataModelAdapter());
            n = dataTableModel != null ? dataTableModel.getRowIndex(l) : -1;
        }
        catch (DataModelException dataModelException) {}
        return n;
    }

    public abstract int getCurrentRowStatus() throws DataModelException;

    public DataModel getDataModel() {
        return this.dataModel;
    }

    public String getDescription() {
        return this.metaDataModel.getDescription();
    }

    public int getJavaColumnType(int n) {
        return this.getJavaColumnType(this.getColumnIdentifier(n));
    }

    public int getJavaColumnType(String string) {
        int n = -1;
        try {
            n = this.metaDataModel.getJavaColumnType(string);
        }
        catch (DataModelException dataModelException) {}
        return n;
    }

    public Object getListeners() {
        return this.listeners;
    }

    public MetaDataModel getMetaDataModel() {
        return this.metaDataModel;
    }

    public Binding getParent() {
        return this.parent;
    }

    public int getRowCount() {
        int n = 0;
        try {
            n = this.getCurrentDataTableModel(new DataModelAdapter()).getRowCount();
        }
        catch (DataModelException dataModelException) {}
        return n;
    }

    public abstract int getRowStatus(int var1) throws DataModelException;

    public abstract boolean isColumnEditable(int var1);

    public abstract boolean isColumnEditable(String var1);

    public abstract boolean isCurrentRowModified() throws DataModelException;

    public boolean isDataAvailable() {
        boolean bl = false;
        try {
            DataTableModel dataTableModel = this.getCurrentDataTableModel(this.eventAdapter);
            long l = this.metaDataModel.getCurrentBookmark();
            bl = dataTableModel != null && l != -1L && dataTableModel.getRowStatus(l) != 5 && dataTableModel.getRowStatus(l) != 3;
        }
        catch (DataModelException dataModelException) {}
        return bl;
    }

    public boolean isDescendantOf(MetaDataModel metaDataModel) {
        TreeNode treeNode = this.metaDataModel;
        while (treeNode != null) {
            if (treeNode.getParent() == metaDataModel) {
                return true;
            }
            treeNode = treeNode.getParent();
        }
        return false;
    }

    public boolean isOurData(DataModelEvent dataModelEvent) {
        DataTableModel dataTableModel = dataModelEvent.getTable();
        return dataTableModel != null && dataTableModel.getMetaData() == this.metaDataModel;
    }

    public boolean isOutDataOrOurAncestors(DataModelEvent dataModelEvent) {
        return this.isOurData(dataModelEvent) || this.isDescendantOf(dataModelEvent.getTable().getMetaData());
    }

    public abstract boolean isRowModified(int var1) throws DataModelException;

    public abstract void moveToBestRowAfterDelete(DataModelListener var1, DataModelEvent var2) throws DataModelException;

    public boolean moveToRowIndex(DataModelListener dataModelListener, int n) throws DataModelException {
        DataTableModel dataTableModel = this.getCurrentDataTableModel(dataModelListener);
        long l = dataTableModel.getRowIdentifier(n);
        return this.dataModel.moveToRow(dataModelListener, dataTableModel, l);
    }

    public void removeBindingListener(DataModelListener dataModelListener) {
        this.listeners = JCListenerList.remove(this.listeners, dataModelListener);
    }

    public void requeryAll(DataModelListener dataModelListener) throws DataModelException {
        this.dataModel.requeryAll(dataModelListener);
    }

    public void requeryCurrentRow(DataModelListener dataModelListener) throws DataModelException {
        this.requeryRow(dataModelListener, this.getCurrentRowIndex());
    }

    public void requeryCurrentRowAndDetails(DataModelListener dataModelListener) throws DataModelException {
        this.requeryRowAndDetails(dataModelListener, this.getCurrentRowIndex());
    }

    public void requeryLevel(DataModelListener dataModelListener) throws DataModelException {
        DataTableModel dataTableModel = this.getCurrentDataTableModel(dataModelListener);
        if (dataTableModel == null) {
            this.dataModel.requeryAll(dataModelListener);
        } else {
            long l = dataTableModel.getParentBookmark();
            if (l == -1L) {
                this.dataModel.requeryAll(dataModelListener);
            } else {
                MetaDataModel metaDataModel = (MetaDataModel)this.metaDataModel.getParent();
                DataTableModel dataTableModel2 = this.getCurrentDataTableModel(dataModelListener);
                dataTableModel2.requeryRowAndDetails(dataModelListener, l);
            }
        }
    }

    public void requeryRow(DataModelListener dataModelListener, int n) throws DataModelException {
        DataTableModel dataTableModel = this.getCurrentDataTableModel(dataModelListener);
        dataTableModel.requeryRow(dataModelListener, dataTableModel.getRowIdentifier(n));
    }

    public void requeryRowAndDetails(DataModelListener dataModelListener, int n) throws DataModelException {
        DataTableModel dataTableModel = this.getCurrentDataTableModel(dataModelListener);
        dataTableModel.requeryRowAndDetails(dataModelListener, dataTableModel.getRowIdentifier(n));
    }

    public abstract void setCell(DataModelListener var1, int var2, int var3, Object var4) throws DataModelException;

    public abstract void setCurrentCell(DataModelListener var1, String var2, Object var3) throws DataModelException;

    public void setDataModel(DataModel dataModel) {
        this.dataModel = dataModel;
    }

    public void setDescription(String string) {
        this.metaDataModel.setDescription(string);
    }

    public void setMetaDataModel(MetaDataModel metaDataModel) {
        this.metaDataModel = metaDataModel;
    }
}

