/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource;

import com.klg.jclass.datasource.BaseDataTable;
import com.klg.jclass.datasource.Binding;
import com.klg.jclass.datasource.BindingModel;
import com.klg.jclass.datasource.ColumnModel;
import com.klg.jclass.datasource.DataModel;
import com.klg.jclass.datasource.DataModelException;
import com.klg.jclass.datasource.DataSourceTreeModel;
import com.klg.jclass.datasource.DataSourceTreeNode;
import com.klg.jclass.datasource.DataTableModel;
import com.klg.jclass.datasource.LocaleBundle;
import com.klg.jclass.datasource.MetaDataModel;
import com.klg.jclass.datasource.ProviderModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class BaseMetaData
extends DataSourceTreeNode
implements MetaDataModel {
    static final long serialVersionUID = -5410672693378221172L;
    protected DataModel dataModel;
    protected String description = "";
    protected Hashtable insertPermissions;
    protected Hashtable updatePermissions;
    protected Hashtable deletePermissions;
    protected Hashtable idxToColumnMap;
    protected Vector columns = new Vector();
    protected int commitPolicy = 1;
    protected Class storeClass = null;
    protected int initialHashtableSize = 5;
    protected int metaDataID;
    protected static int counter = 0;
    protected int maxRows = 0;
    protected boolean cacheChildren = false;
    protected boolean showDeletedRows = true;
    protected transient DataTableModel currentDataTable;
    protected long currentBookmark = -1L;
    protected int bufferSize = 5000;
    protected BindingModel binding;
    protected ProviderModel provider;

    public BaseMetaData(DataModel dataModel) {
        this.dataModel = dataModel;
        this.metaDataID = counter++;
        this.insertPermissions = new Hashtable(this.initialHashtableSize);
        this.updatePermissions = new Hashtable(this.initialHashtableSize);
        this.deletePermissions = new Hashtable(this.initialHashtableSize);
        this.idxToColumnMap = new Hashtable(this.initialHashtableSize);
    }

    public void addColumn(ColumnModel columnModel) throws DataModelException {
        Enumeration enumeration = this.columns.elements();
        while (enumeration.hasMoreElements()) {
            ColumnModel columnModel2 = (ColumnModel)enumeration.nextElement();
            if (columnModel2.getIdentifier() == null || !columnModel2.getIdentifier().equals(columnModel.getIdentifier())) continue;
            String string = String.valueOf(LocaleBundle.string("Duplicate columns not allowed. Use aliasing. Column: ")) + columnModel2.getIdentifier();
            throw new DataModelException(107, new Exception(string));
        }
        this.columns.addElement(columnModel);
        this.getColumnMap().put(columnModel.getIdentifier(), new Integer(this.columns.size() - 1));
    }

    public void clear() {
        this.idxToColumnMap.clear();
        this.columns.removeAllElements();
        this.setCurrentBookmark(-1L);
    }

    public void commitTransaction() throws DataModelException {
    }

    public byte[] createByteArrayFromBinaryStream(InputStream inputStream) throws DataModelException {
        if (inputStream == null) {
            return null;
        }
        byte[] byArray = new byte[this.getBufferSize()];
        byte[] byArray2 = new byte[this.getBufferSize()];
        int n = 0;
        int n2 = 0;
        try {
            if (inputStream.markSupported()) {
                inputStream.reset();
            }
            while ((n2 = inputStream.read(byArray)) > 0) {
                byte[] byArray3 = byArray2;
                byArray2 = new byte[n + n2];
                System.arraycopy(byArray3, 0, byArray2, 0, n);
                System.arraycopy(byArray, 0, byArray2, n, n2);
                n += n2;
            }
        }
        catch (IOException iOException) {
            throw new DataModelException(107, iOException);
        }
        return byArray2;
    }

    public boolean getAutoCommit() throws DataModelException {
        return true;
    }

    public BindingModel getBinding() {
        if (this.binding == null) {
            this.binding = new Binding(this.dataModel);
            this.binding.setMetaDataModel(this);
        }
        return this.binding;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public boolean getCacheChildren() {
        return this.cacheChildren;
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public String getColumnIdentifier(int n) throws DataModelException {
        return ((ColumnModel)this.columns.elementAt(n)).getIdentifier();
    }

    public int getColumnIndex(String string) throws DataModelException {
        if (!this.getColumnMap().containsKey(string)) {
            Exception exception = new Exception(String.valueOf(LocaleBundle.string("Column not found: ")) + string);
            throw new DataModelException(107, exception);
        }
        return (Integer)this.idxToColumnMap.get(string);
    }

    public Hashtable getColumnMap() {
        return this.idxToColumnMap;
    }

    public ColumnModel getColumnObject(String string) throws DataModelException {
        return (ColumnModel)this.getColumnObjects().elementAt(this.getColumnIndex(string));
    }

    public Vector getColumnObjects() {
        return this.columns;
    }

    public int getCommitPolicy() {
        return this.commitPolicy;
    }

    public long getCurrentBookmark() {
        try {
            DataTableModel dataTableModel;
            if (this.currentBookmark == -1L && (dataTableModel = this.getCurrentDataTable()) != null && dataTableModel.getRowCount() > 0) {
                dataTableModel.first();
                this.setCurrentBookmark(dataTableModel.getCurrentBookmark());
            }
        }
        catch (DataModelException dataModelException) {
            dataModelException.printStackTrace();
        }
        return this.currentBookmark;
    }

    public DataTableModel getCurrentDataTable() {
        return this.currentDataTable;
    }

    public DataModel getDataModel() {
        return this.dataModel;
    }

    public boolean getDeleteAllowed(String string) {
        if (string == null) {
            return true;
        }
        return this.deletePermissions.get(string) != null ? (Boolean)this.deletePermissions.get(string) : true;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getInsertAllowed(String string) {
        if (string == null) {
            return true;
        }
        return this.insertPermissions.get(string) != null ? (Boolean)this.insertPermissions.get(string) : true;
    }

    public int getJavaColumnType(String string) throws DataModelException {
        return this.getColumnObject(string).getMetaColumnType();
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public int getMetaID() {
        return this.metaDataID;
    }

    public Object getNativeMetaData() {
        return null;
    }

    public ProviderModel getProvider() {
        return this.provider;
    }

    public boolean getShowDeletedRows() {
        return this.showDeletedRows;
    }

    public Class getStoreClass() throws DataModelException {
        if (this.storeClass == null) {
            this.setStoreClass("com.klg.jclass.datasource.Store");
        }
        return this.storeClass;
    }

    public boolean getUpdateAllowed(String string) {
        if (string == null) {
            return true;
        }
        return this.updatePermissions.get(string) != null ? (Boolean)this.updatePermissions.get(string) : true;
    }

    public boolean isUpdateAllowedOnColumn(String string) throws DataModelException {
        ColumnModel columnModel = this.getColumnObject(string);
        if (columnModel == null || columnModel.getTableName() == null || columnModel.getTableName().equals("")) {
            return true;
        }
        return this.getUpdateAllowed(columnModel.getTableName());
    }

    public void rollbackTransaction() throws DataModelException {
    }

    public void setAutoCommit(boolean bl) throws DataModelException {
    }

    public void setBinding(BindingModel bindingModel) {
        this.binding = bindingModel;
    }

    public void setBufferSize(int n) {
        this.bufferSize = n;
    }

    public void setCacheChildren(boolean bl) {
        this.cacheChildren = bl;
    }

    public void setCommitPolicy(int n) throws DataModelException {
        if (!this.getShowDeletedRows() && n == 1) {
            Exception exception = new Exception(LocaleBundle.string("setShowDeletedRows cannot be false if commit policy is COMMIT_LEAVING_RECORD"));
            throw new DataModelException(107, exception);
        }
        this.commitPolicy = n;
    }

    public void setCurrentBookmark(long l) {
        this.currentBookmark = l;
    }

    public void setCurrentDataTable(DataTableModel dataTableModel) {
        this.currentDataTable = dataTableModel;
    }

    public void setDeleteAllowed(String string, boolean bl) {
        if (this.deletePermissions.containsKey(string)) {
            this.deletePermissions.remove(string);
        }
        this.deletePermissions.put(string, new Boolean(bl));
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setInsertAllowed(String string, boolean bl) {
        if (this.insertPermissions.containsKey(string)) {
            this.insertPermissions.remove(string);
        }
        this.insertPermissions.put(string, new Boolean(bl));
    }

    public void setMaxRows(int n) {
        this.maxRows = n;
    }

    public void setMetaID(int n) {
        this.metaDataID = n;
        counter = n + 1;
    }

    public void setProviderClassName(String string) throws DataModelException {
        if (string != null && !string.equals("")) {
            ReflectiveOperationException reflectiveOperationException = null;
            try {
                this.provider = (ProviderModel)Class.forName(string).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                reflectiveOperationException = classNotFoundException;
            }
            catch (IllegalAccessException illegalAccessException) {
                reflectiveOperationException = illegalAccessException;
            }
            catch (InstantiationException instantiationException) {
                reflectiveOperationException = instantiationException;
            }
            if (reflectiveOperationException != null) {
                throw new DataModelException(107, reflectiveOperationException);
            }
            if (this.getParent() == null) {
                Object[][] objectArray = this.provider.getData(null, -1L, this);
                DataTableModel dataTableModel = BaseDataTable.createDataTableModelFromProviderData(this, -1L, objectArray);
                ((DataSourceTreeModel)this.dataModel.getDataTableTree()).setRoot((TreeNode)((Object)dataTableModel));
            }
        }
    }

    public void setShowDeletedRows(boolean bl) throws DataModelException {
        if (!bl && this.getCommitPolicy() == 1) {
            Exception exception = new Exception(LocaleBundle.string("setShowDeletedRows cannot be false if commit policy is COMMIT_LEAVING_RECORD"));
            throw new DataModelException(107, exception);
        }
        this.showDeletedRows = bl;
    }

    public void setStoreClass(String string) throws DataModelException {
        try {
            this.storeClass = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DataModelException(107, classNotFoundException);
        }
    }

    public void setUpdateAllowed(String string, boolean bl) {
        if (this.updatePermissions.containsKey(string)) {
            this.updatePermissions.remove(string);
        }
        this.updatePermissions.put(string, new Boolean(bl));
    }
}

