/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource;

import com.klg.jclass.datasource.ColumnModel;
import com.klg.jclass.datasource.DataModelEvent;
import com.klg.jclass.datasource.DataModelException;
import com.klg.jclass.datasource.DataModelListener;
import com.klg.jclass.datasource.DataSourceTreeNode;
import com.klg.jclass.datasource.DataTableAbstractionLayer;
import com.klg.jclass.datasource.DataTableModel;
import com.klg.jclass.datasource.LocaleBundle;
import com.klg.jclass.datasource.MetaDataModel;
import com.klg.jclass.datasource.ProviderModel;
import com.klg.jclass.datasource.StoreModel;
import com.klg.jclass.datasource.VirtualColumnModel;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class BaseDataTable
extends DataSourceTreeNode
implements DataTableModel,
DataTableAbstractionLayer {
    static final long serialVersionUID = 3364765541867247105L;
    protected MetaDataModel metaData;
    protected long parentRow;
    protected StoreModel store;
    protected int initialHashtableSize = 5;
    protected Hashtable updatedRows;
    protected Hashtable insertedRows;
    protected Hashtable rowIndexBeforeEvent;
    protected Hashtable[] rowCaches;
    protected int cursor = -1;
    protected Hashtable logicallyDeletedRows = new Hashtable(this.initialHashtableSize);
    protected Hashtable userData = null;
    protected Hashtable internalData = null;
    protected Vector eventQueue;
    protected static long bookmark = 1L;
    protected String currentColumn;

    private BaseDataTable() {
        this.updatedRows = new Hashtable(this.initialHashtableSize);
        this.insertedRows = new Hashtable(this.initialHashtableSize);
        this.rowCaches = new Hashtable[]{this.logicallyDeletedRows, this.updatedRows, this.insertedRows};
        this.eventQueue = new Vector();
        this.rowIndexBeforeEvent = new Hashtable(this.initialHashtableSize);
    }

    public BaseDataTable(MetaDataModel metaDataModel) {
        this();
        this.metaData = metaDataModel;
        this.parentRow = -1L;
        this.createStore();
    }

    public BaseDataTable(MetaDataModel metaDataModel, long l) {
        this();
        this.metaData = metaDataModel;
        this.parentRow = l;
        this.createStore();
    }

    public void absolute(int n) throws DataModelException {
        if (n <= 0 || n > this.store.getRowCount()) {
            Exception exception = new Exception(String.valueOf(LocaleBundle.string("Absolute move failed. Ordinal out of bounds. ")) + n);
            throw new DataModelException(107, exception);
        }
        this.cursor = n - 1;
    }

    public long addInternalRow(Object object) {
        long l = this.getNextBookmark();
        this.store.addRow(l, object);
        return l;
    }

    public long addInternalRow(Object object, int n) {
        long l = this.getNextBookmark();
        this.store.addRow(l, object, n);
        return l;
    }

    public long addRow(DataModelListener dataModelListener) throws DataModelException {
        Object object = this.createNewRow();
        return this.addRow(dataModelListener, object);
    }

    public long addRow(DataModelListener dataModelListener, Object object) throws DataModelException {
        return this.addRow(dataModelListener, object, 2);
    }

    public long addRow(DataModelListener dataModelListener, Object object, int n) throws DataModelException {
        return this.addRow(dataModelListener, object, n, -1);
    }

    public long addRow(DataModelListener dataModelListener, Object object, int n, int n2) throws DataModelException {
        if (!this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, -2L, "", 1))) {
            return -1L;
        }
        Object[] objectArray = (Object[])object;
        long l = n2 < 0 ? this.addInternalRow(objectArray) : this.addInternalRow(objectArray, n2);
        switch (n) {
            case 2: {
                this.insertedRows.put(new Long(l), objectArray);
                break;
            }
            case 3: {
                this.logicallyDeletedRows.put(new Long(l), objectArray);
                break;
            }
        }
        this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 101));
        return l;
    }

    public void afterLast() {
        this.cursor = this.store.getRowCount();
    }

    public void beforeFirst() {
        this.cursor = -1;
    }

    public void cancelAllRowChanges(DataModelListener dataModelListener) throws DataModelException {
        Object object;
        Object object2;
        int n = 0;
        while (n < this.rowCaches.length) {
            object2 = (Hashtable)this.rowCaches[n].clone();
            object = ((Hashtable)object2).keys();
            while (object.hasMoreElements()) {
                this.cancelRowChanges(dataModelListener, (Long)object.nextElement());
            }
            ++n;
        }
        object2 = this.children();
        while (object2.hasMoreElements()) {
            object = (DataTableModel)object2.nextElement();
            object.cancelAllRowChanges(dataModelListener);
        }
    }

    public void cancelChanges(DataModelListener dataModelListener, long l) throws DataModelException {
        switch (this.getRowStatus(l)) {
            case 1: {
                this.restoreRow(l);
                this.removeRowFromUpdatedTable(l);
                this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 100));
                break;
            }
            case 3: {
                if (!this.metaData.getShowDeletedRows()) {
                    Object v = this.logicallyDeletedRows.get(new Long(l));
                    long l2 = this.addInternalRow(v);
                    this.removeRowFromLogicallyDeletedTable(l);
                    this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l2, "", 101));
                    break;
                }
                this.removeRowFromLogicallyDeletedTable(l);
                this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 100));
                break;
            }
            case 2: {
                Long l3 = new Long(l);
                this.rowIndexBeforeEvent.put(l3, new Integer(this.store.getIndex(l)));
                this.removeInsertedRow(l);
                this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 102));
                this.fireOriginatorDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 108));
                this.rowIndexBeforeEvent.remove(l3);
                break;
            }
            default: {
                this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 100));
            }
        }
    }

    public void cancelRowChanges(DataModelListener dataModelListener, long l) throws DataModelException {
        if (!this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 8))) {
            return;
        }
        this.cancelChanges(dataModelListener, l);
    }

    public void clearEventQueue() {
        this.eventQueue.removeAllElements();
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            ((DataTableModel)((Object)enumeration.nextElement())).clearEventQueue();
        }
    }

    public Object cloneRow(long l) throws DataModelException {
        Object[] objectArray = (Object[])this.getRowFromCache(l);
        return objectArray.clone();
    }

    public boolean columnModified(long l, String string) throws DataModelException {
        int n = this.metaData.getColumnIndex(string);
        Object[] objectArray = (Object[])this.getOriginalRow(l);
        if (objectArray == null) {
            return false;
        }
        Object object = this.getResultData(l, string);
        Object object2 = objectArray[n];
        return this.hasValueChanged(object, object2);
    }

    public void commitAll(DataModelListener dataModelListener) throws DataModelException {
        this.commitThisLevel(dataModelListener);
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            DataTableModel dataTableModel = (DataTableModel)((Object)enumeration.nextElement());
            dataTableModel.commitAll(dataModelListener);
        }
    }

    public boolean commitRow(DataModelListener dataModelListener, long l) throws DataModelException {
        if (!this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 10))) {
            return false;
        }
        if (this.getRowStatus(l) == 4 || this.getRowStatus(l) == 5) {
            return true;
        }
        this.commitRow2(dataModelListener, l);
        this.commitTransactionAndProcessEvent(dataModelListener, l);
        return true;
    }

    private void commitRow2(DataModelListener dataModelListener, long l) throws DataModelException {
        if (this.getRowStatus(l) == 4) {
            return;
        }
        try {
            this.saveRow(l);
        }
        catch (DataModelException dataModelException) {
            int n = this.getRowStatus(l) == 3 ? 102 : 100;
            throw new DataModelException(l, "", this, n, dataModelException);
        }
        if (!this.metaData.getAutoCommit()) {
            this.eventQueue.addElement(new Long(l));
        } else {
            this.processRowEvent(dataModelListener, l);
        }
    }

    public void commitSubTree(DataModelListener dataModelListener, long l) throws DataModelException {
        this.commitRow(dataModelListener, l);
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            DataTableModel dataTableModel = (DataTableModel)((Object)enumeration.nextElement());
            dataTableModel.commitAll(dataModelListener);
        }
    }

    private void commitThisLevel(DataModelListener dataModelListener) throws DataModelException {
        int n = 0;
        while (n < this.rowCaches.length) {
            Hashtable hashtable = (Hashtable)this.rowCaches[n].clone();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                long l = (Long)enumeration.nextElement();
                if (this.metaData.getAutoCommit()) {
                    this.commitRow(dataModelListener, l);
                    continue;
                }
                this.commitRow2(dataModelListener, l);
            }
            ++n;
        }
    }

    private void commitTransactionAndProcessEvent(DataModelListener dataModelListener, long l) throws DataModelException {
        try {
            this.metaData.commitTransaction();
        }
        catch (DataModelException dataModelException) {
            int n = this.getRowStatus(l) == 102 ? 102 : 100;
            throw new DataModelException(l, "", this, n, dataModelException);
        }
        this.processRowEvent(dataModelListener, l);
    }

    public void conditionallyCommitYourselfAndChildren(DataModelListener dataModelListener) throws DataModelException {
        if (this.metaData.getCommitPolicy() != 3) {
            this.commitThisLevel(dataModelListener);
        }
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            DataTableModel dataTableModel = (DataTableModel)((Object)enumeration.nextElement());
            dataTableModel.conditionallyCommitYourselfAndChildren(dataModelListener);
        }
    }

    public static DataTableModel createDataTableModelFromProviderData(MetaDataModel metaDataModel, long l, Object[][] objectArray) {
        BaseDataTable baseDataTable = metaDataModel.getParent() == null ? new BaseDataTable(metaDataModel) : new BaseDataTable(metaDataModel, l);
        int n = 0;
        while (n < objectArray.length) {
            baseDataTable.addInternalRow(objectArray[n]);
            ++n;
        }
        return baseDataTable;
    }

    public Object createNewRow() throws DataModelException {
        int n = this.metaData.getColumnCount();
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = null;
            ++n2;
        }
        return objectArray;
    }

    private void createStore() {
        try {
            this.store = (StoreModel)this.metaData.getStoreClass().newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (DataModelException dataModelException) {
            dataModelException.printStackTrace();
        }
    }

    public DataTableModel createTable(DataModelListener dataModelListener, long l, TreeNode treeNode) throws DataModelException {
        DataTableModel dataTableModel = this.getTable(l, treeNode);
        if (dataTableModel == null) {
            ProviderModel providerModel = this.metaData.getProvider();
            if (providerModel != null) {
                Object[][] objectArray = providerModel.getData(dataModelListener, l, (MetaDataModel)treeNode);
                dataTableModel = BaseDataTable.createDataTableModelFromProviderData((MetaDataModel)treeNode, l, objectArray);
            } else if (l != -1L) {
                dataTableModel = this.materializeTable(dataModelListener, l, treeNode);
            }
            if (dataTableModel != null) {
                this.add((DataSourceTreeNode)((Object)dataTableModel));
            }
        }
        return dataTableModel;
    }

    public void deleteCacheChildren(DataModelListener dataModelListener) throws DataModelException {
        BaseDataTable baseDataTable;
        if (this.recursivelyDeleteChildren(this, dataModelListener)) {
            this.removeAllChildren();
        }
        if ((baseDataTable = (BaseDataTable)this.getParent()) != null && this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, -2L, "", 12))) {
            baseDataTable.remove(this);
        }
    }

    public void deleteRow(DataModelListener dataModelListener, long l) throws DataModelException {
        if (!this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 5))) {
            return;
        }
        int n = this.getRowStatus(l);
        if (n != 4) {
            this.cancelChanges(dataModelListener, l);
            if (n == 2) {
                return;
            }
        }
        this.logicallyDeletedRows.put(new Long(l), this.getRowFromCache(l));
        if (this.metaData.getCommitPolicy() == 1) {
            try {
                this.commitRow2(dataModelListener, l);
                this.commitTransactionAndProcessEvent(dataModelListener, l);
            }
            catch (DataModelException dataModelException) {
                this.removeRowFromLogicallyDeletedTable(l);
                throw dataModelException;
            }
        } else if (this.metaData.getShowDeletedRows()) {
            this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 100));
        } else {
            Long l2 = new Long(l);
            this.rowIndexBeforeEvent.put(l2, new Integer(this.store.getIndex(l)));
            this.removeRowFromOriginalRowTable(l);
            this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 102));
            this.fireOriginatorDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 108));
            this.rowIndexBeforeEvent.remove(l2);
        }
    }

    public boolean fireDataModelEvent(DataModelEvent dataModelEvent) {
        return this.metaData.getDataModel().fireDataModelEvent(dataModelEvent);
    }

    public boolean fireOriginatorDataModelEvent(DataModelEvent dataModelEvent) {
        this.metaData.getDataModel().fireDataModelEvent(dataModelEvent, dataModelEvent.getOriginator());
        return true;
    }

    public boolean first() {
        if (this.getRowCount() > 0) {
            this.cursor = 0;
            return true;
        }
        return false;
    }

    public void getAncestors(Vector vector) {
        DataTableModel dataTableModel = (DataTableModel)((Object)this.getParent());
        if (dataTableModel != null && ((TreeNode)((Object)dataTableModel)).getParent() != null) {
            dataTableModel.getAncestors(vector);
        }
        if (this.parentRow != -1L) {
            vector.addElement(new Long(this.parentRow));
        }
    }

    private long[] getBookmarksFromTable(Hashtable hashtable) {
        long[] lArray = new long[hashtable.size()];
        int n = 0;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            lArray[n++] = (Long)enumeration.nextElement();
        }
        return lArray;
    }

    public Object getCell(long l, String string) throws DataModelException {
        int n = this.metaData.getColumnIndex(string);
        Object[] objectArray = (Object[])this.getRowFromCache(l);
        if (objectArray != null) {
            return objectArray[n];
        }
        return null;
    }

    public long getCurrentBookmark() throws DataModelException {
        if (this.store.getRowCount() < 1) {
            return 0L;
        }
        if (this.cursor >= this.store.getRowCount() || this.cursor < 0) {
            Exception exception = new Exception(LocaleBundle.string("Error getting current bookmark. Are there any rows?"));
            throw new DataModelException(-2L, "", this, 107, exception);
        }
        return this.store.getBookmark(this.cursor);
    }

    public int getCursor() {
        return this.cursor;
    }

    public Object getDeletedRow(long l) {
        return this.logicallyDeletedRows.get(new Long(l));
    }

    public long[] getDeletedRowBookmarks() {
        return this.getBookmarksFromTable(this.logicallyDeletedRows);
    }

    public long[] getInsertedRowBookmarks() {
        return this.getBookmarksFromTable(this.insertedRows);
    }

    public Object getInternalData(Object object) {
        if (this.internalData == null || object == null) {
            return null;
        }
        return this.internalData.get(object);
    }

    public MetaDataModel getMetaData() {
        return this.metaData;
    }

    protected long getNextBookmark() {
        return bookmark++;
    }

    public Object getOriginalRow(long l) {
        return (Object[])this.updatedRows.get(new Long(l));
    }

    public long getParentBookmark() {
        return this.parentRow;
    }

    public Object getResultData(long l, String string) throws DataModelException {
        ColumnModel columnModel = this.metaData.getColumnObject(string);
        return columnModel instanceof VirtualColumnModel ? ((VirtualColumnModel)columnModel).getResultData(this, l) : this.getCell(l, string);
    }

    public long getRootAncestorBookmark(long l) {
        DataTableModel dataTableModel = (DataTableModel)((Object)this.getParent());
        if (dataTableModel == null) {
            return l;
        }
        if (((TreeNode)((Object)dataTableModel)).getParent() == null) {
            return this.parentRow;
        }
        return dataTableModel.getRootAncestorBookmark(l);
    }

    private void getRow(DataModelListener dataModelListener, long l) throws DataModelException {
        if (this.insertedRows.containsKey(new Long(l))) {
            this.removeInsertedRow(l);
            return;
        }
        if (this.getRowStatus(l) == 1) {
            this.cancelChanges(dataModelListener, l);
        }
        this.refreshRow(l);
        this.removeRowFromUpdatedTable(l);
        this.removeRowFromLogicallyDeletedTable(l);
    }

    public int getRowCount() {
        return this.store.getRowCount();
    }

    public Object getRowFromCache(long l) throws DataModelException {
        Object object = this.store.getRow(l);
        if (object == null) {
            Exception exception = new Exception(String.valueOf(LocaleBundle.string("Internal error: bookmark not found in cache: ")) + l);
            throw new DataModelException(l, "", this, 107, exception);
        }
        return object;
    }

    public long getRowIdentifier(int n) {
        return this.store.getBookmark(n);
    }

    public int getRowIndex(long l) {
        if (l < 0L) {
            return -1;
        }
        int n = this.store.getIndex(l);
        if (n == -1) {
            Integer n2 = (Integer)this.rowIndexBeforeEvent.get(new Long(l));
            n = n2 != null ? n2 : -1;
        }
        return n;
    }

    public int getRowStatus(long l) {
        if (this.logicallyDeleted(l)) {
            return 3;
        }
        if (this.updatedRows.containsKey(new Long(l))) {
            return 1;
        }
        if (this.insertedRows.containsKey(new Long(l))) {
            return 2;
        }
        if (this.store.getIndex(l) != -1) {
            return 4;
        }
        return 5;
    }

    public DataTableModel getTable(long l, TreeNode treeNode) {
        MetaDataModel metaDataModel = (MetaDataModel)treeNode;
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            DataTableModel dataTableModel = (DataTableModel)((Object)enumeration.nextElement());
            if (dataTableModel.getParentBookmark() != l || !dataTableModel.getMetaData().equals(metaDataModel)) continue;
            return dataTableModel;
        }
        return null;
    }

    public long[] getUpdatedRowBookmarks() {
        return this.getBookmarksFromTable(this.updatedRows);
    }

    public Object getUserData(Object object) {
        if (this.userData == null || object == null) {
            return null;
        }
        return this.userData.get(object);
    }

    public boolean hasValueChanged(Object object, Object object2) {
        return object == null && object2 != null || object2 == null && object != null || object2 != null && object != null && !object.equals(object2);
    }

    public boolean isAfterLast() {
        return this.cursor >= this.store.getRowCount();
    }

    public boolean isBeforeFirst() {
        return this.cursor == -1;
    }

    public boolean isModified() {
        return this.insertedRows.size() + this.updatedRows.size() + this.logicallyDeletedRows.size() > 0;
    }

    public boolean isSubTreeModified(long l) {
        int n = this.getRowStatus(l);
        if (n != 4 && n != 5) {
            return true;
        }
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            DataTableModel dataTableModel = (DataTableModel)((Object)enumeration.nextElement());
            if (dataTableModel.getParentBookmark() != l || !dataTableModel.isTableOrChildrenModified()) continue;
            return true;
        }
        return false;
    }

    public boolean isTableOrChildrenModified() {
        boolean bl = false;
        if (this.isModified()) {
            bl = true;
        } else {
            Enumeration<TreeNode> enumeration = this.children();
            while (enumeration.hasMoreElements()) {
                DataTableModel dataTableModel = (DataTableModel)((Object)enumeration.nextElement());
                if (!dataTableModel.isTableOrChildrenModified()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public boolean last() {
        if (this.getRowCount() > 0) {
            this.cursor = this.store.getRowCount() - 1;
            return true;
        }
        return false;
    }

    private boolean logicallyDeleted(long l) {
        return this.logicallyDeletedRows.size() > 0 && this.logicallyDeletedRows.containsKey(new Long(l));
    }

    public DataTableModel materializeTable(DataModelListener dataModelListener, long l, TreeNode treeNode) throws DataModelException {
        return new BaseDataTable((MetaDataModel)treeNode, l);
    }

    public void moveCursorToRow(long l) throws DataModelException {
        int n = this.getRowIndex(l);
        if (n == -1) {
            Exception exception = new Exception(String.valueOf(LocaleBundle.string("Move failed, bookmark not found: ")) + l);
            throw new DataModelException(l, "", this, 107, exception);
        }
        this.cursor = n;
    }

    public void moveToRow(long l) throws DataModelException {
        this.setAncestorPath();
        this.getMetaData().setCurrentDataTable(this);
        this.getMetaData().setCurrentBookmark(l);
    }

    public boolean next() {
        if (++this.cursor < this.store.getRowCount()) {
            return true;
        }
        --this.cursor;
        return false;
    }

    public boolean originalCellWasNull(int n, Vector vector, Object[] objectArray) {
        int n2 = (Integer)vector.elementAt(n);
        Object object = objectArray[n2];
        return object == null;
    }

    public boolean prepareCellUpdate(DataModelListener dataModelListener, long l, String string) throws DataModelException {
        if (this.logicallyDeleted(l)) {
            Exception exception = new Exception(LocaleBundle.string("Deleted rows cannot be modified."));
            throw new DataModelException(l, string, this, 4, exception);
        }
        ColumnModel columnModel = this.metaData.getColumnObject(string);
        if (columnModel == null || columnModel instanceof VirtualColumnModel) {
            Exception exception = new Exception(LocaleBundle.string("This is a derived column.  It cannot be modified."));
            throw new DataModelException(l, string, this, 4, exception);
        }
        if (!this.metaData.isUpdateAllowedOnColumn(string) || columnModel.isReadOnly()) {
            Exception exception = new Exception(String.valueOf(LocaleBundle.string("Cell cannot be updated: permissions disallow it or its table name cannot be determined.")) + ": " + string);
            throw new DataModelException(l, string, this, 4, exception);
        }
        return this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, string, 4));
    }

    public boolean previous() {
        if (--this.cursor > -1) {
            return true;
        }
        ++this.cursor;
        return false;
    }

    public void processEventQueue(DataModelListener dataModelListener) throws DataModelException {
        Enumeration enumeration = this.eventQueue.elements();
        while (enumeration.hasMoreElements()) {
            long l = (Long)enumeration.nextElement();
            this.processRowEvent(dataModelListener, l);
        }
        this.eventQueue.removeAllElements();
        Enumeration<TreeNode> enumeration2 = this.children();
        while (enumeration2.hasMoreElements()) {
            ((DataTableModel)((Object)enumeration2.nextElement())).processEventQueue(dataModelListener);
        }
    }

    private void processRowEvent(DataModelListener dataModelListener, long l) throws DataModelException {
        switch (this.getRowStatus(l)) {
            case 1: {
                this.removeRowFromUpdatedTable(l);
                this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 100));
                break;
            }
            case 2: {
                this.removeRowFromInsertedTable(l);
                this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 100));
                break;
            }
            case 3: {
                Long l2 = new Long(l);
                this.rowIndexBeforeEvent.put(l2, new Integer(this.store.getIndex(l)));
                this.removeRowFromLogicallyDeletedTable(l);
                this.removeRowFromOriginalRowTable(l);
                if (this.metaData.getShowDeletedRows()) {
                    this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 102));
                    this.fireOriginatorDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 108));
                }
                this.rowIndexBeforeEvent.remove(l2);
                break;
            }
        }
    }

    protected boolean recursivelyDeleteChildren(BaseDataTable baseDataTable, DataModelListener dataModelListener) throws DataModelException {
        if (baseDataTable == null) {
            return true;
        }
        Enumeration<TreeNode> enumeration = baseDataTable.children();
        while (enumeration.hasMoreElements()) {
            baseDataTable = (BaseDataTable)enumeration.nextElement();
            if (!(baseDataTable.getChildCount() > 0 ? !this.recursivelyDeleteChildren(baseDataTable, dataModelListener) : !this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, baseDataTable, -2L, "", 12)))) continue;
            return false;
        }
        return true;
    }

    public void refreshRow(long l) throws DataModelException {
    }

    public void relative(int n) throws DataModelException {
        int n2 = this.cursor + n;
        if (n2 >= this.store.getRowCount() + 1 || n2 <= -2) {
            Exception exception = new Exception(String.valueOf(LocaleBundle.string("Relative move failed. Index out of bounds. ")) + n2);
            throw new DataModelException(107, exception);
        }
        this.cursor = n2;
    }

    private void removeInsertedRow(long l) {
        this.removeRowFromInsertedTable(l);
        this.removeRowFromOriginalRowTable(l);
    }

    public void removeRowFromInsertedTable(long l) {
        Long l2 = new Long(l);
        if (this.insertedRows.containsKey(l2)) {
            this.insertedRows.remove(l2);
        }
    }

    protected void removeRowFromLogicallyDeletedTable(long l) {
        if (this.logicallyDeleted(l)) {
            this.logicallyDeletedRows.remove(new Long(l));
        }
    }

    protected void removeRowFromOriginalRowTable(long l) {
        this.store.removeRow(l);
    }

    public void removeRowFromUpdatedTable(long l) {
        Long l2 = new Long(l);
        if (this.updatedRows.containsKey(l2)) {
            this.updatedRows.remove(l2);
        }
    }

    public DataTableModel requeryLevel() throws DataModelException {
        return this;
    }

    public void requeryRow(DataModelListener dataModelListener, long l) throws DataModelException {
        if (!this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 3))) {
            return;
        }
        int n = this.getRowStatus(l);
        Long l2 = new Long(l);
        this.rowIndexBeforeEvent.put(l2, new Integer(this.store.getIndex(l)));
        this.getRow(dataModelListener, l);
        if (n == 2) {
            this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 102));
            this.fireOriginatorDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 108));
        } else {
            this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 100));
        }
        this.rowIndexBeforeEvent.remove(l2);
    }

    public void requeryRowAndDetails(DataModelListener dataModelListener, long l) throws DataModelException {
        if (!this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 3))) {
            return;
        }
        this.requeryRow(dataModelListener, l);
        this.removeAllChildren();
        this.metaData.getDataModel().clearCurrentPath(this.metaData);
        this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, "", 109));
    }

    public void requeryTable(DataModelListener dataModelListener) throws DataModelException {
        if (!this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, this.getParentBookmark(), "", 3))) {
            return;
        }
        this.cancelAllRowChanges(dataModelListener);
        this.removeAllChildren();
        this.metaData.getDataModel().clearCurrentPath(this.metaData);
        this.cursor = 0;
        this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, this.getParentBookmark(), "", 110));
    }

    public void restoreRow(long l) {
        Object[] objectArray = (Object[])this.getOriginalRow(l);
        if (objectArray == null) {
            return;
        }
        int n = 0;
        while (n < objectArray.length) {
            try {
                String string = this.metaData.getColumnIdentifier(n);
                if (this.columnModified(l, string)) {
                    this.setValueAt(l, string, objectArray[n]);
                }
            }
            catch (DataModelException dataModelException) {}
            ++n;
        }
    }

    public void saveRow(long l) throws DataModelException {
    }

    private void setAncestorPath() {
        DataTableModel dataTableModel = (DataTableModel)((Object)this.getParent());
        if (dataTableModel == null) {
            return;
        }
        ((BaseDataTable)dataTableModel).setAncestorPath();
        MetaDataModel metaDataModel = dataTableModel.getMetaData();
        metaDataModel.setCurrentDataTable(dataTableModel);
        metaDataModel.setCurrentBookmark(this.getParentBookmark());
    }

    public void setInternalData(Object object, Object object2) {
        if (object == null) {
            return;
        }
        if (this.internalData == null) {
            this.internalData = new Hashtable(this.initialHashtableSize);
        }
        if (object2 == null) {
            this.internalData.remove(object);
        } else {
            this.internalData.put(object, object2);
        }
    }

    public void setRowDirty(long l) {
        block2: {
            if (this.insertedRows.containsKey(new Long(l)) || this.updatedRows.containsKey(new Long(l))) break block2;
            try {
                this.updatedRows.put(new Long(l), this.cloneRow(l));
            }
            catch (DataModelException dataModelException) {
                System.out.println(dataModelException.toString());
            }
        }
    }

    public void setUserData(Object object, Object object2) {
        if (object == null) {
            return;
        }
        if (this.userData == null) {
            this.userData = new Hashtable(this.initialHashtableSize);
        }
        if (object2 == null) {
            this.userData.remove(object);
        } else {
            this.userData.put(object, object2);
        }
    }

    public void setValueAt(long l, String string, Object object) throws DataModelException {
        ((Object[])this.getRowFromCache((long)l))[this.metaData.getColumnIndex((String)string)] = object;
    }

    public boolean tableIsAncestor(DataTableModel dataTableModel) {
        TreeNode treeNode = (TreeNode)((Object)dataTableModel);
        while (treeNode != null) {
            if (treeNode == this) {
                return true;
            }
            treeNode = treeNode.getParent();
        }
        return false;
    }

    public void updateCell(DataModelListener dataModelListener, long l, String string, Object object) throws DataModelException {
        if (!this.hasValueChanged(object, this.getResultData(l, string))) {
            return;
        }
        if (!this.prepareCellUpdate(dataModelListener, l, string)) {
            return;
        }
        this.setRowDirty(l);
        this.setValueAt(l, string, object);
        this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, l, string, 100));
    }
}

