/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.db;

import com.klg.jclass.chart.data.JCDefaultDataSource;
import com.klg.jclass.chart.db.ChartDataBinding;
import com.klg.jclass.chart.db.DataBindingConfigWrapper;
import com.klg.jclass.chart.db.DataChart;
import com.klg.jclass.datasource.BindingModel;
import com.klg.jclass.datasource.DataModel;
import com.klg.jclass.datasource.MetaDataModel;

class DataBoundSource
extends JCDefaultDataSource {
    protected ChartDataBinding dataBinding;
    protected String labelsColumn = null;
    protected String[] seriesColumns = null;
    protected int[] numericalColumns = null;
    protected String[] allColumns = null;
    private MetaDataModel lastMetaDataModel = null;

    private DataBoundSource(DataChart dataChart) {
        this.dataBinding = new ChartDataBinding(dataChart, this);
    }

    DataBoundSource(DataChart dataChart, BindingModel bindingModel) {
        this(dataChart);
        this.dataBinding.setDataBinding(bindingModel);
    }

    DataBoundSource(DataChart dataChart, DataModel dataModel) {
        this(dataChart, dataModel, (MetaDataModel)null);
    }

    DataBoundSource(DataChart dataChart, DataModel dataModel, MetaDataModel metaDataModel) {
        this(dataChart);
        this.dataBinding.setDataBinding(dataModel, metaDataModel);
    }

    DataBoundSource(DataChart dataChart, DataModel dataModel, String string) {
        this(dataChart);
        this.dataBinding.setDataBinding(dataModel, string);
    }

    DataBoundSource(DataChart dataChart, String string) {
        this(dataChart);
        this.dataBinding.setDataBinding(string);
    }

    public void dispose() {
        this.dataBinding.dispose();
    }

    public void finalize() {
        this.dispose();
    }

    public String getDataBinding() {
        return this.dataBinding.getDataBinding();
    }

    public DataBindingConfigWrapper getDataBindingConfigWrapper() {
        return new DataBindingConfigWrapper(this.dataBinding.allRows, this.dataBinding.startPoint, this.dataBinding.endPoint, this.labelsColumn, this.seriesColumns, this.numericalColumns, this.allColumns);
    }

    public String[] getDataColumns() {
        return this.seriesColumns;
    }

    public Object getNativeMetaData() {
        return this.dataBinding.getNativeMetaData();
    }

    public String getPointLabelsColumn() {
        return this.labelsColumn;
    }

    public void initColumns() {
        if (this.dataBinding == null) {
            return;
        }
        this.allColumns = new String[this.dataBinding.getNumColumns()];
        int n = 0;
        int n2 = 0;
        while (n2 < this.dataBinding.getNumColumns()) {
            String string;
            this.allColumns[n2] = string = this.dataBinding.getTableColumnLabel(n2);
            if (this.dataBinding.isNumericalColumn(string)) {
                ++n;
            }
            ++n2;
        }
        if (this.allColumns.length > 0) {
            this.labelsColumn = this.allColumns[0];
        }
        boolean bl = false;
        if (this.seriesColumns == null) {
            bl = true;
        }
        if (bl) {
            this.seriesColumns = new String[n];
        }
        this.numericalColumns = new int[n];
        int n3 = 0;
        int n4 = 0;
        while (n3 < this.allColumns.length) {
            String string = this.allColumns[n3];
            if (this.dataBinding.isNumericalColumn(string)) {
                if (bl) {
                    this.seriesColumns[n4] = string;
                }
                this.numericalColumns[n4] = n3;
                ++n4;
            }
            ++n3;
        }
    }

    protected boolean isValidColumn(String string) {
        int n = 0;
        while (n < this.allColumns.length) {
            if (string.equalsIgnoreCase(this.allColumns[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected boolean isValidColumnSet(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (!this.isValidColumn(stringArray[n]) || !this.dataBinding.isNumericalColumn(stringArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void refreshChart() {
        String string = this.labelsColumn;
        String[] stringArray = this.seriesColumns;
        this.updateConfig();
        if (stringArray != null) {
            this.seriesColumns = stringArray;
        }
        if (string != null) {
            this.labelsColumn = string;
        }
        this.refreshSeries();
        this.refreshPointLabels();
    }

    protected void refreshPointLabels() {
        if (this.labelsColumn != null && this.labelsColumn.compareTo("") != 0) {
            this.setPointLabels(this.dataBinding.getLabels(this.labelsColumn));
        }
    }

    protected void refreshSeries() {
        double[][] dArray = new double[this.seriesColumns.length][];
        int n = 0;
        while (n < this.seriesColumns.length) {
            dArray[n] = this.dataBinding.getData(this.seriesColumns[n]);
            ++n;
        }
        DataBoundSource dataBoundSource = this;
        synchronized (dataBoundSource) {
            this.yvalues = dArray;
            this.xvalues = null;
            if (this.yvalues[0] != null) {
                this.check();
            }
            this.updateChart(12, 0, 0);
        }
        this.setSeriesLabels(this.seriesColumns);
    }

    public void setDataBinding(BindingModel bindingModel) {
        this.dataBinding.setDataBinding(bindingModel);
    }

    protected void setDataBinding(DataModel dataModel, MetaDataModel metaDataModel) {
        this.dataBinding.setDataBinding(dataModel, metaDataModel);
        this.updateConfig();
    }

    public void setDataBinding(String string) {
        this.dataBinding.setDataBinding(string);
        this.updateConfig();
    }

    public void setDataBindingConfigWrapper(DataBindingConfigWrapper dataBindingConfigWrapper) {
        this.dataBinding.allRows = dataBindingConfigWrapper.allRows;
        this.dataBinding.startPoint = dataBindingConfigWrapper.startPoint;
        this.dataBinding.endPoint = dataBindingConfigWrapper.endPoint;
        this.initColumns();
        if (this.isValidColumn(dataBindingConfigWrapper.labelsColumn)) {
            this.labelsColumn = dataBindingConfigWrapper.labelsColumn;
        }
        if (this.isValidColumnSet(dataBindingConfigWrapper.seriesColumns)) {
            this.seriesColumns = dataBindingConfigWrapper.seriesColumns;
        }
        this.refreshPointLabels();
        this.refreshSeries();
    }

    public void setDataColumns(String[] stringArray) {
        this.seriesColumns = stringArray;
        this.refreshSeries();
    }

    public void setName(String string) {
        super.setName(string);
        this.updateChart(12, 0, 0);
    }

    public void setPointLabelsColumn(String string) {
        if (!this.dataBinding.isValidColumn(string)) {
            throw new IllegalArgumentException("The column " + string + " doesn't exist in the table.");
        }
        this.labelsColumn = string;
        this.setPointLabels(this.dataBinding.getLabels(this.labelsColumn));
    }

    protected void updateConfig() {
        this.initColumns();
    }
}

