/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.db;

import com.klg.jclass.chart.JCChartBundle;
import com.klg.jclass.chart.db.DataBindingConfigWrapper;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DataBindingConfigEditor
extends JPanel
implements PropertyEditor,
ActionListener,
ItemListener,
ListSelectionListener,
PropertyChangeListener,
FocusListener,
Serializable {
    public PropertyChangeSupport support = new PropertyChangeSupport(this);
    private JTextField startPoint = null;
    private JTextField endPoint = null;
    private JCheckBox allRows = null;
    private JList seriesColumns = null;
    protected JComboBox labelsColumn;
    protected String[] allColumns = new String[0];
    protected int[] numericalColumns = new int[0];
    protected boolean updateComponents = true;

    public DataBindingConfigEditor() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        GroupPanel groupPanel = new GroupPanel("Data Range");
        groupPanel.add(new JLabel("Start row"));
        this.startPoint = new JTextField(Integer.toString(0), 5);
        groupPanel.add(this.startPoint);
        groupPanel.add(new JLabel("End row"));
        this.endPoint = new JTextField(Integer.toString(100), 5);
        this.allRows = new JCheckBox("All rows", false);
        this.startPoint.setEnabled(this.allRows.isSelected() ^ true);
        this.endPoint.setEnabled(this.allRows.isSelected() ^ true);
        groupPanel.add(this.endPoint);
        groupPanel.add(this.allRows);
        GroupPanel groupPanel2 = new GroupPanel("Potential point labels column");
        this.labelsColumn = new JComboBox();
        groupPanel2.add(new JLabel("Column name"));
        groupPanel2.add((Component)new JScrollPane(this.labelsColumn), "Center");
        GroupPanel groupPanel3 = new GroupPanel("Potential series columns");
        this.seriesColumns = new JList();
        this.seriesColumns.setSelectionMode(2);
        groupPanel3.add((Component)new JScrollPane(this.seriesColumns), "Center");
        this.add((Component)groupPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)groupPanel2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)groupPanel3, gridBagConstraints);
        this.startPoint.addActionListener(this);
        this.startPoint.addFocusListener(this);
        this.endPoint.addActionListener(this);
        this.endPoint.addFocusListener(this);
        this.allRows.addActionListener(this);
        this.labelsColumn.addItemListener(this);
        this.seriesColumns.addListSelectionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.updateComponents) {
            return;
        }
        Object object = actionEvent.getSource();
        if (this.startPoint.equals(object) || this.endPoint.equals(object)) {
            this.firePropertyChange();
        } else if (this.allRows.equals(object)) {
            boolean bl = this.allRows.isSelected() ^ true;
            this.startPoint.setEnabled(bl);
            this.endPoint.setEnabled(bl);
            this.firePropertyChange();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    protected int[] columnsIndices(String[] stringArray, String[] stringArray2, String[] stringArray3) {
        int[] nArray = new int[stringArray3.length];
        int n = 0;
        while (n < stringArray3.length) {
            int n2 = DataBindingConfigEditor.findColumnIndex(stringArray, stringArray3[n]);
            if (!this.isNumerical(n2)) {
                return null;
            }
            nArray[n] = DataBindingConfigEditor.findColumnIndex(stringArray2, stringArray3[n]);
            ++n;
        }
        return nArray;
    }

    public static int findColumnIndex(String[] stringArray, String string) {
        int n = 0;
        while (n < stringArray.length) {
            if (string.equalsIgnoreCase(stringArray[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected void firePropertyChange() {
        this.support.firePropertyChange("dataBindingConfig", null, this.getValue());
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!this.updateComponents) {
            return;
        }
        Object object = focusEvent.getSource();
        if (this.startPoint.equals(object) || this.endPoint.equals(object)) {
            this.firePropertyChange();
        }
    }

    public String getAsText() {
        return null;
    }

    public Component getCustomEditor() {
        return this;
    }

    public String getJavaInitializationString() {
        return ((DataBindingConfigWrapper)this.getValue()).getJavaInitializationString();
    }

    public String[] getTags() {
        return null;
    }

    public Object getValue() {
        Object[] objectArray = this.seriesColumns.getSelectedValues();
        String[] stringArray = new String[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            stringArray[n] = (String)objectArray[n];
            ++n;
        }
        return new DataBindingConfigWrapper(this.allRows.isSelected(), Integer.valueOf(this.startPoint.getText()), Integer.valueOf(this.endPoint.getText()), (String)this.labelsColumn.getSelectedItem(), stringArray, this.numericalColumns, this.allColumns);
    }

    protected boolean isNumerical(int n) {
        int n2 = 0;
        while (n2 < this.numericalColumns.length) {
            if (n == this.numericalColumns[n2]) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isPaintable() {
        return true;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (!this.updateComponents) {
            return;
        }
        if (this.labelsColumn.equals(itemEvent.getSource())) {
            this.firePropertyChange();
        }
    }

    protected String[] numericalColumnNames() {
        String[] stringArray = new String[this.numericalColumns.length];
        int n = 0;
        while (n < this.numericalColumns.length) {
            stringArray[n] = this.allColumns[this.numericalColumns[n]];
            ++n;
        }
        return stringArray;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        String string = JCChartBundle.string("com.klg.jclass.chart.Key163");
        if (string == null) {
            string = new String("");
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = (rectangle.height - fontMetrics.getAscent()) / 2;
        graphics.drawString(string, rectangle.x, rectangle.y + rectangle.height - n);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.firePropertyChange();
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void setAsText(String string) throws IllegalArgumentException {
    }

    public void setValue(Object object) {
        if (object == null || !(object instanceof DataBindingConfigWrapper)) {
            return;
        }
        DataBindingConfigWrapper dataBindingConfigWrapper = (DataBindingConfigWrapper)object;
        this.allColumns = dataBindingConfigWrapper.allColumns;
        if (this.allColumns == null) {
            this.allColumns = new String[0];
        }
        this.numericalColumns = dataBindingConfigWrapper.numericalColumns;
        if (this.numericalColumns == null) {
            this.numericalColumns = new int[0];
        }
        DataBindingConfigEditor dataBindingConfigEditor = this;
        synchronized (dataBindingConfigEditor) {
            this.updateComponents = false;
            this.allRows.setSelected(dataBindingConfigWrapper.allRows);
            this.startPoint.setText(String.valueOf(dataBindingConfigWrapper.startPoint));
            this.endPoint.setText(String.valueOf(dataBindingConfigWrapper.endPoint));
            if (this.labelsColumn.getItemCount() > 0) {
                this.labelsColumn.removeAllItems();
            }
            int n = 0;
            while (n < this.allColumns.length) {
                this.labelsColumn.addItem(this.allColumns[n]);
                ++n;
            }
            if (DataBindingConfigEditor.findColumnIndex(this.allColumns, dataBindingConfigWrapper.labelsColumn) != -1) {
                this.labelsColumn.setSelectedItem(dataBindingConfigWrapper.labelsColumn);
            }
            String[] stringArray = this.numericalColumnNames();
            this.seriesColumns.setListData(stringArray);
            int[] nArray = this.columnsIndices(this.allColumns, stringArray, dataBindingConfigWrapper.seriesColumns);
            if (nArray != null) {
                this.seriesColumns.setSelectedIndices(nArray);
            }
            this.updateComponents = true;
        }
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!this.updateComponents) {
            return;
        }
        if (this.seriesColumns.equals(listSelectionEvent.getSource())) {
            this.firePropertyChange();
        }
    }

    protected class GroupPanel
    extends JPanel {
        GroupPanel(String string) {
            this.setBorder(BorderFactory.createTitledBorder(string));
        }
    }
}

