/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.db;

import com.klg.jclass.chart.db.DataBoundSource;
import com.klg.jclass.chart.db.DataChart;
import com.klg.jclass.datasource.DataModelException;
import com.klg.jclass.datasource.DataModelListener;
import com.klg.jclass.datasource.util.DataBinding;

class ChartDataBinding
extends DataBinding {
    protected DataChart dataChart;
    protected DataBoundSource dataSource;
    public static final int START_POINT = 0;
    public static final int END_POINT = 100;
    protected int startPoint = 0;
    protected int endPoint = 100;
    protected boolean allRows = false;

    ChartDataBinding(DataChart dataChart, DataBoundSource dataBoundSource) {
        super(dataChart);
        this.dataSource = dataBoundSource;
        this.dataChart = dataChart;
    }

    protected boolean beforeCurrentRowChange() {
        return true;
    }

    protected void cellDataChanged(int n, String string) {
        this.dataSource.refreshChart();
    }

    protected void currentRowChanged(int n) {
    }

    public int getCurrentRowIndex() {
        return super.getCurrentRowIndex();
    }

    public double[] getData(String string) {
        if (!this.binding.isDataAvailable()) {
            return null;
        }
        int n = this.getFirstRow();
        int n2 = this.getLastRow();
        double[] dArray = new double[n2 - n + 1];
        Object object = null;
        int n3 = n;
        while (n3 <= n2) {
            try {
                object = this.binding.getCell((DataModelListener)this, n3, string);
                if (object instanceof Number) {
                    dArray[n3 - n] = ((Number)object).doubleValue();
                } else if (object instanceof String) {
                    dArray[n3 - n] = Double.valueOf((String)object);
                }
            }
            catch (DataModelException dataModelException) {
                this.processException(dataModelException);
            }
            catch (ClassCastException classCastException) {
                System.out.println("Invalid double value for column '" + string + "', row " + n3 + ": " + object);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Invalid double value for column '" + string + "', row " + n3 + ": " + object);
            }
            ++n3;
        }
        return dArray;
    }

    protected int getFirstRow() {
        return this.allRows ? 0 : this.startPoint;
    }

    public String[] getLabels(String string) {
        if (!this.binding.isDataAvailable() || string == null || string.length() == 0) {
            return null;
        }
        int n = this.getFirstRow();
        int n2 = this.getLastRow();
        String[] stringArray = new String[n2 - n + 1];
        int n3 = n;
        while (n3 <= n2) {
            try {
                stringArray[n3 - n] = this.binding.getCell((DataModelListener)this, n3, string).toString();
            }
            catch (DataModelException dataModelException) {
                dataModelException.printStackTrace();
            }
            ++n3;
        }
        return stringArray;
    }

    protected int getLastRow() {
        int n = this.binding.getRowCount() - 1;
        return this.allRows ? n : Math.min(n, this.endPoint);
    }

    public boolean isEnabled() {
        return this.binding != null && this.binding.isDataAvailable();
    }

    public static boolean isNumerical(int n) {
        return n == 1002 || n == 1003 || n == 1004 || n == 1006 || n == 1007 || n == 1011 || n == 1012;
    }

    public boolean isNumericalColumn(String string) {
        return ChartDataBinding.isNumerical(this.getJavaColumnType(string));
    }

    public boolean isValidColumn(String string) {
        return this.binding.getColumnIndex(string) != -1;
    }

    protected void rowDataChanged(int n) {
        this.dataSource.refreshChart();
    }

    protected void rowDeleted() {
        this.dataSource.refreshChart();
    }

    protected void rowInserted() {
        this.dataSource.refreshChart();
    }

    protected void setDataAvailable(boolean bl) {
    }

    protected void tableChanged() {
        this.dataSource.refreshChart();
    }
}

