/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.beans;

import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.beans.View3DEditor;
import com.klg.jclass.util.JCNumberUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class View3DCube
extends JPanel
implements MouseListener,
MouseMotionListener {
    protected View3DEditor parent;
    protected int deltaX;
    protected int deltaY;
    protected boolean inDepthChange = false;
    protected Point first;
    protected Point last;
    protected int firstDepth;
    protected int firstElevation;
    protected int firstRotation;
    protected int scaleWidth;
    protected int scaleHeight;

    View3DCube(View3DEditor view3DEditor) {
        this.parent = view3DEditor;
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    void calculateDeltas(int n, int n2) {
        if (this.parent == null) {
            return;
        }
        int n3 = this.getDepth();
        int n4 = this.getElevation();
        int n5 = this.getRotation();
        double d = JCNumberUtil.degToRad(n5);
        double d2 = JCNumberUtil.degToRad(n4);
        double d3 = Math.sin(d);
        double d4 = Math.sin(d2);
        double d5 = Math.cos(d2);
        double d6 = (double)n3 / 80.0;
        double d7 = JCNumberUtil.max(1.0, n);
        double d8 = (d7 /= 1.0 + JCNumberUtil.abs(d3) * d5 * d6) * d6;
        this.deltaX = (int)(d8 * d3 * d5);
        this.deltaY = (int)(-d8 * d4);
        int n6 = n;
        if (Math.abs(this.deltaX) > n6) {
            this.deltaX = this.deltaX < 0 ? -n6 : n6;
        }
        n6 = n2;
        if (Math.abs(this.deltaY) > n6) {
            this.deltaY = this.deltaY < 0 ? -n6 : n6;
        }
    }

    private boolean getChangeDepth() {
        return this.parent.cbDepth.isSelected();
    }

    private int getDepth() {
        return Integer.parseInt(this.parent.textDepth.getText());
    }

    private int getElevation() {
        return Integer.parseInt(this.parent.textElevation.getText());
    }

    private int getRotation() {
        return Integer.parseInt(this.parent.textRotation.getText());
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.first == null) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.last == null) {
            this.last = new Point(n, n2);
            return;
        }
        if (n == this.last.x && n2 == this.last.y) {
            return;
        }
        int n3 = n2 - this.first.y;
        int n4 = n - this.first.x;
        this.last.x = n;
        this.last.y = n2;
        if (this.inDepthChange) {
            int n5 = this.firstDepth;
            this.setDepth(n5 += n3);
        } else {
            double d = 90.0 / (double)this.scaleWidth;
            double d2 = 90.0 / (double)this.scaleHeight;
            int n6 = this.firstElevation;
            int n7 = this.firstRotation;
            n6 = (int)((double)n6 + (double)n3 * d2);
            n7 = (int)((double)n7 - (double)n4 * d);
            this.setElevation(n6);
            this.setRotation(n7);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.inDepthChange = this.getChangeDepth();
        this.first = new Point(mouseEvent.getX(), mouseEvent.getY());
        this.last = null;
        this.firstDepth = this.getDepth();
        this.firstElevation = this.getElevation();
        this.firstRotation = this.getRotation();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.first = null;
    }

    public void paintComponent(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        super.paintComponent(graphics);
        graphics = graphics.create();
        Rectangle rectangle = null;
        rectangle = this.getBounds(rectangle);
        int n = rectangle.width / 3;
        int n2 = rectangle.height / 3;
        boolean bl = n > n2;
        Color color = Color.black;
        n2 = n = Math.min(n, n2);
        Rectangle rectangle2 = new Rectangle((rectangle.width - n) / 2, (rectangle.height - n2) / 2, n, n2);
        JCFillStyle jCFillStyle = new JCFillStyle(Color.red, 1);
        jCFillStyle.fillOutlineRect(graphics, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, color);
        this.scaleWidth = (rectangle.width - rectangle2.width) / 2 - 8;
        this.scaleHeight = (rectangle.height - rectangle2.height) / 2 - 8;
        this.calculateDeltas(this.scaleWidth, this.scaleHeight);
        if (this.deltaX == 0 && this.deltaY == 0) {
            return;
        }
        Point[] pointArray = new Point[]{this.deltaY < 0 ? new Point(rectangle2.x, rectangle2.y) : new Point(rectangle2.x, rectangle2.y + rectangle2.height), new Point(this.deltaX, this.deltaY), new Point(rectangle2.width, 0), new Point(-this.deltaX, -this.deltaY)};
        Polygon polygon = JCNumberUtil.pointsToPolygon(pointArray);
        if (this.deltaY <= 0) {
            jCFillStyle.fillOutlinePolygonHighlight(graphics, polygon, color);
        } else {
            jCFillStyle.fillOutlinePolygonShadow(graphics, polygon, color);
        }
        pointArray[0] = this.deltaX < 0 ? new Point(rectangle2.x, rectangle2.y) : new Point(rectangle2.x + rectangle2.width, rectangle2.y);
        pointArray[1] = new Point(this.deltaX, this.deltaY);
        pointArray[2] = new Point(0, rectangle2.height);
        pointArray[3] = new Point(-this.deltaX, -this.deltaY);
        polygon = JCNumberUtil.pointsToPolygon(pointArray);
        if (this.deltaX <= 0) {
            jCFillStyle.fillOutlinePolygonHighlight(graphics, polygon, color);
        } else {
            jCFillStyle.fillOutlinePolygonShadow(graphics, polygon, color);
        }
        graphics.dispose();
    }

    private void setDepth(int n) {
        this.parent.textDepth.setText(Integer.toString(n));
        this.parent.setSelectedValue(true);
    }

    private void setElevation(int n) {
        this.parent.textElevation.setText(Integer.toString(n));
        this.parent.setSelectedValue(true);
    }

    private void setRotation(int n) {
        this.parent.textRotation.setText(Integer.toString(n));
        this.parent.setSelectedValue(true);
    }
}

