/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.rhook;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class RLogger {
    private String logFileName = null;
    private PrintWriter pw = null;
    private Date startTime = null;
    private Date stopTime = null;

    public void write(String s) {
        this.pw.print(s);
    }

    public void writeln(String s) {
        this.pw.println(s);
    }

    public void writeln(Exception e) {
        e.printStackTrace(this.pw);
    }

    public void writeln() {
        this.pw.println();
    }

    public void start() {
        this.startTime = Calendar.getInstance().getTime();
        try {
            this.pw = new PrintWriter(new FileWriter(this.logFileName, true));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.pw.println("# --------------------------------------------");
        this.pw.println("# RHook LOG FILE     : " + this.logFileName);
        this.pw.println("# START TIME   : " + this.startTime);
        this.pw.println("# --------------------------------------------");
        this.pw.println();
    }

    public void stop() {
        this.stopTime = Calendar.getInstance().getTime();
        long diff = this.stopTime.getTime() - this.startTime.getTime();
        this.pw.println();
        this.pw.println("# --------------------------------------------");
        this.pw.println("#           << END OF SESSION >>              ");
        this.pw.println("# --------------------------------------------");
        this.pw.println("# STOP TIME    : " + this.stopTime);
        this.pw.println("# ELAPSED TIME : " + diff / 1000L + " seconds.");
        this.pw.println("# --------------------------------------------");
        this.pw.close();
    }

    public static String getLogFileName() {
        String file = "rhook.log";
        System.out.println("user.home " + System.getProperty("user.home"));
        System.out.println("user.dir " + System.getProperty("user.dir"));
        File f = new File(System.getProperty("user.dir") + System.getProperty("file.separator") + file);
        if (f.exists()) {
            if (f.length() / 1000L > 500L) {
                Date now = new Date();
                SimpleDateFormat formatDt = new SimpleDateFormat("MM_dd_yy_HHmmss");
                String dateString = formatDt.format(now);
                File nf = new File(System.getProperty("user.home") + System.getProperty("file.separator") + file + dateString);
                if (!f.renameTo(nf)) {
                    System.out.println("Unable to rename rhook.log file");
                }
            }
        } else {
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                System.out.println("Unable to create rhook.log file");
                e.printStackTrace();
            }
        }
        return file;
    }

    public RLogger(String logFileName) {
        this.logFileName = logFileName;
    }
}

