/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.rhook;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import org.rosuda.JRI.REXP;
import org.rosuda.JRI.RMainLoopCallbacks;
import org.rosuda.JRI.Rengine;
import org.tigr.microarray.mev.TMEV;
import org.tigr.rhook.RConstants;
import org.tigr.rhook.RLogger;
import org.tigr.rhook.TextConsole;
import org.tigr.util.ConfMap;
import org.tigr.util.FloatMatrix;

public class RHook {
    static Rengine re;
    protected static RLogger logger;
    private static Properties rHookProps;
    private static Properties macRVersionProp;

    private RHook(String[] args) {
        if (!Rengine.versionCheck()) {
            System.err.println("** Version mismatch - Java files don't match library version.");
            return;
        }
        if (re != null) {
            System.out.println("Rengine already exists");
            return;
        }
        System.out.println("Creating Rengine (with arguments)");
        re = new Rengine(args, false, (RMainLoopCallbacks)new TextConsole());
        System.out.println("Rengine created, waiting for R");
        if (!re.waitForR()) {
            System.out.println("Cannot load R");
            return;
        }
    }

    public static Rengine startRSession() throws Exception {
        try {
            if (logger != null) {
                logger.stop();
            }
            logger = new RLogger(RLogger.getLogFileName());
            logger.start();
            String r_home = System.getenv("R_HOME");
            System.out.println("Checking for R_HOME : " + r_home);
            RHook.isRhomeSet(r_home);
            RHook.ifExistRhome(r_home);
            RHook.ifExistRlib();
            RHook.loadRHookProperties();
            if (!Rengine.versionCheck()) {
                System.err.println("** Version mismatch - Java files don't match library version.");
                logger.writeln("** Version mismatch - Java files don't match library version.");
                logger.stop();
                throw new Exception("Java class version mismatch");
            }
            re = Rengine.getMainEngine();
            if (re != null) {
                System.out.println("Rengine already exists");
                logger.writeln("Rengine already exists");
                RHook.cleanUp();
                return re;
            }
            System.out.println("Creating Rengine (with arguments)");
            String[] args = new String[]{"--no-save"};
            RHook.checkMacR();
            re = new Rengine(args, false, (RMainLoopCallbacks)new TextConsole());
        }
        catch (Exception e) {
            System.out.println("Error loading R");
            logger.writeln("Error loading R");
            logger.writeln(e);
            logger.stop();
            e.printStackTrace();
            throw e;
        }
        System.out.println("Rengine created, waiting for R");
        if (!re.waitForR()) {
            System.out.println("Cannot load R");
            logger.writeln("Cannot load R");
            logger.stop();
            throw new Exception("waitForR() error: Cannot load R");
        }
        return re;
    }

    private static void loadRHookProperties() throws IOException {
        File mevUserDir = new File(System.getProperty("user.home"), ".mev");
        File rhookPropFile = new File(mevUserDir, "rhook.properties");
        try {
            RHook.getPropInfoRhook();
        }
        catch (ConnectException cex) {
            logger.writeln(cex.getMessage());
            logger.writeln(cex);
            System.out.println("loadRHookProperties() Exception");
            cex.printStackTrace();
            rHookProps = new ConfMap();
            if (rhookPropFile.exists()) {
                System.out.println("rhookPropFile exist");
                FileInputStream in = null;
                try {
                    in = new FileInputStream(rhookPropFile);
                    rHookProps.load(in);
                    ((InputStream)in).close();
                    System.out.println("rhookPropFile loaded");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    logger.writeln(e.getMessage());
                    logger.writeln(e);
                    throw e;
                }
                System.out.println("rhook properties loaded from " + rhookPropFile.getAbsolutePath());
                logger.writeln("rhook properties loaded from " + rhookPropFile.getAbsolutePath());
            } else {
                System.out.println("rhookPropFile does not exist");
                InputStream in = TMEV.class.getClassLoader().getResourceAsStream("org/tigr/rhook/rhook.default.properties");
                try {
                    if (in != null) {
                        rHookProps.load(in);
                    }
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    logger.writeln(e.getMessage());
                    logger.writeln(e);
                    throw e;
                }
                System.out.println("rhook properties loaded from org/tigr/rhook/rhook.default.properties");
                logger.writeln("rhook properties loaded from org/tigr/rhook/rhook.default.properties");
            }
            return;
        }
        catch (UnknownHostException une) {
            une.printStackTrace();
            logger.writeln(une.getMessage());
            logger.writeln(une);
            logger.stop();
            throw new IOException("UnknownHostException: " + une.getMessage());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            logger.writeln(ioe.getMessage());
            logger.writeln(ioe);
            logger.stop();
            throw ioe;
        }
        if (!rhookPropFile.exists()) {
            rhookPropFile.createNewFile();
        }
        FileOutputStream out = new FileOutputStream(rhookPropFile);
        rHookProps.store(out, "----- Last Saved @ " + RHook.getDateTime() + " -----");
        out.close();
    }

    public static REXP evalR(String cmd) throws Exception {
        REXP x;
        try {
            logger.writeln(cmd);
            x = re.eval(cmd);
        }
        catch (Exception e) {
            logger.writeln("Rengine eval error");
            logger.writeln(e.getMessage());
            logger.writeln(e);
            throw e;
        }
        return x;
    }

    public String[] listLibs() {
        System.out.println("Raktim: Test Code");
        System.out.println("Counting Libs Installed");
        System.out.println("Parsing");
        long e = re.rniParse("installed.packages()", 1);
        System.out.println("Result = " + e + ", running eval");
        long r = re.rniEval(e, 0L);
        System.out.println("Result = " + r + ", building REXP");
        REXP x = new REXP(re, r);
        System.out.println("REXP result = " + x);
        System.out.println("REXP result = " + x.asString());
        String[] d = x.asStringArray();
        if (d != null) {
            System.out.println(d.length + " packages installed");
        }
        return d;
    }

    public static void installModule(String modName) throws Exception {
        REXP x = RHook.evalR("which(as.character(installed.packages()[,1])=='" + modName.trim() + "')");
        if (x.asInt() != 0) {
            System.out.println(modName + " Package Installed");
            logger.writeln(modName + " Package ALready Installed");
        } else {
            RHook.evalR("source(\"http://www.bioconductor.org/biocLite.R\")");
            RHook.evalR("biocLite(\"" + modName.trim() + "\")");
            logger.writeln(modName + " Package Installed from BioC");
        }
    }

    public static void testPackage(String moduleName) throws Exception {
        logger.writeln("Checking Package - " + moduleName + " and dependencies..");
        String pkgPath = RHook.getPkgPath();
        String r_ver = RHook.getCurrentRversion();
        String pkg = rHookProps.getProperty(moduleName + "_" + RHook.getOSbyName() + "_" + r_ver + "_" + RHook.getARCHbyName());
        if (pkg == null) {
            throw new Exception("Properties not found for Module: " + moduleName);
        }
        String[] pkgs = pkg.split(":");
        ArrayList<String> pkgsToDownload = RHook.markPkgsToDownload(pkgPath, pkgs);
        if (pkgsToDownload.size() > 0) {
            System.out.println("To Download: " + pkgsToDownload.size() + " packages");
            System.out.println("First Pkg: " + pkgsToDownload.get(0));
            System.out.println("Last Pkg: " + pkgsToDownload.get(pkgsToDownload.size() - 1));
            String os = RHook.getOSbyName();
            String arch = RHook.getARCHbyName();
            ArrayList<String> pkg_url_list = RHook.createPkgUrls("ftp://occams.dfci.harvard.edu/pub/bio/MeV_Etc/R_MeV_Support_devel/R" + r_ver + "/" + os + "/" + moduleName, pkgsToDownload);
            RHook.updatePackages(pkg_url_list, pkgPath);
        }
        for (int i = 0; i < pkgs.length; ++i) {
            String libName = pkgs[i].substring(0, pkgs[i].indexOf("_"));
            REXP x = RHook.evalR("which(as.character(installed.packages()[,1])=='" + libName + "')");
            if (x.asInt() != 0) {
                System.out.println(pkgs[i] + " Package Installed");
                logger.writeln(pkgs[i] + " Package Installed");
                continue;
            }
            System.out.println(pkgs[i] + " Package NOT Installed");
            System.out.println("**** Attempting to install" + libName + " from local rep ***** " + pkgs[i]);
            logger.writeln(moduleName + " Package NOT Installed");
            logger.writeln("**** Attempting to install" + libName + " from local rep ***** " + pkgs[i]);
            RHook.evalR("install.packages('" + pkgPath.replace("\\", "/") + "/" + pkgs[i] + "', repos=NULL)");
        }
    }

    private static String getCurrentRversion() throws Exception {
        if (RHook.getOS() == 3) {
            return RHook.getLastMacRVersion();
        }
        return rHookProps.getProperty("cur_r_ver").trim();
    }

    private static String getLastMacRVersion() throws Exception {
        if (macRVersionProp != null) {
            return macRVersionProp.getProperty("cur_mac_r_ver");
        }
        macRVersionProp = new Properties();
        String ver = rHookProps.getProperty("cur_mac_r_ver");
        try {
            File mevUserDir = new File(System.getProperty("user.home"), ".mev");
            File rhookVersionFile = new File(mevUserDir, "rhook.version.properties");
            if (!rhookVersionFile.exists()) {
                rhookVersionFile.createNewFile();
                FileOutputStream out = new FileOutputStream(rhookVersionFile);
                macRVersionProp.setProperty("cur_mac_r_ver", ver);
                macRVersionProp.store(out, "----- Last Saved @" + RHook.getDateTime() + " -----");
                out.close();
            } else {
                FileInputStream in = new FileInputStream(rhookVersionFile);
                macRVersionProp.load(in);
                ((InputStream)in).close();
                ver = macRVersionProp.getProperty("cur_mac_r_ver");
            }
        }
        catch (Exception e) {
            logger.writeln("Error reading last Mac R Version.");
            logger.writeln(e);
            macRVersionProp = null;
            throw e;
        }
        return ver;
    }

    private static void setLastMacRVersion() throws Exception {
        try {
            File mevUserDir = new File(System.getProperty("user.home"), ".mev");
            File rhookVersionFile = new File(mevUserDir, "rhook.version.properties");
            FileInputStream in = new FileInputStream(rhookVersionFile);
            macRVersionProp.load(in);
            ((InputStream)in).close();
        }
        catch (Exception e) {
            logger.writeln("Error saving last Mac R Version.");
            logger.writeln(e);
            throw e;
        }
    }

    private static String getPkgPath() {
        String pkgPath = System.getProperty("user.dir") + System.getProperty("file.separator") + RConstants.R_PACKAGE_DIR;
        return pkgPath;
    }

    private static ArrayList<String> markPkgsToDownload(String lookupfolder, String[] pkgs) {
        ArrayList<String> pkgsToDownload = new ArrayList<String>();
        for (int i = 0; i < pkgs.length; ++i) {
            File f = new File(lookupfolder + "/" + pkgs[i].trim());
            if (f.exists()) continue;
            pkgsToDownload.add(pkgs[i].trim());
        }
        return pkgsToDownload;
    }

    public static void endR() {
        re.end();
        System.out.println("ended R session");
    }

    public static REXP createRDataMatrix(String name, FloatMatrix fm) {
        REXP x = null;
        int row = fm.getRowDimension();
        int col = fm.getColumnDimension();
        String srtVector = "c(";
        int jCol = 0;
        for (int iRow = 0; iRow < row; ++iRow) {
            for (jCol = 0; jCol < col - 1; ++jCol) {
                srtVector = srtVector + fm.get(iRow, jCol) + ",";
            }
            srtVector = srtVector + fm.get(iRow, jCol);
        }
        srtVector = srtVector + ")";
        String cmdR = name + "<- matrix(" + srtVector + ",nrow=" + row + ",ncol=" + col + ",byrow=TRUE)";
        System.out.println("createRDataMatrix " + cmdR);
        re.eval(cmdR);
        x = re.eval(name);
        return x;
    }

    public static REXP createRDataMatrix(String name, FloatMatrix fm, ArrayList<String> rowNames, ArrayList<String> colNames) {
        int iRow;
        REXP x = null;
        int row = fm.getRowDimension();
        int col = fm.getColumnDimension();
        String srtVector = "c(";
        int jCol = 0;
        for (int iRow2 = 0; iRow2 < row; ++iRow2) {
            for (jCol = 0; jCol < col - 1; ++jCol) {
                srtVector = srtVector + fm.get(iRow2, jCol) + ",";
            }
            srtVector = srtVector + fm.get(iRow2, jCol);
        }
        srtVector = srtVector + ")";
        String dimnames = "dimnames = list(";
        String rNames = "c(";
        for (iRow = 0; iRow < row - 1; ++iRow) {
            rNames = rNames + "'" + rowNames.get(iRow) + "',";
        }
        rNames = rNames + "'" + rowNames.get(iRow) + "')";
        String cNames = "c(";
        for (iRow = 0; iRow < row - 1; ++iRow) {
            cNames = cNames + "'" + colNames.get(iRow) + "',";
        }
        cNames = cNames + "'" + colNames.get(iRow) + "')";
        dimnames = dimnames + rNames + "," + cNames + ")";
        String cmdR = name + "<- matrix(" + srtVector + ",nrow=" + row + ",ncol=" + col + ",byrow=TRUE," + dimnames + ")";
        System.out.println("createRDataMatrix " + cmdR);
        re.eval(cmdR);
        x = re.eval(name);
        return x;
    }

    public static REXP createRDataMatrix(String name, FloatMatrix fm, String[] rowNames, String[] colNames) {
        int iRow;
        REXP x = null;
        int row = fm.getRowDimension();
        int col = fm.getColumnDimension();
        String srtVector = "c(";
        for (int iRow2 = 0; iRow2 < row; ++iRow2) {
            for (int jCol = 0; jCol < col; ++jCol) {
                srtVector = iRow2 == row - 1 & jCol == col - 1 ? srtVector + fm.get(iRow2, jCol) : srtVector + fm.get(iRow2, jCol) + ",";
            }
        }
        srtVector = srtVector + ")";
        String dimnames = "dimnames = list(";
        String rNames = "c(";
        for (iRow = 0; iRow < row - 1; ++iRow) {
            rNames = rNames + "'" + rowNames[iRow] + "',";
        }
        rNames = rNames + "'" + rowNames[iRow] + "')";
        String cNames = "c(";
        for (iRow = 0; iRow < col - 1; ++iRow) {
            cNames = cNames + "'" + colNames[iRow] + "',";
        }
        cNames = cNames + "'" + colNames[iRow] + "')";
        dimnames = dimnames + rNames + "," + cNames + ")";
        String cmdR = name + "<- matrix(" + srtVector + ",nrow=" + row + ",ncol=" + col + ",byrow=TRUE," + dimnames + ")";
        System.out.println("createRDataMatrix " + cmdR);
        re.eval(cmdR);
        x = re.eval(name);
        return x;
    }

    private static void cleanUp() throws Exception {
        RHook.evalR("rm(list = ls())");
    }

    public static void endRSession() throws Exception {
        RHook.cleanUp();
        logger.stop();
    }

    public static void createRDataMatrixFromFile(String rObj, String filePath, boolean rowNames, String[] colNames) throws Exception {
        int iRow;
        String cNames = "cols <- c(0,";
        for (iRow = 0; iRow < colNames.length - 1; ++iRow) {
            cNames = cNames + "'" + colNames[iRow] + "',";
        }
        cNames = cNames + "'" + colNames[iRow] + "')";
        RHook.evalR(cNames);
        String cmdR = rObj + " <- read.delim('" + filePath + "', header=FALSE, sep='\t', row.names=1, col.names=cols)";
        RHook.evalR(cmdR);
        RHook.evalR(rObj + " <- as.matrix(" + rObj + ")");
    }

    public static void createRDataFrameFromFile(String rObj, String filePath, boolean rowNames, String[] colNames) throws Exception {
        int iRow;
        String cNames = "cols <- c(0,";
        for (iRow = 0; iRow < colNames.length - 1; ++iRow) {
            cNames = cNames + "'" + colNames[iRow] + "',";
        }
        cNames = cNames + "'" + colNames[iRow] + "')";
        RHook.evalR(cNames);
        String cmdR = rObj + " <- read.delim('" + filePath + "', header=FALSE, sep='\t', row.names=1, col.names=cols)";
        RHook.evalR(cmdR);
    }

    public static void log(Exception e) {
        logger.writeln(e);
    }

    public static void log(String str) {
        logger.writeln(str);
    }

    public static int getOS() {
        String os = System.getProperty("os.name");
        if (os.toLowerCase().contains("mac")) {
            return 3;
        }
        if (os.toLowerCase().contains("linux")) {
            return 2;
        }
        if (os.toLowerCase().contains("win")) {
            return 1;
        }
        return -1;
    }

    public static String getOSbyName() {
        String os = System.getProperty("os.name");
        if (os.toLowerCase().contains("mac")) {
            return "mac";
        }
        if (os.toLowerCase().contains("linux")) {
            return "linux";
        }
        if (os.toLowerCase().contains("win")) {
            return "win";
        }
        return "unknown";
    }

    private static int getARCH() {
        String arch = System.getProperty("os.arch");
        if (arch.toLowerCase().contains("386") || arch.toLowerCase().contains("x86") || arch.toLowerCase().contains("32")) {
            return 1;
        }
        if (arch.toLowerCase().contains("686") || arch.toLowerCase().contains("64")) {
            return 2;
        }
        return -2;
    }

    private static String getARCHbyName() {
        String arch = System.getProperty("os.arch");
        if (arch.toLowerCase().contains("386") || arch.toLowerCase().contains("x86") || arch.toLowerCase().contains("32")) {
            return "32";
        }
        if (arch.toLowerCase().contains("686") || arch.toLowerCase().contains("64")) {
            return "64";
        }
        return "UNKNOWN_ARCH";
    }

    public static boolean Mac_R_ver_Changed() throws Exception {
        String r_home = System.getenv("R_HOME");
        if (r_home == null || r_home == "") {
            System.err.println("** R_HOME not avaialble or not set properly.");
            throw new Exception("R_HOME not set or available.\n** Possible Causes:\n** MeV launched via WebStart");
        }
        if (!new File(r_home).exists()) {
            System.err.println("R_HOME dir: " + r_home + " does not exist.");
            throw new Exception("R_HOME dir: " + r_home + "does not exist.\n** Possible Causes:\n** MeV launched via WebStart\n** " + r_home + " location removed");
        }
        String ver = RHook.getMacRversionFromRFramework("/Library/Frameworks/R.framework/Versions/Current").trim();
        System.out.println("Mac OS X current R version: " + ver);
        String last_used_ver = RHook.getCurrentRversion().trim();
        System.out.println("Mac OS X last R version: " + last_used_ver);
        return !ver.equals(last_used_ver);
    }

    public static boolean updateRDynLib() throws Exception {
        String ver = RHook.getMacRversionFromRFramework("/Library/Frameworks/R.framework/Versions/Current").trim();
        String os = RHook.getOSbyName();
        String arch = RHook.getARCHbyName();
        ArrayList<String> r_versionList = RHook.getValuesFrmProp(os + "_r_versions");
        ArrayList<String> archList = RHook.getValuesFrmProp(os + "_arch");
        if (!r_versionList.contains(ver)) {
            System.out.println("R version: " + ver + " not yet supported");
            throw new Exception("R version: " + ver + " not yet supported");
        }
        if (!archList.contains(arch)) {
            System.out.println(os + " " + arch + " bit not yet supported");
            throw new Exception(os + " " + arch + " bit not yet supported");
        }
        String lib_url = "ftp://occams.dfci.harvard.edu/pub/bio/MeV_Etc/R_MeV_Support_devel/R" + ver + "/" + os + "/" + RHook.getLibraryName();
        RHook.updateRLib(lib_url);
        RHook.setLastMacRVersion();
        return true;
    }

    private static void updateRLib(String libUrl) throws Exception {
        String lib_dest = System.getProperty("user.dir") + "/" + "MeV.app/Contents/Resources/Java";
        String fileName = RHook.getFileNameFromURL(libUrl);
        System.out.println("updateLibAndPackages remote LIB " + fileName);
        RHook.getRemoteFile(libUrl, lib_dest + "/" + fileName);
    }

    private static void updatePackages(ArrayList<String> pkgUrlList, String pkg_dest) throws Exception {
        for (int i = 0; i < pkgUrlList.size(); ++i) {
            String fileName = RHook.getFileNameFromURL(pkgUrlList.get(i));
            System.out.println("updateLibAndPackages remote PKG " + fileName);
            RHook.getRemoteFile(pkgUrlList.get(i), pkg_dest + "/" + fileName);
        }
    }

    private static String getFileNameFromURL(String libUrl) {
        System.out.println("getFileNameFromURL " + libUrl.substring(libUrl.lastIndexOf("/") + 1));
        return libUrl.substring(libUrl.lastIndexOf("/") + 1);
    }

    private static void getRemoteFile(String libUrl, String libDest) throws Exception {
        int bytesRead;
        InputStream uis;
        String newFName = libDest;
        System.out.println("To Download: " + newFName);
        try {
            URL url = new URL(libUrl);
            uis = url.openConnection().getInputStream();
        }
        catch (Exception e) {
            logger.writeln(libUrl + " could not be retreived");
            logger.writeln(e.getMessage());
            logger.writeln(e);
            throw new Exception(libUrl + " could not be retreived");
        }
        File old = new File(newFName);
        if (old.exists()) {
            String reNameTo = newFName + "_" + RHook.getCurrentRversion() + "_" + RHook.getDateTime();
            if (!old.renameTo(new File(reNameTo))) {
                throw new IOException(newFName + " could not be renamed");
            }
            System.out.println("getRemoteFile: Renamed to " + reNameTo);
        }
        FileOutputStream fos = new FileOutputStream(newFName);
        byte[] buf = new byte[1024];
        while ((bytesRead = uis.read(buf, 0, buf.length)) > 0) {
            ((OutputStream)fos).write(buf, 0, bytesRead);
        }
        ((OutputStream)fos).close();
        uis.close();
        System.out.print("Downloaded: " + newFName);
        System.out.println("\t >>>>>>>>>>>>>>>>>>>");
    }

    private static ArrayList<String> createPkgUrls(String baseUrl, ArrayList<String> rModuleList) {
        System.out.println("createPkgUrls: baseUrl " + baseUrl);
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < rModuleList.size(); ++i) {
            String tmp = rModuleList.get(i);
            result.add(baseUrl + "/" + rModuleList.get(i));
            System.out.println("added PkgUrls " + result.get(result.size() - 1));
        }
        return result;
    }

    private static ArrayList<String> getValuesFrmHash(Hashtable<String, String> repHash, String key) {
        System.out.println("repHash size " + repHash.size());
        return new ArrayList<String>(Arrays.asList(repHash.get(key).split(":")));
    }

    private static ArrayList<String> getValuesFrmProp(String key) {
        return new ArrayList<String>(Arrays.asList(rHookProps.getProperty(key).split(":")));
    }

    public static Properties getPropInfoRhook() throws ConnectException, MalformedURLException, IOException {
        if (rHookProps != null) {
            return rHookProps;
        }
        rHookProps = new ConfMap();
        try {
            URLConnection conn = new URL("ftp://occams.dfci.harvard.edu/pub/bio/MeV_Etc/R_MeV_Support_devel/rhook.txt").openConnection();
            rHookProps.load(conn.getInputStream());
        }
        catch (UnknownHostException une) {
            rHookProps = null;
            System.out.println("Could not retreive RHook Web Property file.");
            une.printStackTrace();
            throw une;
        }
        catch (ConnectException e) {
            rHookProps = null;
            System.out.println("Could not retreive RHook Web Property file.");
            e.printStackTrace();
            throw e;
        }
        return rHookProps;
    }

    static void checkMacR() throws Exception {
        if (RHook.getOS() != 3) {
            return;
        }
        try {
            if (RHook.Mac_R_ver_Changed() && !RHook.updateRDynLib()) {
                throw new Exception("Error updating R library");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("Error updating R library\n **" + e.getMessage());
        }
    }

    private static Hashtable<String, String> parseProp(InputStream is) throws IOException {
        String line;
        String os = RHook.getOSbyName();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        Hashtable<String, String> currHash = new Hashtable<String, String>();
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#")) continue;
            String[] keyValue = line.split("=");
            System.out.println("URL Config: " + keyValue[0] + "-" + keyValue[1]);
            currHash.put(keyValue[0], keyValue[1]);
        }
        return currHash;
    }

    public static boolean isSymlink(File file) throws IOException {
        File canon;
        if (file == null) {
            throw new NullPointerException("File must not be null");
        }
        if (file.getParent() == null) {
            canon = file;
        } else {
            File canonDir = file.getParentFile().getCanonicalFile();
            canon = new File(canonDir, file.getName());
        }
        return !canon.getCanonicalFile().equals(canon.getAbsoluteFile());
    }

    public static String getMacRversionFromRFramework(String curRpath) throws IOException {
        File file = new File(curRpath);
        try {
            System.out.println("Absolute path : " + file.getAbsoluteFile());
            System.out.println("Canonical path: " + file.getCanonicalFile());
            if (RHook.isSymlink(file)) {
                System.out.println("Path is a link");
            } else {
                System.out.println("Path is NOT a link");
            }
            String can = file.getCanonicalPath();
            String ver = can.substring(can.lastIndexOf("/") + 1);
            System.out.println("Mac R version from Link: " + ver);
            return ver;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw ioe;
        }
    }

    private void setLibPath() throws Exception {
        String libPath = System.getenv("R_HOME");
        libPath = libPath.replace("\\", "/");
        libPath = libPath + "/library";
        String rCmd = ".libPaths('" + libPath + "')";
        System.out.println("libPath cmd " + rCmd);
        RHook.evalR(rCmd);
        rCmd = ".libPaths()";
        REXP rx = RHook.evalR(rCmd);
        System.out.println("Curr libPath " + rx.asStringArray()[0]);
    }

    private static void ifExistRlib() throws Exception {
        String lib = RHook.getOS() == 3 ? System.getProperty("user.dir") + "/" + "MeV.app/Contents/Resources/Java" + "/" + RHook.getLibraryName() : System.getProperty("user.dir") + "/lib/" + RHook.getLibraryName();
        if (!new File(lib).exists()) {
            System.err.println("R_HOME dir: " + lib + " does not exist.");
            logger.writeln("R JRI lib: " + lib + "does not exist.");
            logger.stop();
            throw new Exception("R JRI lib: " + lib + "does not exist.");
        }
    }

    private static void ifExistRhome(String r_home) throws Exception {
        if (!new File(r_home).exists()) {
            System.err.println("R_HOME dir: " + r_home + " does not exist.");
            logger.writeln("R_HOME dir: " + r_home + " does not exist.");
            logger.writeln("** Possible Causes:");
            logger.writeln("** MeV launched via WebStart");
            logger.writeln("** " + r_home + " location removed");
            logger.stop();
            throw new Exception("R_HOME dir: " + r_home + "does not exist.\n** Possible Causes:\n** MeV launched via WebStart\n** " + r_home + " location removed");
        }
    }

    private static void isRhomeSet(String r_home) throws Exception {
        if (r_home == null || r_home == "") {
            System.err.println("** R_HOME not avaialble or not set properly.");
            logger.writeln("** R_HOME not avaialble or not set properly.");
            logger.writeln("** Possible Causes:");
            logger.writeln("** MeV launched via WebStart");
            logger.stop();
            throw new Exception("R_HOME not set or available.\n** Possible Causes:\n** MeV launched via WebStart");
        }
    }

    private static String getLibraryName() {
        int os = RHook.getOS();
        switch (os) {
            case 3: {
                return "libjri.jnilib";
            }
            case 1: {
                return "jri.dll";
            }
            case 2: {
                return "libjri.so";
            }
        }
        return null;
    }

    private static String getDateTime() {
        Date now = new Date();
        String dateString = now.toString();
        SimpleDateFormat formatDt = new SimpleDateFormat("MMM_dd_yy_HH:mm:ss");
        dateString = formatDt.format(now);
        return dateString;
    }

    public static String getLogFileName() {
        return RLogger.getLogFileName();
    }
}

