/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.remote.protocol.serializer;

import java.io.OutputStream;
import java.io.PrintStream;
import org.tigr.remote.protocol.Request;
import org.tigr.remote.protocol.StartJob;
import org.tigr.remote.protocol.StartingJob;
import org.tigr.remote.protocol.StartingJobVisitor;
import org.tigr.remote.protocol.StopJob;
import org.tigr.remote.protocol.serializer.BreakFilterStream;
import org.tigr.remote.protocol.serializer.MAGESerializer;
import org.tigr.remote.protocol.serializer.RequestSerializer;
import org.tigr.remote.protocol.serializer.SerializerException;
import org.tigr.remote.protocol.serializer.Util;
import org.tigr.remote.protocol.serializer.XMLIndent;

class RequestSerializerImpl
extends RequestSerializer {
    @Override
    public void serializeRequest(Request req, OutputStream out) throws SerializerException {
        PrintStream p = new PrintStream(out);
        XMLIndent ind = new XMLIndent();
        p.println("<?xml version=\"1.0\"?>");
        p.println("<request>");
        ind.inc();
        StartingJobSerializer ser = new StartingJobSerializer(p, ind);
        StartingJob job = req.getJob();
        if (job != null) {
            job.accept(ser);
        }
        ind.dec();
        p.println("</request>");
    }

    class StartingJobSerializer
    implements StartingJobVisitor {
        private PrintStream m_out;
        private XMLIndent m_ind;

        public StartingJobSerializer(PrintStream out, XMLIndent ind) {
            this.m_out = out;
            this.m_ind = ind;
        }

        @Override
        public void visitStartJob(StartJob job) {
            this.m_ind.print(this.m_out);
            this.m_out.println("<start-job id=\"" + Util.escape(job.getId()) + "\"  type=\"" + Util.escape(job.getType()) + "\"   >");
            this.m_ind.inc();
            this.m_ind.print(this.m_out);
            this.m_out.println("<job-data>");
            BreakFilterStream bfs = new BreakFilterStream(this.m_out);
            PrintStream out = new PrintStream(bfs);
            MAGESerializer serializer = new MAGESerializer(out);
            serializer.serialize(job.getData().getData());
            out.flush();
            out = null;
            this.m_out.println();
            this.m_out.println("</job-data>");
            this.m_ind.dec();
            this.m_ind.print(this.m_out);
            this.m_out.println("</start-job>");
        }

        @Override
        public void visitStopJob(StopJob job) {
            this.m_ind.print(this.m_out);
            this.m_out.println("<stop-job id=\"" + Util.escape(job.getId()) + "\"/>");
        }
    }
}

