/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.remote.protocol.serializer;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.remote.protocol.serializer.Util;
import org.tigr.remote.protocol.serializer.XMLIndent;
import org.tigr.util.FloatMatrix;

class MAGESerializer {
    private static final int BREAK_AFTER = 10240;
    private PrintStream m_out;
    private XMLIndent m_ind = new XMLIndent();

    public MAGESerializer(PrintStream out) {
        this.m_out = out;
    }

    public void serialize(AlgorithmData data) {
        this.m_out.println("<MAGE-ML identifier = \"TIGR:Clustering Request\">");
        this.m_ind.inc();
        this.m_ind.print(this.m_out);
        if (data.getMatrixes().size() > 0 || data.getProperties().size() > 0) {
            this.m_out.println("<BioAssayData_package>");
            this.m_ind.inc();
            this.m_ind.print(this.m_out);
            this.m_out.println("<BioAssayData_assnlist>");
            this.m_ind.inc();
            this.m_ind.print(this.m_out);
            Iterator iter = data.getMatrixes().entrySet().iterator();
            while (iter.hasNext()) {
                this.serializeMatrix(iter.next());
            }
            this.serializeParams(data.getParams());
            this.m_ind.dec();
            this.m_ind.print(this.m_out);
            this.m_out.println("</BioAssayData_assnlist>");
            this.m_ind.dec();
            this.m_ind.print(this.m_out);
            this.m_out.println("</BioAssayData_package>");
            this.m_ind.dec();
            this.m_ind.print(this.m_out);
            this.m_out.println("</MAGE-ML>");
        }
    }

    private void serializeMatrix(Map.Entry s) {
        FloatMatrix mtx = (FloatMatrix)s.getValue();
        String name = Util.escape((String)s.getKey());
        this.m_ind.inc();
        this.m_ind.print(this.m_out);
        this.m_out.println("<DerivedBioAssayData identifier =\"" + name + "\" >");
        this.m_ind.inc();
        this.m_ind.print(this.m_out);
        this.m_out.println("<BioDataValues_assn>");
        this.m_ind.inc();
        this.m_ind.print(this.m_out);
        this.m_out.println("<BioDataCube>");
        this.m_ind.inc();
        this.m_ind.print(this.m_out);
        this.m_out.println("<PropertySets_assnlist>");
        this.m_ind.inc();
        this.m_ind.print(this.m_out);
        this.m_out.println("<NameValueType name=\"cols\" value=\"" + mtx.getColumnDimension() + "\" />");
        this.m_ind.print(this.m_out);
        this.m_out.println("<NameValueType name=\"rows\" value=\"" + mtx.getRowDimension() + "\" />");
        this.m_ind.print(this.m_out);
        this.m_ind.dec();
        this.m_ind.print(this.m_out);
        this.m_out.println("</PropertySets_assnlist>");
        this.m_out.println("         <BioAssayDimension_assnref> \n              <BioAssayDimension_ref identifier=\"UNDEFINED\"/> \n          </BioAssayDimension_assnref> \n          <DesignElementDimension_assnref> \n            <DesignElementDimension_ref identifier=\"UNDEFINED\"/> \n          </DesignElementDimension_assnref> \n          <QuantitationTypeDimension_assnref> \n             <QuantitationTypeDimension_ref identifier=\"UNDEFINED\"/> \n          </QuantitationTypeDimension_assnref> \n          <DataInternal_assn> \n             <DataInternal>");
        float[][] arr = mtx.getArray();
        int maxCols = mtx.getColumnDimension();
        int maxRows = mtx.getRowDimension();
        int br = 0;
        for (int j = 0; j < maxRows; ++j) {
            for (int i = 0; i < maxCols; ++i) {
                float toPrint = arr[j][i];
                if (Float.isNaN(toPrint)) {
                    this.m_out.print("NaN ");
                } else {
                    this.m_out.print(toPrint);
                    this.m_out.print(' ');
                }
                if (++br != 10240) continue;
                br = 0;
                this.m_out.print("\r\n<?break?>\r\n");
            }
        }
        this.m_out.println("             </DataInternal> \n          </DataInternal_assn>");
        this.m_ind.dec();
        this.m_ind.print(this.m_out);
        this.m_out.println("</BioDataCube>");
        this.m_ind.dec();
        this.m_ind.print(this.m_out);
        this.m_out.println("</BioDataValues_assn>");
        this.m_ind.dec();
        this.m_ind.print(this.m_out);
        this.m_out.println("</DerivedBioAssayData>");
    }

    private void serializeParams(AlgorithmParameters params) {
        this.m_ind.print(this.m_out);
        this.m_out.println("<DerivedBioAssayData identifier=\"parameters\">");
        this.m_ind.print(this.m_out);
        this.m_out.println("   <PropertySets_assnlist>");
        this.m_ind.print(this.m_out);
        for (Map.Entry entry : params.entrySet()) {
            String name = Util.escape((String)entry.getKey());
            String value = Util.escape((String)entry.getValue());
            this.m_ind.print(this.m_out);
            this.m_out.println("        <NameValueType name=\"" + name + "\" value=\"" + value + "\" />");
        }
        this.m_ind.print(this.m_out);
        this.m_out.println("   </PropertySets_assnlist>");
        this.m_ind.print(this.m_out);
        this.m_out.println("</DerivedBioAssayData>");
    }

    private void serializeCluster(Cluster s) {
    }
}

