/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.remote.protocol.parser;

import de.mnl.java.io.base64.Base64InputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.remote.protocol.ExecutedJob;
import org.tigr.remote.protocol.Fail;
import org.tigr.remote.protocol.FailedJob;
import org.tigr.remote.protocol.FinishedJob;
import org.tigr.remote.protocol.JobData;
import org.tigr.remote.protocol.Response;
import org.tigr.remote.protocol.SuccessfulJob;
import org.tigr.remote.protocol.parser.ResponseHandlerBase;
import org.tigr.remote.protocol.parser.XMLMAGEParser;
import org.tigr.remote.protocol.util.TempFile;
import org.tigr.util.ConfMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class SAXResponseHandler
extends ResponseHandlerBase {
    private FinishedJob m_job = null;
    private Response m_result = new Response(null);
    private boolean m_inJobData = false;
    private Writer m_mageStorage = null;
    private String m_mageFileName;
    private Fail m_fail;
    private AlgorithmEvent m_event;
    private StringBuffer m_chars = new StringBuffer();

    public SAXResponseHandler(ConfMap cfg) {
        super(cfg);
    }

    @Override
    public void endDocument() {
        this.m_job = null;
        this.m_mageStorage = null;
        this.m_mageFileName = null;
        this.m_fail = null;
        this.m_event = null;
        this.m_chars = null;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attrs) throws SAXException {
        block13: {
            super.startElement(uri, localName, name, attrs);
            try {
                this.m_chars = new StringBuffer();
                if (name.equals("response")) break block13;
                if (name.equals("successful-job")) {
                    String[] path = new String[]{"response", "successful-job"};
                    this.m_path.checkFromTopThrow(path);
                    String jobId = attrs.getValue("id");
                    this.m_job = new SuccessfulJob(jobId, new JobData(null));
                    this.m_result = new Response(this.m_job);
                    break block13;
                }
                if (name.equals("failed-job")) {
                    String[] path = new String[]{"response", "failed-job"};
                    this.m_path.checkFromTopThrow(path);
                    String jobId = attrs.getValue("id");
                    this.m_job = new FailedJob(jobId, null);
                    this.m_result = new Response(this.m_job);
                    break block13;
                }
                if (name.equals("executed-job")) {
                    String[] path = new String[]{"response", "executed-job"};
                    this.m_path.checkFromTopThrow(path);
                    String jobId = attrs.getValue("id");
                    this.m_job = new ExecutedJob(jobId, null);
                    this.m_result = new Response(this.m_job);
                    break block13;
                }
                if (name.equals("job-data")) {
                    String[] path = new String[]{"response", "successful-job", "job-data"};
                    this.m_path.checkFromTopThrow(path);
                    TempFile tmp = new TempFile(this.m_config);
                    this.m_mageFileName = tmp.getName("MAGE.base64");
                    this.m_mageStorage = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.m_mageFileName)));
                    break block13;
                }
                if (name.equals("fail")) {
                    String[] path = new String[]{"response", "failed-job", "fail"};
                    this.m_path.checkFromTopThrow(path);
                    String id = attrs.getValue("id");
                    this.m_fail = new Fail(id, null);
                    ((FailedJob)this.m_job).setFail(this.m_fail);
                    break block13;
                }
                if (name.equals("event")) {
                    String[] path = new String[]{"response", "executed-job", "event"};
                    this.m_path.checkFromTopThrow(path);
                    String id = attrs.getValue("id");
                    int i = 0;
                    try {
                        i = Integer.parseInt(id);
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                    this.m_event = new AlgorithmEvent((Object)this, i);
                    ((ExecutedJob)this.m_job).setEvent(this.m_event);
                    break block13;
                }
                if (name.equals("progress")) {
                    String[] path = new String[]{"response", "executed-job", "event", "progress"};
                    this.m_path.checkFromTopThrow(path);
                    break block13;
                }
                if (name.equals("float-value")) {
                    String[] path = new String[]{"response", "executed-job", "event", "float-value"};
                    this.m_path.checkFromTopThrow(path);
                    break block13;
                }
                if (name.equals("description")) {
                    String[] path = new String[]{"response", "executed-job", "event", "description"};
                    this.m_path.checkFromTopThrow(path);
                    break block13;
                }
                throw new Exception("Unexpected element: " + name);
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
                this.processError(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        block17: {
            try {
                if (name.equals("fail")) {
                    this.m_fail.setDescription(this.m_chars.toString());
                    break block17;
                }
                if (name.equals("job-data")) {
                    int cnt;
                    boolean keepFiles = this.m_config.getBoolean("remote.debug.keep-response-files", false);
                    this.m_mageStorage.close();
                    this.m_mageStorage = null;
                    TempFile tmp = new TempFile(this.m_config);
                    String fname = tmp.getName("MAGE");
                    Base64InputStream in = new Base64InputStream((InputStream)new BufferedInputStream(new FileInputStream(this.m_mageFileName)));
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(fname));
                    byte[] b = new byte[102400];
                    while ((cnt = in.read(b)) >= 0) {
                        ((OutputStream)out).write(b, 0, cnt);
                    }
                    in.close();
                    ((OutputStream)out).close();
                    in = null;
                    out = null;
                    if (!keepFiles) {
                        new File(this.m_mageFileName).delete();
                    }
                    XMLMAGEParser parser = new XMLMAGEParser(this.m_config);
                    parser.parse(fname);
                    ((SuccessfulJob)this.m_job).getData().setData(parser.getResult());
                    if (!keepFiles) {
                        new File(fname).delete();
                    }
                    break block17;
                }
                if (name.equals("progress")) {
                    String str = this.m_chars.toString();
                    try {
                        int i = Integer.parseInt(str);
                        this.m_event.setIntValue(i);
                        break block17;
                    }
                    catch (NumberFormatException ex) {
                        throw new Exception("invalid progress integer value: " + str);
                    }
                }
                if (name.equals("float-value")) {
                    String str = this.m_chars.toString();
                    try {
                        float i = Float.parseFloat(str);
                        this.m_event.setFloatValue(i);
                        break block17;
                    }
                    catch (NumberFormatException ex) {
                        throw new Exception("invalid float value: " + str);
                    }
                }
                if (name.equals("description")) {
                    this.m_event.setDescription(this.m_chars.toString());
                }
            }
            catch (Exception ex) {
                this.processError(ex);
            }
            finally {
                super.endElement(uri, localName, name);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            if (this.getCurrentElement().equals("job-data")) {
                this.m_mageStorage.write(ch, start, length);
            } else {
                this.m_chars.append(ch, start, length);
            }
        }
        catch (Exception ex) {
            this.processError(ex);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    public Response getResponse() {
        return this.m_result;
    }
}

