/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.remote.protocol.parser;

import java.util.LinkedList;
import org.tigr.remote.protocol.parser.CheckPath;
import org.tigr.remote.protocol.parser.ParserException;
import org.tigr.util.ConfMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class ResponseHandlerBase
extends DefaultHandler {
    private LinkedList m_elements = new LinkedList();
    protected CheckPath m_path = new CheckPath(this.m_elements);
    protected ConfMap m_config;

    public ResponseHandlerBase(ConfMap cfg) {
        this.m_config = cfg;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.m_elements.addLast(qName);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.m_elements.removeLast();
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
        this.processError(new Exception("[Warning] " + this.getLocationString(ex) + ": " + ex.getMessage()));
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        this.processError(new Exception("[Error] " + this.getLocationString(ex) + ": " + ex.getMessage()));
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        this.processError(new Exception("[FatalError] " + this.getLocationString(ex) + ": " + ex.getMessage()));
    }

    private String getLocationString(SAXParseException ex) {
        StringBuffer str = new StringBuffer();
        String systemId = ex.getSystemId();
        if (systemId != null) {
            int index = systemId.lastIndexOf(47);
            if (index != -1) {
                systemId = systemId.substring(index + 1);
            }
            str.append(systemId);
        }
        str.append(':');
        str.append(ex.getLineNumber());
        str.append(':');
        str.append(ex.getColumnNumber());
        return str.toString();
    }

    protected String getCurrentElement() {
        return (String)this.m_elements.getLast();
    }

    protected void processError(Exception ex) throws SAXException {
        throw new SAXException(new ParserException("Processing error", ex));
    }
}

