/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.remote.protocol.parser;

import java.util.LinkedList;
import java.util.StringTokenizer;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.remote.protocol.parser.FloatVectorParser;
import org.tigr.remote.protocol.parser.IntVectorParser;
import org.tigr.remote.protocol.parser.ParserException;
import org.tigr.remote.protocol.parser.ResponseHandlerBase;
import org.tigr.util.ConfMap;
import org.tigr.util.FloatMatrix;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class MAGEResponseHandler
extends ResponseHandlerBase {
    private MatrixData m_currentMatrix = null;
    private ClusterData m_currentCluster = null;
    private NodeValue m_nodeValue = null;
    private AlgorithmData m_data = new AlgorithmData();
    private boolean m_parameters;

    public MAGEResponseHandler(ConfMap cfg) {
        super(cfg);
    }

    public AlgorithmData getResult() {
        return this.m_data;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attrs) throws SAXException {
        block31: {
            super.startElement(uri, localName, name, attrs);
            try {
                String[] path;
                if (name.equals("DerivedBioAssayData")) {
                    String matrixID = attrs.getValue("identifier");
                    if (!matrixID.equals("parameters")) {
                        this.m_currentMatrix = new MatrixData(matrixID);
                    } else {
                        this.m_parameters = true;
                    }
                    break block31;
                }
                if (name.equals("NameValueType")) {
                    IntVectorParser p;
                    String[] mdimsPath = new String[]{"NameValueType", "PropertySets_assnlist", "BioDataCube"};
                    String[] paramsPath = new String[]{"NameValueType", "PropertySets_assnlist", "DerivedBioAssayData"};
                    String[] clusterNodeDimsPath = new String[]{"NameValueType", "PropertySets_assnlist", "NodeContents", "NodeContents_assnlist", "Node"};
                    if (this.m_path.checkFromBottom(mdimsPath)) {
                        String val;
                        String _name = attrs.getValue("name");
                        if (_name.equals("cols")) {
                            val = attrs.getValue("value");
                            int dimX = Integer.parseInt(val);
                            this.m_currentMatrix.m_dims.setDimX(dimX);
                        } else if (_name.equals("rows")) {
                            val = attrs.getValue("value");
                            int dimY = Integer.parseInt(val);
                            this.m_currentMatrix.m_dims.setDimY(dimY);
                        }
                        MatrixDimensions dims = this.m_currentMatrix.m_dims;
                        if (dims.getDimX() != 0 && dims.getDimY() != 0) {
                            this.m_currentMatrix.m_matrix = new FloatMatrix(dims.getDimY(), dims.getDimX());
                        }
                        break block31;
                    }
                    if (this.m_path.checkFromBottom(paramsPath)) {
                        String _name = attrs.getValue("name");
                        String value = attrs.getValue("value");
                        String type = attrs.getValue("type");
                        if (type != null) {
                            if (!type.equals("vector-of-int")) break block31;
                            IntVectorParser p2 = new IntVectorParser();
                            int[] vector = null;
                            try {
                                vector = p2.parse(value);
                            }
                            catch (ParserException ee) {
                                throw new ParserException("error parsing parameter " + _name, ee);
                            }
                            this.m_data.addIntArray(_name, vector);
                            break block31;
                        }
                        this.m_data.addParam(_name, value);
                        break block31;
                    }
                    if (!this.m_path.checkFromBottom(clusterNodeDimsPath) || this.m_currentCluster == null) break block31;
                    String nvtName = attrs.getValue("name");
                    String nvtValue = attrs.getValue("value");
                    if (nvtName == null || nvtValue == null) break block31;
                    if (nvtName.equals("features-indexes")) {
                        p = new IntVectorParser();
                        try {
                            this.m_currentCluster.getCurrentNode().setFeaturesIndexes(p.parse(nvtValue));
                        }
                        catch (ParserException e) {
                            throw new ParserException("Cannot parse features indexes. Cluster: " + this.m_currentCluster.m_id + ". Node: " + this.m_currentCluster.getCurrentNode(), e);
                        }
                    }
                    if (nvtName.equals("probes-indexes")) {
                        p = new IntVectorParser();
                        try {
                            this.m_currentCluster.getCurrentNode().setProbesIndexes(p.parse(nvtValue));
                            break block31;
                        }
                        catch (ParserException e) {
                            throw new ParserException("Cannot parse probes indexes. Cluster: " + this.m_currentCluster.m_id + ". Node: " + this.m_currentCluster.getCurrentNode(), e);
                        }
                    }
                    this.m_currentCluster.getCurrentNode().setProperty(nvtName, nvtValue);
                    break block31;
                }
                if (name.equals("BioAssayDataCluster")) {
                    String id = attrs.getValue("identifier");
                    this.m_currentCluster = new ClusterData(id);
                } else if (name.equals("Node")) {
                    String[] path1 = new String[]{"Node", "Nodes_assnlist", "Node"};
                    String[] path2 = new String[]{"Node", "Nodes_assnlist", "BioAssayDataCluster"};
                    if ((this.m_path.checkFromBottom(path1) || this.m_path.checkFromBottom(path2)) && this.m_currentCluster != null) {
                        this.m_currentCluster.startNode(new Node());
                    }
                } else if (name.equals("NodeValue")) {
                    if (this.m_currentCluster != null) {
                        this.m_nodeValue = new NodeValue(attrs.getValue("name"), (Object)attrs.getValue("value"), null);
                    }
                } else if (name.equals("OntologyEntry") && this.m_path.checkFromBottom(path = new String[]{"OntologyEntry", "Type_assn", "NodeValue"}) && this.m_nodeValue != null) {
                    this.m_nodeValue.description = attrs.getValue("value");
                    String category = attrs.getValue("category");
                    if (category != null && category.equals("type")) {
                        this.adjustValueType(this.m_nodeValue, attrs.getValue("value"));
                    }
                }
            }
            catch (Exception ex) {
                this.processError(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        try {
            if (name.equals("DerivedBioAssayData")) {
                if (this.m_currentMatrix != null) {
                    if (!"".equals(this.m_currentMatrix.m_prevChunk)) {
                        this.parseFloats(this.m_currentMatrix.m_prevChunk);
                    }
                    this.m_currentMatrix.checkFinalState();
                    this.m_data.addMatrix(this.m_currentMatrix.m_name, this.m_currentMatrix.m_matrix);
                    this.m_currentMatrix = null;
                } else {
                    this.m_parameters = false;
                }
            } else if (name.equals("BioAssayDataCluster")) {
                this.m_data.addCluster(this.m_currentCluster.m_id, this.m_currentCluster.m_cluster);
                this.m_currentCluster = null;
            } else if (name.equals("Node")) {
                if (this.m_currentCluster != null) {
                    this.m_currentCluster.endNode();
                }
            } else if (name.equals("NodeValue") && this.m_nodeValue != null) {
                this.m_currentCluster.getCurrentNode().getValues().addNodeValue(this.m_nodeValue);
                this.m_nodeValue = null;
            }
        }
        catch (Exception ex) {
            this.processError(ex);
        }
        finally {
            super.endElement(uri, localName, name);
        }
    }

    private void parseFloats(String str) throws ParserException {
        StringTokenizer st = new StringTokenizer(str);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            float value = 0.0f;
            try {
                value = s.equals("NaN") ? Float.NaN : Float.parseFloat(s);
            }
            catch (NumberFormatException ex) {
                throw new ParserException("Failed to parser float: " + s + " matrix: " + this.m_currentMatrix.m_name + " order: " + this.m_currentMatrix.getNumbersRead(), ex);
            }
            this.m_currentMatrix.floatRead(value);
        }
    }

    private static boolean isSpace(char ch) {
        return Character.isWhitespace(ch) || Character.isSpaceChar(ch);
    }

    private int doGlue(char[] ch, int start, int length) throws Exception {
        if (!"".equals(this.m_currentMatrix.m_prevChunk)) {
            StringBuffer toParse = new StringBuffer(this.m_currentMatrix.m_prevChunk);
            int startPos = start;
            if (!MAGEResponseHandler.isSpace(ch[start])) {
                int i;
                for (i = start; !MAGEResponseHandler.isSpace(ch[i]) && start + length > i; ++i) {
                    toParse.append(ch[i]);
                }
                startPos = i;
            }
            this.parseFloats(toParse.toString());
            this.m_currentMatrix.m_prevChunk = "";
            return startPos;
        }
        return start;
    }

    private int leaveChunk(char[] ch, int start, int length) {
        int curPos = start + length - 1;
        if (!MAGEResponseHandler.isSpace(ch[curPos])) {
            int realLength = length;
            StringBuffer sb = new StringBuffer();
            int i = curPos;
            while (!MAGEResponseHandler.isSpace(ch[i]) && i > start) {
                sb.append(ch[i]);
                --i;
                --realLength;
            }
            this.m_currentMatrix.m_prevChunk = sb.reverse().toString();
            return realLength;
        }
        this.m_currentMatrix.m_prevChunk = "";
        return length;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String prevChunk = "";
        int realStart = start;
        int realLength = length;
        try {
            String[] mdataPath = new String[]{"DataInternal", "DataInternal_assn", "BioDataCube"};
            if (this.m_path.checkFromBottom(mdataPath)) {
                if (this.m_currentMatrix == null) {
                    throw new SAXException("Program error parsing matrix");
                }
                if (this.m_currentMatrix.m_matrix == null) {
                    throw new SAXException("Wrong matrix - no dimensions defined");
                }
                realStart = this.doGlue(ch, start, length);
                realLength = this.leaveChunk(ch, realStart, length + (start - realStart));
                String str = new String(ch, realStart, realLength);
                this.parseFloats(str);
            }
        }
        catch (Exception ex) {
            this.processError(ex);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    private void adjustValueType(NodeValue value, String type) throws Exception {
        if (!"".equals(type)) {
            String realValue = (String)value.value;
            if (type.equals("integer")) {
                value.value = new Integer(realValue);
            } else if (type.equals("float")) {
                value.value = new Float(realValue);
            } else if (type.equals("int-array")) {
                value.value = new IntVectorParser().parse(realValue);
            } else if (type.equals("float-array")) {
                value.value = new FloatVectorParser().parse(realValue);
            } else {
                throw new Exception("Unknown value type: " + type);
            }
        }
    }

    class ClusterData {
        public String m_id;
        public Cluster m_cluster = new Cluster();
        private LinkedList m_nodes = new LinkedList();

        public ClusterData(String id) {
            this.m_id = id;
        }

        public void startNode(Node node) {
            this.assignParentToStarted(node);
            this.m_nodes.addLast(node);
        }

        public void endNode() {
            this.m_nodes.removeLast();
        }

        public Node getCurrentNode() {
            if (this.m_nodes.size() == 0) {
                return null;
            }
            return (Node)this.m_nodes.getLast();
        }

        private void assignParentToStarted(Node node) {
            Node current = this.getCurrentNode();
            if (current == null) {
                this.m_cluster.getNodeList().addNode(node);
            } else {
                current.getChildNodes().addNode(node);
            }
        }
    }

    class MatrixData {
        private int m_numbersRead;
        public String m_name;
        public MatrixDimensions m_dims;
        public FloatMatrix m_matrix;
        public String m_prevChunk;

        public MatrixData(String name) {
            this.m_dims = new MatrixDimensions();
            this.m_prevChunk = "";
            this.m_name = name;
            this.m_matrix = null;
            this.m_numbersRead = 0;
        }

        public void floatRead(float value) throws ParserException {
            try {
                this.checkReadInProgressState();
                int col = this.m_numbersRead / this.m_matrix.getRowDimension();
                int row = this.m_numbersRead % this.m_matrix.getRowDimension();
                this.m_matrix.set(row, col, value);
                ++this.m_numbersRead;
            }
            catch (Exception e) {
                throw new ParserException("error setting matrix value", e);
            }
        }

        public void checkReadInProgressState() throws Exception {
            if (this.m_numbersRead + 1 > this.m_dims.getDimX() * this.m_dims.getDimY()) {
                throw new Exception("Error reading matrix data. Has read more data than dims allow: read: " + this.m_numbersRead);
            }
        }

        public void checkFinalState() throws Exception {
            if (this.m_numbersRead != this.m_dims.getDimX() * this.m_dims.getDimY()) {
                String str = "Error reading matrix data: \nDimensions: " + this.m_dims.getDimX() + "x" + this.m_dims.getDimY() + " = " + this.m_dims.getDimX() * this.m_dims.getDimY() + "\n" + "It has been read: " + this.m_numbersRead + "\n";
                throw new Exception(str);
            }
        }

        public int getNumbersRead() {
            return this.m_numbersRead;
        }
    }

    class MatrixDimensions {
        private int m_dimX = 0;
        private int m_dimY = 0;

        public int getDimX() {
            return this.m_dimX;
        }

        public int getDimY() {
            return this.m_dimY;
        }

        public void setDimX(int X) {
            this.m_dimX = X;
        }

        public void setDimY(int Y) {
            this.m_dimY = Y;
        }
    }
}

