/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.remote.protocol.parser;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.xml.sax.SAXException;

class CheckPath {
    private LinkedList m_stack;

    public CheckPath(LinkedList stack) {
        this.m_stack = stack;
    }

    public void checkFromTopThrow(String[] elements) throws SAXException {
        if (!this.checkFromTop(elements)) {
            throw new SAXException("Invalid document structure: " + this.m_stack.getLast());
        }
    }

    public void checkFromBottomThrow(String[] elements) throws SAXException {
        if (!this.checkFromBottom(elements)) {
            throw new SAXException("Invalid document structure: " + this.m_stack.getLast());
        }
    }

    public boolean checkFromTop(String[] elements) {
        int i;
        Iterator iter = this.m_stack.iterator();
        int size = elements.length;
        for (i = 0; i < size && iter.hasNext(); ++i) {
            String el = (String)iter.next();
            if (el.equals(elements[i])) continue;
            return false;
        }
        return iter.hasNext() || i >= size;
    }

    public boolean checkFromBottom(String[] elements) {
        int i;
        ListIterator iter = this.m_stack.listIterator(this.m_stack.size());
        int size = elements.length;
        if (elements.length == 0) {
            return false;
        }
        for (i = 0; i < size && iter.hasPrevious(); ++i) {
            String el = (String)iter.previous();
            if (el.equals(elements[i])) continue;
            return false;
        }
        return iter.hasPrevious() || i >= size;
    }
}

