/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.remote.protocol.communication.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.tigr.remote.RemoteException;
import org.tigr.remote.protocol.communication.RequestMessage;
import org.tigr.remote.protocol.communication.ResponseMessage;
import org.tigr.remote.protocol.communication.Transport;
import org.tigr.remote.protocol.communication.http.HttpCommunicator2;
import org.tigr.util.ConfMap;

class HttpTransport
implements Transport {
    protected ConfMap m_config;
    protected HttpCommunicator2 m_communicator;

    public HttpTransport(ConfMap config) throws RemoteException {
        this.m_config = config;
        try {
            this.m_communicator = new HttpCommunicator2(config);
        }
        catch (Exception ex) {
            throw new RemoteException("HttpTransport: bad server URL ", ex);
        }
    }

    @Override
    public RequestMessage sendRequest(RequestMessage msg) throws RemoteException {
        try {
            OutputStream out = this.m_communicator.send((Properties)msg.getProperties());
            msg.setStream(out);
            return msg;
        }
        catch (IOException ex) {
            throw new RemoteException("HttpTransport: cannot send request: " + ex.toString(), ex);
        }
    }

    @Override
    public ResponseMessage getResponse() throws RemoteException {
        try {
            InputStream in = this.m_communicator.receive();
            ResponseMessage msg = new ResponseMessage("Server", "TIGR-MEV", in);
            return msg;
        }
        catch (IOException ex) {
            throw new RemoteException("HttpTransport: cannot receive response. " + ex.toString(), ex);
        }
    }

    @Override
    public void finalizeSend() throws RemoteException {
        try {
            this.m_communicator.cleanupAfterSend();
        }
        catch (IOException ex) {
            throw new RemoteException("HttpTransport: Server error. Cannot start job: " + ex.toString(), ex);
        }
    }

    @Override
    public void finalizeReceive() throws RemoteException {
        try {
            this.m_communicator.cleanupAfterReceive();
        }
        catch (IOException ex) {
            throw new RemoteException("HttpTransport: cannot finalize receiving: " + ex.toString(), ex);
        }
    }
}

