/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.remote.protocol.communication.http;

import HTTPClient.CookieModule;
import HTTPClient.HTTPConnection;
import HTTPClient.HttpURLConnection;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.tigr.remote.protocol.util.TempFile;
import org.tigr.util.ConfMap;

public class HttpCommunicator2 {
    private URL sendURL;
    private URL receiveURL;
    private HttpURLConnection connection;
    private BufferedOutputStream bufferedOutputStream;
    private InputStream inputStream;
    private int contentLength = 0;
    private String context;
    private String fileName;
    private boolean fileCreated;
    private boolean keepTempFile;
    private static long countInstances = 0L;

    public static synchronized String getUniqueContext() {
        return "context" + ++countInstances;
    }

    private HttpCommunicator2(String serverURL) throws MalformedURLException {
        this.sendURL = new URL(serverURL + "?post-request");
        this.receiveURL = new URL(serverURL + "?get-response");
        this.context = HttpCommunicator2.getUniqueContext();
    }

    public HttpCommunicator2(ConfMap map) throws MalformedURLException, IOException {
        this(map.getString("remote.server"));
        this.fileName = new TempFile(map).getName();
        this.keepTempFile = map.getBoolean("remote.debug.keep-request-file", false);
    }

    public OutputStream send(Properties properties) throws IOException {
        this.createSendConnection();
        this.setRequestProperties(properties);
        this.bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.fileName));
        this.fileCreated = true;
        return this.bufferedOutputStream;
    }

    public InputStream receive() throws IOException {
        this.createReceiveConnection();
        this.inputStream = new BufferedInputStream(this.connection.getInputStream());
        this.checkResponseCode();
        return this.inputStream;
    }

    public void cleanupAfterReceive() throws IOException {
        this.inputStream.close();
        this.inputStream = null;
        this.checkResponseCode();
        this.connection.disconnect();
        this.connection = null;
    }

    public void cleanupAfterSend() throws IOException {
        File file = null;
        InputStream in = null;
        try {
            int cnt;
            this.bufferedOutputStream.flush();
            this.bufferedOutputStream.close();
            this.bufferedOutputStream = null;
            file = new File(this.fileName);
            this.setContentLength((int)file.length());
            if (this.contentLength < 1) {
                throw new IOException("HttpCommunicator: wrong content length");
            }
            this.connection.setRequestProperty("Content-Length", new Integer(this.contentLength).toString());
            in = new BufferedInputStream(new FileInputStream(file));
            BufferedOutputStream out = new BufferedOutputStream(this.connection.getOutputStream());
            byte[] b = new byte[102400];
            while ((cnt = in.read(b)) >= 0) {
                ((OutputStream)out).write(b, 0, cnt);
            }
            in.close();
            in = null;
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
            out = null;
            this.deleteTempFile(file);
            this.fileCreated = false;
            this.checkResponseCode();
            this.connection.disconnect();
            this.connection = null;
        }
        catch (IOException ex) {
            if (this.fileCreated) {
                if (in != null) {
                    in.close();
                    in = null;
                }
                if (file == null) {
                    file = new File(this.fileName);
                }
                this.deleteTempFile(file);
            }
            throw ex;
        }
    }

    private void createSendConnection() throws IOException {
        try {
            this.connection = new HttpURLConnection(this.sendURL);
            this.connection.setContext((Object)this.context);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            HTTPConnection.addDefaultModule(Class.forName("HTTPClient.CookieModule", true, cl), (int)0);
            CookieModule.setCookiePolicyHandler(null);
            this.connection.setRequestMethod("POST");
            this.connection.setAllowUserInteraction(true);
            this.connection.setDoOutput(true);
            this.connection.setRequestProperty("Content-Type", "text/plain");
            this.connection.setRequestProperty("Connection", "close");
        }
        catch (Exception ex) {
            throw new IOException("HttpCommunicator: cannot create send connection");
        }
    }

    private void createReceiveConnection() throws IOException {
        this.connection = new HttpURLConnection(this.receiveURL);
        this.connection.setContext((Object)this.context);
        this.connection.setRequestMethod("GET");
        this.connection.setAllowUserInteraction(true);
        this.connection.setRequestProperty("Connection", "close");
    }

    private void setRequestProperties(Properties props) {
        Enumeration<?> _enum = props.propertyNames();
        while (_enum.hasMoreElements()) {
            String name = (String)_enum.nextElement();
            String value = props.getProperty(name, "");
            this.connection.setRequestProperty(name, value);
        }
    }

    private Properties getResponseProperties() {
        Properties props = new Properties();
        int i = 1;
        while (true) {
            String name = this.connection.getHeaderFieldKey(i);
            String value = this.connection.getHeaderField(i);
            if (name == null) break;
            props.setProperty(name, value);
            ++i;
        }
        return props;
    }

    private void setContentLength(int length) {
        this.contentLength = length;
    }

    public void checkResponseCode() throws IOException {
        int code = this.connection.getResponseCode();
        if (code != 200) {
            throw new IOException("Response code is other than 200 OK. Url: \n" + this.connection.toString() + "\n Code: " + code);
        }
    }

    private void deleteTempFile(File file) throws IOException {
        if (!this.keepTempFile && !file.delete()) {
            throw new IOException("HttpCommunicator: deleting temp file error");
        }
    }
}

