/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.remote.protocol.communication.http;

import org.tigr.remote.RemoteException;
import org.tigr.remote.communication.ClientCommunicator;
import org.tigr.remote.communication.JobControl;
import org.tigr.remote.protocol.FinishedJob;
import org.tigr.remote.protocol.Request;
import org.tigr.remote.protocol.Response;
import org.tigr.remote.protocol.StartingJob;
import org.tigr.remote.protocol.StopJob;
import org.tigr.remote.protocol.communication.Presentation;
import org.tigr.remote.protocol.communication.http.HttpTransport;
import org.tigr.util.ConfMap;

public class Communicator
implements ClientCommunicator {
    private ConfMap m_conf;
    private Presentation m_presentation;
    private int i = 0;

    public Communicator(ConfMap conf) throws RemoteException {
        this.m_conf = conf;
        this.m_presentation = new Presentation(conf, new HttpTransport(conf));
    }

    @Override
    public JobControl postJob(StartingJob job) throws RemoteException {
        Request req = new Request(job);
        this.m_presentation.sendRequest(req);
        return new SyncJobControl(this, job.getId(), this.m_conf.getInt("remote.polling", 10));
    }

    protected FinishedJob getResult() throws RemoteException {
        Response response = this.m_presentation.getResponse();
        return response.getJob();
    }

    @Override
    public String getNewJobId() {
        return ++this.i + "";
    }

    private class SyncJobControl
    implements JobControl {
        private Communicator m_comm;
        private String m_jobId;
        private int m_polling;
        private FinishedJob m_result = null;

        public SyncJobControl(Communicator comm, String id, int polling) {
            this.m_comm = comm;
            this.m_jobId = id;
            this.m_polling = polling;
        }

        private void waitForReply() throws RemoteException {
            while (this.m_result == null) {
                try {
                    Thread.sleep(this.m_polling * 1000);
                }
                catch (InterruptedException e) {
                    throw new RemoteException("Thread was interrupted", e);
                }
                this.m_result = this.m_comm.getResult();
            }
        }

        @Override
        public void terminate() throws RemoteException {
            this.m_comm.postJob(new StopJob(this.getJobId()));
        }

        @Override
        public FinishedJob getResult() throws RemoteException {
            this.waitForReply();
            if (this.m_result == null) {
                throw new RemoteException("No result available");
            }
            FinishedJob result = this.m_result;
            this.m_result = null;
            return result;
        }

        private String getJobId() {
            return this.m_jobId;
        }
    }
}

