/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.remote.protocol.communication;

import org.tigr.remote.RemoteException;
import org.tigr.remote.protocol.Request;
import org.tigr.remote.protocol.Response;
import org.tigr.remote.protocol.communication.RequestMessage;
import org.tigr.remote.protocol.communication.ResponseMessage;
import org.tigr.remote.protocol.communication.Transport;
import org.tigr.remote.protocol.parser.Parser;
import org.tigr.remote.protocol.serializer.RequestSerializer;
import org.tigr.util.ConfMap;

public class Presentation {
    private Transport m_transport;
    private ConfMap m_config;

    public Presentation(ConfMap config, Transport transport) {
        this.m_transport = transport;
        this.m_config = config;
    }

    public Response getResponse() throws RemoteException {
        Response result = null;
        ResponseMessage msg = this.m_transport.getResponse();
        Parser parser = Parser.createParser(this.m_config);
        result = parser.parseResponse(msg.getStream());
        this.m_transport.finalizeReceive();
        return result;
    }

    public void sendRequest(Request req) throws RemoteException {
        RequestMessage msg = new RequestMessage("TIGR-MEV", "Calculation service");
        RequestMessage msg2 = this.m_transport.sendRequest(msg);
        RequestSerializer serializer = RequestSerializer.createSerializer(this.m_config);
        serializer.serializeRequest(req, msg2.getStream());
        this.m_transport.finalizeSend();
    }
}

