/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.remote.gateway;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tigr.remote.gateway.SessionState;
import org.tigr.remote.gateway.util.IQueue;
import org.tigr.util.ConfMap;

class PVMResponseAcceptStrategy {
    private static final int MAX_PACKET_SIZE = 102400;
    private static final int MAX_MESSAGES_IN_QUEUE = 10;
    SessionState m_session;
    int m_maxSize;
    int m_maxMessages;

    public PVMResponseAcceptStrategy(SessionState session, ConfMap cfg) {
        this.m_session = session;
        this.m_maxSize = cfg.getInt("gateway.cache.max-packet-size", 102400);
        this.m_maxMessages = cfg.getInt("gateway.cache.max-messages-in-queue", 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptPVMResponse(HttpServletRequest req, HttpServletResponse resp) throws IOException, InterruptedException {
        Object tmp;
        int packetSize = req.getContentLength();
        if (req.getContentLength() < this.m_maxSize) {
            tmp = new ByteArrayOutputStream(packetSize);
            BufferedInputStream in = new BufferedInputStream((InputStream)req.getInputStream());
            int c = 0;
            for (int counter = 0; (c = in.read()) != -1 && counter < packetSize; ++counter) {
                ((ByteArrayOutputStream)tmp).write(c);
            }
            String response = ((ByteArrayOutputStream)tmp).toString();
            IQueue queue = this.m_session.getMessageQueue();
            if (queue.getSize() >= this.m_maxMessages) {
                queue.getHead();
            }
            queue.addTail(response);
        } else {
            int cnt;
            tmp = this.m_session;
            synchronized (tmp) {
                this.m_session.createMonitor();
                this.m_session.wait();
            }
            BufferedInputStream in = new BufferedInputStream((InputStream)req.getInputStream());
            OutputStream out_pipe = this.m_session.getOutputPipe();
            byte[] b = new byte[102400];
            while ((cnt = in.read(b)) >= 0) {
                out_pipe.write(b, 0, cnt);
            }
            out_pipe.flush();
            out_pipe.close();
        }
        IQueue queue = this.m_session.getRequestQueue();
        if (!queue.isEmpty()) {
            String request = (String)queue.getHead();
            PrintWriter p = new PrintWriter((OutputStream)resp.getOutputStream());
            p.print(request);
            p.flush();
            p = null;
        }
    }
}

