/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.remote.gateway;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import org.tigr.util.ConfMap;

class MEVRequestAcceptStrategy {
    private static final int MAX_PACKET_SIZE = 0x100000;
    private String m_pvmProxyName;
    private String m_pvmSlaveName;
    private String m_pvmURL;
    private String m_pvmRoot;

    public MEVRequestAcceptStrategy(ConfMap cfg) {
        this.m_pvmProxyName = cfg.getString("gateway.pvm.proxy-name");
        this.m_pvmSlaveName = cfg.getString("gateway.pvm.slave-name");
        this.m_pvmURL = cfg.getProperty("gateway.pvm.slave.http", "").trim();
        this.m_pvmRoot = cfg.getProperty("gateway.pvm.root-path", "").trim();
    }

    private static void checkError(InputStream in) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        String result = reader.readLine();
        if (result != null) {
            if (!result.startsWith("OK")) {
                result = reader.readLine();
                throw new IOException("Cannot send to PVM: " + result);
            }
        } else {
            throw new IOException("Bad pvmproxy response.");
        }
    }

    private void constructURL(HttpServletRequest req) throws IOException {
        if (this.m_pvmURL == null || this.m_pvmURL.trim().equals("")) {
            StringBuffer sb = HttpUtils.getRequestURL((HttpServletRequest)req);
            sb.append("?post-response");
            this.m_pvmURL = sb.toString();
        }
    }

    public void acceptMEVRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException, InterruptedException {
        int cnt;
        Process process;
        if (req.getContentLength() < 1) {
            throw new IOException("Bad content length: " + req.getContentLength());
        }
        this.constructURL(req);
        Runtime runtime = Runtime.getRuntime();
        String[] cmdarray = new String[]{this.m_pvmProxyName, this.m_pvmSlaveName, this.m_pvmURL, this.getSessionIdString(req)};
        if (!this.m_pvmRoot.equals("")) {
            String[] envp = new String[]{"PVM_ROOT=" + this.m_pvmRoot};
            process = runtime.exec(cmdarray, envp);
        } else {
            process = runtime.exec(cmdarray);
        }
        BufferedOutputStream out = new BufferedOutputStream(process.getOutputStream(), 0x100000);
        BufferedInputStream in = new BufferedInputStream(process.getInputStream());
        BufferedInputStream wwwIn = new BufferedInputStream((InputStream)req.getInputStream());
        MEVRequestAcceptStrategy.checkError(in);
        int i = 0;
        byte[] b = new byte[102400];
        while ((cnt = ((InputStream)wwwIn).read(b)) >= 0) {
            ((OutputStream)out).write(b, 0, cnt);
            i += cnt;
        }
        if (i < 10) {
            throw new IOException("read only : " + i);
        }
        ((OutputStream)out).flush();
        ((OutputStream)out).close();
        MEVRequestAcceptStrategy.checkError(in);
        process.waitFor();
        int code = process.exitValue();
        if (code != 0) {
            throw new IOException("pvmproxy exit code != 0");
        }
    }

    private final String getSessionIdString(HttpServletRequest req) throws IOException {
        return "JSESSIONID=" + req.getSession().getId();
    }
}

