/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.remote.gateway;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.tigr.remote.gateway.MEVPollAcceptStrategy;
import org.tigr.remote.gateway.MEVRequestAcceptStrategy;
import org.tigr.remote.gateway.MEVRequestAcceptStrategy2;
import org.tigr.remote.gateway.PVMResponseAcceptStrategy;
import org.tigr.remote.gateway.SessionState;
import org.tigr.remote.gateway.util.ServletUtil;
import org.tigr.util.ConfMap;

public class GatewayServlet
extends HttpServlet {
    ServletConfig m_config;
    ServletContext m_ctx;
    ConfMap m_properties;

    public void init(ServletConfig cfg) throws ServletException {
        this.m_config = cfg;
        this.m_ctx = cfg.getServletContext();
        this.configure();
    }

    private void configure() throws ServletException {
        this.m_properties = new ConfMap();
        String[] params = new String[]{"gateway.pvm.proxy-name", "gateway.pvm.slave-name", "gateway.pvm.root-path"};
        String[] defaults = new String[]{"", "tigr-slave", "/usr/local/pvm3"};
        for (int i = 0; i < params.length; ++i) {
            String tmp = this.m_ctx.getInitParameter(params[i]);
            if (tmp == null || "".equals(tmp)) {
                if (!"".equals(defaults[i])) {
                    this.m_properties.setProperty(params[i], defaults[i]);
                    continue;
                }
                throw new ServletException("Undefined required parameter: " + params[i]);
            }
            this.m_properties.setProperty(params[i], tmp);
        }
        this.m_properties.list(System.out);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        this.logTrace(req, "GET log");
        String requestId = req.getQueryString();
        if (requestId == null) {
            return;
        }
        if ("get-response".equals(requestId)) {
            try {
                this.onMEVPollsForResponse(req, resp);
            }
            catch (Exception e) {
                this.logError(req, resp, e, "MEV polling error");
                this.sendError(resp, "MEV polling error: " + e.toString());
            }
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        this.logTrace(req, "POST log");
        String requestId = req.getQueryString();
        if (requestId == null) {
            try {
                ServletUtil.bufferedRead((InputStream)req.getInputStream());
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.logError(req, resp, new Exception("Unrecognized POST"), "");
            this.sendError(resp, "Unrecognized POST");
        } else if ("post-request".equals(requestId)) {
            try {
                this.onMEVPostsRequest(req, resp);
            }
            catch (Exception e) {
                try {
                    ServletUtil.bufferedRead((InputStream)req.getInputStream());
                }
                catch (IOException ex) {
                    // empty catch block
                }
                this.logError(req, resp, e, "MEV POST error");
                this.sendError(resp, "MEV POST error: " + e.toString());
            }
        } else if ("post-response".equals(requestId)) {
            try {
                this.onPVMPostsResponse(req, resp);
            }
            catch (Exception e) {
                try {
                    ServletUtil.bufferedRead((InputStream)req.getInputStream());
                }
                catch (IOException ex) {
                    // empty catch block
                }
                this.logError(req, resp, e, "PVM POST error");
                this.sendError(resp, "PVM POST error: " + e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMEVPostsRequest(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        HttpSession session = req.getSession(false);
        if (session == null) {
            HttpSession httpSession = session = req.getSession();
            synchronized (httpSession) {
                session.setAttribute("MEV_SESSION", (Object)new SessionState());
                MEVRequestAcceptStrategy strategy = new MEVRequestAcceptStrategy(this.m_properties);
                strategy.acceptMEVRequest(req, resp);
            }
        } else {
            SessionState si = (SessionState)session.getAttribute("MEV_SESSION");
            MEVRequestAcceptStrategy2 strategy = new MEVRequestAcceptStrategy2(si);
            strategy.acceptMEVRequest(req, resp);
        }
    }

    protected void onMEVPollsForResponse(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        HttpSession session = req.getSession(false);
        if (session == null) {
            throw new NullPointerException("Illegal call. Session has not been created ");
        }
        SessionState si = (SessionState)session.getAttribute("MEV_SESSION");
        if (si == null) {
            throw new NullPointerException("Illegal call. Session info has not been created for the  current session");
        }
        MEVPollAcceptStrategy strategy = new MEVPollAcceptStrategy(si, this.m_properties);
        strategy.acceptPollRequest(req, resp);
    }

    protected void onPVMPostsResponse(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        HttpSession session = req.getSession(false);
        if (session == null) {
            throw new NullPointerException("Illegal call. Session has has not been created ");
        }
        SessionState si = (SessionState)session.getAttribute("MEV_SESSION");
        if (si == null) {
            throw new NullPointerException("Illegal call. Session info has not been created for the  current session");
        }
        PVMResponseAcceptStrategy strategy = new PVMResponseAcceptStrategy(si, this.m_properties);
        strategy.acceptPVMResponse(req, resp);
    }

    protected void sendError(HttpServletResponse resp, String error) {
        try {
            this.m_ctx.log("Sending HTTP 404");
            resp.setContentType("text/plain");
            resp.sendError(404);
        }
        catch (IOException ex) {
            System.err.println("Error sending error code");
            throw new RuntimeException(ex.toString());
        }
    }

    private final boolean isDebugMode() {
        String debug = this.m_ctx.getInitParameter("gateway.debug");
        if (debug == null) {
            return false;
        }
        return debug.equalsIgnoreCase("true");
    }

    protected void logTrace(HttpServletRequest req, String str) {
        if (!this.isDebugMode()) {
            return;
        }
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("\n---------- Gateway trace message:\n");
            sb.append("Trace message:  " + str + "\n");
            sb.append("Request method: " + req.getMethod() + "\n");
            sb.append("Query string:   " + req.getQueryString() + "\n");
            sb.append("Content length: " + req.getContentLength() + "\n");
            sb.append("Cookies: ( session info )\n");
            Cookie[] cookies = req.getCookies();
            if (cookies == null || cookies.length == 0) {
                sb.append("No cookies in the HTTP request\n");
            } else {
                for (int i = 0; i < cookies.length; ++i) {
                    sb.append("\tName: " + cookies[i].getName() + "\t" + "Value: " + cookies[i].getValue() + "\n");
                }
            }
            sb.append("\n");
            this.m_ctx.log(sb.toString());
        }
        catch (Exception e) {
            System.err.println("Error logging a message");
        }
    }

    protected void logError(HttpServletRequest req, HttpServletResponse resp, Exception ex, String str) {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("\n---------- Gateway error:\n");
            sb.append("Error message:  " + str + "\n");
            sb.append("Request method: " + req.getMethod() + "\n");
            sb.append("Query string:   " + req.getQueryString() + "\n");
            sb.append("Content length: " + req.getContentLength() + "\n");
            sb.append("Cookies: ( session info )\n");
            Cookie[] cookies = req.getCookies();
            if (cookies == null || cookies.length == 0) {
                sb.append("No cookies in the HTTP request\n");
            } else {
                for (int i = 0; i < cookies.length; ++i) {
                    sb.append("\tName: " + cookies[i].getName() + "\t" + "Value: " + cookies[i].getValue() + "\n");
                }
            }
            sb.append("\n");
            this.m_ctx.log(sb.toString(), (Throwable)ex);
        }
        catch (Exception e) {
            System.err.println("Error logging a message");
        }
    }
}

