/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.remote;

import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.remote.RemoteException;
import org.tigr.remote.communication.ClientCommunicator;
import org.tigr.remote.communication.CommunicatorFactory;
import org.tigr.remote.communication.JobControl;
import org.tigr.remote.protocol.ExecutedJob;
import org.tigr.remote.protocol.FailedJob;
import org.tigr.remote.protocol.FinishedJob;
import org.tigr.remote.protocol.JobData;
import org.tigr.remote.protocol.JobVisitor;
import org.tigr.remote.protocol.StartJob;
import org.tigr.remote.protocol.SuccessfulJob;

public class RemoteAlgorithm
extends AbstractAlgorithm {
    private String name;
    private JobControl control;

    public RemoteAlgorithm(String name) {
        this.name = name;
    }

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        try {
            ClientCommunicator comm = CommunicatorFactory.getCommunicator();
            StartJob startJob = new StartJob(comm.getNewJobId(), new JobData(data), this.name);
            this.control = comm.postJob(startJob);
            JobExecution exec = new JobExecution(this);
            do {
                FinishedJob finishedJob = this.control.getResult();
                finishedJob.accept(exec);
            } while (exec.getResult() == null);
            return exec.getResult();
        }
        catch (Exception ex) {
            throw new AlgorithmException(ex);
        }
    }

    public void abort() {
        if (this.control == null) {
            throw new RuntimeException("Not started yet");
        }
        try {
            this.control.terminate();
        }
        catch (RemoteException ex) {
            throw new RuntimeException("Abort error");
        }
    }

    public class JobExecution
    implements JobVisitor {
        private RemoteAlgorithm ra;
        private AlgorithmData result;

        public JobExecution(RemoteAlgorithm ra) {
            this.ra = ra;
        }

        public AlgorithmData getResult() {
            return this.result;
        }

        @Override
        public void visitSuccessfulJob(SuccessfulJob job) {
            this.result = job.getData().getData();
        }

        @Override
        public void visitFailedJob(FailedJob job) {
            throw new RuntimeException("Server error: " + job.getFail().getDescription());
        }

        @Override
        public void visitExecutedJob(ExecutedJob job) {
            AlgorithmEvent ev = job.getEvent();
            this.ra.fireValueChanged(new AlgorithmEvent((Object)this, ev.getId(), ev.getIntValue(), ev.getFloatValue(), ev.getDescription()));
        }
    }
}

